/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import android.content.res.AssetManager;
import android.content.res.Resources;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.ui.core.elements.BankRepository;
import com.stripe.android.ui.core.elements.DropdownItemSpec;
import com.stripe.android.ui.core.elements.SupportedBankType;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\u0007J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u001e\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001eH\u0007J\u001a\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\t\u0010 \u001a\u00020\u0016H\u00d6\u0001R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/stripe/android/ui/core/elements/BankRepository;", "", "resources", "Landroid/content/res/Resources;", "(Landroid/content/res/Resources;)V", "bankItemMap", "", "Lcom/stripe/android/ui/core/elements/SupportedBankType;", "", "Lcom/stripe/android/ui/core/elements/DropdownItemSpec;", "format", "Lkotlinx/serialization/json/Json;", "getResources", "()Landroid/content/res/Resources;", "component1", "copy", "equals", "", "other", "get", "bankType", "getJsonStringFromInputStream", "", "inputStream", "Ljava/io/InputStream;", "hashCode", "", "initialize", "", "supportedBankTypeInputStreamMap", "", "parseBank", "toString", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class BankRepository {
    @Nullable
    private final Resources resources;
    @NotNull
    private final Map<SupportedBankType, List<DropdownItemSpec>> bankItemMap;
    @NotNull
    private final Json format;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    @Inject
    public BankRepository(@Nullable Resources resources) {
        void $this$associateWith$iv;
        this.resources = resources;
        this.bankItemMap = new LinkedHashMap();
        this.format = JsonKt.Json$default(null, (Function1)format.1.INSTANCE, (int)1, null);
        SupportedBankType[] supportedBankTypeArray = SupportedBankType.values();
        BankRepository bankRepository = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associateWith$iv).length), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        void var7_8 = $this$associateWithTo$iv$iv;
        int n = 0;
        int n2 = ((void)var7_8).length;
        while (n < n2) {
            InputStream inputStream;
            void element$iv$iv = var7_8[n];
            ++n;
            void var11_12 = element$iv$iv;
            void var15_15 = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Resources resources2 = this.getResources();
            if (resources2 == null) {
                inputStream = null;
            } else {
                void bank;
                AssetManager assetManager = resources2.getAssets();
                inputStream = assetManager == null ? null : assetManager.open(bank.getAssetFileName());
            }
            InputStream inputStream2 = inputStream;
            map2.put(var15_15, inputStream2);
        }
        bankRepository.initialize(result$iv);
    }

    @Nullable
    public final Resources getResources() {
        return this.resources;
    }

    @NotNull
    public final List<DropdownItemSpec> get(@NotNull SupportedBankType bankType) {
        Intrinsics.checkNotNullParameter((Object)((Object)bankType), (String)"bankType");
        List<DropdownItemSpec> list = this.bankItemMap.get((Object)bankType);
        if (list == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return list;
    }

    @VisibleForTesting
    public final void initialize(@NotNull Map<SupportedBankType, ? extends InputStream> supportedBankTypeInputStreamMap) {
        Intrinsics.checkNotNullParameter(supportedBankTypeInputStreamMap, (String)"supportedBankTypeInputStreamMap");
        Map<SupportedBankType, ? extends InputStream> $this$forEach$iv = supportedBankTypeInputStreamMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<SupportedBankType, ? extends InputStream>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SupportedBankType, ? extends InputStream> element$iv;
            Map.Entry<SupportedBankType, ? extends InputStream> $dstr$bankType$banksOfType = element$iv = iterator.next();
            boolean bl = false;
            SupportedBankType bankType = $dstr$bankType$banksOfType.getKey();
            InputStream banksOfType = $dstr$bankType$banksOfType.getValue();
            Map<SupportedBankType, List<DropdownItemSpec>> map2 = this.bankItemMap;
            List<DropdownItemSpec> list = this.parseBank(banksOfType);
            map2.put(bankType, list);
        }
    }

    private final List<DropdownItemSpec> parseBank(InputStream inputStream) {
        List list;
        String string2 = this.getJsonStringFromInputStream(inputStream);
        if (string2 == null) {
            list = null;
        } else {
            String it = string2;
            boolean bl = false;
            StringFormat $this$decodeFromString$iv = (StringFormat)this.format;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(DropdownItemSpec.class))));
            boolean $i$f$cast = false;
            list = (List)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, it);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getJsonStringFromInputStream(InputStream inputStream) {
        Object object;
        Object object2;
        BufferedReader bufferedReader;
        InputStream inputStream2 = inputStream;
        if (inputStream2 == null) {
            bufferedReader = null;
        } else {
            object2 = inputStream2;
            object = Charsets.UTF_8;
            Closeable closeable = object2;
            closeable = new InputStreamReader((InputStream)closeable, (Charset)object);
            int n = 8192;
            bufferedReader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        }
        Closeable closeable = bufferedReader;
        object2 = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            BufferedReader bufferedReader2 = it;
            object = bufferedReader2 == null ? null : TextStreamsKt.readText((Reader)bufferedReader2);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        return object;
    }

    @Nullable
    public final Resources component1() {
        return this.resources;
    }

    @NotNull
    public final BankRepository copy(@Nullable Resources resources) {
        return new BankRepository(resources);
    }

    public static /* synthetic */ BankRepository copy$default(BankRepository bankRepository, Resources resources, int n, Object object) {
        if ((n & 1) != 0) {
            resources = bankRepository.resources;
        }
        return bankRepository.copy(resources);
    }

    @NotNull
    public String toString() {
        return "BankRepository(resources=" + this.resources + ')';
    }

    public int hashCode() {
        return this.resources == null ? 0 : this.resources.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BankRepository)) {
            return false;
        }
        BankRepository bankRepository = (BankRepository)other;
        return Intrinsics.areEqual((Object)this.resources, (Object)bankRepository.resources);
    }
}

