/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.ui.core.address.AddressFieldElementRepository;
import com.stripe.android.ui.core.elements.CardBillingAddressElement;
import com.stripe.android.ui.core.elements.IdentifierSpec;
import com.stripe.android.ui.core.elements.SectionFieldSpec;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001J$\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001cJ\u0019\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/stripe/android/ui/core/elements/CardBillingSpec;", "Lcom/stripe/android/ui/core/elements/SectionFieldSpec;", "identifier", "Lcom/stripe/android/ui/core/elements/IdentifierSpec;", "countryCodes", "", "", "(Lcom/stripe/android/ui/core/elements/IdentifierSpec;Ljava/util/Set;)V", "getCountryCodes", "()Ljava/util/Set;", "getIdentifier", "()Lcom/stripe/android/ui/core/elements/IdentifierSpec;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "transform", "Lcom/stripe/android/ui/core/elements/CardBillingAddressElement;", "addressRepository", "Lcom/stripe/android/ui/core/address/AddressFieldElementRepository;", "initialValues", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@Parcelize
@StabilityInferred(parameters=0)
public final class CardBillingSpec
extends SectionFieldSpec {
    @NotNull
    private final IdentifierSpec identifier;
    @NotNull
    private final Set<String> countryCodes;
    @NotNull
    public static final Parcelable.Creator<CardBillingSpec> CREATOR;
    public static final int $stable;

    public CardBillingSpec(@NotNull IdentifierSpec identifier, @NotNull Set<String> countryCodes) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(countryCodes, (String)"countryCodes");
        super(identifier, null);
        this.identifier = identifier;
        this.countryCodes = countryCodes;
    }

    public /* synthetic */ CardBillingSpec(IdentifierSpec identifierSpec, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            identifierSpec = new IdentifierSpec.Generic("card_billing");
        }
        this(identifierSpec, set);
    }

    @Override
    @NotNull
    public IdentifierSpec getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final Set<String> getCountryCodes() {
        return this.countryCodes;
    }

    @NotNull
    public final CardBillingAddressElement transform(@NotNull AddressFieldElementRepository addressRepository, @NotNull Map<IdentifierSpec, String> initialValues) {
        Intrinsics.checkNotNullParameter((Object)addressRepository, (String)"addressRepository");
        Intrinsics.checkNotNullParameter(initialValues, (String)"initialValues");
        IdentifierSpec.Generic generic = new IdentifierSpec.Generic("credit_billing");
        Set<String> set = this.countryCodes;
        return new CardBillingAddressElement((IdentifierSpec)generic, initialValues, addressRepository, set, null, 16, null);
    }

    @NotNull
    public final IdentifierSpec component1() {
        return this.getIdentifier();
    }

    @NotNull
    public final Set<String> component2() {
        return this.countryCodes;
    }

    @NotNull
    public final CardBillingSpec copy(@NotNull IdentifierSpec identifier, @NotNull Set<String> countryCodes) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(countryCodes, (String)"countryCodes");
        return new CardBillingSpec(identifier, countryCodes);
    }

    public static /* synthetic */ CardBillingSpec copy$default(CardBillingSpec cardBillingSpec, IdentifierSpec identifierSpec, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            identifierSpec = cardBillingSpec.getIdentifier();
        }
        if ((n & 2) != 0) {
            set = cardBillingSpec.countryCodes;
        }
        return cardBillingSpec.copy(identifierSpec, set);
    }

    @NotNull
    public String toString() {
        return "CardBillingSpec(identifier=" + this.getIdentifier() + ", countryCodes=" + this.countryCodes + ')';
    }

    public int hashCode() {
        int result = this.getIdentifier().hashCode();
        result = result * 31 + ((Object)this.countryCodes).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CardBillingSpec)) {
            return false;
        }
        CardBillingSpec cardBillingSpec = (CardBillingSpec)other;
        if (!Intrinsics.areEqual((Object)this.getIdentifier(), (Object)cardBillingSpec.getIdentifier())) {
            return false;
        }
        return Intrinsics.areEqual(this.countryCodes, cardBillingSpec.countryCodes);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeParcelable((Parcelable)this.identifier, flags);
        Set<String> set = this.countryCodes;
        out.writeInt(set.size());
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            out.writeString(iterator.next());
        }
    }

    static {
        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<CardBillingSpec> {
            @NotNull
            public final CardBillingSpec[] newArray(int size) {
                return new CardBillingSpec[size];
            }

            @NotNull
            public final CardBillingSpec createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(n);
                IdentifierSpec identifierSpec = (IdentifierSpec)parcel.readParcelable(CardBillingSpec.class.getClassLoader());
                for (int i = 0; i != n; ++i) {
                    linkedHashSet.add(parcel.readString());
                }
                Set set = linkedHashSet;
                IdentifierSpec identifierSpec2 = identifierSpec;
                return new CardBillingSpec(identifierSpec2, set);
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }
}

