/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.Country;
import com.stripe.android.core.model.CountryCode;
import com.stripe.android.core.model.CountryUtils;
import com.stripe.android.ui.core.R;
import com.stripe.android.ui.core.elements.DropdownConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018H\u0016R\u0014\u0010\b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\f8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/ui/core/elements/CountryConfig;", "Lcom/stripe/android/ui/core/elements/DropdownConfig;", "onlyShowCountryCodes", "", "", "locale", "Ljava/util/Locale;", "(Ljava/util/Set;Ljava/util/Locale;)V", "debugLabel", "getDebugLabel", "()Ljava/lang/String;", "label", "", "getLabel", "()I", "getLocale", "()Ljava/util/Locale;", "getOnlyShowCountryCodes", "()Ljava/util/Set;", "convertFromRaw", "rawValue", "convertToRaw", "displayName", "getDisplayItems", "", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class CountryConfig
implements DropdownConfig {
    @NotNull
    private final Set<String> onlyShowCountryCodes;
    @NotNull
    private final Locale locale;
    @NotNull
    private final String debugLabel;
    @StringRes
    private final int label;
    public static final int $stable = 8;

    public CountryConfig(@NotNull Set<String> onlyShowCountryCodes, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(onlyShowCountryCodes, (String)"onlyShowCountryCodes");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.onlyShowCountryCodes = onlyShowCountryCodes;
        this.locale = locale;
        this.debugLabel = "country";
        this.label = R.string.address_label_country;
    }

    public /* synthetic */ CountryConfig(Set set, Locale locale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        this(set, locale);
    }

    @NotNull
    public final Set<String> getOnlyShowCountryCodes() {
        return this.onlyShowCountryCodes;
    }

    @NotNull
    public final Locale getLocale() {
        return this.locale;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    public int getLabel() {
        return this.label;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getDisplayItems() {
        void $this$mapTo$iv$iv;
        Country it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CountryUtils.INSTANCE.getOrderedCountries(this.locale);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Country)element$iv$iv;
            boolean bl = false;
            boolean bl2 = this.getOnlyShowCountryCodes().isEmpty() || !((Collection)this.getOnlyShowCountryCodes()).isEmpty() && this.getOnlyShowCountryCodes().contains(it.getCode().getValue());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Country)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        CountryCode countryCode = CountryCode.Companion.create(rawValue);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        Country country = CountryUtils.INSTANCE.getCountryByCode(countryCode, locale);
        String string2 = country == null ? null : country.getName();
        return string2 == null ? this.getDisplayItems().get(0) : string2;
    }

    @Override
    @Nullable
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        CountryCode countryCode = CountryUtils.INSTANCE.getCountryCodeByName(displayName, locale);
        return countryCode == null ? null : countryCode.getValue();
    }

    public CountryConfig() {
        this(null, null, 3, null);
    }
}

