/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.ui.core.elements.CountryConfig;
import com.stripe.android.ui.core.elements.CountryElement;
import com.stripe.android.ui.core.elements.DropdownFieldController;
import com.stripe.android.ui.core.elements.IdentifierSpec;
import com.stripe.android.ui.core.elements.SectionFieldElement;
import com.stripe.android.ui.core.elements.SectionFieldSpec;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001J\u001c\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0015J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/ui/core/elements/CountrySpec;", "Lcom/stripe/android/ui/core/elements/SectionFieldSpec;", "onlyShowCountryCodes", "", "", "(Ljava/util/Set;)V", "getOnlyShowCountryCodes", "()Ljava/util/Set;", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "transform", "Lcom/stripe/android/ui/core/elements/SectionFieldElement;", "initialValues", "", "Lcom/stripe/android/ui/core/elements/IdentifierSpec;", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Parcelize
@StabilityInferred(parameters=0)
public final class CountrySpec
extends SectionFieldSpec {
    @NotNull
    private final Set<String> onlyShowCountryCodes;
    @NotNull
    public static final Parcelable.Creator<CountrySpec> CREATOR;
    public static final int $stable;

    public CountrySpec(@NotNull Set<String> onlyShowCountryCodes) {
        Intrinsics.checkNotNullParameter(onlyShowCountryCodes, (String)"onlyShowCountryCodes");
        super(IdentifierSpec.Country.INSTANCE, null);
        this.onlyShowCountryCodes = onlyShowCountryCodes;
    }

    public /* synthetic */ CountrySpec(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        this(set);
    }

    @NotNull
    public final Set<String> getOnlyShowCountryCodes() {
        return this.onlyShowCountryCodes;
    }

    @NotNull
    public final SectionFieldElement transform(@NotNull Map<IdentifierSpec, String> initialValues) {
        Intrinsics.checkNotNullParameter(initialValues, (String)"initialValues");
        return new CountryElement(this.getIdentifier(), new DropdownFieldController(new CountryConfig(this.onlyShowCountryCodes, null, 2, null), initialValues.get(this.getIdentifier())));
    }

    @NotNull
    public final Set<String> component1() {
        return this.onlyShowCountryCodes;
    }

    @NotNull
    public final CountrySpec copy(@NotNull Set<String> onlyShowCountryCodes) {
        Intrinsics.checkNotNullParameter(onlyShowCountryCodes, (String)"onlyShowCountryCodes");
        return new CountrySpec(onlyShowCountryCodes);
    }

    public static /* synthetic */ CountrySpec copy$default(CountrySpec countrySpec, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = countrySpec.onlyShowCountryCodes;
        }
        return countrySpec.copy(set);
    }

    @NotNull
    public String toString() {
        return "CountrySpec(onlyShowCountryCodes=" + this.onlyShowCountryCodes + ')';
    }

    public int hashCode() {
        return ((Object)this.onlyShowCountryCodes).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CountrySpec)) {
            return false;
        }
        CountrySpec countrySpec = (CountrySpec)other;
        return Intrinsics.areEqual(this.onlyShowCountryCodes, countrySpec.onlyShowCountryCodes);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Set<String> set = this.onlyShowCountryCodes;
        out.writeInt(set.size());
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            out.writeString(iterator.next());
        }
    }

    public CountrySpec() {
        this(null, 1, null);
    }

    static {
        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<CountrySpec> {
            @NotNull
            public final CountrySpec[] newArray(int size) {
                return new CountrySpec[size];
            }

            @NotNull
            public final CountrySpec createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(n);
                for (int i = 0; i != n; ++i) {
                    linkedHashSet.add(parcel.readString());
                }
                Set set = linkedHashSet;
                return new CountrySpec(set);
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }
}

