/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.ui.core.R;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/ui/core/elements/KlarnaHelper;", "", "()V", "buyNowCountries", "", "", "currencyToAllowedCountries", "", "getAllowedCountriesForCurrency", "currencyCode", "getKlarnaHeader", "", "locale", "Ljava/util/Locale;", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class KlarnaHelper {
    @NotNull
    public static final KlarnaHelper INSTANCE = new KlarnaHelper();
    @NotNull
    private static final Map<String, Set<String>> currencyToAllowedCountries;
    @NotNull
    private static final Set<String> buyNowCountries;
    public static final int $stable;

    private KlarnaHelper() {
    }

    @NotNull
    public final Set<String> getAllowedCountriesForCurrency(@Nullable String currencyCode) {
        Set set = currencyToAllowedCountries.get(currencyCode);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final int getKlarnaHeader(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return buyNowCountries.contains(locale.getCountry()) ? R.string.klarna_buy_now_pay_later : R.string.klarna_pay_later;
    }

    public static /* synthetic */ int getKlarnaHeader$default(KlarnaHelper klarnaHelper, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return klarnaHelper.getKlarnaHeader(locale);
    }

    static {
        Object[] objectArray = new Pair[6];
        Object[] objectArray2 = new String[]{"AT", "FI", "DE", "NL", "BE", "ES", "IT", "FR"};
        objectArray[0] = TuplesKt.to((Object)"eur", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray[1] = TuplesKt.to((Object)"dkk", (Object)SetsKt.setOf((Object)"DK"));
        objectArray[2] = TuplesKt.to((Object)"nok", (Object)SetsKt.setOf((Object)"NO"));
        objectArray[3] = TuplesKt.to((Object)"sek", (Object)SetsKt.setOf((Object)"SE"));
        objectArray[4] = TuplesKt.to((Object)"gbp", (Object)SetsKt.setOf((Object)"GB"));
        objectArray[5] = TuplesKt.to((Object)"usd", (Object)SetsKt.setOf((Object)"US"));
        currencyToAllowedCountries = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"AT", "BE", "DE", "IT", "NL", "ES", "SE"};
        buyNowCountries = SetsKt.setOf((Object[])objectArray);
        $stable = 8;
    }
}

