/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.forms;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.ui.core.Amount;
import com.stripe.android.ui.core.address.AddressFieldElementRepository;
import com.stripe.android.ui.core.elements.AddressSpec;
import com.stripe.android.ui.core.elements.AffirmTextSpec;
import com.stripe.android.ui.core.elements.AfterpayClearpayTextSpec;
import com.stripe.android.ui.core.elements.AuBankAccountNumberSpec;
import com.stripe.android.ui.core.elements.AuBecsDebitMandateTextSpec;
import com.stripe.android.ui.core.elements.BankDropdownSpec;
import com.stripe.android.ui.core.elements.BankRepository;
import com.stripe.android.ui.core.elements.BsbSpec;
import com.stripe.android.ui.core.elements.CardBillingSpec;
import com.stripe.android.ui.core.elements.CardDetailsSectionSpec;
import com.stripe.android.ui.core.elements.CountrySpec;
import com.stripe.android.ui.core.elements.EmailSpec;
import com.stripe.android.ui.core.elements.EmptyFormElement;
import com.stripe.android.ui.core.elements.EmptyFormSpec;
import com.stripe.android.ui.core.elements.FormElement;
import com.stripe.android.ui.core.elements.FormItemSpec;
import com.stripe.android.ui.core.elements.IbanSpec;
import com.stripe.android.ui.core.elements.IdentifierSpec;
import com.stripe.android.ui.core.elements.KlarnaCountrySpec;
import com.stripe.android.ui.core.elements.MandateTextSpec;
import com.stripe.android.ui.core.elements.SaveForFutureUseSpec;
import com.stripe.android.ui.core.elements.SectionController;
import com.stripe.android.ui.core.elements.SectionElement;
import com.stripe.android.ui.core.elements.SectionFieldElement;
import com.stripe.android.ui.core.elements.SectionFieldErrorController;
import com.stripe.android.ui.core.elements.SectionFieldSpec;
import com.stripe.android.ui.core.elements.SectionSpec;
import com.stripe.android.ui.core.elements.SimpleTextSpec;
import com.stripe.android.ui.core.elements.StaticTextSpec;
import com.stripe.android.ui.core.forms.resources.ResourceRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011J<\u0010\u0010\u001a\u00020\u0015*\u00020\u00162\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JH\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011*\b\u0012\u0004\u0012\u00020\u001d0\u00112\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/ui/core/forms/TransformSpecToElements;", "", "resourceRepository", "Lcom/stripe/android/ui/core/forms/resources/ResourceRepository;", "initialValues", "", "Lcom/stripe/android/ui/core/elements/IdentifierSpec;", "", "amount", "Lcom/stripe/android/ui/core/Amount;", "saveForFutureUseInitialValue", "", "merchantName", "context", "Landroid/content/Context;", "(Lcom/stripe/android/ui/core/forms/resources/ResourceRepository;Ljava/util/Map;Lcom/stripe/android/ui/core/Amount;ZLjava/lang/String;Landroid/content/Context;)V", "transform", "", "Lcom/stripe/android/ui/core/elements/FormElement;", "list", "Lcom/stripe/android/ui/core/elements/FormItemSpec;", "Lcom/stripe/android/ui/core/elements/SectionElement;", "Lcom/stripe/android/ui/core/elements/SectionSpec;", "currencyCode", "bankRepository", "Lcom/stripe/android/ui/core/elements/BankRepository;", "addressRepository", "Lcom/stripe/android/ui/core/address/AddressFieldElementRepository;", "Lcom/stripe/android/ui/core/elements/SectionFieldElement;", "Lcom/stripe/android/ui/core/elements/SectionFieldSpec;", "payments-ui-core_release"})
@StabilityInferred(parameters=0)
public final class TransformSpecToElements {
    @NotNull
    private final ResourceRepository resourceRepository;
    @NotNull
    private final Map<IdentifierSpec, String> initialValues;
    @Nullable
    private final Amount amount;
    private final boolean saveForFutureUseInitialValue;
    @NotNull
    private final String merchantName;
    @NotNull
    private final Context context;
    public static final int $stable = 8;

    public TransformSpecToElements(@NotNull ResourceRepository resourceRepository, @NotNull Map<IdentifierSpec, String> initialValues, @Nullable Amount amount, boolean saveForFutureUseInitialValue, @NotNull String merchantName, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)resourceRepository, (String)"resourceRepository");
        Intrinsics.checkNotNullParameter(initialValues, (String)"initialValues");
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.resourceRepository = resourceRepository;
        this.initialValues = initialValues;
        this.amount = amount;
        this.saveForFutureUseInitialValue = saveForFutureUseInitialValue;
        this.merchantName = merchantName;
        this.context = context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FormElement> transform(@NotNull List<? extends FormItemSpec> list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FormElement formElement;
            void it;
            FormItemSpec formItemSpec = (FormItemSpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = it;
            if (var11_11 instanceof SaveForFutureUseSpec) {
                formElement = ((SaveForFutureUseSpec)it).transform(this.saveForFutureUseInitialValue, this.merchantName);
            } else if (var11_11 instanceof SectionSpec) {
                Amount amount = this.amount;
                formElement = this.transform((SectionSpec)it, this.initialValues, (String)(amount == null ? null : amount.getCurrencyCode()), this.resourceRepository.getBankRepository(), this.resourceRepository.getAddressRepository());
            } else if (var11_11 instanceof StaticTextSpec) {
                formElement = ((StaticTextSpec)it).transform();
            } else if (var11_11 instanceof MandateTextSpec) {
                formElement = ((MandateTextSpec)it).transform(this.merchantName);
            } else if (var11_11 instanceof AfterpayClearpayTextSpec) {
                Amount amount = this.amount;
                if (amount == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                formElement = ((AfterpayClearpayTextSpec)it).transform(amount);
            } else if (var11_11 instanceof AffirmTextSpec) {
                formElement = ((AffirmTextSpec)it).transform();
            } else if (var11_11 instanceof EmptyFormSpec) {
                formElement = new EmptyFormElement(null, null, 3, null);
            } else if (var11_11 instanceof AuBecsDebitMandateTextSpec) {
                formElement = ((AuBecsDebitMandateTextSpec)it).transform(this.merchantName);
            } else if (var11_11 instanceof CardDetailsSectionSpec) {
                formElement = ((CardDetailsSectionSpec)it).transform(this.context, this.initialValues);
            } else if (var11_11 instanceof BsbSpec) {
                formElement = ((BsbSpec)it).transform(this.initialValues);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(formElement);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final SectionElement transform(SectionSpec $this$transform, Map<IdentifierSpec, String> initialValues, String currencyCode, BankRepository bankRepository, AddressFieldElementRepository addressRepository) {
        Collection<SectionFieldErrorController> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<SectionFieldElement> fieldElements = this.transform($this$transform.getFields(), initialValues, currencyCode, bankRepository, addressRepository);
        Iterable iterable = fieldElements;
        Integer n = $this$transform.getTitle();
        List<SectionFieldElement> list = fieldElements;
        IdentifierSpec identifierSpec = $this$transform.getApi_path();
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SectionFieldElement sectionFieldElement = (SectionFieldElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.sectionFieldErrorController());
        }
        Collection<SectionFieldErrorController> collection2 = collection = (List)destination$iv$iv;
        Integer n2 = n;
        SectionController sectionController = new SectionController(n2, (List<? extends SectionFieldErrorController>)collection2);
        List<SectionFieldElement> list2 = list;
        IdentifierSpec identifierSpec2 = identifierSpec;
        return new SectionElement(identifierSpec2, list2, sectionController);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SectionFieldElement> transform(List<? extends SectionFieldSpec> $this$transform, Map<IdentifierSpec, String> initialValues, String currencyCode, BankRepository bankRepository, AddressFieldElementRepository addressRepository) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$transform;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SectionFieldElement sectionFieldElement;
            void it;
            SectionFieldSpec sectionFieldSpec = (SectionFieldSpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var15_15 = it;
            if (var15_15 instanceof EmailSpec) {
                sectionFieldElement = ((EmailSpec)it).transform(initialValues);
            } else if (var15_15 instanceof IbanSpec) {
                sectionFieldElement = ((IbanSpec)it).transform(initialValues);
            } else if (var15_15 instanceof BankDropdownSpec) {
                sectionFieldElement = ((BankDropdownSpec)it).transform(bankRepository, initialValues.get(it.getIdentifier()));
            } else if (var15_15 instanceof SimpleTextSpec) {
                sectionFieldElement = ((SimpleTextSpec)it).transform(initialValues);
            } else if (var15_15 instanceof AddressSpec) {
                sectionFieldElement = ((AddressSpec)it).transform(initialValues, addressRepository);
            } else if (var15_15 instanceof CountrySpec) {
                sectionFieldElement = ((CountrySpec)it).transform(initialValues);
            } else if (var15_15 instanceof KlarnaCountrySpec) {
                sectionFieldElement = ((KlarnaCountrySpec)it).transform(currencyCode, initialValues);
            } else if (var15_15 instanceof CardBillingSpec) {
                sectionFieldElement = ((CardBillingSpec)it).transform(addressRepository, initialValues);
            } else if (var15_15 instanceof AuBankAccountNumberSpec) {
                sectionFieldElement = ((AuBankAccountNumberSpec)it).transform(initialValues);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(sectionFieldElement);
        }
        return (List)destination$iv$iv;
    }
}

