/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TransformedText;
import androidx.compose.ui.text.input.VisualTransformation;
import com.stripe.android.model.CardBrand;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/ui/core/elements/CardNumberVisualTransformation;", "Landroidx/compose/ui/text/input/VisualTransformation;", "separator", "", "(C)V", "binBasedMaxPan", "", "getBinBasedMaxPan$payments_ui_core_release", "()Ljava/lang/Integer;", "setBinBasedMaxPan$payments_ui_core_release", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "filter", "Landroidx/compose/ui/text/input/TransformedText;", "text", "Landroidx/compose/ui/text/AnnotatedString;", "space4and11", "space4and9and14", "space4and9and14and19", "payments-ui-core_release"})
public final class CardNumberVisualTransformation
implements VisualTransformation {
    private final char separator;
    @Nullable
    private Integer binBasedMaxPan;

    public CardNumberVisualTransformation(char separator) {
        this.separator = separator;
    }

    @Nullable
    public final Integer getBinBasedMaxPan$payments_ui_core_release() {
        return this.binBasedMaxPan;
    }

    public final void setBinBasedMaxPan$payments_ui_core_release(@Nullable Integer n) {
        this.binBasedMaxPan = n;
    }

    @NotNull
    public TransformedText filter(@NotNull AnnotatedString text) {
        TransformedText transformedText;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CardBrand cardBrand = CardBrand.Companion.fromCardNumber(text.getText());
        Integer n = this.binBasedMaxPan;
        int panLength = n != null ? n.intValue() : cardBrand.getMaxLengthForCardNumber(text.getText());
        switch (panLength) {
            case 14: 
            case 15: {
                transformedText = this.space4and11(text);
                break;
            }
            case 16: {
                transformedText = this.space4and9and14(text);
                break;
            }
            case 19: {
                transformedText = this.space4and9and14and19(text);
                break;
            }
            default: {
                transformedText = this.space4and9and14(text);
            }
        }
        return transformedText;
    }

    private final TransformedText space4and11(AnnotatedString text) {
        Object out = "";
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            out = (String)out + text.charAt(i);
            switch (i) {
                case 3: 
                case 9: {
                    out = (String)out + this.separator;
                }
            }
        }
        OffsetMapping creditCardOffsetTranslator2 = new OffsetMapping(){

            public int originalToTransformed(int offset) {
                if (offset <= 3) {
                    return offset;
                }
                if (offset <= 9) {
                    return offset + 1;
                }
                return offset + 2;
            }

            public int transformedToOriginal(int offset) {
                if (offset <= 4) {
                    return offset;
                }
                if (offset <= 11) {
                    return offset - 1;
                }
                return offset - 2;
            }
        };
        return new TransformedText(new AnnotatedString((String)out, null, null, 6, null), creditCardOffsetTranslator2);
    }

    private final TransformedText space4and9and14(AnnotatedString text) {
        Object out = "";
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            out = (String)out + text.charAt(i);
            if (i % 4 != 3 || i >= 15) continue;
            out = (String)out + this.separator;
        }
        OffsetMapping creditCardOffsetTranslator2 = new OffsetMapping(){

            public int originalToTransformed(int offset) {
                if (offset <= 3) {
                    return offset;
                }
                if (offset <= 7) {
                    return offset + 1;
                }
                if (offset <= 11) {
                    return offset + 2;
                }
                return offset + 3;
            }

            public int transformedToOriginal(int offset) {
                if (offset <= 4) {
                    return offset;
                }
                if (offset <= 9) {
                    return offset - 1;
                }
                if (offset <= 14) {
                    return offset - 2;
                }
                return offset - 3;
            }
        };
        return new TransformedText(new AnnotatedString((String)out, null, null, 6, null), creditCardOffsetTranslator2);
    }

    private final TransformedText space4and9and14and19(AnnotatedString text) {
        Object out = "";
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            out = (String)out + text.charAt(i);
            if (i % 4 != 3 || i >= 19) continue;
            out = (String)out + this.separator;
        }
        OffsetMapping creditCardOffsetTranslator2 = new OffsetMapping(){

            public int originalToTransformed(int offset) {
                if (offset <= 3) {
                    return offset;
                }
                if (offset <= 7) {
                    return offset + 1;
                }
                if (offset <= 11) {
                    return offset + 2;
                }
                if (offset <= 15) {
                    return offset + 3;
                }
                return offset + 4;
            }

            public int transformedToOriginal(int offset) {
                if (offset <= 4) {
                    return offset;
                }
                if (offset <= 9) {
                    return offset - 1;
                }
                if (offset <= 14) {
                    return offset - 2;
                }
                if (offset <= 19) {
                    return offset - 3;
                }
                return offset - 4;
            }
        };
        return new TransformedText(new AnnotatedString((String)out, null, null, 6, null), creditCardOffsetTranslator2);
    }
}

