/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.injection;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.ui.core.Amount;
import com.stripe.android.ui.core.forms.TransformSpecToElements;
import com.stripe.android.uicore.address.AddressRepository;
import com.stripe.android.uicore.elements.IdentifierSpec;
import dagger.Module;
import dagger.Provides;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jj\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0016\b\u0001\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000e2\u0018\b\u0001\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/ui/core/injection/FormControllerModule;", "", "()V", "provideTransformSpecToElements", "Lcom/stripe/android/ui/core/forms/TransformSpecToElements;", "addressRepository", "Lcom/stripe/android/uicore/address/AddressRepository;", "context", "Landroid/content/Context;", "merchantName", "", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "initialValues", "", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "shippingValues", "viewOnlyFields", "", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class FormControllerModule {
    @NotNull
    public static final FormControllerModule INSTANCE = new FormControllerModule();
    public static final int $stable;

    private FormControllerModule() {
    }

    @Provides
    @NotNull
    public final TransformSpecToElements provideTransformSpecToElements(@NotNull AddressRepository addressRepository, @NotNull Context context, @NotNull String merchantName, @Nullable StripeIntent stripeIntent, @Named(value="initialValues") @NotNull Map<IdentifierSpec, String> initialValues, @Named(value="shippingValues") @Nullable Map<IdentifierSpec, String> shippingValues, @NotNull Set<IdentifierSpec> viewOnlyFields) {
        Amount amount;
        Intrinsics.checkNotNullParameter((Object)addressRepository, (String)"addressRepository");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        Intrinsics.checkNotNullParameter(initialValues, (String)"initialValues");
        Intrinsics.checkNotNullParameter(viewOnlyFields, (String)"viewOnlyFields");
        PaymentIntent paymentIntent = stripeIntent instanceof PaymentIntent ? (PaymentIntent)stripeIntent : null;
        if (paymentIntent != null) {
            PaymentIntent it = paymentIntent;
            boolean bl = false;
            Long amount2 = it.getAmount();
            String currency = it.getCurrency();
            if (amount2 != null && currency != null) {
                new Amount(amount2, currency);
            }
            amount = null;
        } else {
            amount = null;
        }
        Amount amount3 = amount;
        return new TransformSpecToElements(addressRepository, initialValues, shippingValues, amount3, false, merchantName, context, false, viewOnlyFields);
    }
}

