/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import android.content.res.Resources;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.intl.Locale;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.ui.core.Amount;
import com.stripe.android.ui.core.R;
import com.stripe.android.uicore.elements.Controller;
import com.stripe.android.uicore.elements.FormElement;
import com.stripe.android.uicore.elements.IdentifierSpec;
import com.stripe.android.uicore.format.CurrencyFormatter;
import com.stripe.android.uicore.forms.FormFieldEntry;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 .2\u00020\u0001:\u0001.B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c2\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J \u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020$0#0\"0!H\u0016J\u000e\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*H\u0002J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0012H\u00d6\u0001R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/stripe/android/ui/core/elements/AfterpayClearpayHeaderElement;", "Lcom/stripe/android/uicore/elements/FormElement;", "identifier", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "amount", "Lcom/stripe/android/ui/core/Amount;", "controller", "Lcom/stripe/android/uicore/elements/Controller;", "(Lcom/stripe/android/uicore/elements/IdentifierSpec;Lcom/stripe/android/ui/core/Amount;Lcom/stripe/android/uicore/elements/Controller;)V", "allowsUserInteraction", "", "getAllowsUserInteraction", "()Z", "getController", "()Lcom/stripe/android/uicore/elements/Controller;", "getIdentifier", "()Lcom/stripe/android/uicore/elements/IdentifierSpec;", "infoUrl", "", "getInfoUrl", "()Ljava/lang/String;", "mandateText", "Lcom/stripe/android/core/strings/ResolvableString;", "getMandateText", "()Lcom/stripe/android/core/strings/ResolvableString;", "component1", "component2", "component3", "copy", "equals", "other", "", "getFormFieldValueFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lkotlin/Pair;", "Lcom/stripe/android/uicore/forms/FormFieldEntry;", "getLabel", "resources", "Landroid/content/res/Resources;", "getLocaleString", "locale", "Landroidx/compose/ui/text/intl/Locale;", "hashCode", "", "toString", "Companion", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class AfterpayClearpayHeaderElement
implements FormElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdentifierSpec identifier;
    @NotNull
    private final Amount amount;
    @Nullable
    private final Controller controller;
    private final boolean allowsUserInteraction;
    @Nullable
    private final ResolvableString mandateText;
    public static final int $stable = 8;
    @NotNull
    public static final String url = "https://static.afterpay.com/modal/%s.html";
    @NotNull
    public static final String NO_BREAK_SPACE = "\u00a0";

    public AfterpayClearpayHeaderElement(@NotNull IdentifierSpec identifier, @NotNull Amount amount, @Nullable Controller controller) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        this.identifier = identifier;
        this.amount = amount;
        this.controller = controller;
    }

    public /* synthetic */ AfterpayClearpayHeaderElement(IdentifierSpec identifierSpec, Amount amount, Controller controller, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            controller = null;
        }
        this(identifierSpec, amount, controller);
    }

    @NotNull
    public IdentifierSpec getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public Controller getController() {
        return this.controller;
    }

    public boolean getAllowsUserInteraction() {
        return this.allowsUserInteraction;
    }

    @Nullable
    public ResolvableString getMandateText() {
        return this.mandateText;
    }

    @NotNull
    public StateFlow<List<Pair<IdentifierSpec, FormFieldEntry>>> getFormFieldValueFlow() {
        return StateFlowsKt.stateFlowOf((Object)CollectionsKt.emptyList());
    }

    @NotNull
    public final String getInfoUrl() {
        String string2 = url;
        Object[] objectArray = new Object[]{this.getLocaleString(Locale.Companion.getCurrent())};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    private final String getLocaleString(Locale locale) {
        String string2 = locale.getLanguage().toLowerCase(java.util.Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = locale.getRegion().toUpperCase(java.util.Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        return string2 + "_" + string3;
    }

    @NotNull
    public final String getLabel(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        String string2 = this.amount.getCurrencyCode().toLowerCase(java.util.Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        int numInstallments = Intrinsics.areEqual((Object)string2, (Object)"eur") ? 3 : 4;
        String string3 = resources.getString(R.string.stripe_afterpay_clearpay_message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)"<num_installments/>", (String)String.valueOf(numInstallments), (boolean)false, (int)4, null), (String)"<installment_price/>", (String)CurrencyFormatter.format$default((CurrencyFormatter)CurrencyFormatter.INSTANCE, (long)(this.amount.getValue() / (long)numInstallments), (String)this.amount.getCurrencyCode(), null, (int)4, null), (boolean)false, (int)4, null), (String)"<img/>", (String)"<img/>\u00a0<b>\u24d8</b>", (boolean)false, (int)4, null);
    }

    @NotNull
    public StateFlow<List<IdentifierSpec>> getTextFieldIdentifiers() {
        return FormElement.DefaultImpls.getTextFieldIdentifiers((FormElement)this);
    }

    @NotNull
    public final IdentifierSpec component1() {
        return this.identifier;
    }

    private final Amount component2() {
        return this.amount;
    }

    @Nullable
    public final Controller component3() {
        return this.controller;
    }

    @NotNull
    public final AfterpayClearpayHeaderElement copy(@NotNull IdentifierSpec identifier, @NotNull Amount amount, @Nullable Controller controller) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return new AfterpayClearpayHeaderElement(identifier, amount, controller);
    }

    public static /* synthetic */ AfterpayClearpayHeaderElement copy$default(AfterpayClearpayHeaderElement afterpayClearpayHeaderElement, IdentifierSpec identifierSpec, Amount amount, Controller controller, int n, Object object) {
        if ((n & 1) != 0) {
            identifierSpec = afterpayClearpayHeaderElement.identifier;
        }
        if ((n & 2) != 0) {
            amount = afterpayClearpayHeaderElement.amount;
        }
        if ((n & 4) != 0) {
            controller = afterpayClearpayHeaderElement.controller;
        }
        return afterpayClearpayHeaderElement.copy(identifierSpec, amount, controller);
    }

    @NotNull
    public String toString() {
        return "AfterpayClearpayHeaderElement(identifier=" + this.identifier + ", amount=" + this.amount + ", controller=" + this.controller + ")";
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + (this.controller == null ? 0 : this.controller.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AfterpayClearpayHeaderElement)) {
            return false;
        }
        AfterpayClearpayHeaderElement afterpayClearpayHeaderElement = (AfterpayClearpayHeaderElement)other;
        if (!Intrinsics.areEqual((Object)this.identifier, (Object)afterpayClearpayHeaderElement.identifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.amount, (Object)afterpayClearpayHeaderElement.amount)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.controller, (Object)afterpayClearpayHeaderElement.controller);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/ui/core/elements/AfterpayClearpayHeaderElement$Companion;", "", "()V", "NO_BREAK_SPACE", "", "url", "isClearpay", "", "payments-ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final boolean isClearpay() {
            Object[] objectArray = new String[]{"GB", "ES", "FR", "IT"};
            return SetsKt.setOf((Object[])objectArray).contains(Locale.Companion.getCurrent().getRegion());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

