/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.uicore.elements.FormElement;
import com.stripe.android.uicore.elements.IdentifierSpec;
import com.stripe.android.uicore.elements.InputController;
import com.stripe.android.uicore.forms.FormFieldEntry;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u00c6\u0003J9\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J \u0010$\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020'0&0\u00070%H\u0016J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001J\t\u0010)\u001a\u00020\bH\u00d6\u0001R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lcom/stripe/android/ui/core/elements/MandateTextElement;", "Lcom/stripe/android/uicore/elements/FormElement;", "identifier", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "stringResId", "", "args", "", "", "controller", "Lcom/stripe/android/uicore/elements/InputController;", "(Lcom/stripe/android/uicore/elements/IdentifierSpec;ILjava/util/List;Lcom/stripe/android/uicore/elements/InputController;)V", "allowsUserInteraction", "", "getAllowsUserInteraction", "()Z", "getArgs", "()Ljava/util/List;", "getController", "()Lcom/stripe/android/uicore/elements/InputController;", "getIdentifier", "()Lcom/stripe/android/uicore/elements/IdentifierSpec;", "mandateText", "Lcom/stripe/android/core/strings/ResolvableString;", "getMandateText", "()Lcom/stripe/android/core/strings/ResolvableString;", "getStringResId", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "getFormFieldValueFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lkotlin/Pair;", "Lcom/stripe/android/uicore/forms/FormFieldEntry;", "hashCode", "toString", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMandateTextElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MandateTextElement.kt\ncom/stripe/android/ui/core/elements/MandateTextElement\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,26:1\n37#2,2:27\n*S KotlinDebug\n*F\n+ 1 MandateTextElement.kt\ncom/stripe/android/ui/core/elements/MandateTextElement\n*L\n21#1:27,2\n*E\n"})
public final class MandateTextElement
implements FormElement {
    @NotNull
    private final IdentifierSpec identifier;
    private final int stringResId;
    @NotNull
    private final List<String> args;
    @Nullable
    private final InputController controller;
    private final boolean allowsUserInteraction;
    @NotNull
    private final ResolvableString mandateText;
    public static final int $stable = 8;

    public MandateTextElement(@NotNull IdentifierSpec identifier, int stringResId, @NotNull List<String> args, @Nullable InputController controller) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.identifier = identifier;
        this.stringResId = stringResId;
        this.args = args;
        this.controller = controller;
        Collection $this$toTypedArray$iv = this.args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        this.mandateText = ResolvableStringUtilsKt.resolvableString$default((int)this.stringResId, (Object[])Arrays.copyOf(stringArray, stringArray.length), null, (int)4, null);
    }

    public /* synthetic */ MandateTextElement(IdentifierSpec identifierSpec, int n, List list, InputController inputController, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            inputController = null;
        }
        this(identifierSpec, n, list, inputController);
    }

    @NotNull
    public IdentifierSpec getIdentifier() {
        return this.identifier;
    }

    public final int getStringResId() {
        return this.stringResId;
    }

    @NotNull
    public final List<String> getArgs() {
        return this.args;
    }

    @Nullable
    public InputController getController() {
        return this.controller;
    }

    public boolean getAllowsUserInteraction() {
        return this.allowsUserInteraction;
    }

    @NotNull
    public ResolvableString getMandateText() {
        return this.mandateText;
    }

    @NotNull
    public StateFlow<List<Pair<IdentifierSpec, FormFieldEntry>>> getFormFieldValueFlow() {
        return StateFlowsKt.stateFlowOf((Object)CollectionsKt.emptyList());
    }

    @NotNull
    public StateFlow<List<IdentifierSpec>> getTextFieldIdentifiers() {
        return FormElement.DefaultImpls.getTextFieldIdentifiers((FormElement)this);
    }

    @NotNull
    public final IdentifierSpec component1() {
        return this.identifier;
    }

    public final int component2() {
        return this.stringResId;
    }

    @NotNull
    public final List<String> component3() {
        return this.args;
    }

    @Nullable
    public final InputController component4() {
        return this.controller;
    }

    @NotNull
    public final MandateTextElement copy(@NotNull IdentifierSpec identifier, int stringResId, @NotNull List<String> args, @Nullable InputController controller) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return new MandateTextElement(identifier, stringResId, args, controller);
    }

    public static /* synthetic */ MandateTextElement copy$default(MandateTextElement mandateTextElement, IdentifierSpec identifierSpec, int n, List list, InputController inputController, int n2, Object object) {
        if ((n2 & 1) != 0) {
            identifierSpec = mandateTextElement.identifier;
        }
        if ((n2 & 2) != 0) {
            n = mandateTextElement.stringResId;
        }
        if ((n2 & 4) != 0) {
            list = mandateTextElement.args;
        }
        if ((n2 & 8) != 0) {
            inputController = mandateTextElement.controller;
        }
        return mandateTextElement.copy(identifierSpec, n, list, inputController);
    }

    @NotNull
    public String toString() {
        return "MandateTextElement(identifier=" + this.identifier + ", stringResId=" + this.stringResId + ", args=" + this.args + ", controller=" + this.controller + ")";
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = result * 31 + Integer.hashCode(this.stringResId);
        result = result * 31 + ((Object)this.args).hashCode();
        result = result * 31 + (this.controller == null ? 0 : this.controller.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MandateTextElement)) {
            return false;
        }
        MandateTextElement mandateTextElement = (MandateTextElement)other;
        if (!Intrinsics.areEqual((Object)this.identifier, (Object)mandateTextElement.identifier)) {
            return false;
        }
        if (this.stringResId != mandateTextElement.stringResId) {
            return false;
        }
        if (!Intrinsics.areEqual(this.args, mandateTextElement.args)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.controller, (Object)mandateTextElement.controller);
    }
}

