/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import android.content.res.Resources;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.intl.Locale;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.ui.core.R;
import com.stripe.android.uicore.elements.Controller;
import com.stripe.android.uicore.elements.FormElement;
import com.stripe.android.uicore.elements.IdentifierSpec;
import com.stripe.android.uicore.forms.FormFieldEntry;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 /2\u00020\u0001:\u0001/B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0018\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0\u001b0\u001a0\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010)\u001a\u00020\u00112\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u001d\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000f\u00a8\u00060"}, d2={"Lcom/stripe/android/ui/core/elements/AfterpayClearpayHeaderElement;", "Lcom/stripe/android/uicore/elements/FormElement;", "identifier", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "controller", "Lcom/stripe/android/uicore/elements/Controller;", "currency", "", "<init>", "(Lcom/stripe/android/uicore/elements/IdentifierSpec;Lcom/stripe/android/uicore/elements/Controller;Ljava/lang/String;)V", "getIdentifier", "()Lcom/stripe/android/uicore/elements/IdentifierSpec;", "getController", "()Lcom/stripe/android/uicore/elements/Controller;", "getCurrency", "()Ljava/lang/String;", "allowsUserInteraction", "", "getAllowsUserInteraction", "()Z", "mandateText", "Lcom/stripe/android/core/strings/ResolvableString;", "getMandateText", "()Lcom/stripe/android/core/strings/ResolvableString;", "getFormFieldValueFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lkotlin/Pair;", "Lcom/stripe/android/uicore/forms/FormFieldEntry;", "infoUrl", "getInfoUrl", "getLocaleString", "locale", "Landroidx/compose/ui/text/intl/Locale;", "getLabel", "resources", "Landroid/content/res/Resources;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class AfterpayClearpayHeaderElement
implements FormElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdentifierSpec identifier;
    @Nullable
    private final Controller controller;
    @Nullable
    private final String currency;
    private final boolean allowsUserInteraction;
    @Nullable
    private final ResolvableString mandateText;
    public static final int $stable = 8;
    @NotNull
    public static final String url = "https://static.afterpay.com/modal/%s.html";
    @NotNull
    public static final String NO_BREAK_SPACE = "\u00a0";

    public AfterpayClearpayHeaderElement(@NotNull IdentifierSpec identifier, @Nullable Controller controller, @Nullable String currency) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.identifier = identifier;
        this.controller = controller;
        this.currency = currency;
    }

    public /* synthetic */ AfterpayClearpayHeaderElement(IdentifierSpec identifierSpec, Controller controller, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            controller = null;
        }
        this(identifierSpec, controller, string2);
    }

    @NotNull
    public IdentifierSpec getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public Controller getController() {
        return this.controller;
    }

    @Nullable
    public final String getCurrency() {
        return this.currency;
    }

    public boolean getAllowsUserInteraction() {
        return this.allowsUserInteraction;
    }

    @Nullable
    public ResolvableString getMandateText() {
        return this.mandateText;
    }

    @NotNull
    public StateFlow<List<Pair<IdentifierSpec, FormFieldEntry>>> getFormFieldValueFlow() {
        return StateFlowsKt.stateFlowOf((Object)CollectionsKt.emptyList());
    }

    @NotNull
    public final String getInfoUrl() {
        String string2 = url;
        Object[] objectArray = new Object[]{this.getLocaleString(Locale.Companion.getCurrent())};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    private final String getLocaleString(Locale locale) {
        String string2 = locale.getLanguage().toLowerCase(java.util.Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = locale.getRegion().toUpperCase(java.util.Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        return string2 + "_" + string3;
    }

    @NotNull
    public final String getLabel(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        String string2 = resources.getString(R.string.stripe_afterpay_clearpay_marketing);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return StringsKt.replace$default((String)string2, (String)"<img/>", (String)"<img/>\u00a0<b>\u24d8</b>", (boolean)false, (int)4, null);
    }

    @NotNull
    public final IdentifierSpec component1() {
        return this.identifier;
    }

    @Nullable
    public final Controller component2() {
        return this.controller;
    }

    @Nullable
    public final String component3() {
        return this.currency;
    }

    @NotNull
    public final AfterpayClearpayHeaderElement copy(@NotNull IdentifierSpec identifier, @Nullable Controller controller, @Nullable String currency) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return new AfterpayClearpayHeaderElement(identifier, controller, currency);
    }

    public static /* synthetic */ AfterpayClearpayHeaderElement copy$default(AfterpayClearpayHeaderElement afterpayClearpayHeaderElement, IdentifierSpec identifierSpec, Controller controller, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            identifierSpec = afterpayClearpayHeaderElement.identifier;
        }
        if ((n & 2) != 0) {
            controller = afterpayClearpayHeaderElement.controller;
        }
        if ((n & 4) != 0) {
            string2 = afterpayClearpayHeaderElement.currency;
        }
        return afterpayClearpayHeaderElement.copy(identifierSpec, controller, string2);
    }

    @NotNull
    public String toString() {
        return "AfterpayClearpayHeaderElement(identifier=" + this.identifier + ", controller=" + this.controller + ", currency=" + this.currency + ")";
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = result * 31 + (this.controller == null ? 0 : this.controller.hashCode());
        result = result * 31 + (this.currency == null ? 0 : this.currency.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AfterpayClearpayHeaderElement)) {
            return false;
        }
        AfterpayClearpayHeaderElement afterpayClearpayHeaderElement = (AfterpayClearpayHeaderElement)other;
        if (!Intrinsics.areEqual((Object)this.identifier, (Object)afterpayClearpayHeaderElement.identifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.controller, (Object)afterpayClearpayHeaderElement.controller)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.currency, (Object)afterpayClearpayHeaderElement.currency);
    }

    @NotNull
    public StateFlow<List<IdentifierSpec>> getTextFieldIdentifiers() {
        return FormElement.DefaultImpls.getTextFieldIdentifiers((FormElement)this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\n\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/ui/core/elements/AfterpayClearpayHeaderElement$Companion;", "", "<init>", "()V", "url", "", "NO_BREAK_SPACE", "isClearpay", "", "currency", "isCashappAfterpay", "payments-ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final boolean isClearpay(@Nullable String currency) {
            return StringsKt.equals((String)"GBP", (String)currency, (boolean)true);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final boolean isCashappAfterpay(@Nullable String currency) {
            return StringsKt.equals((String)"USD", (String)currency, (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

