/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.ui.core.elements.BlikConfig;
import com.stripe.android.uicore.elements.IdentifierSpec;
import com.stripe.android.uicore.elements.InputController;
import com.stripe.android.uicore.elements.SectionSingleFieldElement;
import com.stripe.android.uicore.elements.SimpleTextFieldController;
import com.stripe.android.uicore.elements.TextFieldConfig;
import com.stripe.android.uicore.forms.FormFieldEntry;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0014\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u00170\u00160\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/ui/core/elements/BlikElement;", "Lcom/stripe/android/uicore/elements/SectionSingleFieldElement;", "identifier", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "controller", "Lcom/stripe/android/uicore/elements/InputController;", "<init>", "(Lcom/stripe/android/uicore/elements/IdentifierSpec;Lcom/stripe/android/uicore/elements/InputController;)V", "getIdentifier", "()Lcom/stripe/android/uicore/elements/IdentifierSpec;", "getController", "()Lcom/stripe/android/uicore/elements/InputController;", "allowsUserInteraction", "", "getAllowsUserInteraction", "()Z", "mandateText", "Lcom/stripe/android/core/strings/ResolvableString;", "getMandateText", "()Lcom/stripe/android/core/strings/ResolvableString;", "getFormFieldValueFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lkotlin/Pair;", "Lcom/stripe/android/uicore/forms/FormFieldEntry;", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@StabilityInferred(parameters=0)
public final class BlikElement
extends SectionSingleFieldElement {
    @NotNull
    private final IdentifierSpec identifier;
    @NotNull
    private final InputController controller;
    private final boolean allowsUserInteraction;
    @Nullable
    private final ResolvableString mandateText;
    public static final int $stable = 8;

    public BlikElement(@NotNull IdentifierSpec identifier, @NotNull InputController controller) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        super(identifier);
        this.identifier = identifier;
        this.controller = controller;
        this.allowsUserInteraction = true;
    }

    public /* synthetic */ BlikElement(IdentifierSpec identifierSpec, InputController inputController, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            identifierSpec = IdentifierSpec.Companion.getBlikCode();
        }
        if ((n & 2) != 0) {
            inputController = (InputController)new SimpleTextFieldController((TextFieldConfig)new BlikConfig(), false, null, null, 14, null);
        }
        this(identifierSpec, inputController);
    }

    @NotNull
    public IdentifierSpec getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public InputController getController() {
        return this.controller;
    }

    public boolean getAllowsUserInteraction() {
        return this.allowsUserInteraction;
    }

    @Nullable
    public ResolvableString getMandateText() {
        return this.mandateText;
    }

    @NotNull
    public StateFlow<List<Pair<IdentifierSpec, FormFieldEntry>>> getFormFieldValueFlow() {
        return StateFlowsKt.mapAsStateFlow((StateFlow)this.getController().getFormFieldValue(), arg_0 -> BlikElement.getFormFieldValueFlow$lambda$0(this, arg_0));
    }

    private static final List getFormFieldValueFlow$lambda$0(BlikElement this$0, FormFieldEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return CollectionsKt.listOf((Object)TuplesKt.to((Object)this$0.getIdentifier(), (Object)entry));
    }

    public BlikElement() {
        this(null, null, 3, null);
    }
}

