/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.ui.core.elements.BsbConfig;
import com.stripe.android.uicore.elements.Controller;
import com.stripe.android.uicore.elements.FormElement;
import com.stripe.android.uicore.elements.IdentifierSpec;
import com.stripe.android.uicore.elements.SimpleTextElement;
import com.stripe.android.uicore.elements.SimpleTextFieldController;
import com.stripe.android.uicore.elements.TextFieldConfig;
import com.stripe.android.uicore.elements.TextFieldController;
import com.stripe.android.uicore.forms.FormFieldEntry;
import com.stripe.android.uicore.utils.StateFlowsKt;
import com.stripe.android.view.BecsDebitBanks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\"\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020$0#0\u00050\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006%"}, d2={"Lcom/stripe/android/ui/core/elements/BsbElement;", "Lcom/stripe/android/uicore/elements/FormElement;", "identifierSpec", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "banks", "", "Lcom/stripe/android/view/BecsDebitBanks$Bank;", "initialValue", "", "<init>", "(Lcom/stripe/android/uicore/elements/IdentifierSpec;Ljava/util/List;Ljava/lang/String;)V", "controller", "Lcom/stripe/android/uicore/elements/Controller;", "getController", "()Lcom/stripe/android/uicore/elements/Controller;", "identifier", "getIdentifier", "()Lcom/stripe/android/uicore/elements/IdentifierSpec;", "allowsUserInteraction", "", "getAllowsUserInteraction", "()Z", "mandateText", "Lcom/stripe/android/core/strings/ResolvableString;", "getMandateText", "()Lcom/stripe/android/core/strings/ResolvableString;", "textElement", "Lcom/stripe/android/uicore/elements/SimpleTextElement;", "getTextElement$payments_ui_core_release", "()Lcom/stripe/android/uicore/elements/SimpleTextElement;", "bankName", "Lkotlinx/coroutines/flow/StateFlow;", "getBankName", "()Lkotlinx/coroutines/flow/StateFlow;", "getFormFieldValueFlow", "Lkotlin/Pair;", "Lcom/stripe/android/uicore/forms/FormFieldEntry;", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBsbElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BsbElement.kt\ncom/stripe/android/ui/core/elements/BsbElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n774#2:50\n865#2,2:51\n1557#2:53\n1628#2,3:54\n*S KotlinDebug\n*F\n+ 1 BsbElement.kt\ncom/stripe/android/ui/core/elements/BsbElement\n*L\n35#1:50\n35#1:51,2\n36#1:53\n36#1:54,3\n*E\n"})
public final class BsbElement
implements FormElement {
    @NotNull
    private final IdentifierSpec identifierSpec;
    @NotNull
    private final List<BecsDebitBanks.Bank> banks;
    private final boolean allowsUserInteraction;
    @Nullable
    private final ResolvableString mandateText;
    @NotNull
    private final SimpleTextElement textElement;
    @NotNull
    private final StateFlow<String> bankName;
    public static final int $stable = 8;

    public BsbElement(@NotNull IdentifierSpec identifierSpec, @NotNull List<BecsDebitBanks.Bank> banks, @Nullable String initialValue) {
        Intrinsics.checkNotNullParameter((Object)identifierSpec, (String)"identifierSpec");
        Intrinsics.checkNotNullParameter(banks, (String)"banks");
        this.identifierSpec = identifierSpec;
        this.banks = banks;
        this.allowsUserInteraction = true;
        this.textElement = new SimpleTextElement(IdentifierSpec.Companion.Generic("au_becs_debit[bsb_number]"), (TextFieldController)new SimpleTextFieldController((TextFieldConfig)new BsbConfig(this.banks), false, initialValue, null, 10, null));
        this.bankName = StateFlowsKt.mapAsStateFlow((StateFlow)this.textElement.getController().getFieldValue(), arg_0 -> BsbElement.bankName$lambda$2(this, arg_0));
    }

    @Nullable
    public Controller getController() {
        return null;
    }

    @NotNull
    public IdentifierSpec getIdentifier() {
        return this.identifierSpec;
    }

    public boolean getAllowsUserInteraction() {
        return this.allowsUserInteraction;
    }

    @Nullable
    public ResolvableString getMandateText() {
        return this.mandateText;
    }

    @NotNull
    public final SimpleTextElement getTextElement$payments_ui_core_release() {
        return this.textElement;
    }

    @NotNull
    public final StateFlow<String> getBankName() {
        return this.bankName;
    }

    @NotNull
    public StateFlow<List<Pair<IdentifierSpec, FormFieldEntry>>> getFormFieldValueFlow() {
        return StateFlowsKt.combineAsStateFlow((StateFlow)this.textElement.getController().isComplete(), (StateFlow)this.textElement.getController().getFieldValue(), (arg_0, arg_1) -> BsbElement.getFormFieldValueFlow$lambda$3(this, arg_0, arg_1));
    }

    @NotNull
    public StateFlow<List<IdentifierSpec>> getTextFieldIdentifiers() {
        return FormElement.DefaultImpls.getTextFieldIdentifiers((FormElement)this);
    }

    /*
     * WARNING - void declaration
     */
    private static final String bankName$lambda$2(BsbElement this$0, String textFieldValue) {
        void $this$mapTo$iv$iv;
        BecsDebitBanks.Bank it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"textFieldValue");
        Iterable $this$filter$iv = this$0.banks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BecsDebitBanks.Bank)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)textFieldValue, (String)it.getPrefix(), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BecsDebitBanks.Bank)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    private static final List getFormFieldValueFlow$lambda$3(BsbElement this$0, boolean complete, String fieldValue) {
        Intrinsics.checkNotNullParameter((Object)fieldValue, (String)"fieldValue");
        return CollectionsKt.listOf((Object)TuplesKt.to((Object)this$0.getIdentifier(), (Object)new FormFieldEntry(fieldValue, complete)));
    }
}

