/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.KeyboardCapitalization;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.VisualTransformation;
import com.stripe.android.CardBrandFilter;
import com.stripe.android.CardUtils;
import com.stripe.android.R;
import com.stripe.android.model.CardBrand;
import com.stripe.android.ui.core.elements.CardDetailsTextFieldConfig;
import com.stripe.android.ui.core.elements.CardNumberVisualTransformations;
import com.stripe.android.uicore.elements.TextFieldState;
import com.stripe.android.uicore.elements.TextFieldStateConstants;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0012H\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000eH\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eH\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0016\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u0016\u0010\u000bR\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/stripe/android/ui/core/elements/CardNumberConfig;", "Lcom/stripe/android/ui/core/elements/CardDetailsTextFieldConfig;", "isCardBrandChoiceEligible", "", "cardBrandFilter", "Lcom/stripe/android/CardBrandFilter;", "<init>", "(ZLcom/stripe/android/CardBrandFilter;)V", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "getCapitalization-IUNYP9k", "()I", "I", "debugLabel", "", "getDebugLabel", "()Ljava/lang/String;", "label", "", "getLabel", "keyboard", "Landroidx/compose/ui/text/input/KeyboardType;", "getKeyboard-PjHm6EE", "digitsRequiredToFetchBrands", "determineVisualTransformation", "Landroidx/compose/ui/text/input/VisualTransformation;", "number", "panLength", "determineState", "Lcom/stripe/android/uicore/elements/TextFieldState;", "brand", "Lcom/stripe/android/model/CardBrand;", "numberAllowedDigits", "filter", "userTyped", "convertToRaw", "displayName", "convertFromRaw", "rawValue", "Companion", "payments-ui-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCardNumberConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardNumberConfig.kt\ncom/stripe/android/ui/core/elements/CardNumberConfig\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,80:1\n434#2:81\n507#2,5:82\n*S KotlinDebug\n*F\n+ 1 CardNumberConfig.kt\ncom/stripe/android/ui/core/elements/CardNumberConfig\n*L\n70#1:81\n70#1:82,5\n*E\n"})
public final class CardNumberConfig
implements CardDetailsTextFieldConfig {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean isCardBrandChoiceEligible;
    @NotNull
    private final CardBrandFilter cardBrandFilter;
    private final int capitalization;
    @NotNull
    private final String debugLabel;
    private final int label;
    private final int keyboard;
    private int digitsRequiredToFetchBrands;
    public static final int $stable = 8;
    @Deprecated
    public static final char SEPARATOR = ' ';

    public CardNumberConfig(boolean isCardBrandChoiceEligible, @NotNull CardBrandFilter cardBrandFilter) {
        Intrinsics.checkNotNullParameter((Object)cardBrandFilter, (String)"cardBrandFilter");
        this.isCardBrandChoiceEligible = isCardBrandChoiceEligible;
        this.cardBrandFilter = cardBrandFilter;
        this.capitalization = KeyboardCapitalization.Companion.getNone-IUNYP9k();
        this.debugLabel = "Card number";
        this.label = R.string.stripe_acc_label_card_number;
        this.keyboard = KeyboardType.Companion.getNumberPassword-PjHm6EE();
        this.digitsRequiredToFetchBrands = 9;
    }

    @Override
    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    public int getLabel() {
        return this.label;
    }

    @Override
    public int getKeyboard-PjHm6EE() {
        return this.keyboard;
    }

    @Override
    @NotNull
    public VisualTransformation determineVisualTransformation(@NotNull String number, int panLength) {
        VisualTransformation visualTransformation2;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        switch (panLength) {
            case 14: 
            case 15: {
                visualTransformation2 = new CardNumberVisualTransformations.FourteenAndFifteenPanLength(' ');
                break;
            }
            case 19: {
                visualTransformation2 = new CardNumberVisualTransformations.NineteenPanLength(' ');
                break;
            }
            default: {
                visualTransformation2 = new CardNumberVisualTransformations.Default(' ');
            }
        }
        return visualTransformation2;
    }

    @Override
    @NotNull
    public TextFieldState determineState(@NotNull CardBrand brand, @NotNull String number, int numberAllowedDigits) {
        TextFieldState textFieldState;
        boolean isDigitLimit;
        Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        boolean luhnValid = CardUtils.INSTANCE.isValidLuhnNumber(number);
        boolean bl = isDigitLimit = brand.getMaxLengthForCardNumber(number) != -1;
        if (StringsKt.isBlank((CharSequence)number)) {
            textFieldState = (TextFieldState)TextFieldStateConstants.Error.Blank.INSTANCE;
        } else {
            if (!(this.cardBrandFilter.isAccepted(brand) || this.isCardBrandChoiceEligible && number.length() <= this.digitsRequiredToFetchBrands)) {
                Object[] objectArray = new String[]{brand.getDisplayName()};
                return (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_disallowed_card_brand, objectArray, false);
            }
            textFieldState = brand == CardBrand.Unknown ? (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_invalid_card_number, null, true, 2, null) : (isDigitLimit && number.length() < numberAllowedDigits ? (TextFieldState)new TextFieldStateConstants.Error.Incomplete(R.string.stripe_invalid_card_number) : (!luhnValid ? (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_invalid_card_number, null, true, 2, null) : (isDigitLimit && number.length() == numberAllowedDigits ? (TextFieldState)TextFieldStateConstants.Valid.Full.INSTANCE : (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_invalid_card_number, null, false, 6, null))));
        }
        return textFieldState;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String filter(@NotNull String userTyped) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userTyped, (String)"userTyped");
        String $this$filter$iv = userTyped;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isDigit(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return ((StringBuilder)destination$iv$iv).toString();
    }

    @Override
    @NotNull
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return displayName;
    }

    @Override
    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        return rawValue;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/ui/core/elements/CardNumberConfig$Companion;", "", "<init>", "()V", "SEPARATOR", "", "payments-ui-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

