/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.autofill.AutofillType;
import androidx.compose.ui.text.input.VisualTransformation;
import androidx.compose.ui.unit.LayoutDirection;
import com.stripe.android.R;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.model.CardBrand;
import com.stripe.android.ui.core.elements.CvcConfig;
import com.stripe.android.uicore.elements.FieldError;
import com.stripe.android.uicore.elements.IdentifierSpec;
import com.stripe.android.uicore.elements.SectionFieldElement;
import com.stripe.android.uicore.elements.TextFieldController;
import com.stripe.android.uicore.elements.TextFieldIcon;
import com.stripe.android.uicore.elements.TextFieldState;
import com.stripe.android.uicore.forms.FormFieldEntry;
import com.stripe.android.uicore.utils.AccessibilityKt;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010I\u001a\u0004\u0018\u0001072\u0006\u0010J\u001a\u00020\bH\u0016J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\bH\u0016J\u0010\u0010N\u001a\u00020L2\u0006\u0010O\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0018\u0010\u0014R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000eR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001dR\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001dR\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001dR\u001a\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001dR\u0014\u00106\u001a\b\u0012\u0004\u0012\u0002070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00108\u001a\b\u0012\u0004\u0012\u0002070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001dR\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u001dR\u001c\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u001dR\u001a\u0010@\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u001dR\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u001dR\u001c\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010E0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u001dR\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u001d\u00a8\u0006P"}, d2={"Lcom/stripe/android/ui/core/elements/CvcController;", "Lcom/stripe/android/uicore/elements/TextFieldController;", "cvcTextFieldConfig", "Lcom/stripe/android/ui/core/elements/CvcConfig;", "cardBrandFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/model/CardBrand;", "initialValue", "", "showOptionalLabel", "", "<init>", "(Lcom/stripe/android/ui/core/elements/CvcConfig;Lkotlinx/coroutines/flow/StateFlow;Ljava/lang/String;Z)V", "getInitialValue", "()Ljava/lang/String;", "getShowOptionalLabel", "()Z", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "getCapitalization-IUNYP9k", "()I", "I", "keyboardType", "Landroidx/compose/ui/text/input/KeyboardType;", "getKeyboardType-PjHm6EE", "_label", "", "label", "getLabel", "()Lkotlinx/coroutines/flow/StateFlow;", "debugLabel", "getDebugLabel", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "autofillType", "Landroidx/compose/ui/autofill/AutofillType;", "getAutofillType$annotations", "()V", "getAutofillType", "()Landroidx/compose/ui/autofill/AutofillType;", "_fieldValue", "Lkotlinx/coroutines/flow/MutableStateFlow;", "fieldValue", "getFieldValue", "visualTransformation", "Landroidx/compose/ui/text/input/VisualTransformation;", "getVisualTransformation", "rawFieldValue", "getRawFieldValue", "contentDescription", "Lcom/stripe/android/core/strings/ResolvableString;", "getContentDescription", "_fieldState", "Lcom/stripe/android/uicore/elements/TextFieldState;", "fieldState", "getFieldState", "_hasFocus", "visibleError", "getVisibleError", "error", "Lcom/stripe/android/uicore/elements/FieldError;", "getError", "isComplete", "formFieldValue", "Lcom/stripe/android/uicore/forms/FormFieldEntry;", "getFormFieldValue", "trailingIcon", "Lcom/stripe/android/uicore/elements/TextFieldIcon;", "getTrailingIcon", "loading", "getLoading", "onValueChange", "displayFormatted", "onRawValueChange", "", "rawValue", "onFocusChange", "newHasFocus", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCvcController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CvcController.kt\ncom/stripe/android/ui/core/elements/CvcController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class CvcController
implements TextFieldController {
    @NotNull
    private final CvcConfig cvcTextFieldConfig;
    @Nullable
    private final String initialValue;
    private final boolean showOptionalLabel;
    private final int capitalization;
    private final int keyboardType;
    @NotNull
    private final StateFlow<Integer> _label;
    @NotNull
    private final StateFlow<Integer> label;
    @NotNull
    private final String debugLabel;
    @NotNull
    private final LayoutDirection layoutDirection;
    @NotNull
    private final AutofillType autofillType;
    @NotNull
    private final MutableStateFlow<String> _fieldValue;
    @NotNull
    private final StateFlow<String> fieldValue;
    @NotNull
    private final StateFlow<VisualTransformation> visualTransformation;
    @NotNull
    private final StateFlow<String> rawFieldValue;
    @NotNull
    private final StateFlow<ResolvableString> contentDescription;
    @NotNull
    private final StateFlow<TextFieldState> _fieldState;
    @NotNull
    private final StateFlow<TextFieldState> fieldState;
    @NotNull
    private final MutableStateFlow<Boolean> _hasFocus;
    @NotNull
    private final StateFlow<Boolean> visibleError;
    @NotNull
    private final StateFlow<FieldError> error;
    @NotNull
    private final StateFlow<Boolean> isComplete;
    @NotNull
    private final StateFlow<FormFieldEntry> formFieldValue;
    @NotNull
    private final StateFlow<TextFieldIcon> trailingIcon;
    @NotNull
    private final StateFlow<Boolean> loading;
    public static final int $stable = 8;

    public CvcController(@NotNull CvcConfig cvcTextFieldConfig, @NotNull StateFlow<? extends CardBrand> cardBrandFlow, @Nullable String initialValue, boolean showOptionalLabel) {
        Intrinsics.checkNotNullParameter((Object)cvcTextFieldConfig, (String)"cvcTextFieldConfig");
        Intrinsics.checkNotNullParameter(cardBrandFlow, (String)"cardBrandFlow");
        this.cvcTextFieldConfig = cvcTextFieldConfig;
        this.initialValue = initialValue;
        this.showOptionalLabel = showOptionalLabel;
        this.capitalization = this.cvcTextFieldConfig.getCapitalization-IUNYP9k();
        this.keyboardType = this.cvcTextFieldConfig.getKeyboard-PjHm6EE();
        this._label = StateFlowsKt.mapAsStateFlow(cardBrandFlow, CvcController::_label$lambda$0);
        this.label = this._label;
        this.debugLabel = this.cvcTextFieldConfig.getDebugLabel();
        this.layoutDirection = LayoutDirection.Ltr;
        this.autofillType = AutofillType.CreditCardSecurityCode;
        this._fieldValue = StateFlowKt.MutableStateFlow((Object)"");
        this.fieldValue = FlowKt.asStateFlow(this._fieldValue);
        this.visualTransformation = StateFlowsKt.mapAsStateFlow((StateFlow)((StateFlow)this._fieldValue), arg_0 -> CvcController.visualTransformation$lambda$1(this, arg_0));
        this.rawFieldValue = StateFlowsKt.mapAsStateFlow((StateFlow)((StateFlow)this._fieldValue), arg_0 -> CvcController.rawFieldValue$lambda$2(this, arg_0));
        this.contentDescription = StateFlowsKt.mapAsStateFlow((StateFlow)((StateFlow)this._fieldValue), CvcController::contentDescription$lambda$3);
        this._fieldState = StateFlowsKt.combineAsStateFlow(cardBrandFlow, (StateFlow)((StateFlow)this._fieldValue), (arg_0, arg_1) -> CvcController._fieldState$lambda$4(this, arg_0, arg_1));
        this.fieldState = this._fieldState;
        this._hasFocus = StateFlowKt.MutableStateFlow((Object)false);
        this.visibleError = StateFlowsKt.combineAsStateFlow(this._fieldState, (StateFlow)((StateFlow)this._hasFocus), CvcController::visibleError$lambda$5);
        this.error = StateFlowsKt.combineAsStateFlow(this.getVisibleError(), this._fieldState, CvcController::error$lambda$7);
        this.isComplete = StateFlowsKt.mapAsStateFlow(this._fieldState, CvcController::isComplete$lambda$8);
        this.formFieldValue = StateFlowsKt.combineAsStateFlow(this.isComplete(), this.getRawFieldValue(), CvcController::formFieldValue$lambda$9);
        this.trailingIcon = StateFlowsKt.mapAsStateFlow(cardBrandFlow, CvcController::trailingIcon$lambda$10);
        this.loading = StateFlowsKt.stateFlowOf((Object)false);
        String string2 = this.getInitialValue();
        if (string2 == null) {
            string2 = "";
        }
        this.onRawValueChange(string2);
    }

    public /* synthetic */ CvcController(CvcConfig cvcConfig, StateFlow stateFlow, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            cvcConfig = new CvcConfig();
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(cvcConfig, (StateFlow<? extends CardBrand>)stateFlow, string2, bl);
    }

    @Nullable
    public String getInitialValue() {
        return this.initialValue;
    }

    public boolean getShowOptionalLabel() {
        return this.showOptionalLabel;
    }

    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    public int getKeyboardType-PjHm6EE() {
        return this.keyboardType;
    }

    @NotNull
    public StateFlow<Integer> getLabel() {
        return this.label;
    }

    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @NotNull
    public LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    @NotNull
    public AutofillType getAutofillType() {
        return this.autofillType;
    }

    public static /* synthetic */ void getAutofillType$annotations() {
    }

    @NotNull
    public StateFlow<String> getFieldValue() {
        return this.fieldValue;
    }

    @NotNull
    public StateFlow<VisualTransformation> getVisualTransformation() {
        return this.visualTransformation;
    }

    @NotNull
    public StateFlow<String> getRawFieldValue() {
        return this.rawFieldValue;
    }

    @NotNull
    public StateFlow<ResolvableString> getContentDescription() {
        return this.contentDescription;
    }

    @NotNull
    public StateFlow<TextFieldState> getFieldState() {
        return this.fieldState;
    }

    @NotNull
    public StateFlow<Boolean> getVisibleError() {
        return this.visibleError;
    }

    @NotNull
    public StateFlow<FieldError> getError() {
        return this.error;
    }

    @NotNull
    public StateFlow<Boolean> isComplete() {
        return this.isComplete;
    }

    @NotNull
    public StateFlow<FormFieldEntry> getFormFieldValue() {
        return this.formFieldValue;
    }

    @NotNull
    public StateFlow<TextFieldIcon> getTrailingIcon() {
        return this.trailingIcon;
    }

    @NotNull
    public StateFlow<Boolean> getLoading() {
        return this.loading;
    }

    @Nullable
    public TextFieldState onValueChange(@NotNull String displayFormatted) {
        Intrinsics.checkNotNullParameter((Object)displayFormatted, (String)"displayFormatted");
        this._fieldValue.setValue((Object)this.cvcTextFieldConfig.filter(displayFormatted));
        return null;
    }

    public void onRawValueChange(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        this.onValueChange(this.cvcTextFieldConfig.convertFromRaw(rawValue));
    }

    public void onFocusChange(boolean newHasFocus) {
        this._hasFocus.setValue((Object)newHasFocus);
    }

    public void onDropdownItemClicked(@NotNull TextFieldIcon.Dropdown.Item item) {
        TextFieldController.DefaultImpls.onDropdownItemClicked((TextFieldController)this, (TextFieldIcon.Dropdown.Item)item);
    }

    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    public void ComposeUI-MxjM1cc(boolean enabled, @NotNull SectionFieldElement field, @NotNull Modifier modifier, @NotNull Set<IdentifierSpec> hiddenIdentifiers, @Nullable IdentifierSpec lastTextFieldIdentifier, int nextFocusDirection, int previousFocusDirection, @Nullable Composer $composer, int $changed) {
        TextFieldController.DefaultImpls.ComposeUI-MxjM1cc((TextFieldController)this, (boolean)enabled, (SectionFieldElement)field, (Modifier)modifier, hiddenIdentifiers, (IdentifierSpec)lastTextFieldIdentifier, (int)nextFocusDirection, (int)previousFocusDirection, (Composer)$composer, (int)$changed);
    }

    @NotNull
    public StateFlow<String> getPlaceHolder() {
        return TextFieldController.DefaultImpls.getPlaceHolder((TextFieldController)this);
    }

    public boolean getEnabled() {
        return TextFieldController.DefaultImpls.getEnabled((TextFieldController)this);
    }

    private static final int _label$lambda$0(CardBrand cardBrand) {
        Intrinsics.checkNotNullParameter((Object)cardBrand, (String)"cardBrand");
        return cardBrand == CardBrand.AmericanExpress ? R.string.stripe_cvc_amex_hint : R.string.stripe_cvc_number_hint;
    }

    private static final VisualTransformation visualTransformation$lambda$1(CvcController this$0, String number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return this$0.cvcTextFieldConfig.determineVisualTransformation(number, 0);
    }

    private static final String rawFieldValue$lambda$2(CvcController this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.cvcTextFieldConfig.convertToRaw(it);
    }

    private static final ResolvableString contentDescription$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ResolvableStringUtilsKt.getResolvableString((String)AccessibilityKt.asIndividualDigits((String)it));
    }

    private static final TextFieldState _fieldState$lambda$4(CvcController this$0, CardBrand brand, String fieldValue) {
        Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
        Intrinsics.checkNotNullParameter((Object)fieldValue, (String)"fieldValue");
        return this$0.cvcTextFieldConfig.determineState(brand, fieldValue, brand.getMaxCvcLength());
    }

    private static final boolean visibleError$lambda$5(TextFieldState fieldState, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)fieldState, (String)"fieldState");
        return fieldState.shouldShowError(hasFocus);
    }

    private static final FieldError error$lambda$7(boolean visibleError, TextFieldState fieldState) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fieldState, (String)"fieldState");
        FieldError fieldError = fieldState.getError();
        if (fieldError != null) {
            FieldError fieldError2;
            FieldError it = fieldError2 = fieldError;
            boolean bl = false;
            object = visibleError ? fieldError2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final boolean isComplete$lambda$8(TextFieldState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isValid();
    }

    private static final FormFieldEntry formFieldValue$lambda$9(boolean complete, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new FormFieldEntry(value, complete);
    }

    private static final TextFieldIcon.Trailing trailingIcon$lambda$10(CardBrand it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new TextFieldIcon.Trailing(it.getCvcIcon(), null, false, null, 10, null);
    }
}

