/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.RestrictTo;
import androidx.appcompat.app.AppCompatDelegate;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.uicore.R;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a8\u0006\u0004"}, d2={"formatExpirationDateForAccessibility", "Lcom/stripe/android/core/strings/ResolvableString;", "input", "", "payments-ui-core_release"})
public final class ExpiryDateContentDescriptionFormatterKt {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public static final ResolvableString formatExpirationDateForAccessibility(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (((CharSequence)input).length() == 0) {
            return ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_expiration_date_empty_content_description, (Object[])new Object[0], null, (int)4, null);
        }
        if (StringsKt.toIntOrNull((String)input) == null) {
            return ResolvableStringUtilsKt.getResolvableString((String)input);
        }
        boolean canOnlyBeSingleDigitMonth = !StringsKt.isBlank((CharSequence)input) && input.charAt(0) != '0' && input.charAt(0) != '1';
        boolean canOnlyBeJanuary = input.length() > 1 && Integer.parseInt(StringsKt.take((String)input, (int)2)) > 12;
        boolean isSingleDigitMonth = canOnlyBeSingleDigitMonth || canOnlyBeJanuary;
        int lastIndexOfMonth = isSingleDigitMonth ? 0 : 1;
        Integer month = StringsKt.toIntOrNull((String)StringsKt.take((String)input, (int)(lastIndexOfMonth + 1)));
        Integer year = StringsKt.toIntOrNull((String)StringsKt.slice((String)input, (IntRange)new IntRange(lastIndexOfMonth + 1, StringsKt.getLastIndex((CharSequence)input))));
        try {
            if (month != null) {
                ResolvableString resolvableString;
                String string2;
                Locale locale = AppCompatDelegate.getApplicationLocales().get(0);
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                Locale locale2 = locale;
                Date date = new SimpleDateFormat("MM", locale2).parse(String.valueOf(month));
                if (date != null) {
                    Date it = date;
                    boolean bl = false;
                    string2 = new SimpleDateFormat("MMMM", locale2).format(it);
                } else {
                    string2 = null;
                }
                String monthName = string2;
                Integer n = year;
                if (n == null) {
                    Object[] objectArray = new Object[]{monthName};
                    return ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_expiration_date_month_complete_content_description, (Object[])objectArray, null, (int)4, null);
                }
                if (new IntRange(0, 9).contains(n.intValue())) {
                    Object[] objectArray = new Object[]{monthName};
                    resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_expiration_date_year_incomplete_content_description, (Object[])objectArray, null, (int)4, null);
                } else {
                    Object[] objectArray = new Object[]{monthName, 2000 + year};
                    resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_expiration_date_content_description, (Object[])objectArray, null, (int)4, null);
                }
                return resolvableString;
            }
            return ResolvableStringUtilsKt.getResolvableString((String)input);
        }
        catch (ParseException e) {
            return ResolvableStringUtilsKt.getResolvableString((String)input);
        }
    }
}

