/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.KeyboardCapitalization;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TransformedText;
import androidx.compose.ui.text.input.VisualTransformation;
import androidx.compose.ui.unit.LayoutDirection;
import com.stripe.android.R;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.ui.core.R;
import com.stripe.android.uicore.elements.TextFieldConfig;
import com.stripe.android.uicore.elements.TextFieldIcon;
import com.stripe.android.uicore.elements.TextFieldState;
import com.stripe.android.uicore.elements.TextFieldStateConstants;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\nH\u0016J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nH\u0016J\u0010\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\nH\u0016J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\nH\u0002R\u0016\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u000e8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0013\u0010\u0007R\u001c\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006."}, d2={"Lcom/stripe/android/ui/core/elements/IbanConfig;", "Lcom/stripe/android/uicore/elements/TextFieldConfig;", "<init>", "()V", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "getCapitalization-IUNYP9k", "()I", "I", "debugLabel", "", "getDebugLabel", "()Ljava/lang/String;", "label", "", "getLabel", "()Ljava/lang/Integer;", "keyboard", "Landroidx/compose/ui/text/input/KeyboardType;", "getKeyboard-PjHm6EE", "trailingIcon", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/uicore/elements/TextFieldIcon;", "getTrailingIcon", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "loading", "Lkotlinx/coroutines/flow/StateFlow;", "", "getLoading", "()Lkotlinx/coroutines/flow/StateFlow;", "visualTransformation", "Landroidx/compose/ui/text/input/VisualTransformation;", "getVisualTransformation", "()Landroidx/compose/ui/text/input/VisualTransformation;", "filter", "userTyped", "convertToRaw", "displayName", "convertFromRaw", "rawValue", "determineState", "Lcom/stripe/android/uicore/elements/TextFieldState;", "input", "isIbanValid", "iban", "Companion", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nIbanConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IbanConfig.kt\ncom/stripe/android/ui/core/elements/IbanConfig\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,136:1\n434#2:137\n507#2,5:138\n1088#2,2:143\n1188#2,3:145\n*S KotlinDebug\n*F\n+ 1 IbanConfig.kt\ncom/stripe/android/ui/core/elements/IbanConfig\n*L\n62#1:137\n62#1:138,5\n75#1:143,2\n48#1:145,3\n*E\n"})
public final class IbanConfig
implements TextFieldConfig {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int capitalization = KeyboardCapitalization.Companion.getCharacters-IUNYP9k();
    @NotNull
    private final String debugLabel;
    @StringRes
    private final int label = R.string.stripe_iban;
    private final int keyboard = KeyboardType.Companion.getAscii-PjHm6EE();
    @NotNull
    private final MutableStateFlow<TextFieldIcon> trailingIcon = StateFlowKt.MutableStateFlow((Object)new TextFieldIcon.Trailing(R.drawable.stripe_ic_bank_generic, null, true, null, 10, null));
    @NotNull
    private final StateFlow<Boolean> loading = (StateFlow)StateFlowKt.MutableStateFlow((Object)false);
    @NotNull
    private final VisualTransformation visualTransformation = IbanConfig::visualTransformation$lambda$1;
    public static final int $stable = 8;
    @Deprecated
    public static final int MIN_LENGTH = 8;
    @Deprecated
    public static final int MAX_LENGTH = 34;
    @NotNull
    private static final List<Character> VALID_INPUT_RANGES = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('0', '9')), (Iterable)((Iterable)new CharRange('a', 'z'))), (Iterable)((Iterable)new CharRange('A', 'Z')));

    public IbanConfig() {
        this.debugLabel = "iban";
    }

    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @NotNull
    public Integer getLabel() {
        return this.label;
    }

    public int getKeyboard-PjHm6EE() {
        return this.keyboard;
    }

    @NotNull
    public MutableStateFlow<TextFieldIcon> getTrailingIcon() {
        return this.trailingIcon;
    }

    @NotNull
    public StateFlow<Boolean> getLoading() {
        return this.loading;
    }

    @NotNull
    public VisualTransformation getVisualTransformation() {
        return this.visualTransformation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String filter(@NotNull String userTyped) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userTyped, (String)"userTyped");
        String $this$filter$iv = userTyped;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!VALID_INPUT_RANGES.contains(Character.valueOf(it))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string2 = StringsKt.take((String)((StringBuilder)destination$iv$iv).toString(), (int)34).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return string2;
    }

    @NotNull
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return displayName;
    }

    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        return rawValue;
    }

    @NotNull
    public TextFieldState determineState(@NotNull String input) {
        boolean bl;
        String countryCode;
        block6: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            CharSequence charSequence = input;
            if (StringsKt.isBlank((CharSequence)charSequence)) {
                boolean bl2 = false;
                return (TextFieldState)TextFieldStateConstants.Error.Blank.INSTANCE;
            }
            String string2 = StringsKt.take((String)input, (int)2).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            countryCode = string2;
            CharSequence $this$any$iv = countryCode;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl3 = false;
                if (!Character.isDigit(it)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            return (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_iban_invalid_start, null, false, 6, null);
        }
        if (countryCode.length() < 2) {
            return (TextFieldState)new TextFieldStateConstants.Error.Incomplete(R.string.stripe_iban_incomplete);
        }
        String[] stringArray = Locale.getISOCountries();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getISOCountries(...)");
        if (!ArraysKt.contains((Object[])stringArray, (Object)countryCode)) {
            Object[] objectArray = new String[]{countryCode};
            return (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.stripe_iban_invalid_country, objectArray, false, 4, null);
        }
        if (input.length() < 8) {
            return (TextFieldState)new TextFieldStateConstants.Error.Incomplete(R.string.stripe_iban_incomplete);
        }
        return this.isIbanValid(input) ? (TextFieldState)(input.length() == 34 ? (TextFieldStateConstants.Valid)TextFieldStateConstants.Valid.Full.INSTANCE : (TextFieldStateConstants.Valid)TextFieldStateConstants.Valid.Limitless.INSTANCE) : (TextFieldState)new TextFieldStateConstants.Error.Incomplete(R.string.stripe_invalid_bank_account_iban);
    }

    private final boolean isIbanValid(String iban) {
        String string2 = (StringsKt.takeLast((String)iban, (int)(iban.length() - 4)) + StringsKt.take((String)iban, (int)4)).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        CharSequence charSequence = string2;
        Regex regex = new Regex("[A-Z]");
        Function1 function1 = IbanConfig::isIbanValid$lambda$5;
        charSequence = regex.replace(charSequence, function1);
        return new BigInteger((String)charSequence).mod(new BigInteger("97")).equals(BigInteger.ONE);
    }

    @Nullable
    public LayoutDirection getLayoutDirection() {
        return TextFieldConfig.DefaultImpls.getLayoutDirection((TextFieldConfig)this);
    }

    @Nullable
    public String getPlaceHolder() {
        return TextFieldConfig.DefaultImpls.getPlaceHolder((TextFieldConfig)this);
    }

    public boolean getShouldAnnounceLabel() {
        return TextFieldConfig.DefaultImpls.getShouldAnnounceLabel((TextFieldConfig)this);
    }

    public boolean getShouldAnnounceFieldValue() {
        return TextFieldConfig.DefaultImpls.getShouldAnnounceFieldValue((TextFieldConfig)this);
    }

    @Nullable
    public Function1<String, ResolvableString> getOverrideContentDescriptionProvider() {
        return TextFieldConfig.DefaultImpls.getOverrideContentDescriptionProvider((TextFieldConfig)this);
    }

    /*
     * WARNING - void declaration
     */
    private static final TransformedText visualTransformation$lambda$1(AnnotatedString text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        StringBuilder output = new StringBuilder();
        CharSequence $this$forEachIndexed$iv = text.getText();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void char_;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int i2 = n;
            boolean bl = false;
            output.append((char)char_);
            if (i2 % 4 != 3 || i2 >= 33) continue;
            output.append(" ");
        }
        String string2 = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return new TransformedText(new AnnotatedString(string2, null, null, 6, null), new OffsetMapping(){

            public int originalToTransformed(int offset) {
                return offset + offset / 4;
            }

            public int transformedToOriginal(int offset) {
                return offset - offset / 5;
            }
        });
    }

    private static final CharSequence isIbanValid$lambda$5(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(StringsKt.first((CharSequence)it.getValue()) - 65 + 10);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/stripe/android/ui/core/elements/IbanConfig$Companion;", "", "<init>", "()V", "MIN_LENGTH", "", "MAX_LENGTH", "VALID_INPUT_RANGES", "", "", "getVALID_INPUT_RANGES", "()Ljava/util/List;", "payments-ui-core_release"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Character> getVALID_INPUT_RANGES() {
            return VALID_INPUT_RANGES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

