/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.uicore.elements.FormElement;
import com.stripe.android.uicore.elements.IdentifierSpec;
import com.stripe.android.uicore.elements.InputController;
import com.stripe.android.uicore.forms.FormFieldEntry;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\fJ \u0010\u0019\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b0\u001aH\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\u000bH\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010\u00a8\u0006("}, d2={"Lcom/stripe/android/ui/core/elements/StaticTextElement;", "Lcom/stripe/android/uicore/elements/FormElement;", "identifier", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "text", "Lcom/stripe/android/core/strings/ResolvableString;", "controller", "Lcom/stripe/android/uicore/elements/InputController;", "<init>", "(Lcom/stripe/android/uicore/elements/IdentifierSpec;Lcom/stripe/android/core/strings/ResolvableString;Lcom/stripe/android/uicore/elements/InputController;)V", "stringResId", "", "(Lcom/stripe/android/uicore/elements/IdentifierSpec;ILcom/stripe/android/uicore/elements/InputController;)V", "getIdentifier", "()Lcom/stripe/android/uicore/elements/IdentifierSpec;", "getText", "()Lcom/stripe/android/core/strings/ResolvableString;", "getController", "()Lcom/stripe/android/uicore/elements/InputController;", "allowsUserInteraction", "", "getAllowsUserInteraction", "()Z", "mandateText", "getMandateText", "getFormFieldValueFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lkotlin/Pair;", "Lcom/stripe/android/uicore/forms/FormFieldEntry;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class StaticTextElement
implements FormElement {
    @NotNull
    private final IdentifierSpec identifier;
    @NotNull
    private final ResolvableString text;
    @Nullable
    private final InputController controller;
    private final boolean allowsUserInteraction;
    @Nullable
    private final ResolvableString mandateText;
    public static final int $stable = 8;

    public StaticTextElement(@NotNull IdentifierSpec identifier, @NotNull ResolvableString text, @Nullable InputController controller) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.identifier = identifier;
        this.text = text;
        this.controller = controller;
    }

    public /* synthetic */ StaticTextElement(IdentifierSpec identifierSpec, ResolvableString resolvableString, InputController inputController, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            inputController = null;
        }
        this(identifierSpec, resolvableString, inputController);
    }

    @NotNull
    public IdentifierSpec getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final ResolvableString getText() {
        return this.text;
    }

    @Nullable
    public InputController getController() {
        return this.controller;
    }

    public StaticTextElement(@NotNull IdentifierSpec identifier, int stringResId, @Nullable InputController controller) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this(identifier, ResolvableStringUtilsKt.getResolvableString((int)stringResId), controller);
    }

    public /* synthetic */ StaticTextElement(IdentifierSpec identifierSpec, int n, InputController inputController, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            inputController = null;
        }
        this(identifierSpec, n, inputController);
    }

    public boolean getAllowsUserInteraction() {
        return this.allowsUserInteraction;
    }

    @Nullable
    public ResolvableString getMandateText() {
        return this.mandateText;
    }

    @NotNull
    public StateFlow<List<Pair<IdentifierSpec, FormFieldEntry>>> getFormFieldValueFlow() {
        return StateFlowsKt.stateFlowOf((Object)CollectionsKt.emptyList());
    }

    @NotNull
    public final IdentifierSpec component1() {
        return this.identifier;
    }

    @NotNull
    public final ResolvableString component2() {
        return this.text;
    }

    @Nullable
    public final InputController component3() {
        return this.controller;
    }

    @NotNull
    public final StaticTextElement copy(@NotNull IdentifierSpec identifier, @NotNull ResolvableString text, @Nullable InputController controller) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new StaticTextElement(identifier, text, controller);
    }

    public static /* synthetic */ StaticTextElement copy$default(StaticTextElement staticTextElement, IdentifierSpec identifierSpec, ResolvableString resolvableString, InputController inputController, int n, Object object) {
        if ((n & 1) != 0) {
            identifierSpec = staticTextElement.identifier;
        }
        if ((n & 2) != 0) {
            resolvableString = staticTextElement.text;
        }
        if ((n & 4) != 0) {
            inputController = staticTextElement.controller;
        }
        return staticTextElement.copy(identifierSpec, resolvableString, inputController);
    }

    @NotNull
    public String toString() {
        return "StaticTextElement(identifier=" + this.identifier + ", text=" + this.text + ", controller=" + this.controller + ")";
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = result * 31 + this.text.hashCode();
        result = result * 31 + (this.controller == null ? 0 : this.controller.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StaticTextElement)) {
            return false;
        }
        StaticTextElement staticTextElement = (StaticTextElement)other;
        if (!Intrinsics.areEqual((Object)this.identifier, (Object)staticTextElement.identifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)staticTextElement.text)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.controller, (Object)staticTextElement.controller);
    }

    @NotNull
    public StateFlow<List<IdentifierSpec>> getTextFieldIdentifiers() {
        return FormElement.DefaultImpls.getTextFieldIdentifiers((FormElement)this);
    }
}

