/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.ui.core.elements;

import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.KeyboardCapitalization;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.VisualTransformation;
import androidx.compose.ui.unit.LayoutDirection;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.ui.core.R;
import com.stripe.android.uicore.elements.TextFieldConfig;
import com.stripe.android.uicore.elements.TextFieldIcon;
import com.stripe.android.uicore.elements.TextFieldState;
import com.stripe.android.uicore.elements.TextFieldStateConstants;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0014H\u0016J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0014H\u0016J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u0014H\u0016J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0014H\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\n\u001a\u00020\u000b8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0019\u0010\u0011R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\"\u00a8\u0006/"}, d2={"Lcom/stripe/android/ui/core/elements/UpiConfig;", "Lcom/stripe/android/uicore/elements/TextFieldConfig;", "<init>", "()V", "upiPattern", "Lkotlin/text/Regex;", "getUpiPattern", "()Lkotlin/text/Regex;", "upiPattern$delegate", "Lkotlin/Lazy;", "label", "", "getLabel", "()Ljava/lang/Integer;", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "getCapitalization-IUNYP9k", "()I", "I", "debugLabel", "", "getDebugLabel", "()Ljava/lang/String;", "keyboard", "Landroidx/compose/ui/text/input/KeyboardType;", "getKeyboard-PjHm6EE", "visualTransformation", "Landroidx/compose/ui/text/input/VisualTransformation;", "getVisualTransformation", "()Landroidx/compose/ui/text/input/VisualTransformation;", "trailingIcon", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/uicore/elements/TextFieldIcon;", "getTrailingIcon", "()Lkotlinx/coroutines/flow/StateFlow;", "loading", "", "getLoading", "determineState", "Lcom/stripe/android/uicore/elements/TextFieldState;", "input", "filter", "userTyped", "convertToRaw", "displayName", "convertFromRaw", "rawValue", "payments-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class UpiConfig
implements TextFieldConfig {
    @NotNull
    private final Lazy upiPattern$delegate = LazyKt.lazy(UpiConfig::upiPattern_delegate$lambda$0);
    @StringRes
    private final int label = R.string.stripe_upi_id_label;
    private final int capitalization = KeyboardCapitalization.Companion.getNone-IUNYP9k();
    @NotNull
    private final String debugLabel;
    private final int keyboard = KeyboardType.Companion.getEmail-PjHm6EE();
    @Nullable
    private final VisualTransformation visualTransformation;
    @NotNull
    private final StateFlow<TextFieldIcon> trailingIcon = (StateFlow)StateFlowKt.MutableStateFlow(null);
    @NotNull
    private final StateFlow<Boolean> loading = (StateFlow)StateFlowKt.MutableStateFlow((Object)false);
    public static final int $stable = 8;

    public UpiConfig() {
        this.debugLabel = "upi_id";
    }

    private final Regex getUpiPattern() {
        Lazy lazy = this.upiPattern$delegate;
        return (Regex)lazy.getValue();
    }

    @NotNull
    public Integer getLabel() {
        return this.label;
    }

    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    public int getKeyboard-PjHm6EE() {
        return this.keyboard;
    }

    @Nullable
    public VisualTransformation getVisualTransformation() {
        return this.visualTransformation;
    }

    @NotNull
    public StateFlow<TextFieldIcon> getTrailingIcon() {
        return this.trailingIcon;
    }

    @NotNull
    public StateFlow<Boolean> getLoading() {
        return this.loading;
    }

    @NotNull
    public TextFieldState determineState(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        boolean isValid = this.getUpiPattern().matches((CharSequence)input) && input.length() <= 30;
        return ((CharSequence)input).length() == 0 ? (TextFieldState)TextFieldStateConstants.Error.Blank.INSTANCE : (isValid ? (TextFieldState)TextFieldStateConstants.Valid.Limitless.INSTANCE : (TextFieldState)new TextFieldStateConstants.Error.Incomplete(R.string.stripe_invalid_upi_id));
    }

    @NotNull
    public String filter(@NotNull String userTyped) {
        Intrinsics.checkNotNullParameter((Object)userTyped, (String)"userTyped");
        return ((Object)StringsKt.trim((CharSequence)userTyped)).toString();
    }

    @NotNull
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return displayName;
    }

    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        return rawValue;
    }

    @Nullable
    public LayoutDirection getLayoutDirection() {
        return TextFieldConfig.DefaultImpls.getLayoutDirection((TextFieldConfig)this);
    }

    @Nullable
    public String getPlaceHolder() {
        return TextFieldConfig.DefaultImpls.getPlaceHolder((TextFieldConfig)this);
    }

    public boolean getShouldAnnounceLabel() {
        return TextFieldConfig.DefaultImpls.getShouldAnnounceLabel((TextFieldConfig)this);
    }

    public boolean getShouldAnnounceFieldValue() {
        return TextFieldConfig.DefaultImpls.getShouldAnnounceFieldValue((TextFieldConfig)this);
    }

    @Nullable
    public Function1<String, ResolvableString> getOverrideContentDescriptionProvider() {
        return TextFieldConfig.DefaultImpls.getOverrideContentDescriptionProvider((TextFieldConfig)this);
    }

    private static final Regex upiPattern_delegate$lambda$0() {
        return new Regex("[a-zA-Z0-9.\\-_]{2,256}@[a-zA-Z]{2,64}");
    }
}

