/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.savedstate.SavedStateRegistryOwner;
import com.stripe.android.core.Logger;
import com.stripe.android.core.injection.IOContext;
import com.stripe.android.core.injection.Injectable;
import com.stripe.android.core.injection.InjectableKtxKt;
import com.stripe.android.core.injection.InjectorKey;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.injection.LinkPaymentLauncherFactory;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.payments.paymentlauncher.PaymentResult;
import com.stripe.android.paymentsheet.PaymentOptionContract;
import com.stripe.android.paymentsheet.PaymentOptionResult;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.PrefsRepository;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.injection.DaggerPaymentOptionsViewModelFactoryComponent;
import com.stripe.android.paymentsheet.injection.PaymentOptionsViewModelSubcomponent;
import com.stripe.android.paymentsheet.model.FragmentConfig;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.repositories.CustomerRepository;
import com.stripe.android.paymentsheet.ui.PrimaryButton;
import com.stripe.android.paymentsheet.viewmodels.BaseSheetViewModel;
import com.stripe.android.ui.core.forms.resources.ResourceRepository;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002OPBq\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0001\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0019\u00105\u001a\u0002062\n\b\u0001\u0010$\u001a\u0004\u0018\u000107H\u0016\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u000206H\u0016J\b\u0010=\u001a\u000206H\u0016J\u0010\u0010>\u001a\u0002062\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u0002062\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u000206H\u0016J\u0006\u0010E\u001a\u000206J\u0010\u0010F\u001a\u0002062\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u0002062\u0006\u0010G\u001a\u00020HH\u0002J\u000e\u0010J\u001a\u0002062\u0006\u0010K\u001a\u00020LJ\u0012\u0010M\u001a\u0002062\b\u0010N\u001a\u0004\u0018\u00010HH\u0016R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001d8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140%8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f0%X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010'R\u0014\u00102\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006Q"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel;", "Lcom/stripe/android/paymentsheet/viewmodels/BaseSheetViewModel;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "args", "Lcom/stripe/android/paymentsheet/PaymentOptionContract$Args;", "prefsRepositoryFactory", "Lkotlin/Function1;", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerConfiguration;", "Lcom/stripe/android/paymentsheet/PrefsRepository;", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "customerRepository", "Lcom/stripe/android/paymentsheet/repositories/CustomerRepository;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "application", "Landroid/app/Application;", "logger", "Lcom/stripe/android/core/Logger;", "injectorKey", "", "resourceRepository", "Lcom/stripe/android/ui/core/forms/resources/ResourceRepository;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "linkPaymentLauncherFactory", "Lcom/stripe/android/link/injection/LinkPaymentLauncherFactory;", "(Lcom/stripe/android/paymentsheet/PaymentOptionContract$Args;Lkotlin/jvm/functions/Function1;Lcom/stripe/android/paymentsheet/analytics/EventReporter;Lcom/stripe/android/paymentsheet/repositories/CustomerRepository;Lkotlin/coroutines/CoroutineContext;Landroid/app/Application;Lcom/stripe/android/core/Logger;Ljava/lang/String;Lcom/stripe/android/ui/core/forms/resources/ResourceRepository;Landroidx/lifecycle/SavedStateHandle;Lcom/stripe/android/link/injection/LinkPaymentLauncherFactory;)V", "_error", "Landroidx/lifecycle/MutableLiveData;", "_paymentOptionResult", "Lcom/stripe/android/paymentsheet/PaymentOptionResult;", "get_paymentOptionResult$paymentsheet_release$annotations", "()V", "get_paymentOptionResult$paymentsheet_release", "()Landroidx/lifecycle/MutableLiveData;", "error", "Landroidx/lifecycle/LiveData;", "getError$paymentsheet_release", "()Landroidx/lifecycle/LiveData;", "hasTransitionToUnsavedCard", "", "newLpm", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$New;", "getNewLpm", "()Lcom/stripe/android/paymentsheet/model/PaymentSelection$New;", "setNewLpm", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection$New;)V", "paymentOptionResult", "getPaymentOptionResult$paymentsheet_release", "shouldTransitionToUnsavedCard", "getShouldTransitionToUnsavedCard", "()Z", "onError", "", "", "(Ljava/lang/Integer;)V", "onFatal", "throwable", "", "onFinish", "onLinkLaunched", "onLinkPaymentResult", "result", "Lcom/stripe/android/link/LinkActivityResult;", "onPaymentResult", "paymentResult", "Lcom/stripe/android/payments/paymentlauncher/PaymentResult;", "onUserCancel", "onUserSelection", "processExistingPaymentMethod", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "processNewPaymentMethod", "resolveTransitionTarget", "config", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "updateSelection", "selection", "Factory", "TransitionTarget", "paymentsheet_release"})
@JvmSuppressWildcards
public final class PaymentOptionsViewModel
extends BaseSheetViewModel<TransitionTarget> {
    @NotNull
    private final MutableLiveData<PaymentOptionResult> _paymentOptionResult;
    @NotNull
    private final LiveData<PaymentOptionResult> paymentOptionResult;
    @NotNull
    private final MutableLiveData<String> _error;
    @Nullable
    private PaymentSelection.New newLpm;
    private boolean hasTransitionToUnsavedCard;

    @Inject
    public PaymentOptionsViewModel(@NotNull PaymentOptionContract.Args args, @NotNull Function1<PaymentSheet.CustomerConfiguration, PrefsRepository> prefsRepositoryFactory, @NotNull EventReporter eventReporter, @NotNull CustomerRepository customerRepository, @IOContext @NotNull CoroutineContext workContext, @NotNull Application application, @NotNull Logger logger, @InjectorKey @NotNull String injectorKey, @NotNull ResourceRepository resourceRepository, @NotNull SavedStateHandle savedStateHandle, @NotNull LinkPaymentLauncherFactory linkPaymentLauncherFactory) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(prefsRepositoryFactory, (String)"prefsRepositoryFactory");
        Intrinsics.checkNotNullParameter((Object)eventReporter, (String)"eventReporter");
        Intrinsics.checkNotNullParameter((Object)customerRepository, (String)"customerRepository");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)injectorKey, (String)"injectorKey");
        Intrinsics.checkNotNullParameter((Object)resourceRepository, (String)"resourceRepository");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)linkPaymentLauncherFactory, (String)"linkPaymentLauncherFactory");
        PaymentSheet.Configuration configuration = args.getConfig();
        PaymentSheet.Configuration configuration2 = args.getConfig();
        PrefsRepository prefsRepository = (PrefsRepository)prefsRepositoryFactory.invoke(configuration2 == null ? null : configuration2.getCustomer());
        super(application, configuration, eventReporter, customerRepository, prefsRepository, workContext, logger, injectorKey, resourceRepository, savedStateHandle, linkPaymentLauncherFactory);
        this._paymentOptionResult = new MutableLiveData();
        this.paymentOptionResult = (LiveData)this._paymentOptionResult;
        this._error = new MutableLiveData();
        this.newLpm = args.getNewLpm();
        savedStateHandle.set("google_pay_ready", (Object)args.isGooglePayReady());
        this.setupLink(args.getStripeIntent(), false);
        this.setStripeIntent(args.getStripeIntent());
        savedStateHandle.set("customer_payment_methods", args.getPaymentMethods());
        savedStateHandle.set("processing", (Object)false);
    }

    @NotNull
    public final MutableLiveData<PaymentOptionResult> get_paymentOptionResult$paymentsheet_release() {
        return this._paymentOptionResult;
    }

    @VisibleForTesting
    public static /* synthetic */ void get_paymentOptionResult$paymentsheet_release$annotations() {
    }

    @NotNull
    public final LiveData<PaymentOptionResult> getPaymentOptionResult$paymentsheet_release() {
        return this.paymentOptionResult;
    }

    @NotNull
    public final LiveData<String> getError$paymentsheet_release() {
        return (LiveData)this._error;
    }

    @Override
    @Nullable
    public PaymentSelection.New getNewLpm() {
        return this.newLpm;
    }

    @Override
    public void setNewLpm(@Nullable PaymentSelection.New new_) {
        this.newLpm = new_;
    }

    private final boolean getShouldTransitionToUnsavedCard() {
        return !this.hasTransitionToUnsavedCard && this.getNewLpm() != null;
    }

    @Override
    public void onFatal(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.get_fatal().setValue((Object)throwable);
        this._paymentOptionResult.setValue((Object)new PaymentOptionResult.Failed(throwable));
    }

    @Override
    public void onUserCancel() {
        this._paymentOptionResult.setValue((Object)new PaymentOptionResult.Canceled((Throwable)this.get_fatal().getValue()));
    }

    @Override
    public void onFinish() {
        this.onUserSelection();
    }

    @Override
    public void onError(@StringRes @Nullable Integer error) {
        Integer n = error;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            this._error.setValue((Object)this.getApplication().getString(error.intValue()));
        }
    }

    public final void onUserSelection() {
        PaymentSelection paymentSelection = (PaymentSelection)this.getSelection$paymentsheet_release().getValue();
        if (paymentSelection != null) {
            PaymentSelection paymentSelection2 = paymentSelection;
            boolean bl = false;
            this.getEventReporter$paymentsheet_release().onSelectPaymentOption(paymentSelection2);
            PaymentSelection paymentSelection3 = paymentSelection2;
            if (paymentSelection3 instanceof PaymentSelection.Saved) {
                if (((PaymentSelection.Saved)paymentSelection2).getPaymentMethod().type != PaymentMethod.Type.USBankAccount) {
                    this.processExistingPaymentMethod(paymentSelection2);
                }
            } else if (paymentSelection3 instanceof PaymentSelection.GooglePay) {
                this.processExistingPaymentMethod(paymentSelection2);
            } else if (paymentSelection3 instanceof PaymentSelection.New) {
                this.processNewPaymentMethod(paymentSelection2);
            }
        }
    }

    @Override
    public void onLinkLaunched() {
        super.onLinkLaunched();
        this.get_processing$paymentsheet_release().setValue((Object)true);
    }

    @Override
    public void onLinkPaymentResult(@NotNull LinkActivityResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result instanceof LinkActivityResult.Success.Selected) {
            PaymentSelection.New.Link linkSelection = new PaymentSelection.New.Link(((LinkActivityResult.Success.Selected)result).getPaymentDetails(), ((LinkActivityResult.Success.Selected)result).getPaymentMethodCreateParams());
            this.updateSelection(linkSelection);
            this.onUserSelection();
        } else {
            super.onLinkPaymentResult(result);
            this.get_processing$paymentsheet_release().setValue((Object)false);
        }
    }

    @Override
    public void onPaymentResult(@NotNull PaymentResult paymentResult) {
        Intrinsics.checkNotNullParameter((Object)paymentResult, (String)"paymentResult");
        this.get_processing$paymentsheet_release().setValue((Object)false);
    }

    @Override
    public void updateSelection(@Nullable PaymentSelection selection) {
        super.updateSelection(selection);
        if (selection instanceof PaymentSelection.Saved && ((PaymentSelection.Saved)selection).getPaymentMethod().type == PaymentMethod.Type.USBankAccount) {
            this.updateBelowButtonText(this.getApplication().getString(R.string.us_bank_account_payment_sheet_saved_mandate));
            String string2 = this.getApplication().getString(R.string.stripe_continue_button_label);
            this.updatePrimaryButtonUIState(new PrimaryButton.UIState(string2, (Function0<Unit>)((Function0)new Function0<Unit>(this, selection){
                final /* synthetic */ PaymentOptionsViewModel this$0;
                final /* synthetic */ PaymentSelection $selection;
                {
                    this.this$0 = $receiver;
                    this.$selection = $selection;
                    super(0);
                }

                public final void invoke() {
                    PaymentOptionsViewModel.access$processExistingPaymentMethod(this.this$0, this.$selection);
                }
            }), true, true));
        }
    }

    private final void processExistingPaymentMethod(PaymentSelection paymentSelection) {
        this.getPrefsRepository().savePaymentSelection(paymentSelection);
        this._paymentOptionResult.setValue((Object)new PaymentOptionResult.Succeeded(paymentSelection));
    }

    private final void processNewPaymentMethod(PaymentSelection paymentSelection) {
        this.getPrefsRepository().savePaymentSelection(paymentSelection);
        this._paymentOptionResult.setValue((Object)new PaymentOptionResult.Succeeded(paymentSelection));
    }

    public final void resolveTransitionTarget(@NotNull FragmentConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.getShouldTransitionToUnsavedCard()) {
            this.hasTransitionToUnsavedCard = true;
            this.transitionTo(new TransitionTarget.AddPaymentMethodFull(config));
        }
    }

    public static final /* synthetic */ void access$processExistingPaymentMethod(PaymentOptionsViewModel $this, PaymentSelection paymentSelection) {
        $this.processExistingPaymentMethod(paymentSelection);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "", "()V", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "AddPaymentMethodFull", "AddPaymentMethodSheet", "SelectSavedPaymentMethod", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$SelectSavedPaymentMethod;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$AddPaymentMethodFull;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$AddPaymentMethodSheet;", "paymentsheet_release"})
    public static abstract class TransitionTarget {
        private TransitionTarget() {
        }

        @NotNull
        public abstract FragmentConfig getFragmentConfig();

        public /* synthetic */ TransitionTarget(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$SelectSavedPaymentMethod;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "(Lcom/stripe/android/paymentsheet/model/FragmentConfig;)V", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
        @StabilityInferred(parameters=0)
        public static final class SelectSavedPaymentMethod
        extends TransitionTarget {
            @NotNull
            private final FragmentConfig fragmentConfig;
            public static final int $stable = 8;

            public SelectSavedPaymentMethod(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                super(null);
                this.fragmentConfig = fragmentConfig;
            }

            @Override
            @NotNull
            public FragmentConfig getFragmentConfig() {
                return this.fragmentConfig;
            }

            @NotNull
            public final FragmentConfig component1() {
                return this.getFragmentConfig();
            }

            @NotNull
            public final SelectSavedPaymentMethod copy(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                return new SelectSavedPaymentMethod(fragmentConfig);
            }

            public static /* synthetic */ SelectSavedPaymentMethod copy$default(SelectSavedPaymentMethod selectSavedPaymentMethod, FragmentConfig fragmentConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    fragmentConfig = selectSavedPaymentMethod.getFragmentConfig();
                }
                return selectSavedPaymentMethod.copy(fragmentConfig);
            }

            @NotNull
            public String toString() {
                return "SelectSavedPaymentMethod(fragmentConfig=" + this.getFragmentConfig() + ')';
            }

            public int hashCode() {
                return this.getFragmentConfig().hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SelectSavedPaymentMethod)) {
                    return false;
                }
                SelectSavedPaymentMethod selectSavedPaymentMethod = (SelectSavedPaymentMethod)other;
                return Intrinsics.areEqual((Object)this.getFragmentConfig(), (Object)selectSavedPaymentMethod.getFragmentConfig());
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$AddPaymentMethodFull;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "(Lcom/stripe/android/paymentsheet/model/FragmentConfig;)V", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
        @StabilityInferred(parameters=0)
        public static final class AddPaymentMethodFull
        extends TransitionTarget {
            @NotNull
            private final FragmentConfig fragmentConfig;
            public static final int $stable = 8;

            public AddPaymentMethodFull(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                super(null);
                this.fragmentConfig = fragmentConfig;
            }

            @Override
            @NotNull
            public FragmentConfig getFragmentConfig() {
                return this.fragmentConfig;
            }

            @NotNull
            public final FragmentConfig component1() {
                return this.getFragmentConfig();
            }

            @NotNull
            public final AddPaymentMethodFull copy(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                return new AddPaymentMethodFull(fragmentConfig);
            }

            public static /* synthetic */ AddPaymentMethodFull copy$default(AddPaymentMethodFull addPaymentMethodFull, FragmentConfig fragmentConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    fragmentConfig = addPaymentMethodFull.getFragmentConfig();
                }
                return addPaymentMethodFull.copy(fragmentConfig);
            }

            @NotNull
            public String toString() {
                return "AddPaymentMethodFull(fragmentConfig=" + this.getFragmentConfig() + ')';
            }

            public int hashCode() {
                return this.getFragmentConfig().hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AddPaymentMethodFull)) {
                    return false;
                }
                AddPaymentMethodFull addPaymentMethodFull = (AddPaymentMethodFull)other;
                return Intrinsics.areEqual((Object)this.getFragmentConfig(), (Object)addPaymentMethodFull.getFragmentConfig());
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget$AddPaymentMethodSheet;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "fragmentConfig", "Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "(Lcom/stripe/android/paymentsheet/model/FragmentConfig;)V", "getFragmentConfig", "()Lcom/stripe/android/paymentsheet/model/FragmentConfig;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
        @StabilityInferred(parameters=0)
        public static final class AddPaymentMethodSheet
        extends TransitionTarget {
            @NotNull
            private final FragmentConfig fragmentConfig;
            public static final int $stable = 8;

            public AddPaymentMethodSheet(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                super(null);
                this.fragmentConfig = fragmentConfig;
            }

            @Override
            @NotNull
            public FragmentConfig getFragmentConfig() {
                return this.fragmentConfig;
            }

            @NotNull
            public final FragmentConfig component1() {
                return this.getFragmentConfig();
            }

            @NotNull
            public final AddPaymentMethodSheet copy(@NotNull FragmentConfig fragmentConfig) {
                Intrinsics.checkNotNullParameter((Object)fragmentConfig, (String)"fragmentConfig");
                return new AddPaymentMethodSheet(fragmentConfig);
            }

            public static /* synthetic */ AddPaymentMethodSheet copy$default(AddPaymentMethodSheet addPaymentMethodSheet, FragmentConfig fragmentConfig, int n, Object object) {
                if ((n & 1) != 0) {
                    fragmentConfig = addPaymentMethodSheet.getFragmentConfig();
                }
                return addPaymentMethodSheet.copy(fragmentConfig);
            }

            @NotNull
            public String toString() {
                return "AddPaymentMethodSheet(fragmentConfig=" + this.getFragmentConfig() + ')';
            }

            public int hashCode() {
                return this.getFragmentConfig().hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AddPaymentMethodSheet)) {
                    return false;
                }
                AddPaymentMethodSheet addPaymentMethodSheet = (AddPaymentMethodSheet)other;
                return Intrinsics.areEqual((Object)this.getFragmentConfig(), (Object)addPaymentMethodSheet.getFragmentConfig());
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\"B5\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ5\u0010\u0015\u001a\u0002H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$Factory;", "Landroidx/lifecycle/AbstractSavedStateViewModelFactory;", "Lcom/stripe/android/core/injection/Injectable;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$Factory$FallbackInitializeParam;", "applicationSupplier", "Lkotlin/Function0;", "Landroid/app/Application;", "starterArgsSupplier", "Lcom/stripe/android/paymentsheet/PaymentOptionContract$Args;", "owner", "Landroidx/savedstate/SavedStateRegistryOwner;", "defaultArgs", "Landroid/os/Bundle;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Landroidx/savedstate/SavedStateRegistryOwner;Landroid/os/Bundle;)V", "subComponentBuilderProvider", "Ljavax/inject/Provider;", "Lcom/stripe/android/paymentsheet/injection/PaymentOptionsViewModelSubcomponent$Builder;", "getSubComponentBuilderProvider", "()Ljavax/inject/Provider;", "setSubComponentBuilderProvider", "(Ljavax/inject/Provider;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "key", "", "modelClass", "Ljava/lang/Class;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Ljava/lang/String;Ljava/lang/Class;Landroidx/lifecycle/SavedStateHandle;)Landroidx/lifecycle/ViewModel;", "fallbackInitialize", "", "arg", "FallbackInitializeParam", "paymentsheet_release"})
    public static final class Factory
    extends AbstractSavedStateViewModelFactory
    implements Injectable<FallbackInitializeParam> {
        @NotNull
        private final Function0<Application> applicationSupplier;
        @NotNull
        private final Function0<PaymentOptionContract.Args> starterArgsSupplier;
        @Inject
        public Provider<PaymentOptionsViewModelSubcomponent.Builder> subComponentBuilderProvider;

        public Factory(@NotNull Function0<Application> applicationSupplier, @NotNull Function0<PaymentOptionContract.Args> starterArgsSupplier, @NotNull SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs) {
            Intrinsics.checkNotNullParameter(applicationSupplier, (String)"applicationSupplier");
            Intrinsics.checkNotNullParameter(starterArgsSupplier, (String)"starterArgsSupplier");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner, defaultArgs);
            this.applicationSupplier = applicationSupplier;
            this.starterArgsSupplier = starterArgsSupplier;
        }

        public /* synthetic */ Factory(Function0 function0, Function0 function02, SavedStateRegistryOwner savedStateRegistryOwner, Bundle bundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bundle = null;
            }
            this((Function0<Application>)function0, (Function0<PaymentOptionContract.Args>)function02, savedStateRegistryOwner, bundle);
        }

        public void fallbackInitialize(@NotNull FallbackInitializeParam arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            DaggerPaymentOptionsViewModelFactoryComponent.builder().context((Context)arg.getApplication()).productUsage(arg.getProductUsage()).build().inject(this);
        }

        @NotNull
        public final Provider<PaymentOptionsViewModelSubcomponent.Builder> getSubComponentBuilderProvider() {
            Provider<PaymentOptionsViewModelSubcomponent.Builder> provider = this.subComponentBuilderProvider;
            if (provider != null) {
                return provider;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"subComponentBuilderProvider");
            return null;
        }

        public final void setSubComponentBuilderProvider(@NotNull Provider<PaymentOptionsViewModelSubcomponent.Builder> provider) {
            Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
            this.subComponentBuilderProvider = provider;
        }

        @NotNull
        protected <T extends ViewModel> T create(@NotNull String key, @NotNull Class<T> modelClass, @NotNull SavedStateHandle savedStateHandle) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
            Application application = (Application)this.applicationSupplier.invoke();
            PaymentOptionContract.Args starterArgs2 = (PaymentOptionContract.Args)this.starterArgsSupplier.invoke();
            InjectableKtxKt.injectWithFallback((Injectable)this, (String)((PaymentOptionContract.Args)this.starterArgsSupplier.invoke()).getInjectorKey(), (Object)new FallbackInitializeParam(application, starterArgs2.getProductUsage()));
            return (T)((ViewModel)((PaymentOptionsViewModelSubcomponent.Builder)this.getSubComponentBuilderProvider().get()).application(application).args(starterArgs2).savedStateHandle(savedStateHandle).build().getViewModel());
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$Factory$FallbackInitializeParam;", "", "application", "Landroid/app/Application;", "productUsage", "", "", "(Landroid/app/Application;Ljava/util/Set;)V", "getApplication", "()Landroid/app/Application;", "getProductUsage", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "paymentsheet_release"})
        public static final class FallbackInitializeParam {
            @NotNull
            private final Application application;
            @NotNull
            private final Set<String> productUsage;

            public FallbackInitializeParam(@NotNull Application application, @NotNull Set<String> productUsage) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
                this.application = application;
                this.productUsage = productUsage;
            }

            @NotNull
            public final Application getApplication() {
                return this.application;
            }

            @NotNull
            public final Set<String> getProductUsage() {
                return this.productUsage;
            }

            @NotNull
            public final Application component1() {
                return this.application;
            }

            @NotNull
            public final Set<String> component2() {
                return this.productUsage;
            }

            @NotNull
            public final FallbackInitializeParam copy(@NotNull Application application, @NotNull Set<String> productUsage) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
                return new FallbackInitializeParam(application, productUsage);
            }

            public static /* synthetic */ FallbackInitializeParam copy$default(FallbackInitializeParam fallbackInitializeParam, Application application, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    application = fallbackInitializeParam.application;
                }
                if ((n & 2) != 0) {
                    set = fallbackInitializeParam.productUsage;
                }
                return fallbackInitializeParam.copy(application, set);
            }

            @NotNull
            public String toString() {
                return "FallbackInitializeParam(application=" + this.application + ", productUsage=" + this.productUsage + ')';
            }

            public int hashCode() {
                int result = this.application.hashCode();
                result = result * 31 + ((Object)this.productUsage).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FallbackInitializeParam)) {
                    return false;
                }
                FallbackInitializeParam fallbackInitializeParam = (FallbackInitializeParam)other;
                if (!Intrinsics.areEqual((Object)this.application, (Object)fallbackInitializeParam.application)) {
                    return false;
                }
                return Intrinsics.areEqual(this.productUsage, fallbackInitializeParam.productUsage);
            }
        }
    }
}

