/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \t2\u00020\u0001:\u0007\t\n\u000b\f\r\u000e\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0006\u0010\u0011\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "Lcom/stripe/android/core/networking/AnalyticsEvent;", "()V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "Companion", "Dismiss", "Init", "Payment", "SelectPaymentOption", "ShowExistingPaymentOptions", "ShowNewPaymentOptionForm", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Init;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Dismiss;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowNewPaymentOptionForm;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowExistingPaymentOptions;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SelectPaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment;", "paymentsheet_release"})
public abstract class PaymentSheetEvent
implements AnalyticsEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String FIELD_CUSTOMER = "customer";
    @NotNull
    public static final String FIELD_GOOGLE_PAY = "googlepay";
    @NotNull
    public static final String FIELD_PRIMARY_BUTTON_COLOR = "primary_button_color";
    @NotNull
    public static final String FIELD_BILLING = "default_billing_details";
    @NotNull
    public static final String FIELD_DELAYED_PMS = "allows_delayed_payment_methods";
    @NotNull
    public static final String FIELD_PAYMENT_SHEET_CONFIGURATION = "payment_sheet_configuration";

    private PaymentSheetEvent() {
    }

    @NotNull
    public abstract Map<String, Object> getAdditionalParams();

    public /* synthetic */ PaymentSheetEvent(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Init;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "configuration", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Init
    extends PaymentSheetEvent {
        @NotNull
        private final EventReporter.Mode mode;
        @Nullable
        private final PaymentSheet.Configuration configuration;
        public static final int $stable = 8;

        public Init(@NotNull EventReporter.Mode mode, @Nullable PaymentSheet.Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.mode = mode;
            this.configuration = configuration;
        }

        @NotNull
        public String getEventName() {
            String string2;
            Object object = new String[2];
            String string3 = string2 = PaymentSheetEvent.FIELD_CUSTOMER;
            int n = 0;
            Object[] objectArray = object;
            boolean bl = false;
            PaymentSheet.Configuration configuration = this.configuration;
            boolean bl2 = (configuration == null ? null : configuration.getCustomer()) != null;
            objectArray[n] = bl2 ? string2 : null;
            String it = string2 = PaymentSheetEvent.FIELD_GOOGLE_PAY;
            n = 1;
            objectArray = object;
            boolean bl3 = false;
            PaymentSheet.Configuration configuration2 = this.configuration;
            bl2 = (configuration2 == null ? null : configuration2.getGooglePay()) != null;
            objectArray[n] = bl2 ? string2 : null;
            Object it2 = object = CollectionsKt.listOfNotNull((Object[])object);
            boolean bl4 = false;
            Object object2 = !it2.isEmpty() ? object : null;
            String configValue = object2 == null ? "default" : ((object = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null)) == null ? "default" : object);
            return Companion.formatEventName(this.mode, Intrinsics.stringPlus((String)"init_", (Object)configValue));
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            Pair[] pairArray = new Pair[5];
            PaymentSheet.Configuration configuration = this.configuration;
            pairArray[0] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_CUSTOMER, (Object)((configuration == null ? null : configuration.getCustomer()) != null ? 1 : 0));
            PaymentSheet.Configuration configuration2 = this.configuration;
            pairArray[1] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_GOOGLE_PAY, (Object)((configuration2 == null ? null : configuration2.getGooglePay()) != null ? 1 : 0));
            PaymentSheet.Configuration configuration3 = this.configuration;
            pairArray[2] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_PRIMARY_BUTTON_COLOR, (Object)((configuration3 == null ? null : configuration3.getPrimaryButtonColor()) != null ? 1 : 0));
            PaymentSheet.Configuration configuration4 = this.configuration;
            pairArray[3] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_BILLING, (Object)((configuration4 == null ? null : configuration4.getDefaultBillingDetails()) != null ? 1 : 0));
            PaymentSheet.Configuration configuration5 = this.configuration;
            pairArray[4] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_DELAYED_PMS, (Object)(configuration5 == null ? null : Boolean.valueOf(configuration5.getAllowsDelayedPaymentMethods())));
            Map configurationMap = MapsKt.mapOf((Pair[])pairArray);
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_PAYMENT_SHEET_CONFIGURATION, (Object)configurationMap));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Dismiss;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Dismiss
    extends PaymentSheetEvent {
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public Dismiss(@NotNull EventReporter.Mode mode) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.eventName = Companion.formatEventName(mode, "dismiss");
            this.additionalParams = MapsKt.emptyMap();
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowNewPaymentOptionForm;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowNewPaymentOptionForm
    extends PaymentSheetEvent {
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowNewPaymentOptionForm(@NotNull EventReporter.Mode mode) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.eventName = Companion.formatEventName(mode, "sheet_newpm_show");
            this.additionalParams = MapsKt.emptyMap();
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowExistingPaymentOptions;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowExistingPaymentOptions
    extends PaymentSheetEvent {
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowExistingPaymentOptions(@NotNull EventReporter.Mode mode) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.eventName = Companion.formatEventName(mode, "sheet_savedpm_show");
            this.additionalParams = MapsKt.emptyMap();
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SelectPaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Lcom/stripe/android/paymentsheet/model/PaymentSelection;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class SelectPaymentOption
    extends PaymentSheetEvent {
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public SelectPaymentOption(@NotNull EventReporter.Mode mode, @Nullable PaymentSelection paymentSelection) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.eventName = Companion.formatEventName(mode, "paymentoption_" + Companion.analyticsValue(paymentSelection) + "_select");
            this.additionalParams = MapsKt.emptyMap();
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "result", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;Lcom/stripe/android/paymentsheet/model/PaymentSelection;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "Result", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Payment
    extends PaymentSheetEvent {
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public Payment(@NotNull EventReporter.Mode mode, @NotNull Result result, @Nullable PaymentSelection paymentSelection) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"result");
            super(null);
            this.eventName = Companion.formatEventName(mode, "payment_" + Companion.analyticsValue(paymentSelection) + '_' + (Object)((Object)result));
            this.additionalParams = MapsKt.emptyMap();
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "toString", "Success", "Failure", "paymentsheet_release"})
        public static final class Result
        extends Enum<Result> {
            @NotNull
            private final String code;
            public static final /* enum */ Result Success = new Result("success");
            public static final /* enum */ Result Failure = new Result("failure");
            private static final /* synthetic */ Result[] $VALUES;

            private Result(String code) {
                this.code = code;
            }

            @NotNull
            public String toString() {
                return this.code;
            }

            public static Result[] values() {
                return (Result[])$VALUES.clone();
            }

            public static Result valueOf(String value) {
                return Enum.valueOf(Result.class, value);
            }

            static {
                $VALUES = resultArray = new Result[]{Result.Success, Result.Failure};
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Companion;", "", "()V", "FIELD_BILLING", "", "FIELD_CUSTOMER", "FIELD_DELAYED_PMS", "FIELD_GOOGLE_PAY", "FIELD_PAYMENT_SHEET_CONFIGURATION", "FIELD_PRIMARY_BUTTON_COLOR", "analyticsValue", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "formatEventName", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "eventName", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String analyticsValue(PaymentSelection paymentSelection) {
            PaymentSelection paymentSelection2 = paymentSelection;
            return Intrinsics.areEqual((Object)paymentSelection2, (Object)PaymentSelection.GooglePay.INSTANCE) ? PaymentSheetEvent.FIELD_GOOGLE_PAY : (paymentSelection2 instanceof PaymentSelection.Saved ? "savedpm" : (paymentSelection2 instanceof PaymentSelection.New ? "newpm" : "unknown"));
        }

        private final String formatEventName(EventReporter.Mode mode, String eventName) {
            return "mc_" + (Object)((Object)mode) + '_' + eventName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

