/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.DrawableRes;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.forms.Delayed;
import com.stripe.android.paymentsheet.forms.PIRequirement;
import com.stripe.android.paymentsheet.forms.PaymentMethodRequirements;
import com.stripe.android.paymentsheet.forms.PaymentMethodRequirementsKt;
import com.stripe.android.paymentsheet.forms.SIRequirement;
import com.stripe.android.paymentsheet.forms.ShippingAddress;
import com.stripe.android.paymentsheet.model.SupportedPaymentMethod;
import com.stripe.android.ui.core.elements.LayoutFormDescriptor;
import com.stripe.android.ui.core.elements.LayoutSpec;
import com.stripe.android.ui.core.forms.AffirmSpecKt;
import com.stripe.android.ui.core.forms.AfterpayClearpaySpecKt;
import com.stripe.android.ui.core.forms.AuBecsDebitSpecKt;
import com.stripe.android.ui.core.forms.BancontactSpecKt;
import com.stripe.android.ui.core.forms.CardSpecKt;
import com.stripe.android.ui.core.forms.EpsSpecKt;
import com.stripe.android.ui.core.forms.GiropaySpecKt;
import com.stripe.android.ui.core.forms.IdealSpecKt;
import com.stripe.android.ui.core.forms.KlarnaSpecKt;
import com.stripe.android.ui.core.forms.P24SpecKt;
import com.stripe.android.ui.core.forms.PaypalSpecKt;
import com.stripe.android.ui.core.forms.SepaDebitSpecKt;
import com.stripe.android.ui.core.forms.SofortSpecKt;
import com.stripe.android.ui.core.forms.USBankAccountSpecKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 02\u00020\u0001:\u000f+,-./0123456789B3\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ*\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\"\u0010\u001c\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ!\u0010\"\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0002\b#J\u0006\u0010$\u001a\u00020\u0014J\u001a\u0010%\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u001a\u0010&\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u001a\u0010'\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0012\u0010(\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010)\u001a\u00020*H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0001\u000e:;<=>?@ABCDEFG\u00a8\u0006H"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "Landroid/os/Parcelable;", "type", "Lcom/stripe/android/model/PaymentMethod$Type;", "displayNameResource", "", "iconResource", "requirement", "Lcom/stripe/android/paymentsheet/forms/PaymentMethodRequirements;", "formSpec", "Lcom/stripe/android/ui/core/elements/LayoutSpec;", "(Lcom/stripe/android/model/PaymentMethod$Type;IILcom/stripe/android/paymentsheet/forms/PaymentMethodRequirements;Lcom/stripe/android/ui/core/elements/LayoutSpec;)V", "getDisplayNameResource", "()I", "getFormSpec", "()Lcom/stripe/android/ui/core/elements/LayoutSpec;", "getIconResource", "getType", "()Lcom/stripe/android/model/PaymentMethod$Type;", "checkPaymentIntentRequirements", "", "requirements", "", "Lcom/stripe/android/paymentsheet/forms/PIRequirement;", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "config", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "checkSetupIntentRequirements", "Lcom/stripe/android/paymentsheet/forms/SIRequirement;", "getPMAddForm", "Lcom/stripe/android/ui/core/elements/LayoutFormDescriptor;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "getSpecWithFullfilledRequirements", "getSpecWithFullfilledRequirements$paymentsheet_release", "supportsCustomerSavedPM", "supportsPaymentIntentSfuNotSettable", "supportsPaymentIntentSfuSet", "supportsPaymentIntentSfuSettable", "supportsSetupIntent", "toString", "", "Affirm", "AfterpayClearpay", "AuBecsDebit", "Bancontact", "Card", "Companion", "Eps", "Giropay", "Ideal", "Klarna", "P24", "PayPal", "SepaDebit", "Sofort", "USBankAccount", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Card;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Bancontact;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Sofort;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Ideal;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$SepaDebit;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Eps;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$P24;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Giropay;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$AfterpayClearpay;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Klarna;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$PayPal;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Affirm;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$AuBecsDebit;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$USBankAccount;", "paymentsheet_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@StabilityInferred(parameters=0)
public abstract class SupportedPaymentMethod
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PaymentMethod.Type type;
    private final int displayNameResource;
    private final int iconResource;
    @NotNull
    private final PaymentMethodRequirements requirement;
    @NotNull
    private final LayoutSpec formSpec;
    public static final int $stable = 8;
    @NotNull
    private static final Lazy<List<SupportedPaymentMethod>> exposedPaymentMethods$delegate = LazyKt.lazy((Function0)Companion.exposedPaymentMethods.2.INSTANCE);

    private SupportedPaymentMethod(PaymentMethod.Type type, @StringRes int displayNameResource, @DrawableRes int iconResource, PaymentMethodRequirements requirement, LayoutSpec formSpec) {
        this.type = type;
        this.displayNameResource = displayNameResource;
        this.iconResource = iconResource;
        this.requirement = requirement;
        this.formSpec = formSpec;
    }

    @NotNull
    public final PaymentMethod.Type getType() {
        return this.type;
    }

    public final int getDisplayNameResource() {
        return this.displayNameResource;
    }

    public final int getIconResource() {
        return this.iconResource;
    }

    @NotNull
    public final LayoutSpec getFormSpec() {
        return this.formSpec;
    }

    @NotNull
    public final LayoutFormDescriptor getPMAddForm(@NotNull StripeIntent stripeIntent, @Nullable PaymentSheet.Configuration config) {
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        LayoutFormDescriptor layoutFormDescriptor = this.getSpecWithFullfilledRequirements$paymentsheet_release(stripeIntent, config);
        if (layoutFormDescriptor == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return layoutFormDescriptor;
    }

    @Nullable
    public final LayoutFormDescriptor getSpecWithFullfilledRequirements$paymentsheet_release(@NotNull StripeIntent stripeIntent, @Nullable PaymentSheet.Configuration config) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        LayoutSpec formSpec = this.formSpec;
        LayoutFormDescriptor oneTimeUse = new LayoutFormDescriptor(formSpec, false, false);
        LayoutFormDescriptor merchantRequestedSave = new LayoutFormDescriptor(formSpec, false, true);
        LayoutFormDescriptor userSelectableSave = new LayoutFormDescriptor(formSpec, true, false);
        if (!stripeIntent.getPaymentMethodTypes().contains(this.type.code)) {
            return null;
        }
        StripeIntent stripeIntent2 = stripeIntent;
        if (stripeIntent2 instanceof PaymentIntent) {
            object = ((PaymentIntent)stripeIntent).isSetupFutureUsageSet() ? (this.supportsPaymentIntentSfuSet((PaymentIntent)stripeIntent, config) ? merchantRequestedSave : (LayoutFormDescriptor)null) : (this.supportsPaymentIntentSfuSettable((PaymentIntent)stripeIntent, config) ? userSelectableSave : (this.supportsPaymentIntentSfuNotSettable((PaymentIntent)stripeIntent, config) ? oneTimeUse : null));
        } else if (stripeIntent2 instanceof SetupIntent) {
            object = this.supportsSetupIntent(config) ? merchantRequestedSave : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public final boolean supportsCustomerSavedPM() {
        return Intrinsics.areEqual((Object)this.requirement.getConfirmPMFromCustomer(), (Object)true);
    }

    private final boolean supportsSetupIntent(PaymentSheet.Configuration config) {
        return Intrinsics.areEqual((Object)this.requirement.getConfirmPMFromCustomer(), (Object)true) && this.checkSetupIntentRequirements(this.requirement.getSiRequirements(), config);
    }

    private final boolean supportsPaymentIntentSfuSet(PaymentIntent paymentIntent, PaymentSheet.Configuration config) {
        return Intrinsics.areEqual((Object)this.requirement.getConfirmPMFromCustomer(), (Object)true) && this.checkSetupIntentRequirements(this.requirement.getSiRequirements(), config) && this.checkPaymentIntentRequirements(this.requirement.getPiRequirements(), paymentIntent, config);
    }

    private final boolean supportsPaymentIntentSfuNotSettable(PaymentIntent paymentIntent, PaymentSheet.Configuration config) {
        return this.checkPaymentIntentRequirements(this.requirement.getPiRequirements(), paymentIntent, config);
    }

    private final boolean supportsPaymentIntentSfuSettable(PaymentIntent paymentIntent, PaymentSheet.Configuration config) {
        PaymentSheet.Configuration configuration = config;
        return (configuration == null ? null : configuration.getCustomer()) != null && Intrinsics.areEqual((Object)this.requirement.getConfirmPMFromCustomer(), (Object)true) && this.checkPaymentIntentRequirements(this.requirement.getPiRequirements(), paymentIntent, config) && this.checkSetupIntentRequirements(this.requirement.getSiRequirements(), config);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSetupIntentRequirements(Set<? extends SIRequirement> requirements, PaymentSheet.Configuration config) {
        boolean bl;
        Set<? extends SIRequirement> set = requirements;
        if (set == null) {
            bl = false;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PaymentSheet.Configuration configuration;
                void requirement;
                SIRequirement sIRequirement = (SIRequirement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)requirement, (Object)Delayed.INSTANCE)) {
                    configuration = config;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(configuration == null ? false : configuration.getAllowsDelayedPaymentMethods());
            }
            List list = (List)destination$iv$iv;
            bl = !list.contains(false);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean checkPaymentIntentRequirements(Set<? extends PIRequirement> requirements, PaymentIntent paymentIntent, PaymentSheet.Configuration config) {
        block10: {
            block9: {
                v0 = requirements;
                if (v0 != null) break block9;
                v1 = false;
                break block10;
            }
            $this$map$iv = v0;
            $i$f$map = false;
            var7_6 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                block12: {
                    block13: {
                        block11: {
                            var12_11 = (PIRequirement)item$iv$iv;
                            var15_14 = destination$iv$iv;
                            $i$a$-map-SupportedPaymentMethod$checkPaymentIntentRequirements$1 = false;
                            var14_13 = requirement;
                            if (!Intrinsics.areEqual((Object)var14_13, (Object)Delayed.INSTANCE)) break block11;
                            v2 = config;
                            v3 = v2 == null ? false : v2.getAllowsDelayedPaymentMethods();
                            break block12;
                        }
                        if (!Intrinsics.areEqual((Object)var14_13, (Object)ShippingAddress.INSTANCE)) break block13;
                        v4 = paymentIntent.getShipping();
                        if ((v4 == null ? null : v4.getName()) == null) ** GOTO lbl-1000
                        v5 = paymentIntent.getShipping();
                        if (v5 == null) {
                            v6 /* !! */  = null;
                        } else {
                            v7 = v5.getAddress();
                            v6 /* !! */  = v7 == null ? null : v7.getLine1();
                        }
                        if (v6 /* !! */  == null) ** GOTO lbl-1000
                        v8 = paymentIntent.getShipping();
                        if (v8 == null) {
                            v9 /* !! */  = null;
                        } else {
                            v10 = v8.getAddress();
                            v9 /* !! */  = v10 == null ? null : v10.getCountry();
                        }
                        if (v9 /* !! */  == null) ** GOTO lbl-1000
                        v11 = paymentIntent.getShipping();
                        if (v11 == null) {
                            v12 /* !! */  = null;
                        } else {
                            v13 = v11.getAddress();
                            v12 /* !! */  = v13 == null ? null : v13.getPostalCode();
                        }
                        if (v12 /* !! */  != null) {
                            v3 = true;
                        } else lbl-1000:
                        // 4 sources

                        {
                            v3 = false;
                        }
                        break block12;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                var15_14.add(v3);
            }
            var4_15 = (List)destination$iv$iv;
            v1 = var4_15.contains(false) == false;
        }
        return v1;
    }

    @NotNull
    public String toString() {
        return this.type.code;
    }

    public /* synthetic */ SupportedPaymentMethod(PaymentMethod.Type type, int displayNameResource, int iconResource, PaymentMethodRequirements requirement, LayoutSpec formSpec, DefaultConstructorMarker $constructor_marker) {
        this(type, displayNameResource, iconResource, requirement, formSpec);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Card;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Card
    extends SupportedPaymentMethod {
        @NotNull
        public static final Card INSTANCE = new Card();
        @NotNull
        public static final Parcelable.Creator<Card> CREATOR;
        public static final int $stable;

        private Card() {
            super(PaymentMethod.Type.Card, R.string.stripe_paymentsheet_payment_method_card, R.drawable.stripe_ic_paymentsheet_pm_card, PaymentMethodRequirementsKt.getCardRequirement(), CardSpecKt.getCardForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Card> {
                @NotNull
                public final Card[] newArray(int size) {
                    return new Card[size];
                }

                @NotNull
                public final Card createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Bancontact;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Bancontact
    extends SupportedPaymentMethod {
        @NotNull
        public static final Bancontact INSTANCE = new Bancontact();
        @NotNull
        public static final Parcelable.Creator<Bancontact> CREATOR;
        public static final int $stable;

        private Bancontact() {
            super(PaymentMethod.Type.Bancontact, R.string.stripe_paymentsheet_payment_method_bancontact, R.drawable.stripe_ic_paymentsheet_pm_bancontact, PaymentMethodRequirementsKt.getBancontactRequirement(), BancontactSpecKt.getBancontactForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Bancontact> {
                @NotNull
                public final Bancontact[] newArray(int size) {
                    return new Bancontact[size];
                }

                @NotNull
                public final Bancontact createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Sofort;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Sofort
    extends SupportedPaymentMethod {
        @NotNull
        public static final Sofort INSTANCE = new Sofort();
        @NotNull
        public static final Parcelable.Creator<Sofort> CREATOR;
        public static final int $stable;

        private Sofort() {
            super(PaymentMethod.Type.Sofort, R.string.stripe_paymentsheet_payment_method_sofort, R.drawable.stripe_ic_paymentsheet_pm_klarna, PaymentMethodRequirementsKt.getSofortRequirement(), SofortSpecKt.getSofortForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Sofort> {
                @NotNull
                public final Sofort[] newArray(int size) {
                    return new Sofort[size];
                }

                @NotNull
                public final Sofort createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Ideal;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Ideal
    extends SupportedPaymentMethod {
        @NotNull
        public static final Ideal INSTANCE = new Ideal();
        @NotNull
        public static final Parcelable.Creator<Ideal> CREATOR;
        public static final int $stable;

        private Ideal() {
            super(PaymentMethod.Type.Ideal, R.string.stripe_paymentsheet_payment_method_ideal, R.drawable.stripe_ic_paymentsheet_pm_ideal, PaymentMethodRequirementsKt.getIdealRequirement(), IdealSpecKt.getIdealForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Ideal> {
                @NotNull
                public final Ideal[] newArray(int size) {
                    return new Ideal[size];
                }

                @NotNull
                public final Ideal createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$SepaDebit;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class SepaDebit
    extends SupportedPaymentMethod {
        @NotNull
        public static final SepaDebit INSTANCE = new SepaDebit();
        @NotNull
        public static final Parcelable.Creator<SepaDebit> CREATOR;
        public static final int $stable;

        private SepaDebit() {
            super(PaymentMethod.Type.SepaDebit, R.string.stripe_paymentsheet_payment_method_sepa_debit, R.drawable.stripe_ic_paymentsheet_pm_sepa_debit, PaymentMethodRequirementsKt.getSepaDebitRequirement(), SepaDebitSpecKt.getSepaDebitForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<SepaDebit> {
                @NotNull
                public final SepaDebit[] newArray(int size) {
                    return new SepaDebit[size];
                }

                @NotNull
                public final SepaDebit createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Eps;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Eps
    extends SupportedPaymentMethod {
        @NotNull
        public static final Eps INSTANCE = new Eps();
        @NotNull
        public static final Parcelable.Creator<Eps> CREATOR;
        public static final int $stable;

        private Eps() {
            super(PaymentMethod.Type.Eps, R.string.stripe_paymentsheet_payment_method_eps, R.drawable.stripe_ic_paymentsheet_pm_eps, PaymentMethodRequirementsKt.getEpsRequirement(), EpsSpecKt.getEpsForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Eps> {
                @NotNull
                public final Eps[] newArray(int size) {
                    return new Eps[size];
                }

                @NotNull
                public final Eps createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$P24;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class P24
    extends SupportedPaymentMethod {
        @NotNull
        public static final P24 INSTANCE = new P24();
        @NotNull
        public static final Parcelable.Creator<P24> CREATOR;
        public static final int $stable;

        private P24() {
            super(PaymentMethod.Type.P24, R.string.stripe_paymentsheet_payment_method_p24, R.drawable.stripe_ic_paymentsheet_pm_p24, PaymentMethodRequirementsKt.getP24Requirement(), P24SpecKt.getP24Form(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<P24> {
                @NotNull
                public final P24[] newArray(int size) {
                    return new P24[size];
                }

                @NotNull
                public final P24 createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Giropay;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Giropay
    extends SupportedPaymentMethod {
        @NotNull
        public static final Giropay INSTANCE = new Giropay();
        @NotNull
        public static final Parcelable.Creator<Giropay> CREATOR;
        public static final int $stable;

        private Giropay() {
            super(PaymentMethod.Type.Giropay, R.string.stripe_paymentsheet_payment_method_giropay, R.drawable.stripe_ic_paymentsheet_pm_giropay, PaymentMethodRequirementsKt.getGiropayRequirement(), GiropaySpecKt.getGiropayForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Giropay> {
                @NotNull
                public final Giropay[] newArray(int size) {
                    return new Giropay[size];
                }

                @NotNull
                public final Giropay createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$AfterpayClearpay;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class AfterpayClearpay
    extends SupportedPaymentMethod {
        @NotNull
        public static final AfterpayClearpay INSTANCE = new AfterpayClearpay();
        @NotNull
        public static final Parcelable.Creator<AfterpayClearpay> CREATOR;
        public static final int $stable;

        private AfterpayClearpay() {
            super(PaymentMethod.Type.AfterpayClearpay, R.string.stripe_paymentsheet_payment_method_afterpay_clearpay, R.drawable.stripe_ic_paymentsheet_pm_afterpay_clearpay, PaymentMethodRequirementsKt.getAfterpayClearpayRequirement(), AfterpayClearpaySpecKt.getAfterpayClearpayForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<AfterpayClearpay> {
                @NotNull
                public final AfterpayClearpay[] newArray(int size) {
                    return new AfterpayClearpay[size];
                }

                @NotNull
                public final AfterpayClearpay createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Klarna;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Klarna
    extends SupportedPaymentMethod {
        @NotNull
        public static final Klarna INSTANCE = new Klarna();
        @NotNull
        public static final Parcelable.Creator<Klarna> CREATOR;
        public static final int $stable;

        private Klarna() {
            super(PaymentMethod.Type.Klarna, R.string.stripe_paymentsheet_payment_method_klarna, R.drawable.stripe_ic_paymentsheet_pm_klarna, PaymentMethodRequirementsKt.getKlarnaRequirement(), KlarnaSpecKt.getKlarnaForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Klarna> {
                @NotNull
                public final Klarna[] newArray(int size) {
                    return new Klarna[size];
                }

                @NotNull
                public final Klarna createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$PayPal;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class PayPal
    extends SupportedPaymentMethod {
        @NotNull
        public static final PayPal INSTANCE = new PayPal();
        @NotNull
        public static final Parcelable.Creator<PayPal> CREATOR;
        public static final int $stable;

        private PayPal() {
            super(PaymentMethod.Type.PayPal, R.string.stripe_paymentsheet_payment_method_paypal, R.drawable.stripe_ic_paymentsheet_pm_paypal, PaymentMethodRequirementsKt.getPaypalRequirement(), PaypalSpecKt.getPaypalForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<PayPal> {
                @NotNull
                public final PayPal[] newArray(int size) {
                    return new PayPal[size];
                }

                @NotNull
                public final PayPal createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Affirm;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Affirm
    extends SupportedPaymentMethod {
        @NotNull
        public static final Affirm INSTANCE = new Affirm();
        @NotNull
        public static final Parcelable.Creator<Affirm> CREATOR;
        public static final int $stable;

        private Affirm() {
            super(PaymentMethod.Type.Affirm, R.string.stripe_paymentsheet_payment_method_affirm, R.drawable.stripe_ic_paymentsheet_pm_affirm, PaymentMethodRequirementsKt.getAffirmRequirement(), AffirmSpecKt.getAffirmForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Affirm> {
                @NotNull
                public final Affirm[] newArray(int size) {
                    return new Affirm[size];
                }

                @NotNull
                public final Affirm createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$AuBecsDebit;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class AuBecsDebit
    extends SupportedPaymentMethod {
        @NotNull
        public static final AuBecsDebit INSTANCE = new AuBecsDebit();
        @NotNull
        public static final Parcelable.Creator<AuBecsDebit> CREATOR;
        public static final int $stable;

        private AuBecsDebit() {
            super(PaymentMethod.Type.AuBecsDebit, R.string.stripe_paymentsheet_payment_method_au_becs_debit, R.drawable.stripe_ic_paymentsheet_pm_bank, PaymentMethodRequirementsKt.getAuBecsDebitRequirement(), AuBecsDebitSpecKt.getAuBecsDebitForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<AuBecsDebit> {
                @NotNull
                public final AuBecsDebit[] newArray(int size) {
                    return new AuBecsDebit[size];
                }

                @NotNull
                public final AuBecsDebit createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00d6\u0001\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$USBankAccount;", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "()V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class USBankAccount
    extends SupportedPaymentMethod {
        @NotNull
        public static final USBankAccount INSTANCE = new USBankAccount();
        @NotNull
        public static final Parcelable.Creator<USBankAccount> CREATOR;
        public static final int $stable;

        private USBankAccount() {
            super(PaymentMethod.Type.USBankAccount, R.string.stripe_paymentsheet_payment_method_us_bank_account, R.drawable.stripe_ic_paymentsheet_pm_bank, PaymentMethodRequirementsKt.getUSBankAccountRequirement(), USBankAccountSpecKt.getUSBankAccountForm(), null);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(1);
        }

        static {
            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<USBankAccount> {
                @NotNull
                public final USBankAccount[] newArray(int size) {
                    return new USBankAccount[size];
                }

                @NotNull
                public final USBankAccount createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rJ'\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0013J'\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0011\u0010\u0017\u001a\u00020\u0018*\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0019R'\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048@X\u0081\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Companion;", "", "()V", "exposedPaymentMethods", "", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "getExposedPaymentMethods$paymentsheet_release$annotations", "getExposedPaymentMethods$paymentsheet_release", "()Ljava/util/List;", "exposedPaymentMethods$delegate", "Lkotlin/Lazy;", "fromCode", "code", "", "getPMsToAdd", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "config", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "getPMsToAdd$paymentsheet_release", "getSupportedSavedCustomerPMs", "getSupportedSavedCustomerPMs$paymentsheet_release", "values", "shouldTintOnSelection", "", "shouldTintOnSelection$paymentsheet_release", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<SupportedPaymentMethod> values() {
            return this.getExposedPaymentMethods$paymentsheet_release();
        }

        @NotNull
        public final List<SupportedPaymentMethod> getExposedPaymentMethods$paymentsheet_release() {
            Lazy lazy = exposedPaymentMethods$delegate;
            return (List)lazy.getValue();
        }

        @VisibleForTesting
        public static /* synthetic */ void getExposedPaymentMethods$paymentsheet_release$annotations() {
        }

        public final boolean shouldTintOnSelection$paymentsheet_release(@NotNull SupportedPaymentMethod $this$shouldTintOnSelection) {
            Intrinsics.checkNotNullParameter((Object)$this$shouldTintOnSelection, (String)"<this>");
            Object[] objectArray = new SupportedPaymentMethod[]{Card.INSTANCE, AuBecsDebit.INSTANCE, USBankAccount.INSTANCE};
            return SetsKt.setOf((Object[])objectArray).contains($this$shouldTintOnSelection);
        }

        @Nullable
        public final SupportedPaymentMethod fromCode(@Nullable String code) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = this.getExposedPaymentMethods$paymentsheet_release();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SupportedPaymentMethod it = (SupportedPaymentMethod)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType().code, (Object)code)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SupportedPaymentMethod> getSupportedSavedCustomerPMs$paymentsheet_release(@Nullable StripeIntent stripeIntent, @Nullable PaymentSheet.Configuration config) {
            List list;
            StripeIntent stripeIntent2 = stripeIntent;
            if (stripeIntent2 == null) {
                list = null;
            } else {
                List list2 = stripeIntent2.getPaymentMethodTypes();
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = list2;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        SupportedPaymentMethod it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String it = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (Companion.fromCode(it) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List list3 = (List)destination$iv$iv;
                    $this$mapNotNull$iv = list3;
                    boolean $i$f$filter = false;
                    $this$mapNotNullTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        SupportedPaymentMethod paymentMethod = (SupportedPaymentMethod)element$iv$iv;
                        boolean bl = false;
                        boolean bl4 = paymentMethod.supportsCustomerSavedPM() && paymentMethod.getSpecWithFullfilledRequirements$paymentsheet_release(stripeIntent, config) != null;
                        if (!bl4) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
            }
            List list4 = list;
            return list4 == null ? CollectionsKt.emptyList() : list4;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SupportedPaymentMethod> getPMsToAdd$paymentsheet_release(@Nullable StripeIntent stripeIntent, @Nullable PaymentSheet.Configuration config) {
            List list;
            StripeIntent stripeIntent2 = stripeIntent;
            if (stripeIntent2 == null) {
                list = null;
            } else {
                List list2 = stripeIntent2.getPaymentMethodTypes();
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$filterNotTo$iv$iv;
                    void $this$filterNot$iv;
                    SupportedPaymentMethod supportedPaymentMethod;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = list2;
                    boolean $i$f$mapNotNull22 = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        SupportedPaymentMethod it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String it = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (Companion.fromCode(it) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List list3 = (List)destination$iv$iv;
                    Iterable $i$f$mapNotNull22 = list3;
                    boolean $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        supportedPaymentMethod = (SupportedPaymentMethod)element$iv$iv;
                        boolean bl = false;
                        if (!(supportedPaymentMethod.getSpecWithFullfilledRequirements$paymentsheet_release(stripeIntent, config) != null)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List list4 = (List)destination$iv$iv2;
                    $this$filter$iv = list4;
                    boolean $i$f$filterNot = false;
                    $this$filterTo$iv$iv = $this$filterNot$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                        supportedPaymentMethod = (SupportedPaymentMethod)element$iv$iv;
                        boolean bl = false;
                        if (stripeIntent.isLiveMode() && stripeIntent.getUnactivatedPaymentMethods().contains(supportedPaymentMethod.getType().code)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv2;
                }
            }
            List list5 = list;
            return list5 == null ? CollectionsKt.emptyList() : list5;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

