/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import android.content.Context;
import android.content.res.Configuration;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.TextKeyListener;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.os.ConfigurationCompat;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.core.model.Country;
import com.stripe.android.core.model.CountryCode;
import com.stripe.android.core.model.CountryUtils;
import com.stripe.android.model.Address;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.databinding.StripeBillingAddressLayoutBinding;
import com.stripe.android.paymentsheet.ui.BillingAddressView;
import com.stripe.android.view.CountryTextInputLayout;
import com.stripe.android.view.PostalCodeValidator;
import com.stripe.android.view.StripeEditText;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u0004~\u007f\u0080\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010p\u001a\u00020CH\u0002J\n\u0010q\u001a\u0004\u0018\u00010\u000bH\u0002J\u001c\u0010r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010s\u001a\u00020B2\b\u0010t\u001a\u0004\u0018\u00010mH\u0002J\u0006\u0010u\u001a\u00020CJ\b\u0010v\u001a\u00020wH\u0002J\u0017\u0010x\u001a\u00020C2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\byJ\u0010\u0010z\u001a\u00020C2\u0006\u0010{\u001a\u000204H\u0016J\u0012\u0010|\u001a\u00020C2\b\u0010s\u001a\u0004\u0018\u00010BH\u0002J\u0012\u0010}\u001a\u00020C2\b\u0010s\u001a\u0004\u0018\u00010BH\u0002R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u00020\u00118\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u00020\u00118\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0013\u001a\u0004\b\u0018\u0010\u0015R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u00020\u001d8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0013\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u00020\"8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b#\u0010\u0013\u001a\u0004\b$\u0010%R\u001c\u0010&\u001a\u00020\u00118\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b'\u0010\u0013\u001a\u0004\b(\u0010\u0015R\u001c\u0010)\u001a\u00020*8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b+\u0010\u0013\u001a\u0004\b,\u0010-R\u001c\u0010.\u001a\u00020/8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010\u0013\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00105R1\u00108\u001a\u0002072\u0006\u00106\u001a\u0002078@@@X\u0081\u008e\u0002\u00a2\u0006\u0018\n\u0004\b>\u0010?\u0012\u0004\b9\u0010\u0013\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010@\u001a\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C0AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010D\u001a\b\u0012\u0004\u0012\u00020C0EX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR+\u0010K\u001a\u00020J2\u0006\u00106\u001a\u00020J8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bP\u0010?\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u001c\u0010Q\u001a\u00020\u001d8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bR\u0010\u0013\u001a\u0004\bS\u0010 R\u000e\u0010T\u001a\u00020UX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010V\u001a\u00020W8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bX\u0010\u0013\u001a\u0004\bY\u0010ZR&\u0010[\u001a\u0004\u0018\u00010\\8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b]\u0010\u0013\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR\u0014\u0010b\u001a\b\u0012\u0004\u0012\u00020c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010d\u001a\u00020\u001d8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\be\u0010\u0013\u001a\u0004\bf\u0010 R\u001c\u0010g\u001a\u00020\u00118\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bh\u0010\u0013\u001a\u0004\bi\u0010\u0015R\u000e\u0010j\u001a\u00020kX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010l\u001a\u0004\u0018\u00010m*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bn\u0010o\u00a8\u0006\u0081\u0001"}, d2={"Lcom/stripe/android/paymentsheet/ui/BillingAddressView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "_address", "Landroidx/lifecycle/MutableLiveData;", "Lcom/stripe/android/model/Address;", "address", "Landroidx/lifecycle/LiveData;", "getAddress$paymentsheet_release", "()Landroidx/lifecycle/LiveData;", "address1View", "Lcom/google/android/material/textfield/TextInputEditText;", "getAddress1View$paymentsheet_release$annotations", "()V", "getAddress1View$paymentsheet_release", "()Lcom/google/android/material/textfield/TextInputEditText;", "address2View", "getAddress2View$paymentsheet_release$annotations", "getAddress2View$paymentsheet_release", "allFields", "", "Landroid/widget/EditText;", "cityLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "getCityLayout$paymentsheet_release$annotations", "getCityLayout$paymentsheet_release", "()Lcom/google/android/material/textfield/TextInputLayout;", "cityPostalContainer", "Landroid/widget/LinearLayout;", "getCityPostalContainer$paymentsheet_release$annotations", "getCityPostalContainer$paymentsheet_release", "()Landroid/widget/LinearLayout;", "cityView", "getCityView$paymentsheet_release$annotations", "getCityView$paymentsheet_release", "countryLayout", "Lcom/stripe/android/view/CountryTextInputLayout;", "getCountryLayout$paymentsheet_release$annotations", "getCountryLayout$paymentsheet_release", "()Lcom/stripe/android/view/CountryTextInputLayout;", "countryView", "Landroid/widget/AutoCompleteTextView;", "getCountryView$paymentsheet_release$annotations", "getCountryView$paymentsheet_release", "()Landroid/widget/AutoCompleteTextView;", "isUnitedStates", "", "()Z", "<set-?>", "Lcom/stripe/android/paymentsheet/ui/BillingAddressView$BillingAddressCollectionLevel;", "level", "getLevel$paymentsheet_release$annotations", "getLevel$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/ui/BillingAddressView$BillingAddressCollectionLevel;", "setLevel$paymentsheet_release", "(Lcom/stripe/android/paymentsheet/ui/BillingAddressView$BillingAddressCollectionLevel;)V", "level$delegate", "Lkotlin/properties/ReadWriteProperty;", "newCountryCodeCallback", "Lkotlin/Function1;", "Lcom/stripe/android/core/model/CountryCode;", "", "onFocus", "Lkotlin/Function0;", "getOnFocus$paymentsheet_release", "()Lkotlin/jvm/functions/Function0;", "setOnFocus$paymentsheet_release", "(Lkotlin/jvm/functions/Function0;)V", "Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeConfig;", "postalCodeConfig", "getPostalCodeConfig", "()Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeConfig;", "setPostalCodeConfig", "(Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeConfig;)V", "postalCodeConfig$delegate", "postalCodeLayout", "getPostalCodeLayout$paymentsheet_release$annotations", "getPostalCodeLayout$paymentsheet_release", "postalCodeValidator", "Lcom/stripe/android/view/PostalCodeValidator;", "postalCodeView", "Lcom/stripe/android/view/StripeEditText;", "getPostalCodeView$paymentsheet_release$annotations", "getPostalCodeView$paymentsheet_release", "()Lcom/stripe/android/view/StripeEditText;", "postalCodeViewListener", "Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeViewListener;", "getPostalCodeViewListener$paymentsheet_release$annotations", "getPostalCodeViewListener$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeViewListener;", "setPostalCodeViewListener$paymentsheet_release", "(Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeViewListener;)V", "requiredViews", "Landroid/view/View;", "stateLayout", "getStateLayout$paymentsheet_release$annotations", "getStateLayout$paymentsheet_release", "stateView", "getStateView$paymentsheet_release$annotations", "getStateView$paymentsheet_release", "viewBinding", "Lcom/stripe/android/paymentsheet/databinding/StripeBillingAddressLayoutBinding;", "value", "", "getValue", "(Landroid/widget/EditText;)Ljava/lang/String;", "configureForLevel", "createAddress", "createRequiredAddress", "countryCode", "postalCode", "focusFirstField", "getLocale", "Ljava/util/Locale;", "populate", "populate$paymentsheet_release", "setEnabled", "enabled", "updatePostalCodeView", "updateStateView", "BillingAddressCollectionLevel", "PostalCodeConfig", "PostalCodeViewListener", "paymentsheet_release"})
public final class BillingAddressView
extends FrameLayout {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadWriteProperty level$delegate;
    @NotNull
    private Function0<Unit> onFocus;
    @NotNull
    private final StripeBillingAddressLayoutBinding viewBinding;
    @NotNull
    private final PostalCodeValidator postalCodeValidator;
    @NotNull
    private final MutableLiveData<Address> _address;
    @NotNull
    private final LiveData<Address> address;
    @NotNull
    private final CountryTextInputLayout countryLayout;
    @NotNull
    private final AutoCompleteTextView countryView;
    @NotNull
    private final LinearLayout cityPostalContainer;
    @NotNull
    private final StripeEditText postalCodeView;
    @NotNull
    private final TextInputLayout postalCodeLayout;
    @NotNull
    private final TextInputEditText address1View;
    @NotNull
    private final TextInputEditText address2View;
    @NotNull
    private final TextInputLayout cityLayout;
    @NotNull
    private final TextInputEditText cityView;
    @NotNull
    private final TextInputEditText stateView;
    @NotNull
    private final TextInputLayout stateLayout;
    @Nullable
    private PostalCodeViewListener postalCodeViewListener;
    @NotNull
    private final ReadWriteProperty postalCodeConfig$delegate;
    @NotNull
    private final Function1<CountryCode, Unit> newCountryCodeCallback;
    @NotNull
    private final Set<View> requiredViews;
    @NotNull
    private final Set<EditText> allFields;

    @JvmOverloads
    public BillingAddressView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        PostalCodeConfig.Global initialValue$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        Delegates delegates = Delegates.INSTANCE;
        BillingAddressCollectionLevel billingAddressCollectionLevel = BillingAddressCollectionLevel.Automatic;
        boolean $i$f$observable = false;
        this.level$delegate = (ReadWriteProperty)new ObservableProperty<BillingAddressCollectionLevel>((Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ BillingAddressView this$0;
            {
                this.$initialValue = $initialValue;
                this.this$0 = billingAddressView;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newLevel;
                void oldLevel;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                BillingAddressCollectionLevel billingAddressCollectionLevel = (BillingAddressCollectionLevel)((Object)newValue);
                BillingAddressCollectionLevel billingAddressCollectionLevel2 = (BillingAddressCollectionLevel)((Object)oldValue);
                KProperty $noName_0 = property;
                boolean bl = false;
                if (oldLevel != newLevel) {
                    BillingAddressView.access$configureForLevel(this.this$0);
                }
            }
        };
        this.onFocus = onFocus.1.INSTANCE;
        Object[] this_$iv = StripeBillingAddressLayoutBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"inflate(\n        LayoutI\u2026text),\n        this\n    )");
        this.viewBinding = this_$iv;
        this.postalCodeValidator = new PostalCodeValidator();
        this._address = new MutableLiveData(null);
        this.address = (LiveData)this._address;
        this_$iv = this.viewBinding.countryLayout;
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"viewBinding.countryLayout");
        this.countryLayout = this_$iv;
        this.countryView = this.countryLayout.getCountryAutocomplete();
        this_$iv = this.viewBinding.cityPostalContainer;
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"viewBinding.cityPostalContainer");
        this.cityPostalContainer = this_$iv;
        this_$iv = this.viewBinding.postalCode;
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"viewBinding.postalCode");
        this.postalCodeView = this_$iv;
        this_$iv = this.viewBinding.postalCodeLayout;
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"viewBinding.postalCodeLayout");
        this.postalCodeLayout = this_$iv;
        this_$iv = this.viewBinding.address1;
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"viewBinding.address1");
        this.address1View = this_$iv;
        this_$iv = this.viewBinding.address2;
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"viewBinding.address2");
        this.address2View = this_$iv;
        this_$iv = this.viewBinding.cityLayout;
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"viewBinding.cityLayout");
        this.cityLayout = this_$iv;
        this_$iv = this.viewBinding.city;
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"viewBinding.city");
        this.cityView = this_$iv;
        this_$iv = this.viewBinding.state;
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"viewBinding.state");
        this.stateView = this_$iv;
        this_$iv = this.viewBinding.stateLayout;
        Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"viewBinding.stateLayout");
        this.stateLayout = this_$iv;
        this_$iv = Delegates.INSTANCE;
        initialValue$iv = PostalCodeConfig.Global.INSTANCE;
        $i$f$observable = false;
        this.postalCodeConfig$delegate = (ReadWriteProperty)new ObservableProperty<PostalCodeConfig>((Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ BillingAddressView this$0;
            {
                this.$initialValue = $initialValue;
                this.this$0 = billingAddressView;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void config;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                PostalCodeConfig postalCodeConfig = (PostalCodeConfig)newValue;
                PostalCodeConfig postalCodeConfig2 = (PostalCodeConfig)oldValue;
                KProperty $noName_0 = property;
                boolean bl = false;
                InputFilter.LengthFilter[] lengthFilterArray = new InputFilter.LengthFilter[]{new InputFilter.LengthFilter(config.getMaxLength())};
                this.this$0.getPostalCodeView$paymentsheet_release().setFilters((InputFilter[])lengthFilterArray);
                this.this$0.getPostalCodeView$paymentsheet_release().setKeyListener(config.getKeyListener());
                if (config.getInputType() == 18) {
                    this.this$0.getPostalCodeView$paymentsheet_release().setNumberOnlyInputType();
                } else {
                    this.this$0.getPostalCodeView$paymentsheet_release().setInputType(config.getInputType());
                }
            }
        };
        this.newCountryCodeCallback = (Function1)new Function1<CountryCode, Unit>(this){
            final /* synthetic */ BillingAddressView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CountryCode newCountryCode) {
                Intrinsics.checkNotNullParameter((Object)newCountryCode, (String)"newCountryCode");
                BillingAddressView.access$updateStateView(this.this$0, newCountryCode);
                BillingAddressView.access$updatePostalCodeView(this.this$0, newCountryCode);
                BillingAddressView.access$get_address$p(this.this$0).setValue((Object)BillingAddressView.access$createAddress(this.this$0));
                PostalCodeValidator postalCodeValidator = BillingAddressView.access$getPostalCodeValidator$p(this.this$0);
                String string2 = BillingAddressView.access$getValue(this.this$0, (EditText)this.this$0.getPostalCodeView$paymentsheet_release());
                if (string2 == null) {
                    string2 = "";
                }
                boolean bl = postalCodeValidator.isValid(string2, newCountryCode.getValue());
                BillingAddressView billingAddressView = this.this$0;
                boolean isPostalValid = bl;
                boolean bl2 = false;
                PostalCodeViewListener postalCodeViewListener = billingAddressView.getPostalCodeViewListener$paymentsheet_release();
                if (postalCodeViewListener != null) {
                    postalCodeViewListener.onCountryChanged(CountryUtils.INSTANCE.getCountryByCode(newCountryCode, BillingAddressView.access$getLocale(billingAddressView)), isPostalValid);
                }
                billingAddressView.getPostalCodeView$paymentsheet_release().setShouldShowError(!isPostalValid);
            }
        };
        this_$iv = new View[]{this.viewBinding.address1Divider, (View)this.viewBinding.address1Layout, (View)this.address1View, this.viewBinding.address2Divider, (View)this.viewBinding.address2Layout, (View)this.address2View, (View)this.viewBinding.cityLayout, (View)this.cityView, this.viewBinding.stateDivider, (View)this.stateLayout, (View)this.stateView};
        this.requiredViews = SetsKt.setOf((Object[])this_$iv);
        this_$iv = new EditText[]{(EditText)this.address1View, (EditText)this.address2View, (EditText)this.cityView, (EditText)this.stateView, (EditText)this.postalCodeView, (EditText)this.countryView};
        this.allFields = SetsKt.setOf((Object[])this_$iv);
        this.countryLayout.setCountryCodeChangeCallback(this.newCountryCodeCallback);
        CountryCode countryCode = this.countryLayout.getSelectedCountryCode();
        if (countryCode != null) {
            CountryCode it = countryCode;
            boolean bl = false;
            this.newCountryCodeCallback.invoke((Object)it);
        }
        this.configureForLevel();
        Iterable $this$forEach$iv = this.allFields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditText editText = (EditText)element$iv;
            boolean bl = false;
            TextView $this$doAfterTextChanged$iv = (TextView)editText;
            boolean $i$f$doAfterTextChanged = false;
            TextView $this$addTextChangedListener_u24default$iv$iv = $this$doAfterTextChanged$iv;
            boolean $i$f$addTextChangedListener = false;
            TextWatcher textWatcher$iv$iv = new TextWatcher(this){
                final /* synthetic */ BillingAddressView this$0;
                {
                    this.this$0 = billingAddressView;
                }

                public void afterTextChanged(@Nullable Editable s) {
                    Editable it = s;
                    boolean bl = false;
                    BillingAddressView.access$get_address$p(this.this$0).setValue((Object)BillingAddressView.access$createAddress(this.this$0));
                }

                public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                    int n = after;
                    int n2 = count;
                    int n3 = start;
                    CharSequence $noName_0 = text;
                }

                public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                    int n = count;
                    int n2 = before;
                    int n3 = start;
                    CharSequence $noName_0 = text;
                }
            };
            $this$addTextChangedListener_u24default$iv$iv.addTextChangedListener(textWatcher$iv$iv);
            editText.setOnFocusChangeListener((arg_0, arg_1) -> BillingAddressView.lambda-5$lambda-4(this, arg_0, arg_1));
        }
        this.postalCodeView.getInternalFocusChangeListeners().add((arg_0, arg_1) -> BillingAddressView._init_$lambda-9(this, arg_0, arg_1));
    }

    public /* synthetic */ BillingAddressView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final BillingAddressCollectionLevel getLevel$paymentsheet_release() {
        return (BillingAddressCollectionLevel)((Object)this.level$delegate.getValue((Object)this, $$delegatedProperties[0]));
    }

    public final void setLevel$paymentsheet_release(@NotNull BillingAddressCollectionLevel billingAddressCollectionLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)billingAddressCollectionLevel), (String)"<set-?>");
        this.level$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)billingAddressCollectionLevel);
    }

    @VisibleForTesting
    public static /* synthetic */ void getLevel$paymentsheet_release$annotations() {
    }

    @NotNull
    public final Function0<Unit> getOnFocus$paymentsheet_release() {
        return this.onFocus;
    }

    public final void setOnFocus$paymentsheet_release(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.onFocus = function0;
    }

    @NotNull
    public final LiveData<Address> getAddress$paymentsheet_release() {
        return this.address;
    }

    @NotNull
    public final CountryTextInputLayout getCountryLayout$paymentsheet_release() {
        return this.countryLayout;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCountryLayout$paymentsheet_release$annotations() {
    }

    @NotNull
    public final AutoCompleteTextView getCountryView$paymentsheet_release() {
        return this.countryView;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCountryView$paymentsheet_release$annotations() {
    }

    @NotNull
    public final LinearLayout getCityPostalContainer$paymentsheet_release() {
        return this.cityPostalContainer;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCityPostalContainer$paymentsheet_release$annotations() {
    }

    @NotNull
    public final StripeEditText getPostalCodeView$paymentsheet_release() {
        return this.postalCodeView;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPostalCodeView$paymentsheet_release$annotations() {
    }

    @NotNull
    public final TextInputLayout getPostalCodeLayout$paymentsheet_release() {
        return this.postalCodeLayout;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPostalCodeLayout$paymentsheet_release$annotations() {
    }

    @NotNull
    public final TextInputEditText getAddress1View$paymentsheet_release() {
        return this.address1View;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAddress1View$paymentsheet_release$annotations() {
    }

    @NotNull
    public final TextInputEditText getAddress2View$paymentsheet_release() {
        return this.address2View;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAddress2View$paymentsheet_release$annotations() {
    }

    @NotNull
    public final TextInputLayout getCityLayout$paymentsheet_release() {
        return this.cityLayout;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCityLayout$paymentsheet_release$annotations() {
    }

    @NotNull
    public final TextInputEditText getCityView$paymentsheet_release() {
        return this.cityView;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCityView$paymentsheet_release$annotations() {
    }

    @NotNull
    public final TextInputEditText getStateView$paymentsheet_release() {
        return this.stateView;
    }

    @VisibleForTesting
    public static /* synthetic */ void getStateView$paymentsheet_release$annotations() {
    }

    @NotNull
    public final TextInputLayout getStateLayout$paymentsheet_release() {
        return this.stateLayout;
    }

    @VisibleForTesting
    public static /* synthetic */ void getStateLayout$paymentsheet_release$annotations() {
    }

    @Nullable
    public final PostalCodeViewListener getPostalCodeViewListener$paymentsheet_release() {
        return this.postalCodeViewListener;
    }

    public final void setPostalCodeViewListener$paymentsheet_release(@Nullable PostalCodeViewListener postalCodeViewListener) {
        this.postalCodeViewListener = postalCodeViewListener;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPostalCodeViewListener$paymentsheet_release$annotations() {
    }

    private final boolean isUnitedStates() {
        return CountryCode.Companion.isUS(this.countryLayout.getSelectedCountryCode());
    }

    private final PostalCodeConfig getPostalCodeConfig() {
        return (PostalCodeConfig)this.postalCodeConfig$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setPostalCodeConfig(PostalCodeConfig postalCodeConfig) {
        this.postalCodeConfig$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)postalCodeConfig);
    }

    private final Address createAddress() {
        Address address;
        block6: {
            block7: {
                boolean isPostalCodeValid;
                CountryCode countryCode;
                block5: {
                    countryCode = this.countryLayout.getSelectedCountryCode();
                    if (countryCode != null) break block5;
                    address = null;
                    break block6;
                }
                CountryCode countryCode2 = countryCode;
                boolean bl = false;
                String postalCode = this.getValue((EditText)this.getPostalCodeView$paymentsheet_release());
                String string2 = postalCode;
                if (string2 == null) {
                    string2 = "";
                }
                if (!(isPostalCodeValid = this.postalCodeValidator.isValid(string2, countryCode2.getValue()))) break block7;
                switch (WhenMappings.$EnumSwitchMapping$0[this.getLevel$paymentsheet_release().ordinal()]) {
                    case 1: {
                        address = new Address.Builder().setCountryCode(countryCode2).setPostalCode(postalCode).build();
                        break block6;
                    }
                    case 2: {
                        address = this.createRequiredAddress(countryCode2, postalCode);
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            address = null;
        }
        return address;
    }

    private final Address createRequiredAddress(CountryCode countryCode, String postalCode) {
        String line1 = this.getValue((EditText)this.address1View);
        String line2 = this.getValue((EditText)this.address2View);
        String city = this.getValue((EditText)this.cityView);
        String state = this.getValue((EditText)this.stateView);
        return line1 != null && city != null ? (!this.isUnitedStates() ? new Address.Builder().setCountryCode(countryCode).setPostalCode(postalCode).setLine1(line1).setLine2(line2).setCity(city).build() : (state != null ? new Address.Builder().setCountryCode(countryCode).setPostalCode(postalCode).setLine1(line1).setLine2(line2).setCity(city).setState(state).build() : (Address)null)) : (Address)null;
    }

    private final void updateStateView(CountryCode countryCode) {
        int it = CountryCode.Companion.isUS(countryCode) ? R.string.address_label_state : (CountryCode.Companion.isCA(countryCode) ? R.string.address_label_province : (CountryCode.Companion.isGB(countryCode) ? R.string.address_label_county : R.string.address_label_region_generic));
        boolean bl = false;
        this.getStateLayout$paymentsheet_release().setHint((CharSequence)this.getResources().getString(it));
    }

    private final void updatePostalCodeView(CountryCode countryCode) {
        boolean shouldShowPostalCode = countryCode == null || CountryUtils.INSTANCE.doesCountryUsePostalCode(countryCode);
        View $this$isVisible$iv = (View)this.postalCodeLayout;
        boolean $i$f$setVisible22 = false;
        $this$isVisible$iv.setVisibility(shouldShowPostalCode ? 0 : 8);
        boolean shouldShowPostalCodeContainer = this.getLevel$paymentsheet_release() == BillingAddressCollectionLevel.Required || shouldShowPostalCode;
        View $i$f$setVisible22 = this.viewBinding.cityPostalDivider;
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$setVisible22, (String)"viewBinding.cityPostalDivider");
        View $this$isVisible$iv2 = $i$f$setVisible22;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv2.setVisibility(shouldShowPostalCodeContainer ? 0 : 8);
        $this$isVisible$iv2 = this.viewBinding.cityPostalContainer;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv2, (String)"viewBinding.cityPostalContainer");
        $i$f$setVisible = false;
        $this$isVisible$iv2.setVisibility(shouldShowPostalCodeContainer ? 0 : 8);
        this.setPostalCodeConfig(CountryCode.Companion.isUS(countryCode) ? (PostalCodeConfig)PostalCodeConfig.UnitedStates.INSTANCE : (PostalCodeConfig)PostalCodeConfig.Global.INSTANCE);
        this.viewBinding.postalCodeLayout.setHint((CharSequence)this.getResources().getString(CountryCode.Companion.isUS(countryCode) ? R.string.acc_label_zip_short : R.string.address_label_postal_code));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Object[] objectArray = new TextInputLayout[]{(TextInputLayout)this.countryLayout, this.viewBinding.address1Layout, this.viewBinding.address2Layout, this.viewBinding.cityLayout, this.postalCodeLayout, this.stateLayout};
        Iterable $this$forEach$iv = SetsKt.setOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextInputLayout it = (TextInputLayout)element$iv;
            boolean bl = false;
            it.setEnabled(enabled);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configureForLevel() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getLevel$paymentsheet_release().ordinal()]) {
            case 1: {
                Iterable $this$forEach$iv = this.requiredViews;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$isVisible$iv;
                    View it = (View)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    View view = it;
                    boolean value$iv = false;
                    boolean $i$f$setVisible = false;
                    $this$isVisible$iv.setVisibility(8);
                }
                break;
            }
            case 2: {
                Iterable $this$forEach$iv = this.requiredViews;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    View it = (View)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    View $this$isVisible$iv = it;
                    boolean value$iv = true;
                    boolean $i$f$setVisible = false;
                    $this$isVisible$iv.setVisibility(0);
                }
                break;
            }
        }
        this._address.setValue((Object)this.createAddress());
    }

    public final void focusFirstField() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getLevel$paymentsheet_release().ordinal()]) {
            case 1: {
                this.postalCodeLayout.requestFocus();
                break;
            }
            case 2: {
                this.viewBinding.address1Layout.requestFocus();
            }
        }
    }

    public final void populate$paymentsheet_release(@Nullable Address address) {
        Address address2 = address;
        if (address2 != null) {
            Address it = address2;
            boolean bl = false;
            this.getPostalCodeView$paymentsheet_release().setText((CharSequence)it.getPostalCode());
            CountryCode countryCode = it.getCountryCode();
            if (countryCode != null) {
                CountryCode it2 = countryCode;
                boolean bl2 = false;
                this.getCountryLayout$paymentsheet_release().setSelectedCountryCode(it2);
                this.getCountryView$paymentsheet_release().setText((CharSequence)CountryUtils.INSTANCE.getDisplayCountry(it2, this.getLocale()));
            }
            this.getAddress1View$paymentsheet_release().setText((CharSequence)it.getLine1());
            this.getAddress2View$paymentsheet_release().setText((CharSequence)it.getLine2());
            this.getCityView$paymentsheet_release().setText((CharSequence)it.getCity());
            this.getStateView$paymentsheet_release().setText((CharSequence)it.getState());
        }
    }

    private final String getValue(EditText $this$value) {
        String string2;
        String string3;
        EditText editText;
        EditText it = editText = $this$value;
        boolean bl = false;
        View $this$isVisible$iv = (View)it;
        boolean $i$f$isVisible = false;
        Object object = $this$isVisible$iv.getVisibility() == 0 ? editText : null;
        if (object == null) {
            string3 = null;
        } else {
            Editable editable = object.getText();
            string3 = editable == null ? null : editable.toString();
        }
        String it2 = string2 = string3;
        boolean bl2 = false;
        CharSequence charSequence = it2;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
    }

    private final Locale getLocale() {
        Locale locale = ConfigurationCompat.getLocales((Configuration)this.getContext().getResources().getConfiguration()).get(0);
        Intrinsics.checkNotNull((Object)locale);
        return locale;
    }

    @JvmOverloads
    public BillingAddressView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BillingAddressView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void lambda-5$lambda-4(BillingAddressView this$0, View $noName_0, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (hasFocus) {
            this$0.onFocus.invoke();
        }
    }

    private static final void _init_$lambda-9(BillingAddressView this$0, View $noName_0, boolean hasFocus) {
        CountryCode it;
        CountryCode countryCode;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object object = this$0.countryLayout.getSelectedCountryCode();
        if (object == null) {
            bl = false;
        } else {
            boolean bl2;
            countryCode = object;
            boolean bl3 = false;
            PostalCodeValidator postalCodeValidator = this$0.postalCodeValidator;
            String string2 = this$0.getValue((EditText)this$0.getPostalCodeView$paymentsheet_release());
            if (string2 == null) {
                string2 = "";
            }
            bl = bl2 = postalCodeValidator.isValid(string2, countryCode.getValue());
        }
        boolean isPostalValid = bl;
        this$0.postalCodeView.setShouldShowError(!hasFocus && !((object = (CharSequence)this$0.getValue((EditText)this$0.postalCodeView)) == null || StringsKt.isBlank((CharSequence)object)) && !isPostalValid);
        if (hasFocus) {
            PostalCodeViewListener postalCodeViewListener = this$0.postalCodeViewListener;
            if (postalCodeViewListener != null) {
                Country country;
                CountryCode countryCode2 = this$0.countryLayout.getSelectedCountryCode();
                if (countryCode2 == null) {
                    country = null;
                } else {
                    countryCode = countryCode2;
                    PostalCodeViewListener postalCodeViewListener2 = postalCodeViewListener;
                    boolean bl4 = false;
                    country = CountryUtils.INSTANCE.getCountryByCode(it, this$0.getLocale());
                    postalCodeViewListener = postalCodeViewListener2;
                }
                postalCodeViewListener.onGainingFocus(country, isPostalValid);
            }
        } else {
            PostalCodeViewListener postalCodeViewListener = this$0.postalCodeViewListener;
            if (postalCodeViewListener != null) {
                Country country;
                CountryCode countryCode3 = this$0.countryLayout.getSelectedCountryCode();
                if (countryCode3 == null) {
                    country = null;
                } else {
                    it = countryCode3;
                    PostalCodeViewListener postalCodeViewListener3 = postalCodeViewListener;
                    boolean bl5 = false;
                    country = CountryUtils.INSTANCE.getCountryByCode(it, this$0.getLocale());
                    postalCodeViewListener = postalCodeViewListener3;
                }
                postalCodeViewListener.onLosingFocus(country, isPostalValid);
            }
            object = this$0.getValue((EditText)this$0.postalCodeView);
            this$0.postalCodeView.setShouldShowError(!(object == null || StringsKt.isBlank((CharSequence)object)) && !isPostalValid);
        }
    }

    public static final /* synthetic */ void access$configureForLevel(BillingAddressView $this) {
        $this.configureForLevel();
    }

    public static final /* synthetic */ MutableLiveData access$get_address$p(BillingAddressView $this) {
        return $this._address;
    }

    public static final /* synthetic */ Address access$createAddress(BillingAddressView $this) {
        return $this.createAddress();
    }

    public static final /* synthetic */ void access$updateStateView(BillingAddressView $this, CountryCode countryCode) {
        $this.updateStateView(countryCode);
    }

    public static final /* synthetic */ void access$updatePostalCodeView(BillingAddressView $this, CountryCode countryCode) {
        $this.updatePostalCodeView(countryCode);
    }

    public static final /* synthetic */ PostalCodeValidator access$getPostalCodeValidator$p(BillingAddressView $this) {
        return $this.postalCodeValidator;
    }

    public static final /* synthetic */ String access$getValue(BillingAddressView $this, EditText $receiver) {
        return $this.getValue($receiver);
    }

    public static final /* synthetic */ Locale access$getLocale(BillingAddressView $this) {
        return $this.getLocale();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BillingAddressView.class, "level", "getLevel$paymentsheet_release()Lcom/stripe/android/paymentsheet/ui/BillingAddressView$BillingAddressCollectionLevel;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BillingAddressView.class, "postalCodeConfig", "getPostalCodeConfig()Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeConfig;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001a\u0010\b\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001a\u0010\t\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeViewListener;", "", "onCountryChanged", "", "country", "Lcom/stripe/android/core/model/Country;", "isPostalValid", "", "onGainingFocus", "onLosingFocus", "paymentsheet_release"})
    public static interface PostalCodeViewListener {
        public void onLosingFocus(@Nullable Country var1, boolean var2);

        public void onGainingFocus(@Nullable Country var1, boolean var2);

        public void onCountryChanged(@Nullable Country var1, boolean var2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeConfig;", "", "()V", "inputType", "", "getInputType", "()I", "maxLength", "getMaxLength", "getKeyListener", "Landroid/text/method/KeyListener;", "Global", "UnitedStates", "Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeConfig$UnitedStates;", "Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeConfig$Global;", "paymentsheet_release"})
    public static abstract class PostalCodeConfig {
        private PostalCodeConfig() {
        }

        public abstract int getMaxLength();

        public abstract int getInputType();

        @NotNull
        public abstract KeyListener getKeyListener();

        public /* synthetic */ PostalCodeConfig(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeConfig$UnitedStates;", "Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeConfig;", "()V", "inputType", "", "getInputType", "()I", "maxLength", "getMaxLength", "getKeyListener", "Landroid/text/method/KeyListener;", "paymentsheet_release"})
        @StabilityInferred(parameters=0)
        public static final class UnitedStates
        extends PostalCodeConfig {
            @NotNull
            public static final UnitedStates INSTANCE = new UnitedStates();
            private static final int maxLength = 5;
            private static final int inputType = 18;
            public static final int $stable;

            private UnitedStates() {
                super(null);
            }

            @Override
            public int getMaxLength() {
                return maxLength;
            }

            @Override
            public int getInputType() {
                return inputType;
            }

            @Override
            @NotNull
            public KeyListener getKeyListener() {
                DigitsKeyListener digitsKeyListener = DigitsKeyListener.getInstance((boolean)false, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)digitsKeyListener, (String)"getInstance(false, true)");
                return (KeyListener)digitsKeyListener;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeConfig$Global;", "Lcom/stripe/android/paymentsheet/ui/BillingAddressView$PostalCodeConfig;", "()V", "inputType", "", "getInputType", "()I", "maxLength", "getMaxLength", "getKeyListener", "Landroid/text/method/KeyListener;", "paymentsheet_release"})
        @StabilityInferred(parameters=0)
        public static final class Global
        extends PostalCodeConfig {
            @NotNull
            public static final Global INSTANCE = new Global();
            private static final int maxLength = 13;
            private static final int inputType = 112;
            public static final int $stable;

            private Global() {
                super(null);
            }

            @Override
            public int getMaxLength() {
                return maxLength;
            }

            @Override
            public int getInputType() {
                return inputType;
            }

            @Override
            @NotNull
            public KeyListener getKeyListener() {
                TextKeyListener textKeyListener = TextKeyListener.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)textKeyListener, (String)"getInstance()");
                return (KeyListener)textKeyListener;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/paymentsheet/ui/BillingAddressView$BillingAddressCollectionLevel;", "", "(Ljava/lang/String;I)V", "Automatic", "Required", "paymentsheet_release"})
    public static final class BillingAddressCollectionLevel
    extends Enum<BillingAddressCollectionLevel> {
        public static final /* enum */ BillingAddressCollectionLevel Automatic = new BillingAddressCollectionLevel();
        public static final /* enum */ BillingAddressCollectionLevel Required = new BillingAddressCollectionLevel();
        private static final /* synthetic */ BillingAddressCollectionLevel[] $VALUES;

        public static BillingAddressCollectionLevel[] values() {
            return (BillingAddressCollectionLevel[])$VALUES.clone();
        }

        public static BillingAddressCollectionLevel valueOf(String value) {
            return Enum.valueOf(BillingAddressCollectionLevel.class, value);
        }

        static {
            $VALUES = billingAddressCollectionLevelArray = new BillingAddressCollectionLevel[]{BillingAddressCollectionLevel.Automatic, BillingAddressCollectionLevel.Required};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BillingAddressCollectionLevel.values().length];
            nArray[BillingAddressCollectionLevel.Automatic.ordinal()] = 1;
            nArray[BillingAddressCollectionLevel.Required.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

