/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.core.content.res.ResourcesCompat;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.databinding.StripeGooglePayButtonBinding;
import com.stripe.android.paymentsheet.ui.PrimaryButton;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\nR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/paymentsheet/ui/GooglePayButton;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "state", "Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State;", "viewBinding", "Lcom/stripe/android/paymentsheet/databinding/StripeGooglePayButtonBinding;", "getViewBinding$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/databinding/StripeGooglePayButtonBinding;", "onFinishProcessing", "", "onReadyState", "onStartProcessing", "setBackgroundColor", "useDarkResources", "", "setEnabled", "enabled", "updateAlpha", "updateState", "paymentsheet_release"})
public final class GooglePayButton
extends FrameLayout {
    @NotNull
    private final StripeGooglePayButtonBinding viewBinding;
    @Nullable
    private PrimaryButton.State state;

    @JvmOverloads
    public GooglePayButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        StripeGooglePayButtonBinding stripeGooglePayButtonBinding = StripeGooglePayButtonBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)stripeGooglePayButtonBinding, (String)"inflate(\n        LayoutI\u2026text),\n        this\n    )");
        this.viewBinding = stripeGooglePayButtonBinding;
        super.setClickable(true);
        super.setEnabled(true);
    }

    public /* synthetic */ GooglePayButton(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final StripeGooglePayButtonBinding getViewBinding$paymentsheet_release() {
        return this.viewBinding;
    }

    public final void setBackgroundColor(boolean useDarkResources) {
        int backgroundDrawable = useDarkResources ? R.drawable.stripe_googlepay_button_no_shadow_background_dark : R.drawable.stripe_googlepay_button_no_shadow_background_light;
        this.viewBinding.googlePayButtonIcon.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)backgroundDrawable, null));
        int contentDrawable = useDarkResources ? R.drawable.stripe_googlepay_button_content_dark : R.drawable.stripe_googlepay_button_content_light;
        this.viewBinding.googlePayButtonContent.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)contentDrawable, null));
        int primaryButtonColor = useDarkResources ? -16777216 : -1;
        this.viewBinding.primaryButton.setBackgroundTintList(ColorStateList.valueOf((int)primaryButtonColor));
    }

    private final void onReadyState() {
        RelativeLayout $this$isVisible$iv;
        PrimaryButton primaryButton2 = this.viewBinding.primaryButton;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)primaryButton2), (String)"viewBinding.primaryButton");
        primaryButton2 = (View)primaryButton2;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        $this$isVisible$iv = this.viewBinding.googlePayButtonIcon;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"viewBinding.googlePayButtonIcon");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = true;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
    }

    private final void onStartProcessing() {
        RelativeLayout $this$isVisible$iv;
        PrimaryButton primaryButton2 = this.viewBinding.primaryButton;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)primaryButton2), (String)"viewBinding.primaryButton");
        primaryButton2 = (View)primaryButton2;
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        $this$isVisible$iv = this.viewBinding.googlePayButtonIcon;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"viewBinding.googlePayButtonIcon");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
    }

    private final void onFinishProcessing() {
        RelativeLayout $this$isVisible$iv;
        PrimaryButton primaryButton2 = this.viewBinding.primaryButton;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)primaryButton2), (String)"viewBinding.primaryButton");
        primaryButton2 = (View)primaryButton2;
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        $this$isVisible$iv = this.viewBinding.googlePayButtonIcon;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"viewBinding.googlePayButtonIcon");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.viewBinding.primaryButton.setEnabled(enabled);
        this.updateAlpha();
    }

    private final void updateAlpha() {
        this.viewBinding.googlePayButtonIcon.setAlpha((this.state == null || this.state instanceof PrimaryButton.State.Ready) && !this.isEnabled() ? 0.5f : 1.0f);
    }

    public final void updateState(@Nullable PrimaryButton.State state) {
        this.viewBinding.primaryButton.updateState(state);
        this.state = state;
        this.updateAlpha();
        PrimaryButton.State state2 = state;
        if (state2 instanceof PrimaryButton.State.Ready) {
            this.onReadyState();
        } else if (Intrinsics.areEqual((Object)state2, (Object)PrimaryButton.State.StartProcessing.INSTANCE)) {
            this.onStartProcessing();
        } else if (state2 instanceof PrimaryButton.State.FinishProcessing) {
            this.onFinishProcessing();
        }
    }

    @JvmOverloads
    public GooglePayButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GooglePayButton(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

