/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import android.content.res.Resources;
import androidx.annotation.DrawableRes;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.paymentdatacollection.ach.TransformToBankIcon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0001\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0013\u0010\n\u001a\u0004\u0018\u00010\u0006*\u00020\tH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0013\u0010\f\u001a\u0004\u0018\u00010\u0006*\u00020\tH\u0001\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"createCardLabel", "", "resources", "Landroid/content/res/Resources;", "last4", "getCardBrandIcon", "", "Lcom/stripe/android/model/CardBrand;", "getLabel", "Lcom/stripe/android/model/PaymentMethod;", "getLabelIcon", "(Lcom/stripe/android/model/PaymentMethod;)Ljava/lang/Integer;", "getSavedPaymentMethodIcon", "paymentsheet_release"})
public final class PaymentMethodsUiExtensionKt {
    @DrawableRes
    @Nullable
    public static final Integer getSavedPaymentMethodIcon(@NotNull PaymentMethod $this$getSavedPaymentMethodIcon) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$getSavedPaymentMethodIcon, (String)"<this>");
        PaymentMethod.Type type = $this$getSavedPaymentMethodIcon.type;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Integer n2;
                PaymentMethod.Card card = $this$getSavedPaymentMethodIcon.card;
                if (card == null) {
                    n2 = null;
                } else {
                    CardBrand cardBrand = card.brand;
                    n2 = cardBrand == null ? null : Integer.valueOf(PaymentMethodsUiExtensionKt.getCardBrandIcon(cardBrand));
                }
                Integer n3 = n2;
                n = n3 == null ? R.drawable.stripe_ic_paymentsheet_card_unknown : n3;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_paymentsheet_pm_sepa_debit;
                break;
            }
            case 3: {
                PaymentMethod.USBankAccount uSBankAccount = $this$getSavedPaymentMethodIcon.usBankAccount;
                if (uSBankAccount == null) {
                    n = null;
                    break;
                }
                String string2 = uSBankAccount.bankName;
                if (string2 == null) {
                    n = null;
                    break;
                }
                String it = string2;
                boolean bl = false;
                n = TransformToBankIcon.Companion.invoke(it);
                break;
            }
            default: {
                n = null;
            }
        }
        return n;
    }

    @DrawableRes
    public static final int getCardBrandIcon(@NotNull CardBrand $this$getCardBrandIcon) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getCardBrandIcon, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getCardBrandIcon.ordinal()]) {
            case 1: {
                n = R.drawable.stripe_ic_paymentsheet_card_visa;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_paymentsheet_card_amex;
                break;
            }
            case 3: {
                n = R.drawable.stripe_ic_paymentsheet_card_discover;
                break;
            }
            case 4: {
                n = R.drawable.stripe_ic_paymentsheet_card_jcb;
                break;
            }
            case 5: {
                n = R.drawable.stripe_ic_paymentsheet_card_dinersclub;
                break;
            }
            case 6: {
                n = R.drawable.stripe_ic_paymentsheet_card_mastercard;
                break;
            }
            case 7: {
                n = R.drawable.stripe_ic_paymentsheet_card_unionpay;
                break;
            }
            case 8: {
                n = R.drawable.stripe_ic_paymentsheet_card_unknown;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Nullable
    public static final String getLabel(@NotNull PaymentMethod $this$getLabel, @NotNull Resources resources) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getLabel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        PaymentMethod.Type type = $this$getLabel.type;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                PaymentMethod.Card card = $this$getLabel.card;
                string2 = PaymentMethodsUiExtensionKt.createCardLabel(resources, (String)(card == null ? null : card.last4));
                break;
            }
            case 2: {
                Object[] objectArray = new Object[1];
                PaymentMethod.SepaDebit sepaDebit = $this$getLabel.sepaDebit;
                objectArray[0] = sepaDebit == null ? null : sepaDebit.last4;
                string2 = resources.getString(R.string.paymentsheet_payment_method_item_card_number, objectArray);
                break;
            }
            case 3: {
                Object[] objectArray = new Object[1];
                PaymentMethod.USBankAccount uSBankAccount = $this$getLabel.usBankAccount;
                objectArray[0] = uSBankAccount == null ? null : uSBankAccount.last4;
                string2 = resources.getString(R.string.paymentsheet_payment_method_item_card_number, objectArray);
                break;
            }
            default: {
                string2 = null;
            }
        }
        return string2;
    }

    @Nullable
    public static final Integer getLabelIcon(@NotNull PaymentMethod $this$getLabelIcon) {
        Intrinsics.checkNotNullParameter((Object)$this$getLabelIcon, (String)"<this>");
        PaymentMethod.Type type = $this$getLabelIcon.type;
        return (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) == 3 ? Integer.valueOf(R.drawable.stripe_ic_bank) : null;
    }

    @NotNull
    public static final String createCardLabel(@NotNull Resources resources, @Nullable String last4) {
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        String string4 = last4;
        if (string4 == null) {
            string3 = null;
        } else {
            String it = string4;
            boolean bl = false;
            Object[] objectArray = new Object[]{last4};
            string3 = string2 = resources.getString(R.string.paymentsheet_payment_method_item_card_number, objectArray);
        }
        if (string3 == null) {
            string2 = "";
        }
        return string2;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PaymentMethod.Type.values().length];
            nArray[PaymentMethod.Type.Card.ordinal()] = 1;
            nArray[PaymentMethod.Type.SepaDebit.ordinal()] = 2;
            nArray[PaymentMethod.Type.USBankAccount.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CardBrand.values().length];
            nArray[CardBrand.Visa.ordinal()] = 1;
            nArray[CardBrand.AmericanExpress.ordinal()] = 2;
            nArray[CardBrand.Discover.ordinal()] = 3;
            nArray[CardBrand.JCB.ordinal()] = 4;
            nArray[CardBrand.DinersClub.ordinal()] = 5;
            nArray[CardBrand.MasterCard.ordinal()] = 6;
            nArray[CardBrand.UnionPay.ordinal()] = 7;
            nArray[CardBrand.Unknown.ordinal()] = 8;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

