/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.customersheet;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.app.ActivityOptionsCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.stripe.android.ExperimentalAllowsRemovalOfLastSavedPaymentMethodApi;
import com.stripe.android.common.configuration.ConfigurationDefaults;
import com.stripe.android.customersheet.CustomerAdapter;
import com.stripe.android.customersheet.CustomerAdapterResultKtxKt;
import com.stripe.android.customersheet.CustomerSheetContract;
import com.stripe.android.customersheet.CustomerSheetResult;
import com.stripe.android.customersheet.CustomerSheetResultCallback;
import com.stripe.android.customersheet.ExperimentalCustomerSheetApi;
import com.stripe.android.customersheet.InternalCustomerSheetResult;
import com.stripe.android.customersheet.PaymentOptionSelection;
import com.stripe.android.customersheet.util.CustomerSheetHacks;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.model.PaymentOptionFactory;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.uicore.image.StripeImageLoader;
import com.stripe.android.uicore.utils.AnimationConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f BG\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u0010\u001c\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet;", "", "application", "Landroid/app/Application;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "activityResultRegistryOwner", "Landroidx/activity/result/ActivityResultRegistryOwner;", "paymentOptionFactory", "Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;", "callback", "Lcom/stripe/android/customersheet/CustomerSheetResultCallback;", "configuration", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration;", "statusBarColor", "Lkotlin/Function0;", "", "(Landroid/app/Application;Landroidx/lifecycle/LifecycleOwner;Landroidx/activity/result/ActivityResultRegistryOwner;Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;Lcom/stripe/android/customersheet/CustomerSheetResultCallback;Lcom/stripe/android/customersheet/CustomerSheet$Configuration;Lkotlin/jvm/functions/Function0;)V", "customerSheetActivityLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/customersheet/CustomerSheetContract$Args;", "kotlin.jvm.PlatformType", "onCustomerSheetResult", "", "result", "Lcom/stripe/android/customersheet/InternalCustomerSheetResult;", "present", "resetCustomer", "retrievePaymentOptionSelection", "Lcom/stripe/android/customersheet/CustomerSheetResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "Configuration", "paymentsheet_release"})
@ExperimentalCustomerSheetApi
@StabilityInferred(parameters=0)
public final class CustomerSheet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Application application;
    @NotNull
    private final PaymentOptionFactory paymentOptionFactory;
    @NotNull
    private final CustomerSheetResultCallback callback;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final Function0<Integer> statusBarColor;
    @NotNull
    private final ActivityResultLauncher<CustomerSheetContract.Args> customerSheetActivityLauncher;
    public static final int $stable = 8;

    @Inject
    public CustomerSheet(@NotNull Application application, @NotNull LifecycleOwner lifecycleOwner, @NotNull ActivityResultRegistryOwner activityResultRegistryOwner, @NotNull PaymentOptionFactory paymentOptionFactory, @NotNull CustomerSheetResultCallback callback, @NotNull Configuration configuration, @NotNull Function0<Integer> statusBarColor) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)activityResultRegistryOwner, (String)"activityResultRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)paymentOptionFactory, (String)"paymentOptionFactory");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(statusBarColor, (String)"statusBarColor");
        this.application = application;
        this.paymentOptionFactory = paymentOptionFactory;
        this.callback = callback;
        this.configuration = configuration;
        this.statusBarColor = statusBarColor;
        ActivityResultLauncher activityResultLauncher2 = activityResultRegistryOwner.getActivityResultRegistry().register("CustomerSheet", (ActivityResultContract)new CustomerSheetContract(), new ActivityResultCallback(this){
            final /* synthetic */ CustomerSheet $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void onActivityResult(@NotNull InternalCustomerSheetResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                CustomerSheet.access$onCustomerSheetResult(this.$tmp0, p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, CustomerSheet.class, "onCustomerSheetResult", "onCustomerSheetResult(Lcom/stripe/android/customersheet/InternalCustomerSheetResult;)V", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof ActivityResultCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher2, (String)"register(...)");
        this.customerSheetActivityLauncher = activityResultLauncher2;
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(){

            public void onDestroy(@NotNull LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                customerSheetActivityLauncher.unregister();
                super.onDestroy(owner);
            }
        });
    }

    public final void present() {
        CustomerSheetContract.Args args2 = new CustomerSheetContract.Args(this.configuration, (Integer)this.statusBarColor.invoke());
        ActivityOptionsCompat activityOptionsCompat = ActivityOptionsCompat.makeCustomAnimation((Context)this.application.getApplicationContext(), (int)AnimationConstants.INSTANCE.getFADE_IN(), (int)AnimationConstants.INSTANCE.getFADE_OUT());
        Intrinsics.checkNotNullExpressionValue((Object)activityOptionsCompat, (String)"makeCustomAnimation(...)");
        ActivityOptionsCompat options = activityOptionsCompat;
        this.customerSheetActivityLauncher.launch((Object)args2, options);
    }

    public final void resetCustomer() {
        CustomerSheetHacks.INSTANCE.clear();
    }

    @Nullable
    public final Object retrievePaymentOptionSelection(@NotNull Continuation<? super CustomerSheetResult> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CustomerSheetResult>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CustomerSheet this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var22_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        this.L$0 = $this$coroutineScope;
                        this.label = 1;
                        v0 = CustomerSheetHacks.INSTANCE.getAdapter().await((Continuation)this);
                        if (v0 == var22_2) {
                            return var22_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        adapter = (CustomerAdapter)v0;
                        selectedPaymentOptionDeferred = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CustomerAdapter.Result<CustomerAdapter.PaymentOption>>, Object>(adapter, null){
                            int label;
                            final /* synthetic */ CustomerAdapter $adapter;
                            {
                                this.$adapter = $adapter;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$adapter.retrieveSelectedPaymentOption((Continuation<? super CustomerAdapter.Result<CustomerAdapter.PaymentOption>>)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CustomerAdapter.Result<CustomerAdapter.PaymentOption>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        paymentMethodsDeferred = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CustomerAdapter.Result<List<? extends PaymentMethod>>>, Object>(adapter, null){
                            int label;
                            final /* synthetic */ CustomerAdapter $adapter;
                            {
                                this.$adapter = $adapter;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$adapter.retrievePaymentMethods((Continuation<? super CustomerAdapter.Result<List<PaymentMethod>>>)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CustomerAdapter.Result<List<PaymentMethod>>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.L$0 = paymentMethodsDeferred;
                        this.label = 2;
                        v1 = selectedPaymentOptionDeferred.await((Continuation)this);
                        if (v1 == var22_2) {
                            return var22_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        paymentMethodsDeferred = (Deferred)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        selectedPaymentOption = (CustomerAdapter.Result)v1;
                        this.L$0 = selectedPaymentOption;
                        this.label = 3;
                        v2 = paymentMethodsDeferred.await((Continuation)this);
                        if (v2 == var22_2) {
                            return var22_2;
                        }
                        ** GOTO lbl40
                    }
                    case 3: {
                        selectedPaymentOption = (CustomerAdapter.Result)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl40:
                        // 2 sources

                        paymentMethods = (CustomerAdapter.Result)v2;
                        var9_9 = selectedPaymentOption;
                        var10_10 = this.this$0;
                        $i$f$mapCatching = false;
                        var12_14 = $this$mapCatching$iv;
                        if (var12_14 instanceof CustomerAdapter.Result.Success) {
                            $this$runCatching$iv$iv = $this$mapCatching$iv;
                            $i$f$runCatching = false;
                            try {
                                var15_18 = (CustomerAdapter.Result.Success)$this$runCatching$iv$iv;
                                var16_20 = CustomerAdapter.Result.Companion;
                                $i$a$-runCatching-CustomerAdapterResultKtxKt$mapCatching$1$iv = false;
                                paymentOption = (CustomerAdapter.PaymentOption)$this$mapCatching_u24lambda_u240$iv.getValue();
                                $i$a$-mapCatching-CustomerSheet$retrievePaymentOptionSelection$2$selection$1 = false;
                                var21_25 /* !! */  = var16_20.success(paymentOption != null && (var20_24 = paymentOption.toPaymentSelection$paymentsheet_release((Function1<? super String, PaymentMethod>)((Function1)new Function1<String, PaymentMethod>((CustomerAdapter.Result<List<PaymentMethod>>)paymentMethods, paymentOption){
                                    final /* synthetic */ CustomerAdapter.Result<List<PaymentMethod>> $paymentMethods;
                                    final /* synthetic */ CustomerAdapter.PaymentOption $paymentOption;
                                    {
                                        this.$paymentMethods = $paymentMethods;
                                        this.$paymentOption = $paymentOption;
                                        super(1);
                                    }

                                    @Nullable
                                    public final PaymentMethod invoke(@NotNull String it) {
                                        PaymentMethod paymentMethod;
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        List<PaymentMethod> list = CustomerAdapterResultKtxKt.getOrNull(this.$paymentMethods);
                                        if (list != null) {
                                            Object v1;
                                            block3: {
                                                Iterable iterable = list;
                                                CustomerAdapter.PaymentOption paymentOption = this.$paymentOption;
                                                Iterable iterable2 = iterable;
                                                for (T t : iterable2) {
                                                    PaymentMethod it2 = (PaymentMethod)t;
                                                    boolean bl = false;
                                                    if (!Intrinsics.areEqual((Object)it2.id, (Object)paymentOption.getId())) continue;
                                                    v1 = t;
                                                    break block3;
                                                }
                                                v1 = null;
                                            }
                                            paymentMethod = v1;
                                        } else {
                                            paymentMethod = null;
                                        }
                                        return paymentMethod;
                                    }
                                }))) != null ? CustomerSheet.Companion.toPaymentOptionSelection$paymentsheet_release(var20_24, CustomerSheet.access$getPaymentOptionFactory$p(var10_10)) : null);
                            }
                            catch (Throwable e$iv$iv) {
                                var21_25 /* !! */  = CustomerAdapter.Result.Companion.failure(e$iv$iv, null);
                            }
                            v3 = var21_25 /* !! */ ;
                        } else if (var12_14 instanceof CustomerAdapter.Result.Failure) {
                            v3 = CustomerAdapter.Result.Companion.failure(((CustomerAdapter.Result.Failure)$this$mapCatching$iv).getCause(), ((CustomerAdapter.Result.Failure)$this$mapCatching$iv).getDisplayMessage());
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        $this$fold$iv = selection = v3;
                        $i$f$fold = false;
                        var11_13 = $this$fold$iv;
                        if (var11_13 instanceof CustomerAdapter.Result.Failure) {
                            v4 = ((CustomerAdapter.Result.Failure)$this$fold$iv).getCause();
                            ((CustomerAdapter.Result.Failure)$this$fold$iv).getDisplayMessage();
                            cause = v4;
                            $i$a$-fold-CustomerSheet$retrievePaymentOptionSelection$2$2 = false;
                            v5 = new CustomerSheetResult.Failed(cause);
                        } else if (var11_13 instanceof CustomerAdapter.Result.Success) {
                            it = (PaymentOptionSelection)((CustomerAdapter.Result.Success)$this$fold$iv).getValue();
                            $i$a$-fold-CustomerSheet$retrievePaymentOptionSelection$2$1 = false;
                            v5 = new CustomerSheetResult.Selected(it);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return v5;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CustomerSheetResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final void onCustomerSheetResult(InternalCustomerSheetResult result2) {
        this.callback.onCustomerSheetResult(result2.toPublicResult(this.paymentOptionFactory));
    }

    @JvmStatic
    @NotNull
    public static final CustomerSheet create(@NotNull ComponentActivity activity2, @NotNull Configuration configuration, @NotNull CustomerAdapter customerAdapter, @NotNull CustomerSheetResultCallback callback) {
        return Companion.create(activity2, configuration, customerAdapter, callback);
    }

    @JvmStatic
    @NotNull
    public static final CustomerSheet create(@NotNull Fragment fragment, @NotNull Configuration configuration, @NotNull CustomerAdapter customerAdapter, @NotNull CustomerSheetResultCallback callback) {
        return Companion.create(fragment, configuration, customerAdapter, callback);
    }

    public static final /* synthetic */ PaymentOptionFactory access$getPaymentOptionFactory$p(CustomerSheet $this) {
        return $this.paymentOptionFactory;
    }

    public static final /* synthetic */ void access$onCustomerSheetResult(CustomerSheet $this, InternalCustomerSheetResult result2) {
        $this.onCustomerSheetResult(result2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007JM\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001f\u00a8\u0006 "}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$Companion;", "", "()V", "create", "Lcom/stripe/android/customersheet/CustomerSheet;", "activity", "Landroidx/activity/ComponentActivity;", "configuration", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration;", "customerAdapter", "Lcom/stripe/android/customersheet/CustomerAdapter;", "callback", "Lcom/stripe/android/customersheet/CustomerSheetResultCallback;", "fragment", "Landroidx/fragment/app/Fragment;", "getInstance", "application", "Landroid/app/Application;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "activityResultRegistryOwner", "Landroidx/activity/result/ActivityResultRegistryOwner;", "statusBarColor", "Lkotlin/Function0;", "", "getInstance$paymentsheet_release", "toPaymentOptionSelection", "Lcom/stripe/android/customersheet/PaymentOptionSelection;", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "paymentOptionFactory", "Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;", "toPaymentOptionSelection$paymentsheet_release", "paymentsheet_release"})
    @ExperimentalCustomerSheetApi
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CustomerSheet create(@NotNull ComponentActivity activity2, @NotNull Configuration configuration, @NotNull CustomerAdapter customerAdapter, @NotNull CustomerSheetResultCallback callback) {
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)customerAdapter, (String)"customerAdapter");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            Application application = activity2.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            return this.getInstance$paymentsheet_release(application, (LifecycleOwner)activity2, (ActivityResultRegistryOwner)activity2, (Function0<Integer>)((Function0)new Function0<Integer>(activity2){
                final /* synthetic */ ComponentActivity $activity;
                {
                    this.$activity = $activity;
                    super(0);
                }

                @Nullable
                public final Integer invoke() {
                    return this.$activity.getWindow().getStatusBarColor();
                }
            }), configuration, customerAdapter, callback);
        }

        @JvmStatic
        @NotNull
        public final CustomerSheet create(@NotNull Fragment fragment, @NotNull Configuration configuration, @NotNull CustomerAdapter customerAdapter, @NotNull CustomerSheetResultCallback callback) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)customerAdapter, (String)"customerAdapter");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            Application application = fragment.requireActivity().getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            LifecycleOwner lifecycleOwner = (LifecycleOwner)fragment;
            Object object = fragment.getHost();
            ActivityResultRegistryOwner activityResultRegistryOwner = object instanceof ActivityResultRegistryOwner ? (ActivityResultRegistryOwner)object : null;
            if (activityResultRegistryOwner == null) {
                FragmentActivity fragmentActivity = fragment.requireActivity();
                Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity(...)");
                activityResultRegistryOwner = (ActivityResultRegistryOwner)fragmentActivity;
            }
            return this.getInstance$paymentsheet_release(application, lifecycleOwner, activityResultRegistryOwner, (Function0<Integer>)((Function0)new Function0<Integer>(fragment){
                final /* synthetic */ Fragment $fragment;
                {
                    this.$fragment = $fragment;
                    super(0);
                }

                @Nullable
                public final Integer invoke() {
                    FragmentActivity fragmentActivity = this.$fragment.getActivity();
                    return fragmentActivity != null && (fragmentActivity = fragmentActivity.getWindow()) != null ? Integer.valueOf(fragmentActivity.getStatusBarColor()) : null;
                }
            }), configuration, customerAdapter, callback);
        }

        @NotNull
        public final CustomerSheet getInstance$paymentsheet_release(@NotNull Application application, @NotNull LifecycleOwner lifecycleOwner, @NotNull ActivityResultRegistryOwner activityResultRegistryOwner, @NotNull Function0<Integer> statusBarColor, @NotNull Configuration configuration, @NotNull CustomerAdapter customerAdapter, @NotNull CustomerSheetResultCallback callback) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
            Intrinsics.checkNotNullParameter((Object)activityResultRegistryOwner, (String)"activityResultRegistryOwner");
            Intrinsics.checkNotNullParameter(statusBarColor, (String)"statusBarColor");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)customerAdapter, (String)"customerAdapter");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            CustomerSheetHacks.INSTANCE.initialize(lifecycleOwner, customerAdapter, configuration);
            Resources resources = application.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"getResources(...)");
            PaymentOptionFactory paymentOptionFactory = new PaymentOptionFactory(resources, new StripeImageLoader((Context)application, null, null, null, null, 30, null), (Context)application);
            return new CustomerSheet(application, lifecycleOwner, activityResultRegistryOwner, paymentOptionFactory, callback, configuration, statusBarColor);
        }

        @Nullable
        public final PaymentOptionSelection toPaymentOptionSelection$paymentsheet_release(@Nullable PaymentSelection $this$toPaymentOptionSelection, @NotNull PaymentOptionFactory paymentOptionFactory) {
            Intrinsics.checkNotNullParameter((Object)paymentOptionFactory, (String)"paymentOptionFactory");
            PaymentSelection paymentSelection = $this$toPaymentOptionSelection;
            return paymentSelection instanceof PaymentSelection.GooglePay ? (PaymentOptionSelection)new PaymentOptionSelection.GooglePay(paymentOptionFactory.create($this$toPaymentOptionSelection)) : (paymentSelection instanceof PaymentSelection.Saved ? (PaymentOptionSelection)new PaymentOptionSelection.PaymentMethod(((PaymentSelection.Saved)$this$toPaymentOptionSelection).getPaymentMethod(), paymentOptionFactory.create($this$toPaymentOptionSelection)) : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 -2\u00020\u0001:\u0002,-B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Bm\b\u0000\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\b\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\u0002\u0010\u0013J\t\u0010#\u001a\u00020$H\u00d6\u0001J\u0006\u0010%\u001a\u00020&J\u0019\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020$H\u00d6\u0001R\u0014\u0010\u0011\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!\u00a8\u0006."}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$Configuration;", "Landroid/os/Parcelable;", "merchantDisplayName", "", "(Ljava/lang/String;)V", "appearance", "Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "googlePayEnabled", "", "headerTextForSelectionScreen", "defaultBillingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "billingDetailsCollectionConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "preferredNetworks", "", "Lcom/stripe/android/model/CardBrand;", "allowsRemovalOfLastSavedPaymentMethod", "paymentMethodOrder", "(Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;ZLjava/lang/String;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;Ljava/lang/String;Ljava/util/List;ZLjava/util/List;)V", "getAllowsRemovalOfLastSavedPaymentMethod$paymentsheet_release", "()Z", "getAppearance", "()Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "getBillingDetailsCollectionConfiguration", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "getDefaultBillingDetails", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "getGooglePayEnabled", "getHeaderTextForSelectionScreen", "()Ljava/lang/String;", "getMerchantDisplayName", "getPaymentMethodOrder$paymentsheet_release", "()Ljava/util/List;", "getPreferredNetworks", "describeContents", "", "newBuilder", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration$Builder;", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Builder", "Companion", "paymentsheet_release"})
    @ExperimentalCustomerSheetApi
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Configuration
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final PaymentSheet.Appearance appearance;
        private final boolean googlePayEnabled;
        @Nullable
        private final String headerTextForSelectionScreen;
        @NotNull
        private final PaymentSheet.BillingDetails defaultBillingDetails;
        @NotNull
        private final PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration;
        @NotNull
        private final String merchantDisplayName;
        @NotNull
        private final List<CardBrand> preferredNetworks;
        private final boolean allowsRemovalOfLastSavedPaymentMethod;
        @NotNull
        private final List<String> paymentMethodOrder;
        public static final int $stable = 8;
        @NotNull
        public static final Parcelable.Creator<Configuration> CREATOR;

        public Configuration(@NotNull PaymentSheet.Appearance appearance, boolean googlePayEnabled, @Nullable String headerTextForSelectionScreen, @NotNull PaymentSheet.BillingDetails defaultBillingDetails, @NotNull PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, @NotNull String merchantDisplayName, @NotNull List<? extends CardBrand> preferredNetworks, boolean allowsRemovalOfLastSavedPaymentMethod, @NotNull List<String> paymentMethodOrder) {
            Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
            Intrinsics.checkNotNullParameter((Object)defaultBillingDetails, (String)"defaultBillingDetails");
            Intrinsics.checkNotNullParameter((Object)billingDetailsCollectionConfiguration, (String)"billingDetailsCollectionConfiguration");
            Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
            Intrinsics.checkNotNullParameter(preferredNetworks, (String)"preferredNetworks");
            Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
            this.appearance = appearance;
            this.googlePayEnabled = googlePayEnabled;
            this.headerTextForSelectionScreen = headerTextForSelectionScreen;
            this.defaultBillingDetails = defaultBillingDetails;
            this.billingDetailsCollectionConfiguration = billingDetailsCollectionConfiguration;
            this.merchantDisplayName = merchantDisplayName;
            this.preferredNetworks = preferredNetworks;
            this.allowsRemovalOfLastSavedPaymentMethod = allowsRemovalOfLastSavedPaymentMethod;
            this.paymentMethodOrder = paymentMethodOrder;
        }

        public /* synthetic */ Configuration(PaymentSheet.Appearance appearance, boolean bl, String string2, PaymentSheet.BillingDetails billingDetails, PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, String string3, List list, boolean bl2, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                appearance = ConfigurationDefaults.INSTANCE.getAppearance();
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                string2 = ConfigurationDefaults.INSTANCE.getHeaderTextForSelectionScreen();
            }
            if ((n & 8) != 0) {
                billingDetails = ConfigurationDefaults.INSTANCE.getBillingDetails();
            }
            if ((n & 0x10) != 0) {
                billingDetailsCollectionConfiguration = ConfigurationDefaults.INSTANCE.getBillingDetailsCollectionConfiguration();
            }
            if ((n & 0x40) != 0) {
                list = ConfigurationDefaults.INSTANCE.getPreferredNetworks();
            }
            if ((n & 0x80) != 0) {
                bl2 = true;
            }
            if ((n & 0x100) != 0) {
                list2 = ConfigurationDefaults.INSTANCE.getPaymentMethodOrder();
            }
            this(appearance, bl, string2, billingDetails, billingDetailsCollectionConfiguration, string3, list, bl2, list2);
        }

        @NotNull
        public final PaymentSheet.Appearance getAppearance() {
            return this.appearance;
        }

        public final boolean getGooglePayEnabled() {
            return this.googlePayEnabled;
        }

        @Nullable
        public final String getHeaderTextForSelectionScreen() {
            return this.headerTextForSelectionScreen;
        }

        @NotNull
        public final PaymentSheet.BillingDetails getDefaultBillingDetails() {
            return this.defaultBillingDetails;
        }

        @NotNull
        public final PaymentSheet.BillingDetailsCollectionConfiguration getBillingDetailsCollectionConfiguration() {
            return this.billingDetailsCollectionConfiguration;
        }

        @NotNull
        public final String getMerchantDisplayName() {
            return this.merchantDisplayName;
        }

        @NotNull
        public final List<CardBrand> getPreferredNetworks() {
            return this.preferredNetworks;
        }

        public final boolean getAllowsRemovalOfLastSavedPaymentMethod$paymentsheet_release() {
            return this.allowsRemovalOfLastSavedPaymentMethod;
        }

        @NotNull
        public final List<String> getPaymentMethodOrder$paymentsheet_release() {
            return this.paymentMethodOrder;
        }

        public Configuration(@NotNull String merchantDisplayName) {
            Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
            this(ConfigurationDefaults.INSTANCE.getAppearance(), false, ConfigurationDefaults.INSTANCE.getHeaderTextForSelectionScreen(), ConfigurationDefaults.INSTANCE.getBillingDetails(), ConfigurationDefaults.INSTANCE.getBillingDetailsCollectionConfiguration(), merchantDisplayName, null, true, null, 320, null);
        }

        @NotNull
        public final Builder newBuilder() {
            return new Builder(this.merchantDisplayName).appearance(this.appearance).googlePayEnabled(this.googlePayEnabled).headerTextForSelectionScreen(this.headerTextForSelectionScreen).defaultBillingDetails(this.defaultBillingDetails).billingDetailsCollectionConfiguration(this.billingDetailsCollectionConfiguration).allowsRemovalOfLastSavedPaymentMethod(this.allowsRemovalOfLastSavedPaymentMethod).paymentMethodOrder(this.paymentMethodOrder);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Configuration)) {
                return false;
            }
            Configuration configuration = (Configuration)other;
            if (!Intrinsics.areEqual((Object)this.appearance, (Object)configuration.appearance)) {
                return false;
            }
            if (this.googlePayEnabled != configuration.googlePayEnabled) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.headerTextForSelectionScreen, (Object)configuration.headerTextForSelectionScreen)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultBillingDetails, (Object)configuration.defaultBillingDetails)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.billingDetailsCollectionConfiguration, (Object)configuration.billingDetailsCollectionConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.merchantDisplayName, (Object)configuration.merchantDisplayName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.preferredNetworks, configuration.preferredNetworks)) {
                return false;
            }
            if (this.allowsRemovalOfLastSavedPaymentMethod != configuration.allowsRemovalOfLastSavedPaymentMethod) {
                return false;
            }
            return Intrinsics.areEqual(this.paymentMethodOrder, configuration.paymentMethodOrder);
        }

        public int hashCode() {
            int result2 = this.appearance.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.googlePayEnabled);
            result2 = result2 * 31 + (this.headerTextForSelectionScreen == null ? 0 : this.headerTextForSelectionScreen.hashCode());
            result2 = result2 * 31 + this.defaultBillingDetails.hashCode();
            result2 = result2 * 31 + this.billingDetailsCollectionConfiguration.hashCode();
            result2 = result2 * 31 + this.merchantDisplayName.hashCode();
            result2 = result2 * 31 + ((Object)this.preferredNetworks).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.allowsRemovalOfLastSavedPaymentMethod);
            result2 = result2 * 31 + ((Object)this.paymentMethodOrder).hashCode();
            return result2;
        }

        @NotNull
        public String toString() {
            return "Configuration(appearance=" + this.appearance + ", googlePayEnabled=" + this.googlePayEnabled + ", headerTextForSelectionScreen=" + this.headerTextForSelectionScreen + ", defaultBillingDetails=" + this.defaultBillingDetails + ", billingDetailsCollectionConfiguration=" + this.billingDetailsCollectionConfiguration + ", merchantDisplayName=" + this.merchantDisplayName + ", preferredNetworks=" + this.preferredNetworks + ", allowsRemovalOfLastSavedPaymentMethod=" + this.allowsRemovalOfLastSavedPaymentMethod + ", paymentMethodOrder=" + this.paymentMethodOrder + ")";
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.appearance.writeToParcel(out, flags);
            out.writeInt(this.googlePayEnabled ? 1 : 0);
            out.writeString(this.headerTextForSelectionScreen);
            this.defaultBillingDetails.writeToParcel(out, flags);
            this.billingDetailsCollectionConfiguration.writeToParcel(out, flags);
            out.writeString(this.merchantDisplayName);
            List<CardBrand> list = this.preferredNetworks;
            out.writeInt(list.size());
            Iterator<CardBrand> iterator = list.iterator();
            while (iterator.hasNext()) {
                out.writeString(iterator.next().name());
            }
            out.writeInt(this.allowsRemovalOfLastSavedPaymentMethod ? 1 : 0);
            out.writeStringList(this.paymentMethodOrder);
        }

        @JvmStatic
        @NotNull
        public static final Builder builder(@NotNull String merchantDisplayName) {
            return Companion.builder(merchantDisplayName);
        }

        static {
            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Configuration> {
                @NotNull
                public final Configuration[] newArray(int size) {
                    return new Configuration[size];
                }

                @NotNull
                public final Configuration createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n = parcel.readInt();
                    ArrayList<CardBrand> arrayList = new ArrayList<CardBrand>(n);
                    String string2 = parcel.readString();
                    PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = (PaymentSheet.BillingDetailsCollectionConfiguration)PaymentSheet.BillingDetailsCollectionConfiguration.CREATOR.createFromParcel(parcel);
                    PaymentSheet.BillingDetails billingDetails = (PaymentSheet.BillingDetails)PaymentSheet.BillingDetails.CREATOR.createFromParcel(parcel);
                    String string3 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    PaymentSheet.Appearance appearance = (PaymentSheet.Appearance)PaymentSheet.Appearance.CREATOR.createFromParcel(parcel);
                    for (int i = 0; i != n; ++i) {
                        arrayList.add(CardBrand.valueOf((String)parcel.readString()));
                    }
                    List list = parcel.createStringArrayList();
                    boolean bl2 = parcel.readInt() != 0;
                    List list2 = arrayList;
                    String string4 = string2;
                    PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration2 = billingDetailsCollectionConfiguration;
                    PaymentSheet.BillingDetails billingDetails2 = billingDetails;
                    String string5 = string3;
                    boolean bl3 = bl;
                    PaymentSheet.Appearance appearance2 = appearance;
                    return new Configuration(appearance2, bl3, string5, billingDetails2, billingDetailsCollectionConfiguration2, string4, list2, bl2, list);
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\nJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003J\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\u0014\u0010\u0011\u001a\u00020\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$Configuration$Builder;", "", "merchantDisplayName", "", "(Ljava/lang/String;)V", "allowsRemovalOfLastSavedPaymentMethod", "", "appearance", "Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "billingDetailsCollectionConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "defaultBillingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "googlePayEnabled", "headerTextForSelectionScreen", "paymentMethodOrder", "", "preferredNetworks", "Lcom/stripe/android/model/CardBrand;", "configuration", "build", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration;", "details", "googlePayConfiguration", "paymentsheet_release"})
        @ExperimentalCustomerSheetApi
        @StabilityInferred(parameters=0)
        public static final class Builder {
            @NotNull
            private final String merchantDisplayName;
            @NotNull
            private PaymentSheet.Appearance appearance;
            private boolean googlePayEnabled;
            @Nullable
            private String headerTextForSelectionScreen;
            @NotNull
            private PaymentSheet.BillingDetails defaultBillingDetails;
            @NotNull
            private PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration;
            @NotNull
            private List<? extends CardBrand> preferredNetworks;
            private boolean allowsRemovalOfLastSavedPaymentMethod;
            @NotNull
            private List<String> paymentMethodOrder;
            public static final int $stable = 8;

            public Builder(@NotNull String merchantDisplayName) {
                Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
                this.merchantDisplayName = merchantDisplayName;
                this.appearance = ConfigurationDefaults.INSTANCE.getAppearance();
                this.headerTextForSelectionScreen = ConfigurationDefaults.INSTANCE.getHeaderTextForSelectionScreen();
                this.defaultBillingDetails = ConfigurationDefaults.INSTANCE.getBillingDetails();
                this.billingDetailsCollectionConfiguration = ConfigurationDefaults.INSTANCE.getBillingDetailsCollectionConfiguration();
                this.preferredNetworks = ConfigurationDefaults.INSTANCE.getPreferredNetworks();
                this.allowsRemovalOfLastSavedPaymentMethod = true;
                this.paymentMethodOrder = ConfigurationDefaults.INSTANCE.getPaymentMethodOrder();
            }

            @NotNull
            public final Builder appearance(@NotNull PaymentSheet.Appearance appearance) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
                Builder $this$appearance_u24lambda_u240 = builder = this;
                boolean bl = false;
                $this$appearance_u24lambda_u240.appearance = appearance;
                return builder;
            }

            @NotNull
            public final Builder googlePayEnabled(boolean googlePayConfiguration) {
                Builder builder;
                Builder $this$googlePayEnabled_u24lambda_u241 = builder = this;
                boolean bl = false;
                $this$googlePayEnabled_u24lambda_u241.googlePayEnabled = googlePayConfiguration;
                return builder;
            }

            @NotNull
            public final Builder headerTextForSelectionScreen(@Nullable String headerTextForSelectionScreen) {
                Builder builder;
                Builder $this$headerTextForSelectionScreen_u24lambda_u242 = builder = this;
                boolean bl = false;
                $this$headerTextForSelectionScreen_u24lambda_u242.headerTextForSelectionScreen = headerTextForSelectionScreen;
                return builder;
            }

            @NotNull
            public final Builder defaultBillingDetails(@NotNull PaymentSheet.BillingDetails details) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)details, (String)"details");
                Builder $this$defaultBillingDetails_u24lambda_u243 = builder = this;
                boolean bl = false;
                $this$defaultBillingDetails_u24lambda_u243.defaultBillingDetails = details;
                return builder;
            }

            @NotNull
            public final Builder billingDetailsCollectionConfiguration(@NotNull PaymentSheet.BillingDetailsCollectionConfiguration configuration) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Builder $this$billingDetailsCollectionConfiguration_u24lambda_u244 = builder = this;
                boolean bl = false;
                $this$billingDetailsCollectionConfiguration_u24lambda_u244.billingDetailsCollectionConfiguration = configuration;
                return builder;
            }

            @NotNull
            public final Builder preferredNetworks(@NotNull List<? extends CardBrand> preferredNetworks) {
                Builder builder;
                Intrinsics.checkNotNullParameter(preferredNetworks, (String)"preferredNetworks");
                Builder $this$preferredNetworks_u24lambda_u245 = builder = this;
                boolean bl = false;
                $this$preferredNetworks_u24lambda_u245.preferredNetworks = preferredNetworks;
                return builder;
            }

            @ExperimentalAllowsRemovalOfLastSavedPaymentMethodApi
            @NotNull
            public final Builder allowsRemovalOfLastSavedPaymentMethod(boolean allowsRemovalOfLastSavedPaymentMethod) {
                Builder builder;
                Builder $this$allowsRemovalOfLastSavedPaymentMethod_u24lambda_u246 = builder = this;
                boolean bl = false;
                $this$allowsRemovalOfLastSavedPaymentMethod_u24lambda_u246.allowsRemovalOfLastSavedPaymentMethod = allowsRemovalOfLastSavedPaymentMethod;
                return builder;
            }

            @NotNull
            public final Builder paymentMethodOrder(@NotNull List<String> paymentMethodOrder) {
                Builder builder;
                Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
                Builder $this$paymentMethodOrder_u24lambda_u247 = builder = this;
                boolean bl = false;
                $this$paymentMethodOrder_u24lambda_u247.paymentMethodOrder = paymentMethodOrder;
                return builder;
            }

            @NotNull
            public final Configuration build() {
                return new Configuration(this.appearance, this.googlePayEnabled, this.headerTextForSelectionScreen, this.defaultBillingDetails, this.billingDetailsCollectionConfiguration, this.merchantDisplayName, this.preferredNetworks, this.allowsRemovalOfLastSavedPaymentMethod, this.paymentMethodOrder);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$Configuration$Companion;", "", "()V", "builder", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration$Builder;", "merchantDisplayName", "", "paymentsheet_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder builder(@NotNull String merchantDisplayName) {
                Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
                return new Builder(merchantDisplayName);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

