/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.customersheet.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.common.analytics.AnalyticsKtxKt;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.customersheet.CustomerSheet;
import com.stripe.android.customersheet.analytics.CustomerSheetEventReporter;
import com.stripe.android.model.CardBrand;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \r2\u00020\u0001:\u0013\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0012\u001c\u001d\u001e\u001f !\"#$%&'()*+,-\u00a8\u0006."}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "Lcom/stripe/android/core/networking/AnalyticsEvent;", "()V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "AttachPaymentMethodCanceled", "AttachPaymentMethodFailed", "AttachPaymentMethodSucceeded", "CardNumberCompleted", "Companion", "ConfirmPaymentMethodFailed", "ConfirmPaymentMethodSucceeded", "EditCompleted", "EditTapped", "HidePaymentOptionBrands", "Init", "RemovePaymentMethodFailed", "RemovePaymentMethodSucceeded", "ScreenHidden", "ScreenPresented", "SelectPaymentMethod", "ShowPaymentOptionBrands", "UpdatePaymentOptionFailed", "UpdatePaymentOptionSucceeded", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$AttachPaymentMethodCanceled;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$AttachPaymentMethodFailed;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$AttachPaymentMethodSucceeded;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$CardNumberCompleted;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ConfirmPaymentMethodFailed;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ConfirmPaymentMethodSucceeded;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$EditCompleted;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$EditTapped;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$HidePaymentOptionBrands;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$Init;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$RemovePaymentMethodFailed;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$RemovePaymentMethodSucceeded;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ScreenHidden;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ScreenPresented;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$SelectPaymentMethod;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ShowPaymentOptionBrands;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$UpdatePaymentOptionFailed;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$UpdatePaymentOptionSucceeded;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public abstract class CustomerSheetEvent
implements AnalyticsEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    public static final String CS_INIT = "cs_init";
    @NotNull
    public static final String CS_ADD_PAYMENT_METHOD_SCREEN_PRESENTED = "cs_add_payment_method_screen_presented";
    @NotNull
    public static final String CS_SELECT_PAYMENT_METHOD_SCREEN_PRESENTED = "cs_select_payment_method_screen_presented";
    @NotNull
    public static final String CS_SELECT_PAYMENT_METHOD_CONFIRMED_SAVED_PM_SUCCEEDED = "cs_select_payment_method_screen_confirmed_savedpm_success";
    @NotNull
    public static final String CS_SELECT_PAYMENT_METHOD_CONFIRMED_SAVED_PM_FAILED = "cs_select_payment_method_screen_confirmed_savedpm_failure";
    @NotNull
    public static final String CS_PAYMENT_METHOD_SELECTED = "cs_carousel_payment_method_selected";
    @NotNull
    public static final String CS_CARD_NUMBER_COMPLETED = "cs_card_number_completed";
    @NotNull
    public static final String CS_SELECT_PAYMENT_METHOD_EDIT_TAPPED = "cs_select_payment_method_screen_edit_tapped";
    @NotNull
    public static final String CS_SELECT_PAYMENT_METHOD_DONE_TAPPED = "cs_select_payment_method_screen_done_tapped";
    @NotNull
    public static final String CS_SELECT_PAYMENT_METHOD_REMOVE_PM_SUCCEEDED = "cs_select_payment_method_screen_removepm_success";
    @NotNull
    public static final String CS_SELECT_PAYMENT_METHOD_REMOVE_PM_FAILED = "cs_select_payment_method_screen_removepm_failure";
    @NotNull
    public static final String CS_ADD_PAYMENT_METHOD_VIA_SETUP_INTENT_SUCCEEDED = "cs_add_payment_method_via_setup_intent_success";
    @NotNull
    public static final String CS_ADD_PAYMENT_METHOD_VIA_SETUP_INTENT_CANCELED = "cs_add_payment_method_via_setupintent_canceled";
    @NotNull
    public static final String CS_ADD_PAYMENT_METHOD_VIA_SETUP_INTENT_FAILED = "cs_add_payment_method_via_setup_intent_failure";
    @NotNull
    public static final String CS_ADD_PAYMENT_METHOD_VIA_CREATE_ATTACH_SUCCEEDED = "cs_add_payment_method_via_createAttach_success";
    @NotNull
    public static final String CS_ADD_PAYMENT_METHOD_VIA_CREATE_ATTACH_FAILED = "cs_add_payment_method_via_createAttach_failure";
    @NotNull
    public static final String CS_SHOW_EDITABLE_PAYMENT_OPTION = "cs_open_edit_screen";
    @NotNull
    public static final String CS_HIDE_EDITABLE_PAYMENT_OPTION = "cs_cancel_edit_screen";
    @NotNull
    public static final String CS_SHOW_PAYMENT_OPTION_BRANDS = "cs_open_cbc_dropdown";
    @NotNull
    public static final String CS_HIDE_PAYMENT_OPTION_BRANDS = "cs_close_cbc_dropdown";
    @NotNull
    public static final String CS_UPDATE_PAYMENT_METHOD = "cs_update_card";
    @NotNull
    public static final String CS_UPDATE_PAYMENT_METHOD_FAILED = "cs_update_card_failed";
    @NotNull
    public static final String FIELD_GOOGLE_PAY_ENABLED = "google_pay_enabled";
    @NotNull
    public static final String FIELD_BILLING = "default_billing_details";
    @NotNull
    public static final String FIELD_PREFERRED_NETWORKS = "preferred_networks";
    @NotNull
    public static final String FIELD_CUSTOMER_SHEET_CONFIGURATION = "cs_config";
    @NotNull
    public static final String FIELD_APPEARANCE = "appearance";
    @NotNull
    public static final String FIELD_PAYMENT_METHOD_ORDER = "payment_method_order";
    @NotNull
    public static final String FIELD_BILLING_DETAILS_COLLECTION_CONFIGURATION = "billing_details_collection_configuration";
    @NotNull
    public static final String FIELD_ALLOWS_REMOVAL_OF_LAST_SAVED_PAYMENT_METHOD = "allows_removal_of_last_saved_payment_method";
    @NotNull
    public static final String FIELD_CBC_EVENT_SOURCE = "cbc_event_source";
    @NotNull
    public static final String FIELD_SELECTED_CARD_BRAND = "selected_card_brand";
    @NotNull
    public static final String FIELD_ERROR_MESSAGE = "error_message";
    @NotNull
    public static final String FIELD_PAYMENT_METHOD_TYPE = "payment_method_type";
    @NotNull
    public static final String FIELD_SELECTED_LPM = "selected_lpm";
    @NotNull
    public static final String VALUE_EDIT_CBC_EVENT_SOURCE = "edit";
    @NotNull
    public static final String VALUE_ADD_CBC_EVENT_SOURCE = "add";

    private CustomerSheetEvent() {
    }

    @NotNull
    public abstract Map<String, Object> getAdditionalParams();

    public /* synthetic */ CustomerSheetEvent(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$AttachPaymentMethodCanceled;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "()V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class AttachPaymentMethodCanceled
    extends CustomerSheetEvent {
        @NotNull
        private final Map<String, Object> additionalParams = MapsKt.emptyMap();
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public AttachPaymentMethodCanceled() {
            super(null);
            this.eventName = CustomerSheetEvent.CS_ADD_PAYMENT_METHOD_VIA_SETUP_INTENT_CANCELED;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$AttachPaymentMethodFailed;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "style", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEventReporter$AddPaymentMethodStyle;", "(Lcom/stripe/android/customersheet/analytics/CustomerSheetEventReporter$AddPaymentMethodStyle;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class AttachPaymentMethodFailed
    extends CustomerSheetEvent {
        @NotNull
        private final Map<String, Object> additionalParams;
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public AttachPaymentMethodFailed(@NotNull CustomerSheetEventReporter.AddPaymentMethodStyle style) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
            super(null);
            this.additionalParams = MapsKt.emptyMap();
            switch (WhenMappings.$EnumSwitchMapping$0[style.ordinal()]) {
                case 1: {
                    string2 = CustomerSheetEvent.CS_ADD_PAYMENT_METHOD_VIA_SETUP_INTENT_FAILED;
                    break;
                }
                case 2: {
                    string2 = CustomerSheetEvent.CS_ADD_PAYMENT_METHOD_VIA_CREATE_ATTACH_FAILED;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.eventName = string2;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CustomerSheetEventReporter.AddPaymentMethodStyle.values().length];
                try {
                    nArray[CustomerSheetEventReporter.AddPaymentMethodStyle.SetupIntent.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CustomerSheetEventReporter.AddPaymentMethodStyle.CreateAttach.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$AttachPaymentMethodSucceeded;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "style", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEventReporter$AddPaymentMethodStyle;", "(Lcom/stripe/android/customersheet/analytics/CustomerSheetEventReporter$AddPaymentMethodStyle;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class AttachPaymentMethodSucceeded
    extends CustomerSheetEvent {
        @NotNull
        private final Map<String, Object> additionalParams;
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public AttachPaymentMethodSucceeded(@NotNull CustomerSheetEventReporter.AddPaymentMethodStyle style) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
            super(null);
            this.additionalParams = MapsKt.emptyMap();
            switch (WhenMappings.$EnumSwitchMapping$0[style.ordinal()]) {
                case 1: {
                    string2 = CustomerSheetEvent.CS_ADD_PAYMENT_METHOD_VIA_SETUP_INTENT_SUCCEEDED;
                    break;
                }
                case 2: {
                    string2 = CustomerSheetEvent.CS_ADD_PAYMENT_METHOD_VIA_CREATE_ATTACH_SUCCEEDED;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.eventName = string2;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CustomerSheetEventReporter.AddPaymentMethodStyle.values().length];
                try {
                    nArray[CustomerSheetEventReporter.AddPaymentMethodStyle.SetupIntent.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CustomerSheetEventReporter.AddPaymentMethodStyle.CreateAttach.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$CardNumberCompleted;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "()V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class CardNumberCompleted
    extends CustomerSheetEvent {
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams = MapsKt.emptyMap();
        public static final int $stable = 8;

        public CardNumberCompleted() {
            super(null);
            this.eventName = CustomerSheetEvent.CS_CARD_NUMBER_COMPLETED;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b%\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$Companion;", "", "()V", "CS_ADD_PAYMENT_METHOD_SCREEN_PRESENTED", "", "CS_ADD_PAYMENT_METHOD_VIA_CREATE_ATTACH_FAILED", "CS_ADD_PAYMENT_METHOD_VIA_CREATE_ATTACH_SUCCEEDED", "CS_ADD_PAYMENT_METHOD_VIA_SETUP_INTENT_CANCELED", "CS_ADD_PAYMENT_METHOD_VIA_SETUP_INTENT_FAILED", "CS_ADD_PAYMENT_METHOD_VIA_SETUP_INTENT_SUCCEEDED", "CS_CARD_NUMBER_COMPLETED", "CS_HIDE_EDITABLE_PAYMENT_OPTION", "CS_HIDE_PAYMENT_OPTION_BRANDS", "CS_INIT", "CS_PAYMENT_METHOD_SELECTED", "CS_SELECT_PAYMENT_METHOD_CONFIRMED_SAVED_PM_FAILED", "CS_SELECT_PAYMENT_METHOD_CONFIRMED_SAVED_PM_SUCCEEDED", "CS_SELECT_PAYMENT_METHOD_DONE_TAPPED", "CS_SELECT_PAYMENT_METHOD_EDIT_TAPPED", "CS_SELECT_PAYMENT_METHOD_REMOVE_PM_FAILED", "CS_SELECT_PAYMENT_METHOD_REMOVE_PM_SUCCEEDED", "CS_SELECT_PAYMENT_METHOD_SCREEN_PRESENTED", "CS_SHOW_EDITABLE_PAYMENT_OPTION", "CS_SHOW_PAYMENT_OPTION_BRANDS", "CS_UPDATE_PAYMENT_METHOD", "CS_UPDATE_PAYMENT_METHOD_FAILED", "FIELD_ALLOWS_REMOVAL_OF_LAST_SAVED_PAYMENT_METHOD", "FIELD_APPEARANCE", "FIELD_BILLING", "FIELD_BILLING_DETAILS_COLLECTION_CONFIGURATION", "FIELD_CBC_EVENT_SOURCE", "FIELD_CUSTOMER_SHEET_CONFIGURATION", "FIELD_ERROR_MESSAGE", "FIELD_GOOGLE_PAY_ENABLED", "FIELD_PAYMENT_METHOD_ORDER", "FIELD_PAYMENT_METHOD_TYPE", "FIELD_PREFERRED_NETWORKS", "FIELD_SELECTED_CARD_BRAND", "FIELD_SELECTED_LPM", "VALUE_ADD_CBC_EVENT_SOURCE", "VALUE_EDIT_CBC_EVENT_SOURCE", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ConfirmPaymentMethodFailed;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "type", "", "(Ljava/lang/String;)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ConfirmPaymentMethodFailed
    extends CustomerSheetEvent {
        @NotNull
        private final Map<String, Object> additionalParams;
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public ConfirmPaymentMethodFailed(@NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            super(null);
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)CustomerSheetEvent.FIELD_PAYMENT_METHOD_TYPE, (Object)type));
            this.eventName = CustomerSheetEvent.CS_SELECT_PAYMENT_METHOD_CONFIRMED_SAVED_PM_FAILED;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ConfirmPaymentMethodSucceeded;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "type", "", "(Ljava/lang/String;)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ConfirmPaymentMethodSucceeded
    extends CustomerSheetEvent {
        @NotNull
        private final Map<String, Object> additionalParams;
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public ConfirmPaymentMethodSucceeded(@NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            super(null);
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)CustomerSheetEvent.FIELD_PAYMENT_METHOD_TYPE, (Object)type));
            this.eventName = CustomerSheetEvent.CS_SELECT_PAYMENT_METHOD_CONFIRMED_SAVED_PM_SUCCEEDED;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$EditCompleted;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "()V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class EditCompleted
    extends CustomerSheetEvent {
        @NotNull
        private final Map<String, Object> additionalParams = MapsKt.emptyMap();
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public EditCompleted() {
            super(null);
            this.eventName = CustomerSheetEvent.CS_SELECT_PAYMENT_METHOD_DONE_TAPPED;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$EditTapped;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "()V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class EditTapped
    extends CustomerSheetEvent {
        @NotNull
        private final Map<String, Object> additionalParams = MapsKt.emptyMap();
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public EditTapped() {
            super(null);
            this.eventName = CustomerSheetEvent.CS_SELECT_PAYMENT_METHOD_EDIT_TAPPED;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$HidePaymentOptionBrands;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "source", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$HidePaymentOptionBrands$Source;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "(Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$HidePaymentOptionBrands$Source;Lcom/stripe/android/model/CardBrand;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "Source", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class HidePaymentOptionBrands
    extends CustomerSheetEvent {
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public HidePaymentOptionBrands(@NotNull Source source, @Nullable CardBrand selectedBrand) {
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            super(null);
            this.eventName = CustomerSheetEvent.CS_HIDE_PAYMENT_OPTION_BRANDS;
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)CustomerSheetEvent.FIELD_CBC_EVENT_SOURCE, (Object)source.getValue());
            CardBrand cardBrand = selectedBrand;
            pairArray[1] = TuplesKt.to((Object)CustomerSheetEvent.FIELD_SELECTED_CARD_BRAND, (Object)(cardBrand != null ? cardBrand.getCode() : null));
            this.additionalParams = MapsKt.mapOf((Pair[])pairArray);
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$HidePaymentOptionBrands$Source;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "Edit", "Add", "paymentsheet_release"})
        public static final class Source
        extends Enum<Source> {
            @NotNull
            private final String value;
            public static final /* enum */ Source Edit = new Source("edit");
            public static final /* enum */ Source Add = new Source("add");
            private static final /* synthetic */ Source[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Source(String value) {
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public static Source[] values() {
                return (Source[])$VALUES.clone();
            }

            public static Source valueOf(String value) {
                return Enum.valueOf(Source.class, value);
            }

            @NotNull
            public static EnumEntries<Source> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = sourceArray = new Source[]{Source.Edit, Source.Add};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$Init;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "configuration", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration;", "(Lcom/stripe/android/customersheet/CustomerSheet$Configuration;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Init
    extends CustomerSheetEvent {
        @NotNull
        private final CustomerSheet.Configuration configuration;
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public Init(@NotNull CustomerSheet.Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            super(null);
            this.configuration = configuration;
            this.eventName = CustomerSheetEvent.CS_INIT;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CustomerSheetEvent.FIELD_GOOGLE_PAY_ENABLED, (Object)this.configuration.getGooglePayEnabled()), TuplesKt.to((Object)CustomerSheetEvent.FIELD_BILLING, (Object)this.configuration.getDefaultBillingDetails().isFilledOut$paymentsheet_release()), TuplesKt.to((Object)CustomerSheetEvent.FIELD_APPEARANCE, AnalyticsKtxKt.toAnalyticsMap(this.configuration.getAppearance())), TuplesKt.to((Object)CustomerSheetEvent.FIELD_ALLOWS_REMOVAL_OF_LAST_SAVED_PAYMENT_METHOD, (Object)this.configuration.getAllowsRemovalOfLastSavedPaymentMethod$paymentsheet_release()), TuplesKt.to((Object)CustomerSheetEvent.FIELD_PAYMENT_METHOD_ORDER, this.configuration.getPaymentMethodOrder$paymentsheet_release()), TuplesKt.to((Object)CustomerSheetEvent.FIELD_BILLING_DETAILS_COLLECTION_CONFIGURATION, AnalyticsKtxKt.toAnalyticsMap(this.configuration.getBillingDetailsCollectionConfiguration())), TuplesKt.to((Object)CustomerSheetEvent.FIELD_PREFERRED_NETWORKS, (Object)AnalyticsKtxKt.toAnalyticsValue(this.configuration.getPreferredNetworks()))};
            Map configurationMap = MapsKt.mapOf((Pair[])pairArray);
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)CustomerSheetEvent.FIELD_CUSTOMER_SHEET_CONFIGURATION, (Object)configurationMap));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$RemovePaymentMethodFailed;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "()V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class RemovePaymentMethodFailed
    extends CustomerSheetEvent {
        @NotNull
        private final Map<String, Object> additionalParams = MapsKt.emptyMap();
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public RemovePaymentMethodFailed() {
            super(null);
            this.eventName = CustomerSheetEvent.CS_SELECT_PAYMENT_METHOD_REMOVE_PM_FAILED;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$RemovePaymentMethodSucceeded;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "()V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class RemovePaymentMethodSucceeded
    extends CustomerSheetEvent {
        @NotNull
        private final Map<String, Object> additionalParams = MapsKt.emptyMap();
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public RemovePaymentMethodSucceeded() {
            super(null);
            this.eventName = CustomerSheetEvent.CS_SELECT_PAYMENT_METHOD_REMOVE_PM_SUCCEEDED;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ScreenHidden;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "screen", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEventReporter$Screen;", "(Lcom/stripe/android/customersheet/analytics/CustomerSheetEventReporter$Screen;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ScreenHidden
    extends CustomerSheetEvent {
        @NotNull
        private final Map<String, Object> additionalParams;
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public ScreenHidden(@NotNull CustomerSheetEventReporter.Screen screen) {
            Intrinsics.checkNotNullParameter((Object)((Object)screen), (String)"screen");
            super(null);
            this.additionalParams = MapsKt.emptyMap();
            if (WhenMappings.$EnumSwitchMapping$0[screen.ordinal()] != 1) {
                throw new IllegalArgumentException(screen.name() + " has no supported event for hiding screen!");
            }
            this.eventName = CustomerSheetEvent.CS_HIDE_EDITABLE_PAYMENT_OPTION;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CustomerSheetEventReporter.Screen.values().length];
                try {
                    nArray[CustomerSheetEventReporter.Screen.EditPaymentMethod.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ScreenPresented;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "screen", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEventReporter$Screen;", "(Lcom/stripe/android/customersheet/analytics/CustomerSheetEventReporter$Screen;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ScreenPresented
    extends CustomerSheetEvent {
        @NotNull
        private final Map<String, Object> additionalParams;
        @NotNull
        private final String eventName;
        public static final int $stable = 8;

        public ScreenPresented(@NotNull CustomerSheetEventReporter.Screen screen) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)((Object)screen), (String)"screen");
            super(null);
            this.additionalParams = MapsKt.emptyMap();
            switch (WhenMappings.$EnumSwitchMapping$0[screen.ordinal()]) {
                case 1: {
                    string2 = CustomerSheetEvent.CS_ADD_PAYMENT_METHOD_SCREEN_PRESENTED;
                    break;
                }
                case 2: {
                    string2 = CustomerSheetEvent.CS_SELECT_PAYMENT_METHOD_SCREEN_PRESENTED;
                    break;
                }
                case 3: {
                    string2 = CustomerSheetEvent.CS_SHOW_EDITABLE_PAYMENT_OPTION;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.eventName = string2;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CustomerSheetEventReporter.Screen.values().length];
                try {
                    nArray[CustomerSheetEventReporter.Screen.AddPaymentMethod.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CustomerSheetEventReporter.Screen.SelectPaymentMethod.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CustomerSheetEventReporter.Screen.EditPaymentMethod.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$SelectPaymentMethod;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "code", "", "(Ljava/lang/String;)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class SelectPaymentMethod
    extends CustomerSheetEvent {
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public SelectPaymentMethod(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            super(null);
            this.eventName = CustomerSheetEvent.CS_PAYMENT_METHOD_SELECTED;
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)CustomerSheetEvent.FIELD_SELECTED_LPM, (Object)code));
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ShowPaymentOptionBrands;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "source", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ShowPaymentOptionBrands$Source;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "(Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ShowPaymentOptionBrands$Source;Lcom/stripe/android/model/CardBrand;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "Source", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowPaymentOptionBrands
    extends CustomerSheetEvent {
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowPaymentOptionBrands(@NotNull Source source, @NotNull CardBrand selectedBrand) {
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)selectedBrand, (String)"selectedBrand");
            super(null);
            this.eventName = CustomerSheetEvent.CS_SHOW_PAYMENT_OPTION_BRANDS;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CustomerSheetEvent.FIELD_CBC_EVENT_SOURCE, (Object)source.getValue()), TuplesKt.to((Object)CustomerSheetEvent.FIELD_SELECTED_CARD_BRAND, (Object)selectedBrand.getCode())};
            this.additionalParams = MapsKt.mapOf((Pair[])pairArray);
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$ShowPaymentOptionBrands$Source;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "Edit", "Add", "paymentsheet_release"})
        public static final class Source
        extends Enum<Source> {
            @NotNull
            private final String value;
            public static final /* enum */ Source Edit = new Source("edit");
            public static final /* enum */ Source Add = new Source("add");
            private static final /* synthetic */ Source[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Source(String value) {
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public static Source[] values() {
                return (Source[])$VALUES.clone();
            }

            public static Source valueOf(String value) {
                return Enum.valueOf(Source.class, value);
            }

            @NotNull
            public static EnumEntries<Source> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = sourceArray = new Source[]{Source.Edit, Source.Add};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$UpdatePaymentOptionFailed;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "error", "", "(Lcom/stripe/android/model/CardBrand;Ljava/lang/Throwable;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class UpdatePaymentOptionFailed
    extends CustomerSheetEvent {
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public UpdatePaymentOptionFailed(@NotNull CardBrand selectedBrand, @NotNull Throwable error2) {
            Intrinsics.checkNotNullParameter((Object)selectedBrand, (String)"selectedBrand");
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            super(null);
            this.eventName = CustomerSheetEvent.CS_UPDATE_PAYMENT_METHOD_FAILED;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CustomerSheetEvent.FIELD_SELECTED_CARD_BRAND, (Object)selectedBrand.getCode()), TuplesKt.to((Object)CustomerSheetEvent.FIELD_ERROR_MESSAGE, (Object)error2.getMessage())};
            this.additionalParams = MapsKt.mapOf((Pair[])pairArray);
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent$UpdatePaymentOptionSucceeded;", "Lcom/stripe/android/customersheet/analytics/CustomerSheetEvent;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "(Lcom/stripe/android/model/CardBrand;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class UpdatePaymentOptionSucceeded
    extends CustomerSheetEvent {
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public UpdatePaymentOptionSucceeded(@NotNull CardBrand selectedBrand) {
            Intrinsics.checkNotNullParameter((Object)selectedBrand, (String)"selectedBrand");
            super(null);
            this.eventName = CustomerSheetEvent.CS_UPDATE_PAYMENT_METHOD;
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)CustomerSheetEvent.FIELD_SELECTED_CARD_BRAND, (Object)selectedBrand.getCode()));
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        public Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }
}

