/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.lpmfoundations.paymentmethod;

import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement;", "", "(Ljava/lang/String;I)V", "isMetBy", "", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "Unsupported", "UnsupportedForSetup", "ShippingAddress", "MerchantSupportsDelayedPaymentMethods", "FinancialConnectionsSdk", "ValidUsBankVerificationMethod", "InstantDebits", "paymentsheet_release"})
public abstract class AddPaymentMethodRequirement
extends Enum<AddPaymentMethodRequirement> {
    public static final /* enum */ AddPaymentMethodRequirement Unsupported = new Unsupported("Unsupported", 0);
    public static final /* enum */ AddPaymentMethodRequirement UnsupportedForSetup = new UnsupportedForSetup("UnsupportedForSetup", 1);
    public static final /* enum */ AddPaymentMethodRequirement ShippingAddress = new ShippingAddress("ShippingAddress", 2);
    public static final /* enum */ AddPaymentMethodRequirement MerchantSupportsDelayedPaymentMethods = new MerchantSupportsDelayedPaymentMethods("MerchantSupportsDelayedPaymentMethods", 3);
    public static final /* enum */ AddPaymentMethodRequirement FinancialConnectionsSdk = new FinancialConnectionsSdk("FinancialConnectionsSdk", 4);
    public static final /* enum */ AddPaymentMethodRequirement ValidUsBankVerificationMethod = new ValidUsBankVerificationMethod("ValidUsBankVerificationMethod", 5);
    public static final /* enum */ AddPaymentMethodRequirement InstantDebits = new InstantDebits("InstantDebits", 6);
    private static final /* synthetic */ AddPaymentMethodRequirement[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private AddPaymentMethodRequirement() {
    }

    public abstract boolean isMetBy(@NotNull PaymentMethodMetadata var1);

    public static AddPaymentMethodRequirement[] values() {
        return (AddPaymentMethodRequirement[])$VALUES.clone();
    }

    public static AddPaymentMethodRequirement valueOf(String value) {
        return Enum.valueOf(AddPaymentMethodRequirement.class, value);
    }

    @NotNull
    public static EnumEntries<AddPaymentMethodRequirement> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ AddPaymentMethodRequirement(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        $VALUES = addPaymentMethodRequirementArray = new AddPaymentMethodRequirement[]{AddPaymentMethodRequirement.Unsupported, AddPaymentMethodRequirement.UnsupportedForSetup, AddPaymentMethodRequirement.ShippingAddress, AddPaymentMethodRequirement.MerchantSupportsDelayedPaymentMethods, AddPaymentMethodRequirement.FinancialConnectionsSdk, AddPaymentMethodRequirement.ValidUsBankVerificationMethod, AddPaymentMethodRequirement.InstantDebits};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement$FinancialConnectionsSdk;", "Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement;", "isMetBy", "", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
    static final class FinancialConnectionsSdk
    extends AddPaymentMethodRequirement {
        /*
         * WARNING - void declaration
         */
        FinancialConnectionsSdk() {
            void var1_1;
        }

        @Override
        public boolean isMetBy(@NotNull PaymentMethodMetadata metadata2) {
            Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
            return metadata2.getFinancialConnectionsAvailable();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement$InstantDebits;", "Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement;", "isMetBy", "", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
    static final class InstantDebits
    extends AddPaymentMethodRequirement {
        /*
         * WARNING - void declaration
         */
        InstantDebits() {
            void var1_1;
        }

        @Override
        public boolean isMetBy(@NotNull PaymentMethodMetadata metadata2) {
            Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
            List paymentMethodTypes = metadata2.getStripeIntent().getPaymentMethodTypes();
            boolean noUsBankAccount = !paymentMethodTypes.contains(PaymentMethod.Type.USBankAccount.code);
            boolean supportsBankAccounts = metadata2.getStripeIntent().getLinkFundingSources().contains("bank_account");
            boolean isDeferred = metadata2.getStripeIntent().getClientSecret() == null;
            return noUsBankAccount && supportsBankAccounts && !isDeferred;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement$MerchantSupportsDelayedPaymentMethods;", "Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement;", "isMetBy", "", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
    static final class MerchantSupportsDelayedPaymentMethods
    extends AddPaymentMethodRequirement {
        /*
         * WARNING - void declaration
         */
        MerchantSupportsDelayedPaymentMethods() {
            void var1_1;
        }

        @Override
        public boolean isMetBy(@NotNull PaymentMethodMetadata metadata2) {
            Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
            return metadata2.getAllowsDelayedPaymentMethods();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement$ShippingAddress;", "Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement;", "isMetBy", "", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
    static final class ShippingAddress
    extends AddPaymentMethodRequirement {
        /*
         * WARNING - void declaration
         */
        ShippingAddress() {
            void var1_1;
        }

        @Override
        public boolean isMetBy(@NotNull PaymentMethodMetadata metadata2) {
            PaymentIntent.Shipping shipping;
            Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
            if (metadata2.getAllowsPaymentMethodsRequiringShippingAddress()) {
                return true;
            }
            StripeIntent stripeIntent = metadata2.getStripeIntent();
            PaymentIntent paymentIntent = stripeIntent instanceof PaymentIntent ? (PaymentIntent)stripeIntent : null;
            PaymentIntent.Shipping shipping2 = shipping = paymentIntent != null ? paymentIntent.getShipping() : null;
            return (shipping2 != null ? shipping2.getName() : null) != null && shipping.getAddress().getLine1() != null && shipping.getAddress().getCountry() != null && shipping.getAddress().getPostalCode() != null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement$Unsupported;", "Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement;", "isMetBy", "", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
    static final class Unsupported
    extends AddPaymentMethodRequirement {
        /*
         * WARNING - void declaration
         */
        Unsupported() {
            void var1_1;
        }

        @Override
        public boolean isMetBy(@NotNull PaymentMethodMetadata metadata2) {
            Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement$UnsupportedForSetup;", "Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement;", "isMetBy", "", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
    static final class UnsupportedForSetup
    extends AddPaymentMethodRequirement {
        /*
         * WARNING - void declaration
         */
        UnsupportedForSetup() {
            void var1_1;
        }

        @Override
        public boolean isMetBy(@NotNull PaymentMethodMetadata metadata2) {
            Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
            return !metadata2.hasIntentToSetup();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement$ValidUsBankVerificationMethod;", "Lcom/stripe/android/lpmfoundations/paymentmethod/AddPaymentMethodRequirement;", "isMetBy", "", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
    static final class ValidUsBankVerificationMethod
    extends AddPaymentMethodRequirement {
        /*
         * WARNING - void declaration
         */
        ValidUsBankVerificationMethod() {
            void var1_1;
        }

        @Override
        public boolean isMetBy(@NotNull PaymentMethodMetadata metadata2) {
            Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
            Object pmo = metadata2.getStripeIntent().getPaymentMethodOptions().get(PaymentMethod.Type.USBankAccount.code);
            Map map2 = pmo instanceof Map ? (Map)pmo : null;
            Object v = map2 != null ? map2.get("verification_method") : null;
            String verificationMethod = v instanceof String ? (String)v : null;
            Object[] objectArray = new String[]{"instant", "automatic"};
            boolean supportsVerificationMethod = CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)verificationMethod);
            boolean isDeferred = metadata2.getStripeIntent().getClientSecret() == null;
            return supportsVerificationMethod || isDeferred;
        }
    }
}

