/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.content.res.Resources;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.R;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.R;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0006\u0010\u001a\u001a\u00020\u0007J\t\u0010\u001b\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;", "", "displayName", "Lcom/stripe/android/core/strings/ResolvableString;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "isCbcEligible", "", "(Lcom/stripe/android/core/strings/ResolvableString;Lcom/stripe/android/model/PaymentMethod;Z)V", "getDisplayName", "()Lcom/stripe/android/core/strings/ResolvableString;", "()Z", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "component1", "component2", "component3", "copy", "equals", "other", "getDescription", "", "resources", "Landroid/content/res/Resources;", "hashCode", "", "isModifiable", "toString", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class DisplayableSavedPaymentMethod {
    @NotNull
    private final ResolvableString displayName;
    @NotNull
    private final PaymentMethod paymentMethod;
    private final boolean isCbcEligible;
    public static final int $stable = 8;

    public DisplayableSavedPaymentMethod(@NotNull ResolvableString displayName, @NotNull PaymentMethod paymentMethod, boolean isCbcEligible) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        this.displayName = displayName;
        this.paymentMethod = paymentMethod;
        this.isCbcEligible = isCbcEligible;
    }

    public /* synthetic */ DisplayableSavedPaymentMethod(ResolvableString resolvableString, PaymentMethod paymentMethod, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(resolvableString, paymentMethod, bl);
    }

    @NotNull
    public final ResolvableString getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public final boolean isCbcEligible() {
        return this.isCbcEligible;
    }

    public final boolean isModifiable() {
        boolean bl;
        Object object = this.paymentMethod.card;
        if (object != null && (object = ((PaymentMethod.Card)object).networks) != null && (object = object.getAvailable()) != null) {
            Object available = object;
            boolean bl2 = false;
            bl = available.size() > 1;
        } else {
            bl = false;
        }
        boolean hasMultipleNetworks = bl;
        return this.isCbcEligible && hasMultipleNetworks;
    }

    @NotNull
    public final String getDescription(@NotNull Resources resources) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        PaymentMethod.Type type = this.paymentMethod.type;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Object[] objectArray = new Object[2];
                PaymentMethod.Card card = this.paymentMethod.card;
                objectArray[0] = card != null ? card.brand : null;
                PaymentMethod.Card card2 = this.paymentMethod.card;
                objectArray[1] = card2 != null ? card2.last4 : null;
                string2 = resources.getString(R.string.stripe_card_ending_in, objectArray);
                break;
            }
            case 2: {
                Object[] objectArray = new Object[1];
                PaymentMethod.SepaDebit sepaDebit = this.paymentMethod.sepaDebit;
                objectArray[0] = sepaDebit != null ? sepaDebit.last4 : null;
                string2 = resources.getString(R.string.stripe_bank_account_ending_in, objectArray);
                break;
            }
            case 3: {
                Object[] objectArray = new Object[1];
                PaymentMethod.USBankAccount uSBankAccount = this.paymentMethod.usBankAccount;
                objectArray[0] = uSBankAccount != null ? uSBankAccount.last4 : null;
                string2 = resources.getString(R.string.stripe_bank_account_ending_in, objectArray);
                break;
            }
            default: {
                string2 = "";
            }
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        return string3;
    }

    @NotNull
    public final ResolvableString component1() {
        return this.displayName;
    }

    @NotNull
    public final PaymentMethod component2() {
        return this.paymentMethod;
    }

    public final boolean component3() {
        return this.isCbcEligible;
    }

    @NotNull
    public final DisplayableSavedPaymentMethod copy(@NotNull ResolvableString displayName, @NotNull PaymentMethod paymentMethod, boolean isCbcEligible) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        return new DisplayableSavedPaymentMethod(displayName, paymentMethod, isCbcEligible);
    }

    public static /* synthetic */ DisplayableSavedPaymentMethod copy$default(DisplayableSavedPaymentMethod displayableSavedPaymentMethod, ResolvableString resolvableString, PaymentMethod paymentMethod, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            resolvableString = displayableSavedPaymentMethod.displayName;
        }
        if ((n & 2) != 0) {
            paymentMethod = displayableSavedPaymentMethod.paymentMethod;
        }
        if ((n & 4) != 0) {
            bl = displayableSavedPaymentMethod.isCbcEligible;
        }
        return displayableSavedPaymentMethod.copy(resolvableString, paymentMethod, bl);
    }

    @NotNull
    public String toString() {
        return "DisplayableSavedPaymentMethod(displayName=" + this.displayName + ", paymentMethod=" + this.paymentMethod + ", isCbcEligible=" + this.isCbcEligible + ")";
    }

    public int hashCode() {
        int result2 = this.displayName.hashCode();
        result2 = result2 * 31 + this.paymentMethod.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isCbcEligible);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DisplayableSavedPaymentMethod)) {
            return false;
        }
        DisplayableSavedPaymentMethod displayableSavedPaymentMethod = (DisplayableSavedPaymentMethod)other;
        if (!Intrinsics.areEqual((Object)this.displayName, (Object)displayableSavedPaymentMethod.displayName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)displayableSavedPaymentMethod.paymentMethod)) {
            return false;
        }
        return this.isCbcEligible == displayableSavedPaymentMethod.isCbcEligible;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentMethod.Type.values().length];
            try {
                nArray[PaymentMethod.Type.Card.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.SepaDebit.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.USBankAccount.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

