/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.app.Application;
import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.cards.DefaultCardAccountRangeRepositoryFactory;
import com.stripe.android.link.LinkConfigurationCoordinator;
import com.stripe.android.link.ui.inline.InlineSignupViewState;
import com.stripe.android.lpmfoundations.luxe.SupportedPaymentMethod;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.lpmfoundations.paymentmethod.UiDefinitionFactory;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.PaymentMethodExtraParams;
import com.stripe.android.paymentsheet.LinkInlineHandler;
import com.stripe.android.paymentsheet.NewOrExternalPaymentSelection;
import com.stripe.android.paymentsheet.forms.FormArgumentsFactory;
import com.stripe.android.paymentsheet.forms.FormFieldValues;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.paymentdatacollection.FormArguments;
import com.stripe.android.paymentsheet.ui.AddPaymentMethodKt;
import com.stripe.android.paymentsheet.viewmodels.BaseSheetViewModel;
import com.stripe.android.uicore.elements.FormElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0017J\u0018\u0010\u001d\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0017J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/stripe/android/paymentsheet/FormHelper;", "", "context", "Landroid/content/Context;", "paymentMethodMetadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "newPaymentSelectionProvider", "Lkotlin/Function0;", "Lcom/stripe/android/paymentsheet/NewOrExternalPaymentSelection;", "selectionUpdater", "Lkotlin/Function1;", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "", "linkConfigurationCoordinator", "Lcom/stripe/android/link/LinkConfigurationCoordinator;", "onLinkInlineSignupStateChanged", "Lcom/stripe/android/link/ui/inline/InlineSignupViewState;", "(Landroid/content/Context;Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lcom/stripe/android/link/LinkConfigurationCoordinator;Lkotlin/jvm/functions/Function1;)V", "cardAccountRangeRepositoryFactory", "Lcom/stripe/android/cards/DefaultCardAccountRangeRepositoryFactory;", "createFormArguments", "Lcom/stripe/android/paymentsheet/paymentdatacollection/FormArguments;", "paymentMethodCode", "", "Lcom/stripe/android/model/PaymentMethodCode;", "formElementsForCode", "", "Lcom/stripe/android/uicore/elements/FormElement;", "code", "onFormFieldValuesChanged", "formValues", "Lcom/stripe/android/paymentsheet/forms/FormFieldValues;", "selectedPaymentMethodCode", "supportedPaymentMethodForCode", "Lcom/stripe/android/lpmfoundations/luxe/SupportedPaymentMethod;", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFormHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormHelper.kt\ncom/stripe/android/paymentsheet/FormHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class FormHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final PaymentMethodMetadata paymentMethodMetadata;
    @NotNull
    private final Function0<NewOrExternalPaymentSelection> newPaymentSelectionProvider;
    @NotNull
    private final Function1<PaymentSelection, Unit> selectionUpdater;
    @NotNull
    private final LinkConfigurationCoordinator linkConfigurationCoordinator;
    @NotNull
    private final Function1<InlineSignupViewState, Unit> onLinkInlineSignupStateChanged;
    @NotNull
    private final DefaultCardAccountRangeRepositoryFactory cardAccountRangeRepositoryFactory;
    public static final int $stable = 8;

    public FormHelper(@NotNull Context context, @NotNull PaymentMethodMetadata paymentMethodMetadata, @NotNull Function0<? extends NewOrExternalPaymentSelection> newPaymentSelectionProvider, @NotNull Function1<? super PaymentSelection, Unit> selectionUpdater, @NotNull LinkConfigurationCoordinator linkConfigurationCoordinator, @NotNull Function1<? super InlineSignupViewState, Unit> onLinkInlineSignupStateChanged) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)paymentMethodMetadata, (String)"paymentMethodMetadata");
        Intrinsics.checkNotNullParameter(newPaymentSelectionProvider, (String)"newPaymentSelectionProvider");
        Intrinsics.checkNotNullParameter(selectionUpdater, (String)"selectionUpdater");
        Intrinsics.checkNotNullParameter((Object)linkConfigurationCoordinator, (String)"linkConfigurationCoordinator");
        Intrinsics.checkNotNullParameter(onLinkInlineSignupStateChanged, (String)"onLinkInlineSignupStateChanged");
        this.context = context;
        this.paymentMethodMetadata = paymentMethodMetadata;
        this.newPaymentSelectionProvider = newPaymentSelectionProvider;
        this.selectionUpdater = selectionUpdater;
        this.linkConfigurationCoordinator = linkConfigurationCoordinator;
        this.onLinkInlineSignupStateChanged = onLinkInlineSignupStateChanged;
        this.cardAccountRangeRepositoryFactory = new DefaultCardAccountRangeRepositoryFactory(this.context);
    }

    @NotNull
    public final List<FormElement> formElementsForCode(@NotNull String code) {
        NewOrExternalPaymentSelection newOrExternalPaymentSelection;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        NewOrExternalPaymentSelection newOrExternalPaymentSelection2 = (NewOrExternalPaymentSelection)this.newPaymentSelectionProvider.invoke();
        if (newOrExternalPaymentSelection2 != null) {
            NewOrExternalPaymentSelection newOrExternalPaymentSelection3;
            NewOrExternalPaymentSelection it = newOrExternalPaymentSelection3 = newOrExternalPaymentSelection2;
            boolean bl = false;
            newOrExternalPaymentSelection = Intrinsics.areEqual((Object)it.getType(), (Object)code) ? newOrExternalPaymentSelection3 : null;
        } else {
            newOrExternalPaymentSelection = null;
        }
        NewOrExternalPaymentSelection currentSelection = newOrExternalPaymentSelection;
        NewOrExternalPaymentSelection newOrExternalPaymentSelection4 = currentSelection;
        NewOrExternalPaymentSelection newOrExternalPaymentSelection5 = currentSelection;
        List list = this.paymentMethodMetadata.formElementsForCode(code, new UiDefinitionFactory.Arguments.Factory.Default((CardAccountRangeRepository.Factory)this.cardAccountRangeRepositoryFactory, this.linkConfigurationCoordinator, this.onLinkInlineSignupStateChanged, (PaymentMethodCreateParams)(newOrExternalPaymentSelection4 != null ? newOrExternalPaymentSelection4.getPaymentMethodCreateParams() : null), (PaymentMethodExtraParams)(newOrExternalPaymentSelection5 != null ? newOrExternalPaymentSelection5.getPaymentMethodExtraParams() : null)));
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final FormArguments createFormArguments(@NotNull String paymentMethodCode) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodCode, (String)"paymentMethodCode");
        return FormArgumentsFactory.INSTANCE.create(paymentMethodCode, this.paymentMethodMetadata);
    }

    public final void onFormFieldValuesChanged(@Nullable FormFieldValues formValues2, @NotNull String selectedPaymentMethodCode) {
        Intrinsics.checkNotNullParameter((Object)selectedPaymentMethodCode, (String)"selectedPaymentMethodCode");
        FormFieldValues formFieldValues = formValues2;
        PaymentSelection newSelection = formFieldValues != null ? AddPaymentMethodKt.transformToPaymentSelection(formFieldValues, this.supportedPaymentMethodForCode(selectedPaymentMethodCode), this.paymentMethodMetadata) : null;
        this.selectionUpdater.invoke((Object)newSelection);
    }

    private final SupportedPaymentMethod supportedPaymentMethodForCode(String code) {
        SupportedPaymentMethod supportedPaymentMethod = this.paymentMethodMetadata.supportedPaymentMethodForCode(code);
        if (supportedPaymentMethod == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return supportedPaymentMethod;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/paymentsheet/FormHelper$Companion;", "", "()V", "create", "Lcom/stripe/android/paymentsheet/FormHelper;", "viewModel", "Lcom/stripe/android/paymentsheet/viewmodels/BaseSheetViewModel;", "linkInlineHandler", "Lcom/stripe/android/paymentsheet/LinkInlineHandler;", "paymentMethodMetadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FormHelper create(@NotNull BaseSheetViewModel viewModel2, @NotNull LinkInlineHandler linkInlineHandler, @NotNull PaymentMethodMetadata paymentMethodMetadata) {
            Intrinsics.checkNotNullParameter((Object)((Object)viewModel2), (String)"viewModel");
            Intrinsics.checkNotNullParameter((Object)linkInlineHandler, (String)"linkInlineHandler");
            Intrinsics.checkNotNullParameter((Object)paymentMethodMetadata, (String)"paymentMethodMetadata");
            Application application = viewModel2.getApplication();
            LinkConfigurationCoordinator linkConfigurationCoordinator = viewModel2.getLinkConfigurationCoordinator();
            KFunction kFunction = (KFunction)new Function1<InlineSignupViewState, Unit>((Object)linkInlineHandler){

                public final void invoke(@NotNull InlineSignupViewState p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((LinkInlineHandler)this.receiver).onStateUpdated(p0);
                }
            };
            return new FormHelper((Context)application, paymentMethodMetadata, (Function0<? extends NewOrExternalPaymentSelection>)((Function0)new Function0<NewOrExternalPaymentSelection>(viewModel2){
                final /* synthetic */ BaseSheetViewModel $viewModel;
                {
                    this.$viewModel = $viewModel;
                    super(0);
                }

                @Nullable
                public final NewOrExternalPaymentSelection invoke() {
                    return this.$viewModel.getNewPaymentSelection();
                }
            }), (Function1<? super PaymentSelection, Unit>)((Function1)new Function1<PaymentSelection, Unit>(viewModel2){
                final /* synthetic */ BaseSheetViewModel $viewModel;
                {
                    this.$viewModel = $viewModel;
                    super(1);
                }

                public final void invoke(@Nullable PaymentSelection it) {
                    this.$viewModel.updateSelection(it);
                }
            }), linkConfigurationCoordinator, (Function1<? super InlineSignupViewState, Unit>)((Function1)kFunction));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

