/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.PaymentMethodOptionsParams;
import com.stripe.android.paymentsheet.IntentConfirmationInterceptor;
import com.stripe.android.paymentsheet.PaymentConfirmationOption;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import com.stripe.android.paymentsheet.addresselement.AddressDetailsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0080@\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"intercept", "Lcom/stripe/android/paymentsheet/IntentConfirmationInterceptor$NextStep;", "Lcom/stripe/android/paymentsheet/IntentConfirmationInterceptor;", "confirmationOption", "Lcom/stripe/android/paymentsheet/PaymentConfirmationOption$PaymentMethod;", "(Lcom/stripe/android/paymentsheet/IntentConfirmationInterceptor;Lcom/stripe/android/paymentsheet/PaymentConfirmationOption$PaymentMethod;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "paymentsheet_release"})
public final class IntentConfirmationInterceptorKtxKt {
    @Nullable
    public static final Object intercept(@NotNull IntentConfirmationInterceptor $this$intercept, @Nullable PaymentConfirmationOption.PaymentMethod confirmationOption, @NotNull Continuation<? super IntentConfirmationInterceptor.NextStep> $completion) {
        PaymentConfirmationOption.PaymentMethod paymentMethod = confirmationOption;
        if (paymentMethod instanceof PaymentConfirmationOption.PaymentMethod.New) {
            PaymentSheet.InitializationMode initializationMode = ((PaymentConfirmationOption.PaymentMethod.New)confirmationOption).getInitializationMode();
            PaymentMethodOptionsParams paymentMethodOptionsParams = ((PaymentConfirmationOption.PaymentMethod.New)confirmationOption).getOptionsParams();
            PaymentMethodCreateParams paymentMethodCreateParams = ((PaymentConfirmationOption.PaymentMethod.New)confirmationOption).getCreateParams();
            AddressDetails addressDetails = ((PaymentConfirmationOption.PaymentMethod.New)confirmationOption).getShippingDetails();
            ConfirmPaymentIntentParams.Shipping shipping = addressDetails != null ? AddressDetailsKt.toConfirmPaymentIntentShipping(addressDetails) : null;
            boolean bl = ((PaymentConfirmationOption.PaymentMethod.New)confirmationOption).getShouldSave();
            return $this$intercept.intercept(initializationMode, paymentMethodCreateParams, paymentMethodOptionsParams, shipping, bl, $completion);
        }
        if (paymentMethod instanceof PaymentConfirmationOption.PaymentMethod.Saved) {
            AddressDetails addressDetails = ((PaymentConfirmationOption.PaymentMethod.Saved)confirmationOption).getShippingDetails();
            return $this$intercept.intercept(((PaymentConfirmationOption.PaymentMethod.Saved)confirmationOption).getInitializationMode(), ((PaymentConfirmationOption.PaymentMethod.Saved)confirmationOption).getPaymentMethod(), ((PaymentConfirmationOption.PaymentMethod.Saved)confirmationOption).getOptionsParams(), (ConfirmPaymentIntentParams.Shipping)(addressDetails != null ? AddressDetailsKt.toConfirmPaymentIntentShipping(addressDetails) : null), $completion);
        }
        if (paymentMethod != null) {
            throw new NoWhenBranchMatchedException();
        }
        return new IntentConfirmationInterceptor.NextStep.Fail(new IllegalStateException("Nothing selected."), ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_something_went_wrong, (Object[])new Object[0], null, (int)4, null));
    }
}

