/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import androidx.compose.material.Colors;
import androidx.compose.material.ColorsKt;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.VolatilePaymentSheetConfiguration;
import com.stripe.android.uicore.PrimaryButtonColors;
import com.stripe.android.uicore.PrimaryButtonShape;
import com.stripe.android.uicore.PrimaryButtonStyle;
import com.stripe.android.uicore.PrimaryButtonTypography;
import com.stripe.android.uicore.StripeColors;
import com.stripe.android.uicore.StripeShapes;
import com.stripe.android.uicore.StripeTheme;
import com.stripe.android.uicore.StripeThemeDefaults;
import com.stripe.android.uicore.StripeTypography;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0005H\u0002\u001a\f\u0010\n\u001a\u00020\f*\u00020\rH\u0002\u001a\f\u0010\u000e\u001a\u00020\b*\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"CUSTOMER_SESSION_CLIENT_SECRET_KEY_PREFIX", "", "EPHEMERAL_KEY_SECRET_PREFIX", "containsVolatileDifferences", "", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "other", "parseAppearance", "", "Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "toVolatileConfiguration", "Lcom/stripe/android/paymentsheet/VolatilePaymentSheetConfiguration;", "Lcom/stripe/android/paymentsheet/VolatilePaymentSheetConfiguration$GooglePayConfiguration;", "Lcom/stripe/android/paymentsheet/PaymentSheet$GooglePayConfiguration;", "validate", "paymentsheet_release"})
@SourceDebugExtension(value={"SMAP\nPaymentSheetConfigurationKtx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentSheetConfigurationKtx.kt\ncom/stripe/android/paymentsheet/PaymentSheetConfigurationKtxKt\n+ 2 TextUnit.kt\nandroidx/compose/ui/unit/TextUnit\n*L\n1#1,200:1\n146#2,2:201\n*S KotlinDebug\n*F\n+ 1 PaymentSheetConfigurationKtx.kt\ncom/stripe/android/paymentsheet/PaymentSheetConfigurationKtxKt\n*L\n142#1:201,2\n*E\n"})
public final class PaymentSheetConfigurationKtxKt {
    @NotNull
    private static final String EPHEMERAL_KEY_SECRET_PREFIX = "ek_";
    @NotNull
    private static final String CUSTOMER_SESSION_CLIENT_SECRET_KEY_PREFIX = "cuss_";

    public static final void validate(@NotNull PaymentSheet.Configuration $this$validate) {
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        if (StringsKt.isBlank((CharSequence)$this$validate.getMerchantDisplayName())) {
            throw new IllegalArgumentException("When a Configuration is passed to PaymentSheet, the Merchant display name cannot be an empty string.");
        }
        Object object = $this$validate.getCustomer();
        boolean bl = object != null && (object = ((PaymentSheet.CustomerConfiguration)object).getId()) != null ? StringsKt.isBlank((CharSequence)((CharSequence)object)) : false;
        if (bl) {
            throw new IllegalArgumentException("When a CustomerConfiguration is passed to PaymentSheet, the Customer ID cannot be an empty string.");
        }
        Object object2 = $this$validate.getCustomer();
        if (object2 != null && (object2 = object2.getAccessType$paymentsheet_release()) != null) {
            Object customerAccessType = object2;
            boolean bl2 = false;
            Object object3 = customerAccessType;
            if (object3 instanceof PaymentSheet.CustomerAccessType.LegacyCustomerEphemeralKey) {
                if (StringsKt.isBlank((CharSequence)((PaymentSheet.CustomerAccessType.LegacyCustomerEphemeralKey)customerAccessType).getEphemeralKeySecret()) || StringsKt.isBlank((CharSequence)$this$validate.getCustomer().getEphemeralKeySecret())) {
                    throw new IllegalArgumentException("When a CustomerConfiguration is passed to PaymentSheet, the ephemeralKeySecret cannot be an empty string.");
                }
            } else if (object3 instanceof PaymentSheet.CustomerAccessType.CustomerSession) {
                String customerSessionClientSecret = ((PaymentSheet.CustomerAccessType.CustomerSession)customerAccessType).getCustomerSessionClientSecret();
                if (StringsKt.isBlank((CharSequence)customerSessionClientSecret)) {
                    throw new IllegalArgumentException("When a CustomerConfiguration is passed to PaymentSheet, the customerSessionClientSecret cannot be an empty string.");
                }
                if (StringsKt.startsWith$default((String)customerSessionClientSecret, (String)EPHEMERAL_KEY_SECRET_PREFIX, (boolean)false, (int)2, null)) {
                    throw new IllegalArgumentException("Argument looks like an Ephemeral Key secret, but expecting a CustomerSession client secret. See CustomerSession API: https://docs.stripe.com/api/customer_sessions/create");
                }
                if (!StringsKt.startsWith$default((String)customerSessionClientSecret, (String)CUSTOMER_SESSION_CLIENT_SECRET_KEY_PREFIX, (boolean)false, (int)2, null)) {
                    throw new IllegalArgumentException("Argument does not look like a CustomerSession client secret. See CustomerSession API: https://docs.stripe.com/api/customer_sessions/create");
                }
            }
        }
    }

    public static final boolean containsVolatileDifferences(@NotNull PaymentSheet.Configuration $this$containsVolatileDifferences, @NotNull PaymentSheet.Configuration other) {
        Intrinsics.checkNotNullParameter((Object)$this$containsVolatileDifferences, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return !Intrinsics.areEqual((Object)PaymentSheetConfigurationKtxKt.toVolatileConfiguration($this$containsVolatileDifferences), (Object)PaymentSheetConfigurationKtxKt.toVolatileConfiguration(other));
    }

    /*
     * WARNING - void declaration
     */
    public static final void parseAppearance(@NotNull PaymentSheet.Appearance $this$parseAppearance) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$parseAppearance, (String)"<this>");
        long l2 = ColorKt.Color((int)$this$parseAppearance.getColorsLight().getPrimary());
        long l3 = ColorKt.Color((int)$this$parseAppearance.getColorsLight().getSurface());
        long l4 = ColorKt.Color((int)$this$parseAppearance.getColorsLight().getOnSurface());
        long l5 = ColorKt.Color((int)$this$parseAppearance.getColorsLight().getError());
        StripeTheme.INSTANCE.setColorsLightMutable(StripeColors.copy-KvvhxLA$default((StripeColors)StripeThemeDefaults.INSTANCE.getColorsLight(), (long)ColorKt.Color((int)$this$parseAppearance.getColorsLight().getComponent()), (long)ColorKt.Color((int)$this$parseAppearance.getColorsLight().getComponentBorder()), (long)ColorKt.Color((int)$this$parseAppearance.getColorsLight().getComponentDivider()), (long)ColorKt.Color((int)$this$parseAppearance.getColorsLight().getOnComponent()), (long)ColorKt.Color((int)$this$parseAppearance.getColorsLight().getSubtitle()), (long)0L, (long)ColorKt.Color((int)$this$parseAppearance.getColorsLight().getPlaceholderText()), (long)ColorKt.Color((int)$this$parseAppearance.getColorsLight().getAppBarIcon()), (Colors)ColorsKt.lightColors-2qZNXz8$default((long)l2, (long)0L, (long)0L, (long)0L, (long)0L, (long)l3, (long)l5, (long)0L, (long)0L, (long)0L, (long)l4, (long)0L, (int)2974, null), (int)32, null));
        l2 = ColorKt.Color((int)$this$parseAppearance.getColorsDark().getPrimary());
        l3 = ColorKt.Color((int)$this$parseAppearance.getColorsDark().getSurface());
        l4 = ColorKt.Color((int)$this$parseAppearance.getColorsDark().getOnSurface());
        l5 = ColorKt.Color((int)$this$parseAppearance.getColorsDark().getError());
        StripeTheme.INSTANCE.setColorsDarkMutable(StripeColors.copy-KvvhxLA$default((StripeColors)StripeThemeDefaults.INSTANCE.getColorsDark(), (long)ColorKt.Color((int)$this$parseAppearance.getColorsDark().getComponent()), (long)ColorKt.Color((int)$this$parseAppearance.getColorsDark().getComponentBorder()), (long)ColorKt.Color((int)$this$parseAppearance.getColorsDark().getComponentDivider()), (long)ColorKt.Color((int)$this$parseAppearance.getColorsDark().getOnComponent()), (long)ColorKt.Color((int)$this$parseAppearance.getColorsDark().getSubtitle()), (long)0L, (long)ColorKt.Color((int)$this$parseAppearance.getColorsDark().getPlaceholderText()), (long)ColorKt.Color((int)$this$parseAppearance.getColorsDark().getAppBarIcon()), (Colors)ColorsKt.darkColors-2qZNXz8$default((long)l2, (long)0L, (long)0L, (long)0L, (long)0L, (long)l3, (long)l5, (long)0L, (long)0L, (long)0L, (long)l4, (long)0L, (int)2974, null), (int)32, null));
        StripeTheme.INSTANCE.setShapesMutable(StripeShapes.copy$default((StripeShapes)StripeThemeDefaults.INSTANCE.getShapes(), (float)$this$parseAppearance.getShapes().getCornerRadiusDp(), (float)$this$parseAppearance.getShapes().getBorderStrokeWidthDp(), (float)0.0f, (int)4, null));
        StripeTypography stripeTypography = StripeThemeDefaults.INSTANCE.getTypography();
        Integer n = $this$parseAppearance.getTypography().getFontResId();
        float f = $this$parseAppearance.getTypography().getSizeScaleFactor();
        StripeTheme.INSTANCE.setTypographyMutable(StripeTypography.copy-BZCqYng$default((StripeTypography)stripeTypography, (int)0, (int)0, (int)0, (float)f, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (Integer)n, null, null, null, null, null, null, null, (int)261111, null));
        PrimaryButtonStyle primaryButtonStyle = StripeThemeDefaults.INSTANCE.getPrimaryButtonStyle();
        Integer n2 = $this$parseAppearance.getPrimaryButton().getColorsLight().getBackground();
        PrimaryButtonColors primaryButtonColors = new PrimaryButtonColors(ColorKt.Color((int)(n2 != null ? n2.intValue() : $this$parseAppearance.getColorsLight().getPrimary())), ColorKt.Color((int)$this$parseAppearance.getPrimaryButton().getColorsLight().getOnBackground()), ColorKt.Color((int)$this$parseAppearance.getPrimaryButton().getColorsLight().getBorder()), ColorKt.Color((int)$this$parseAppearance.getPrimaryButton().getColorsLight().getSuccessBackgroundColor()), ColorKt.Color((int)$this$parseAppearance.getPrimaryButton().getColorsLight().getOnSuccessBackgroundColor()), null);
        Integer n3 = $this$parseAppearance.getPrimaryButton().getColorsDark().getBackground();
        PrimaryButtonColors primaryButtonColors2 = new PrimaryButtonColors(ColorKt.Color((int)(n3 != null ? n3.intValue() : $this$parseAppearance.getColorsDark().getPrimary())), ColorKt.Color((int)$this$parseAppearance.getPrimaryButton().getColorsDark().getOnBackground()), ColorKt.Color((int)$this$parseAppearance.getPrimaryButton().getColorsDark().getBorder()), ColorKt.Color((int)$this$parseAppearance.getPrimaryButton().getColorsDark().getSuccessBackgroundColor()), ColorKt.Color((int)$this$parseAppearance.getPrimaryButton().getColorsDark().getOnSuccessBackgroundColor()), null);
        Float f2 = $this$parseAppearance.getPrimaryButton().getShape().getCornerRadiusDp();
        Float f3 = $this$parseAppearance.getPrimaryButton().getShape().getBorderStrokeWidthDp();
        PrimaryButtonShape primaryButtonShape = new PrimaryButtonShape(f2 != null ? f2.floatValue() : $this$parseAppearance.getShapes().getCornerRadiusDp(), f3 != null ? f3.floatValue() : $this$parseAppearance.getShapes().getBorderStrokeWidthDp());
        Integer n4 = $this$parseAppearance.getPrimaryButton().getTypography().getFontResId();
        if (n4 == null) {
            n4 = $this$parseAppearance.getTypography().getFontResId();
        }
        Float f4 = $this$parseAppearance.getPrimaryButton().getTypography().getFontSizeSp();
        if (f4 != null) {
            l = TextUnitKt.getSp((float)f4.floatValue());
        } else {
            void arg0$iv;
            long l6 = StripeThemeDefaults.INSTANCE.getTypography().getLargeFontSize-XSAIIZE();
            float other$iv = $this$parseAppearance.getTypography().getSizeScaleFactor();
            boolean bl = false;
            TextUnitKt.checkArithmetic--R2X_6o((long)arg0$iv);
            l = TextUnitKt.pack((long)TextUnit.getRawType-impl((long)arg0$iv), (float)(TextUnit.getValue-impl((long)arg0$iv) * other$iv));
        }
        StripeTheme.INSTANCE.setPrimaryButtonStyle(primaryButtonStyle.copy(primaryButtonColors, primaryButtonColors2, primaryButtonShape, new PrimaryButtonTypography(n4, l, null)));
    }

    private static final VolatilePaymentSheetConfiguration toVolatileConfiguration(PaymentSheet.Configuration $this$toVolatileConfiguration) {
        PaymentSheet.GooglePayConfiguration googlePayConfiguration = $this$toVolatileConfiguration.getGooglePay();
        return new VolatilePaymentSheetConfiguration($this$toVolatileConfiguration.getCustomer(), googlePayConfiguration != null ? PaymentSheetConfigurationKtxKt.toVolatileConfiguration(googlePayConfiguration) : null, $this$toVolatileConfiguration.getDefaultBillingDetails(), $this$toVolatileConfiguration.getShippingDetails(), $this$toVolatileConfiguration.getAllowsDelayedPaymentMethods(), $this$toVolatileConfiguration.getAllowsPaymentMethodsRequiringShippingAddress(), $this$toVolatileConfiguration.getBillingDetailsCollectionConfiguration(), $this$toVolatileConfiguration.getPreferredNetworks(), $this$toVolatileConfiguration.getAllowsRemovalOfLastSavedPaymentMethod$paymentsheet_release());
    }

    private static final VolatilePaymentSheetConfiguration.GooglePayConfiguration toVolatileConfiguration(PaymentSheet.GooglePayConfiguration $this$toVolatileConfiguration) {
        return new VolatilePaymentSheetConfiguration.GooglePayConfiguration($this$toVolatileConfiguration.getEnvironment(), $this$toVolatileConfiguration.getCountryCode(), $this$toVolatileConfiguration.getCurrencyCode());
    }
}

