/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.addresselement;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.cards.DefaultCardAccountRangeRepositoryFactory;
import com.stripe.android.link.ui.inline.InlineSignupViewState;
import com.stripe.android.lpmfoundations.luxe.TransformSpecToElements;
import com.stripe.android.lpmfoundations.paymentmethod.UiDefinitionFactory;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.addresselement.FormControllerModule;
import com.stripe.android.ui.core.Amount;
import com.stripe.android.ui.core.cbc.CardBrandChoiceEligibility;
import com.stripe.android.uicore.elements.IdentifierSpec;
import dagger.Module;
import dagger.Provides;
import java.util.Map;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0016\b\u0001\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\b0\f2\u0018\b\u0001\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\fH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/paymentsheet/addresselement/FormControllerModule;", "", "()V", "provideTransformSpecToElements", "Lcom/stripe/android/lpmfoundations/luxe/TransformSpecToElements;", "context", "Landroid/content/Context;", "merchantName", "", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "initialValues", "", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "shippingValues", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class FormControllerModule {
    @NotNull
    public static final FormControllerModule INSTANCE = new FormControllerModule();
    public static final int $stable;

    private FormControllerModule() {
    }

    @Provides
    @NotNull
    public final TransformSpecToElements provideTransformSpecToElements(@NotNull Context context, @NotNull String merchantName, @Nullable StripeIntent stripeIntent, @Named(value="initialValues") @NotNull Map<IdentifierSpec, String> initialValues, @Named(value="shippingValues") @Nullable Map<IdentifierSpec, String> shippingValues) {
        Amount amount;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        Intrinsics.checkNotNullParameter(initialValues, (String)"initialValues");
        PaymentIntent paymentIntent = stripeIntent instanceof PaymentIntent ? (PaymentIntent)stripeIntent : null;
        if (paymentIntent != null) {
            PaymentIntent it = paymentIntent;
            boolean bl = false;
            Long amount2 = it.getAmount();
            String currency = it.getCurrency();
            if (amount2 != null && currency != null) {
                new Amount(amount2.longValue(), currency);
            }
            amount = null;
        } else {
            amount = null;
        }
        Amount amount3 = amount;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        DefaultCardAccountRangeRepositoryFactory defaultCardAccountRangeRepositoryFactory = new DefaultCardAccountRangeRepositoryFactory(context2);
        CardBrandChoiceEligibility.Ineligible ineligible = CardBrandChoiceEligibility.Ineligible.INSTANCE;
        PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = new PaymentSheet.BillingDetailsCollectionConfiguration(null, null, null, null, false, 31, null);
        UiDefinitionFactory.Arguments arguments = new UiDefinitionFactory.Arguments((CardAccountRangeRepository.Factory)defaultCardAccountRangeRepositoryFactory, null, initialValues, shippingValues, amount3, false, merchantName, (CardBrandChoiceEligibility)ineligible, billingDetailsCollectionConfiguration, false, (Function1<? super InlineSignupViewState, Unit>)((Function1)provideTransformSpecToElements.2.INSTANCE));
        return new TransformSpecToElements(arguments);
    }
}

