/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.injection.IOContext;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.utils.DurationProvider;
import com.stripe.android.model.CardBrand;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.paymentsheet.DeferredIntentConfirmationType;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.analytics.PaymentSheetConfirmationError;
import com.stripe.android.paymentsheet.analytics.PaymentSheetEvent;
import com.stripe.android.paymentsheet.analytics.PaymentSheetEventKt;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0001\u0018\u00002\u00020\u0001B1\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\u001a\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0018\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0010H\u0016JB\u0010+\u001a\u00020\u00142\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e01H\u0016J\u0012\u00102\u001a\u00020\u00142\b\u00103\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u00104\u001a\u00020\u00142\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u001d\u001a\u000205H\u0016J\u0014\u00106\u001a\u00020\u00142\n\u00107\u001a\u00060\u000ej\u0002`8H\u0016J\u0014\u00109\u001a\u00020\u00142\n\u00107\u001a\u00060\u000ej\u0002`8H\u0016J\u001c\u0010:\u001a\u00020\u00142\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0012\u0010=\u001a\u00020\u00142\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0014\u0010>\u001a\u00020\u00142\n\u00107\u001a\u00060\u000ej\u0002`8H\u0016J\u0010\u0010?\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010@\u001a\u00020\u0014H\u0016J\b\u0010A\u001a\u00020\u0014H\u0016J\b\u0010B\u001a\u00020\u0014H\u0016J\u0018\u0010C\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010D\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010E\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/stripe/android/paymentsheet/analytics/DefaultEventReporter;", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "paymentAnalyticsRequestFactory", "Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;", "durationProvider", "Lcom/stripe/android/core/utils/DurationProvider;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;Lcom/stripe/android/core/utils/DurationProvider;Lkotlin/coroutines/CoroutineContext;)V", "currency", "", "googlePaySupported", "", "isDeferred", "linkEnabled", "fireEvent", "", "event", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "onAutofill", "type", "onCannotProperlyReturnFromLinkAndOtherLPMs", "onCardNumberCompleted", "onDismiss", "onElementsSessionLoadFailed", "error", "", "onHideEditablePaymentOption", "onHidePaymentOptionBrands", "source", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$CardBrandChoiceEventSource;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "onInit", "configuration", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "onLoadFailed", "onLoadStarted", "initializedViaCompose", "onLoadSucceeded", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "initializationMode", "Lcom/stripe/android/paymentsheet/PaymentSheet$InitializationMode;", "orderedLpms", "", "onLpmSpecFailure", "errorMessage", "onPaymentFailure", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;", "onPaymentMethodFormInteraction", "code", "Lcom/stripe/android/model/PaymentMethodCode;", "onPaymentMethodFormShown", "onPaymentSuccess", "deferredIntentConfirmationType", "Lcom/stripe/android/paymentsheet/DeferredIntentConfirmationType;", "onPressConfirmButton", "onSelectPaymentMethod", "onSelectPaymentOption", "onShowEditablePaymentOption", "onShowExistingPaymentOptions", "onShowNewPaymentOptionForm", "onShowPaymentOptionBrands", "onUpdatePaymentMethodFailed", "onUpdatePaymentMethodSucceeded", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class DefaultEventReporter
implements EventReporter {
    @NotNull
    private final EventReporter.Mode mode;
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory;
    @NotNull
    private final DurationProvider durationProvider;
    @NotNull
    private final CoroutineContext workContext;
    private boolean isDeferred;
    private boolean linkEnabled;
    private boolean googlePaySupported;
    @Nullable
    private String currency;
    public static final int $stable = 8;

    @Inject
    public DefaultEventReporter(@NotNull EventReporter.Mode mode, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, @NotNull DurationProvider durationProvider, @IOContext @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)paymentAnalyticsRequestFactory, (String)"paymentAnalyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)durationProvider, (String)"durationProvider");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this.mode = mode;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.paymentAnalyticsRequestFactory = paymentAnalyticsRequestFactory;
        this.durationProvider = durationProvider;
        this.workContext = workContext;
    }

    @Override
    public void onInit(@NotNull PaymentSheet.Configuration configuration, boolean isDeferred) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.isDeferred = isDeferred;
        this.fireEvent(new PaymentSheetEvent.Init(this.mode, configuration, isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onLoadStarted(boolean initializedViaCompose) {
        DurationProvider.DefaultImpls.start$default((DurationProvider)this.durationProvider, (DurationProvider.Key)DurationProvider.Key.Loading, (boolean)false, (int)2, null);
        this.fireEvent(new PaymentSheetEvent.LoadStarted(this.isDeferred, this.linkEnabled, this.googlePaySupported, initializedViaCompose));
    }

    @Override
    public void onLoadSucceeded(@Nullable PaymentSelection paymentSelection, boolean linkEnabled, boolean googlePaySupported, @Nullable String currency, @NotNull PaymentSheet.InitializationMode initializationMode, @NotNull List<String> orderedLpms) {
        Intrinsics.checkNotNullParameter((Object)initializationMode, (String)"initializationMode");
        Intrinsics.checkNotNullParameter(orderedLpms, (String)"orderedLpms");
        this.currency = currency;
        this.linkEnabled = linkEnabled;
        this.googlePaySupported = googlePaySupported;
        DurationProvider.DefaultImpls.start$default((DurationProvider)this.durationProvider, (DurationProvider.Key)DurationProvider.Key.Checkout, (boolean)false, (int)2, null);
        Duration duration = this.durationProvider.end-LV8wdWc(DurationProvider.Key.Loading);
        boolean bl = this.isDeferred;
        this.fireEvent(new PaymentSheetEvent.LoadSucceeded(paymentSelection, initializationMode, orderedLpms, duration, bl, linkEnabled, googlePaySupported, null));
    }

    @Override
    public void onLoadFailed(@NotNull Throwable error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        Duration duration = this.durationProvider.end-LV8wdWc(DurationProvider.Key.Loading);
        this.fireEvent(new PaymentSheetEvent.LoadFailed(duration, error2, this.isDeferred, this.linkEnabled, this.googlePaySupported, null));
    }

    @Override
    public void onElementsSessionLoadFailed(@NotNull Throwable error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        this.fireEvent(new PaymentSheetEvent.ElementsSessionLoadFailed(error2, this.isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onDismiss() {
        this.fireEvent(new PaymentSheetEvent.Dismiss(this.isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onShowExistingPaymentOptions() {
        EventReporter.Mode mode = this.mode;
        boolean bl = this.linkEnabled;
        boolean bl2 = this.googlePaySupported;
        String string2 = this.currency;
        boolean bl3 = this.isDeferred;
        this.fireEvent(new PaymentSheetEvent.ShowExistingPaymentOptions(mode, string2, bl3, bl, bl2));
    }

    @Override
    public void onShowNewPaymentOptionForm() {
        EventReporter.Mode mode = this.mode;
        boolean bl = this.linkEnabled;
        boolean bl2 = this.googlePaySupported;
        String string2 = this.currency;
        boolean bl3 = this.isDeferred;
        this.fireEvent(new PaymentSheetEvent.ShowNewPaymentOptionForm(mode, string2, bl3, bl, bl2));
    }

    @Override
    public void onSelectPaymentMethod(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        boolean bl = this.isDeferred;
        String string2 = this.currency;
        boolean bl2 = this.linkEnabled;
        boolean bl3 = this.googlePaySupported;
        this.fireEvent(new PaymentSheetEvent.SelectPaymentMethod(code, string2, bl, bl2, bl3));
    }

    @Override
    public void onPaymentMethodFormShown(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        DurationProvider.DefaultImpls.start$default((DurationProvider)this.durationProvider, (DurationProvider.Key)DurationProvider.Key.ConfirmButtonClicked, (boolean)false, (int)2, null);
        this.fireEvent(new PaymentSheetEvent.ShowPaymentOptionForm(code, this.isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onPaymentMethodFormInteraction(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.fireEvent(new PaymentSheetEvent.PaymentOptionFormInteraction(code, this.isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onCardNumberCompleted() {
        this.fireEvent(new PaymentSheetEvent.CardNumberCompleted(this.isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onSelectPaymentOption(@NotNull PaymentSelection paymentSelection) {
        Intrinsics.checkNotNullParameter((Object)paymentSelection, (String)"paymentSelection");
        this.fireEvent(new PaymentSheetEvent.SelectPaymentOption(this.mode, paymentSelection, this.currency, this.isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onPressConfirmButton(@Nullable PaymentSelection paymentSelection) {
        Duration duration = this.durationProvider.end-LV8wdWc(DurationProvider.Key.ConfirmButtonClicked);
        this.fireEvent(new PaymentSheetEvent.PressConfirmButton(this.currency, duration, PaymentSheetEventKt.code(paymentSelection), PaymentSheetEventKt.linkContext(paymentSelection), this.isDeferred, this.linkEnabled, this.googlePaySupported, null));
    }

    @Override
    public void onPaymentSuccess(@Nullable PaymentSelection paymentSelection, @Nullable DeferredIntentConfirmationType deferredIntentConfirmationType) {
        PaymentSelection.Saved savedSelection2 = paymentSelection instanceof PaymentSelection.Saved ? (PaymentSelection.Saved)paymentSelection : null;
        Object object = savedSelection2;
        if (object == null || (object = ((PaymentSelection.Saved)object).getWalletType()) == null || (object = ((PaymentSelection.Saved.WalletType)((Object)object)).getPaymentSelection()) == null) {
            object = paymentSelection;
        }
        Object realSelection = object;
        Duration duration = this.durationProvider.end-LV8wdWc(DurationProvider.Key.Checkout);
        EventReporter.Mode mode = this.mode;
        PaymentSheetEvent.Payment.Result.Success success = PaymentSheetEvent.Payment.Result.Success.INSTANCE;
        String string2 = this.currency;
        boolean bl = deferredIntentConfirmationType != null;
        boolean bl2 = this.linkEnabled;
        boolean bl3 = this.googlePaySupported;
        this.fireEvent(new PaymentSheetEvent.Payment(mode, success, duration, (PaymentSelection)realSelection, string2, bl, bl2, bl3, deferredIntentConfirmationType, null));
    }

    @Override
    public void onPaymentFailure(@Nullable PaymentSelection paymentSelection, @NotNull PaymentSheetConfirmationError error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        Duration duration = this.durationProvider.end-LV8wdWc(DurationProvider.Key.Checkout);
        EventReporter.Mode mode = this.mode;
        PaymentSheetEvent.Payment.Result.Failure failure = new PaymentSheetEvent.Payment.Result.Failure(error2);
        String string2 = this.currency;
        boolean bl = this.isDeferred;
        boolean bl2 = this.linkEnabled;
        boolean bl3 = this.googlePaySupported;
        this.fireEvent(new PaymentSheetEvent.Payment(mode, failure, duration, paymentSelection, string2, bl, bl2, bl3, null, null));
    }

    @Override
    public void onLpmSpecFailure(@Nullable String errorMessage) {
        this.fireEvent(new PaymentSheetEvent.LpmSerializeFailureEvent(this.isDeferred, this.linkEnabled, this.googlePaySupported, errorMessage));
    }

    @Override
    public void onAutofill(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.fireEvent(new PaymentSheetEvent.AutofillEvent(type, this.isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onShowEditablePaymentOption() {
        this.fireEvent(new PaymentSheetEvent.ShowEditablePaymentOption(this.isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onHideEditablePaymentOption() {
        this.fireEvent(new PaymentSheetEvent.HideEditablePaymentOption(this.isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onShowPaymentOptionBrands(@NotNull EventReporter.CardBrandChoiceEventSource source, @NotNull CardBrand selectedBrand) {
        PaymentSheetEvent.ShowPaymentOptionBrands.Source source2;
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)selectedBrand, (String)"selectedBrand");
        switch (WhenMappings.$EnumSwitchMapping$0[source.ordinal()]) {
            case 1: {
                source2 = PaymentSheetEvent.ShowPaymentOptionBrands.Source.Add;
                break;
            }
            case 2: {
                source2 = PaymentSheetEvent.ShowPaymentOptionBrands.Source.Edit;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PaymentSheetEvent.ShowPaymentOptionBrands.Source source3 = source2;
        boolean bl = this.isDeferred;
        boolean bl2 = this.linkEnabled;
        boolean bl3 = this.googlePaySupported;
        this.fireEvent(new PaymentSheetEvent.ShowPaymentOptionBrands(source3, selectedBrand, bl, bl2, bl3));
    }

    @Override
    public void onHidePaymentOptionBrands(@NotNull EventReporter.CardBrandChoiceEventSource source, @Nullable CardBrand selectedBrand) {
        PaymentSheetEvent.HidePaymentOptionBrands.Source source2;
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        switch (WhenMappings.$EnumSwitchMapping$0[source.ordinal()]) {
            case 1: {
                source2 = PaymentSheetEvent.HidePaymentOptionBrands.Source.Add;
                break;
            }
            case 2: {
                source2 = PaymentSheetEvent.HidePaymentOptionBrands.Source.Edit;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PaymentSheetEvent.HidePaymentOptionBrands.Source source3 = source2;
        boolean bl = this.isDeferred;
        boolean bl2 = this.linkEnabled;
        boolean bl3 = this.googlePaySupported;
        this.fireEvent(new PaymentSheetEvent.HidePaymentOptionBrands(source3, selectedBrand, bl, bl2, bl3));
    }

    @Override
    public void onUpdatePaymentMethodSucceeded(@NotNull CardBrand selectedBrand) {
        Intrinsics.checkNotNullParameter((Object)selectedBrand, (String)"selectedBrand");
        this.fireEvent(new PaymentSheetEvent.UpdatePaymentOptionSucceeded(selectedBrand, this.isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onUpdatePaymentMethodFailed(@NotNull CardBrand selectedBrand, @NotNull Throwable error2) {
        Intrinsics.checkNotNullParameter((Object)selectedBrand, (String)"selectedBrand");
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        this.fireEvent(new PaymentSheetEvent.UpdatePaymentOptionFailed(selectedBrand, error2, this.isDeferred, this.linkEnabled, this.googlePaySupported));
    }

    @Override
    public void onCannotProperlyReturnFromLinkAndOtherLPMs() {
        this.fireEvent(new PaymentSheetEvent.CannotProperlyReturnFromLinkAndLPMs(this.mode));
    }

    private final void fireEvent(PaymentSheetEvent event) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
            int label;
            final /* synthetic */ DefaultEventReporter this$0;
            final /* synthetic */ PaymentSheetEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultEventReporter.access$getAnalyticsRequestExecutor$p(this.this$0).executeAsync(DefaultEventReporter.access$getPaymentAnalyticsRequestFactory$p(this.this$0).createRequest((AnalyticsEvent)this.$event, this.$event.getParams()));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ AnalyticsRequestExecutor access$getAnalyticsRequestExecutor$p(DefaultEventReporter $this) {
        return $this.analyticsRequestExecutor;
    }

    public static final /* synthetic */ PaymentAnalyticsRequestFactory access$getPaymentAnalyticsRequestFactory$p(DefaultEventReporter $this) {
        return $this.paymentAnalyticsRequestFactory;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventReporter.CardBrandChoiceEventSource.values().length];
            try {
                nArray[EventReporter.CardBrandChoiceEventSource.Add.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventReporter.CardBrandChoiceEventSource.Edit.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

