/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.common.analytics.AnalyticsKtxKt;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.paymentsheet.DeferredIntentConfirmationType;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.analytics.PaymentSheetConfirmationError;
import com.stripe.android.paymentsheet.analytics.PaymentSheetEventKt;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.state.PaymentSheetLoadingExceptionKt;
import com.stripe.android.utils.MapUtilsKt;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u00172\u00020\u0001:\u0019\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002R \u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0012\u0010\u000e\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u001f\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\b\u0082\u0001\u0018-./0123456789:;<=>?@ABCD\u00a8\u0006E"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "Lcom/stripe/android/core/networking/AnalyticsEvent;", "()V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "googlePaySupported", "", "getGooglePaySupported", "()Z", "isDeferred", "linkEnabled", "getLinkEnabled", "params", "getParams", "standardParams", "isDecoupled", "AutofillEvent", "CannotProperlyReturnFromLinkAndLPMs", "CardNumberCompleted", "Companion", "Dismiss", "ElementsSessionLoadFailed", "HideEditablePaymentOption", "HidePaymentOptionBrands", "Init", "LoadFailed", "LoadStarted", "LoadSucceeded", "LpmSerializeFailureEvent", "Payment", "PaymentOptionFormInteraction", "PressConfirmButton", "SelectPaymentMethod", "SelectPaymentOption", "ShowEditablePaymentOption", "ShowExistingPaymentOptions", "ShowNewPaymentOptionForm", "ShowPaymentOptionBrands", "ShowPaymentOptionForm", "UpdatePaymentOptionFailed", "UpdatePaymentOptionSucceeded", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$AutofillEvent;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CannotProperlyReturnFromLinkAndLPMs;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CardNumberCompleted;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Dismiss;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ElementsSessionLoadFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$HideEditablePaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$HidePaymentOptionBrands;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Init;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadStarted;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadSucceeded;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LpmSerializeFailureEvent;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$PaymentOptionFormInteraction;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$PressConfirmButton;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SelectPaymentMethod;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SelectPaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowEditablePaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowExistingPaymentOptions;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowNewPaymentOptionForm;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowPaymentOptionBrands;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowPaymentOptionForm;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$UpdatePaymentOptionFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$UpdatePaymentOptionSucceeded;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public abstract class PaymentSheetEvent
implements AnalyticsEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    public static final String FIELD_CUSTOMER = "customer";
    @NotNull
    public static final String FIELD_GOOGLE_PAY = "googlepay";
    @NotNull
    public static final String FIELD_GOOGLE_PAY_ENABLED = "google_pay_enabled";
    @NotNull
    public static final String FIELD_PRIMARY_BUTTON_COLOR = "primary_button_color";
    @NotNull
    public static final String FIELD_BILLING = "default_billing_details";
    @NotNull
    public static final String FIELD_PREFERRED_NETWORKS = "preferred_networks";
    @NotNull
    public static final String FIELD_DELAYED_PMS = "allows_delayed_payment_methods";
    @NotNull
    public static final String FIELD_MOBILE_PAYMENT_ELEMENT_CONFIGURATION = "mpe_config";
    @NotNull
    public static final String FIELD_APPEARANCE = "appearance";
    @NotNull
    public static final String FIELD_ALLOWS_PAYMENT_METHODS_REQUIRING_SHIPPING_ADDRESS = "allows_payment_methods_requiring_shipping_address";
    @NotNull
    public static final String FIELD_ALLOWS_REMOVAL_OF_LAST_SAVED_PAYMENT_METHOD = "allows_removal_of_last_saved_payment_method";
    @NotNull
    public static final String FIELD_BILLING_DETAILS_COLLECTION_CONFIGURATION = "billing_details_collection_configuration";
    @NotNull
    public static final String FIELD_PAYMENT_METHOD_ORDER = "payment_method_order";
    @NotNull
    public static final String FIELD_IS_DECOUPLED = "is_decoupled";
    @NotNull
    public static final String FIELD_DEFERRED_INTENT_CONFIRMATION_TYPE = "deferred_intent_confirmation_type";
    @NotNull
    public static final String FIELD_DURATION = "duration";
    @NotNull
    public static final String FIELD_LINK_ENABLED = "link_enabled";
    @NotNull
    public static final String FIELD_CURRENCY = "currency";
    @NotNull
    public static final String FIELD_SELECTED_LPM = "selected_lpm";
    @NotNull
    public static final String FIELD_ERROR_MESSAGE = "error_message";
    @NotNull
    public static final String FIELD_CBC_EVENT_SOURCE = "cbc_event_source";
    @NotNull
    public static final String FIELD_SELECTED_CARD_BRAND = "selected_card_brand";
    @NotNull
    public static final String FIELD_LINK_CONTEXT = "link_context";
    @NotNull
    public static final String FIELD_EXTERNAL_PAYMENT_METHODS = "external_payment_methods";
    @NotNull
    public static final String FIELD_COMPOSE = "compose";
    @NotNull
    public static final String FIELD_INTENT_TYPE = "intent_type";
    @NotNull
    public static final String FIELD_ORDERED_LPMS = "ordered_lpms";
    @NotNull
    public static final String VALUE_EDIT_CBC_EVENT_SOURCE = "edit";
    @NotNull
    public static final String VALUE_ADD_CBC_EVENT_SOURCE = "add";
    public static final int MAX_EXTERNAL_PAYMENT_METHODS = 10;

    private PaymentSheetEvent() {
    }

    @NotNull
    public final Map<String, Object> getParams() {
        return MapsKt.plus(this.standardParams(this.isDeferred(), this.getLinkEnabled(), this.getGooglePaySupported()), this.getAdditionalParams());
    }

    protected abstract boolean isDeferred();

    protected abstract boolean getLinkEnabled();

    protected abstract boolean getGooglePaySupported();

    @NotNull
    protected abstract Map<String, Object> getAdditionalParams();

    private final Map<String, Object> standardParams(boolean isDecoupled, boolean linkEnabled, boolean googlePaySupported) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)FIELD_IS_DECOUPLED, (Object)isDecoupled), TuplesKt.to((Object)FIELD_LINK_ENABLED, (Object)linkEnabled), TuplesKt.to((Object)FIELD_GOOGLE_PAY_ENABLED, (Object)googlePaySupported)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    public /* synthetic */ PaymentSheetEvent(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\f\u0010\u0014\u001a\u00020\u0003*\u00020\u0003H\u0002R\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$AutofillEvent;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "type", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Ljava/lang/String;ZZZ)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "toSnakeCase", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class AutofillEvent
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public AutofillEvent(@NotNull String type, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "autofill_" + this.toSnakeCase(type);
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        private final String toSnakeCase(String $this$toSnakeCase) {
            CharSequence charSequence = $this$toSnakeCase;
            Regex regex = new Regex("(?<=.)(?=\\p{Upper})");
            String string2 = "_";
            String string3 = regex.replace(charSequence, string2).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            return string3;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CannotProperlyReturnFromLinkAndLPMs;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "googlePaySupported", "", "getGooglePaySupported", "()Z", "isDeferred", "linkEnabled", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class CannotProperlyReturnFromLinkAndLPMs
    extends PaymentSheetEvent {
        private final boolean linkEnabled;
        private final boolean isDeferred;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public CannotProperlyReturnFromLinkAndLPMs(@NotNull EventReporter.Mode mode) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.eventName = Companion.formatEventName(mode, "cannot_return_from_link_and_lpms");
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CardNumberCompleted;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "(ZZZ)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class CardNumberCompleted
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public CardNumberCompleted(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_card_number_completed";
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010#\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0018\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Companion;", "", "()V", "FIELD_ALLOWS_PAYMENT_METHODS_REQUIRING_SHIPPING_ADDRESS", "", "FIELD_ALLOWS_REMOVAL_OF_LAST_SAVED_PAYMENT_METHOD", "FIELD_APPEARANCE", "FIELD_BILLING", "FIELD_BILLING_DETAILS_COLLECTION_CONFIGURATION", "FIELD_CBC_EVENT_SOURCE", "FIELD_COMPOSE", "FIELD_CURRENCY", "FIELD_CUSTOMER", "FIELD_DEFERRED_INTENT_CONFIRMATION_TYPE", "FIELD_DELAYED_PMS", "FIELD_DURATION", "FIELD_ERROR_MESSAGE", "FIELD_EXTERNAL_PAYMENT_METHODS", "FIELD_GOOGLE_PAY", "FIELD_GOOGLE_PAY_ENABLED", "FIELD_INTENT_TYPE", "FIELD_IS_DECOUPLED", "FIELD_LINK_CONTEXT", "FIELD_LINK_ENABLED", "FIELD_MOBILE_PAYMENT_ELEMENT_CONFIGURATION", "FIELD_ORDERED_LPMS", "FIELD_PAYMENT_METHOD_ORDER", "FIELD_PREFERRED_NETWORKS", "FIELD_PRIMARY_BUTTON_COLOR", "FIELD_SELECTED_CARD_BRAND", "FIELD_SELECTED_LPM", "MAX_EXTERNAL_PAYMENT_METHODS", "", "VALUE_ADD_CBC_EVENT_SOURCE", "VALUE_EDIT_CBC_EVENT_SOURCE", "analyticsValue", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "formatEventName", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "eventName", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String analyticsValue(PaymentSelection paymentSelection) {
            PaymentSelection paymentSelection2 = paymentSelection;
            return Intrinsics.areEqual((Object)paymentSelection2, (Object)PaymentSelection.GooglePay.INSTANCE) ? PaymentSheetEvent.FIELD_GOOGLE_PAY : (paymentSelection2 instanceof PaymentSelection.Saved ? "savedpm" : ((Intrinsics.areEqual((Object)paymentSelection2, (Object)PaymentSelection.Link.INSTANCE) ? true : paymentSelection2 instanceof PaymentSelection.New.LinkInline) ? "link" : (paymentSelection2 instanceof PaymentSelection.New ? "newpm" : "unknown")));
        }

        private final String formatEventName(EventReporter.Mode mode, String eventName) {
            return "mc_" + mode + "_" + eventName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Dismiss;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "(ZZZ)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Dismiss
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public Dismiss(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_dismiss";
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ElementsSessionLoadFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "error", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Ljava/lang/Throwable;ZZZ)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ElementsSessionLoadFailed
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ElementsSessionLoadFailed(@NotNull Throwable error2, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_elements_session_load_failed";
            this.additionalParams = MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_ERROR_MESSAGE, (Object)PaymentSheetLoadingExceptionKt.getAsPaymentSheetLoadingException(error2).getType())), (Map)ErrorReporter.Companion.getAdditionalParamsFromError(error2));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$HideEditablePaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "(ZZZ)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class HideEditablePaymentOption
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public HideEditablePaymentOption(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_cancel_edit_screen";
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0015R\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$HidePaymentOptionBrands;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "source", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$HidePaymentOptionBrands$Source;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$HidePaymentOptionBrands$Source;Lcom/stripe/android/model/CardBrand;ZZZ)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "Source", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class HidePaymentOptionBrands
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public HidePaymentOptionBrands(@NotNull Source source, @Nullable CardBrand selectedBrand, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_close_cbc_dropdown";
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_CBC_EVENT_SOURCE, (Object)source.getValue());
            CardBrand cardBrand = selectedBrand;
            pairArray[1] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_CARD_BRAND, (Object)(cardBrand != null ? cardBrand.getCode() : null));
            this.additionalParams = MapsKt.mapOf((Pair[])pairArray);
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$HidePaymentOptionBrands$Source;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "Edit", "Add", "paymentsheet_release"})
        public static final class Source
        extends Enum<Source> {
            @NotNull
            private final String value;
            public static final /* enum */ Source Edit = new Source("edit");
            public static final /* enum */ Source Add = new Source("add");
            private static final /* synthetic */ Source[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Source(String value) {
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public static Source[] values() {
                return (Source[])$VALUES.clone();
            }

            public static Source valueOf(String value) {
                return Enum.valueOf(Source.class, value);
            }

            @NotNull
            public static EnumEntries<Source> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = sourceArray = new Source[]{Source.Edit, Source.Add};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0015R\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Init;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "configuration", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;ZZZ)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nPaymentSheetEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentSheetEvent.kt\ncom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Init\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,528:1\n1#2:529\n*E\n"})
    public static final class Init
    extends PaymentSheetEvent {
        @NotNull
        private final EventReporter.Mode mode;
        @NotNull
        private final PaymentSheet.Configuration configuration;
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        public static final int $stable = 8;

        public Init(@NotNull EventReporter.Mode mode, @NotNull PaymentSheet.Configuration configuration, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            super(null);
            this.mode = mode;
            this.configuration = configuration;
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            String string2;
            Object object = new String[2];
            String string3 = string2 = PaymentSheetEvent.FIELD_CUSTOMER;
            int n = 0;
            Object[] objectArray = object;
            boolean bl = false;
            boolean bl2 = this.configuration.getCustomer() != null;
            objectArray[n] = bl2 ? string2 : null;
            String it = string2 = PaymentSheetEvent.FIELD_GOOGLE_PAY;
            n = 1;
            objectArray = object;
            boolean bl3 = false;
            bl2 = this.configuration.getGooglePay() != null;
            objectArray[n] = bl2 ? string2 : null;
            Object it2 = object = CollectionsKt.listOfNotNull((Object[])object);
            boolean bl4 = false;
            Object object2 = !it2.isEmpty() ? object : null;
            if (object2 == null || (object2 = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null)) == null) {
                object2 = "default";
            }
            Object configValue = object2;
            return Companion.formatEventName(this.mode, "init_" + (String)configValue);
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            Pair[] pairArray = new Pair[12];
            pairArray[0] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_CUSTOMER, (Object)(this.configuration.getCustomer() != null ? 1 : 0));
            pairArray[1] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_GOOGLE_PAY, (Object)(this.configuration.getGooglePay() != null ? 1 : 0));
            pairArray[2] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_PRIMARY_BUTTON_COLOR, (Object)(this.configuration.getPrimaryButtonColor() != null ? 1 : 0));
            PaymentSheet.BillingDetails billingDetails = this.configuration.getDefaultBillingDetails();
            pairArray[3] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_BILLING, (Object)(billingDetails != null ? billingDetails.isFilledOut$paymentsheet_release() : false));
            pairArray[4] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_DELAYED_PMS, (Object)this.configuration.getAllowsDelayedPaymentMethods());
            pairArray[5] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_APPEARANCE, AnalyticsKtxKt.toAnalyticsMap(this.configuration.getAppearance()));
            pairArray[6] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_PAYMENT_METHOD_ORDER, this.configuration.getPaymentMethodOrder$paymentsheet_release());
            pairArray[7] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_ALLOWS_PAYMENT_METHODS_REQUIRING_SHIPPING_ADDRESS, (Object)this.configuration.getAllowsPaymentMethodsRequiringShippingAddress());
            pairArray[8] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_ALLOWS_REMOVAL_OF_LAST_SAVED_PAYMENT_METHOD, (Object)this.configuration.getAllowsRemovalOfLastSavedPaymentMethod$paymentsheet_release());
            pairArray[9] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_BILLING_DETAILS_COLLECTION_CONFIGURATION, AnalyticsKtxKt.toAnalyticsMap(this.configuration.getBillingDetailsCollectionConfiguration()));
            pairArray[10] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_PREFERRED_NETWORKS, (Object)AnalyticsKtxKt.toAnalyticsValue(this.configuration.getPreferredNetworks()));
            pairArray[11] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_EXTERNAL_PAYMENT_METHODS, AnalyticsKtxKt.getExternalPaymentMethodsAnalyticsValue(this.configuration));
            Map configurationMap = MapsKt.mapOf((Pair[])pairArray);
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_MOBILE_PAYMENT_ELEMENT_CONFIGURATION, (Object)configurationMap));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0015R\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "duration", "Lkotlin/time/Duration;", "error", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Lkotlin/time/Duration;Ljava/lang/Throwable;ZZZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class LoadFailed
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        private LoadFailed(Duration duration, Throwable error2, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_load_failed";
            Pair[] pairArray = new Pair[2];
            Duration duration2 = duration;
            pairArray[0] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_DURATION, (Object)(duration2 != null ? Float.valueOf(PaymentSheetEventKt.access$getAsSeconds-LRDsOJo(duration2.unbox-impl())) : null));
            pairArray[1] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_ERROR_MESSAGE, (Object)PaymentSheetLoadingExceptionKt.getAsPaymentSheetLoadingException(error2).getType());
            this.additionalParams = MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), (Map)ErrorReporter.Companion.getAdditionalParamsFromError(error2));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        public /* synthetic */ LoadFailed(Duration duration, Throwable error2, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, DefaultConstructorMarker $constructor_marker) {
            this(duration, error2, isDeferred, linkEnabled, googlePaySupported);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\"\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadStarted;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "initializedViaCompose", "(ZZZZ)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class LoadStarted
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public LoadStarted(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, boolean initializedViaCompose) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_load_started";
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_COMPOSE, (Object)initializedViaCompose));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001BG\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fR\"\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000e\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0019R\u0014\u0010\r\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0018\u0010\u001b\u001a\u00020\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001b\u001a\u00020\b*\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadSucceeded;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "initializationMode", "Lcom/stripe/android/paymentsheet/PaymentSheet$InitializationMode;", "orderedLpms", "", "", "duration", "Lkotlin/time/Duration;", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection;Lcom/stripe/android/paymentsheet/PaymentSheet$InitializationMode;Ljava/util/List;Lkotlin/time/Duration;ZZZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "defaultAnalyticsValue", "getDefaultAnalyticsValue", "(Lcom/stripe/android/paymentsheet/PaymentSheet$InitializationMode;)Ljava/lang/String;", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection;)Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class LoadSucceeded
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        private LoadSucceeded(PaymentSelection paymentSelection, PaymentSheet.InitializationMode initializationMode, List<String> orderedLpms, Duration duration, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)initializationMode, (String)"initializationMode");
            Intrinsics.checkNotNullParameter(orderedLpms, (String)"orderedLpms");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_load_succeeded";
            Pair[] pairArray = new Pair[4];
            Duration duration2 = duration;
            pairArray[0] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_DURATION, (Object)(duration2 != null ? Float.valueOf(PaymentSheetEventKt.access$getAsSeconds-LRDsOJo(duration2.unbox-impl())) : null));
            pairArray[1] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_LPM, (Object)this.getDefaultAnalyticsValue(paymentSelection));
            pairArray[2] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_INTENT_TYPE, (Object)this.getDefaultAnalyticsValue(initializationMode));
            pairArray[3] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_ORDERED_LPMS, (Object)CollectionsKt.joinToString$default((Iterable)orderedLpms, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            this.additionalParams = MapsKt.mapOf((Pair[])pairArray);
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        private final String getDefaultAnalyticsValue(PaymentSelection $this$defaultAnalyticsValue) {
            String string2;
            PaymentSelection paymentSelection = $this$defaultAnalyticsValue;
            if (paymentSelection instanceof PaymentSelection.GooglePay) {
                string2 = "google_pay";
            } else if (paymentSelection instanceof PaymentSelection.Link) {
                string2 = "link";
            } else if (paymentSelection instanceof PaymentSelection.Saved) {
                string2 = ((PaymentSelection.Saved)$this$defaultAnalyticsValue).getPaymentMethod().type;
                if (string2 == null || (string2 = ((PaymentMethod.Type)string2).code) == null) {
                    string2 = "saved";
                }
            } else {
                string2 = "none";
            }
            return string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getDefaultAnalyticsValue(PaymentSheet.InitializationMode $this$defaultAnalyticsValue) {
            PaymentSheet.InitializationMode initializationMode = $this$defaultAnalyticsValue;
            if (initializationMode instanceof PaymentSheet.InitializationMode.DeferredIntent) {
                PaymentSheet.IntentConfiguration.Mode mode = ((PaymentSheet.InitializationMode.DeferredIntent)$this$defaultAnalyticsValue).getIntentConfiguration().getMode();
                if (mode instanceof PaymentSheet.IntentConfiguration.Mode.Payment) {
                    return "deferred_payment_intent";
                }
                if (!(mode instanceof PaymentSheet.IntentConfiguration.Mode.Setup)) throw new NoWhenBranchMatchedException();
                return "deferred_setup_intent";
            }
            if (initializationMode instanceof PaymentSheet.InitializationMode.PaymentIntent) {
                return "payment_intent";
            }
            if (!(initializationMode instanceof PaymentSheet.InitializationMode.SetupIntent)) throw new NoWhenBranchMatchedException();
            return "setup_intent";
        }

        public /* synthetic */ LoadSucceeded(PaymentSelection paymentSelection, PaymentSheet.InitializationMode initializationMode, List orderedLpms, Duration duration, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, DefaultConstructorMarker $constructor_marker) {
            this(paymentSelection, initializationMode, orderedLpms, duration, isDeferred, linkEnabled, googlePaySupported);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LpmSerializeFailureEvent;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "errorMessage", "", "(ZZZLjava/lang/String;)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "getErrorMessage", "()Ljava/lang/String;", "eventName", "getEventName", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class LpmSerializeFailureEvent
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @Nullable
        private final String errorMessage;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public LpmSerializeFailureEvent(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, @Nullable String errorMessage) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.errorMessage = errorMessage;
            this.eventName = "luxe_serialize_failure";
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_ERROR_MESSAGE, (Object)this.errorMessage));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @Nullable
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001:\u0001 BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0014H\u0002J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0014H\u0002R\"\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u000f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u001cR\u0014\u0010\u000e\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "result", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;", "duration", "Lkotlin/time/Duration;", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "currency", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "deferredIntentConfirmationType", "Lcom/stripe/android/paymentsheet/DeferredIntentConfirmationType;", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;Lkotlin/time/Duration;Lcom/stripe/android/paymentsheet/model/PaymentSelection;Ljava/lang/String;ZZZLcom/stripe/android/paymentsheet/DeferredIntentConfirmationType;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "buildDeferredIntentConfirmationType", "errorMessage", "Result", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Payment
    extends PaymentSheetEvent {
        @NotNull
        private final Result result;
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @Nullable
        private final DeferredIntentConfirmationType deferredIntentConfirmationType;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        private Payment(EventReporter.Mode mode, Result result2, Duration duration, PaymentSelection paymentSelection, String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, DeferredIntentConfirmationType deferredIntentConfirmationType) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            super(null);
            this.result = result2;
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.deferredIntentConfirmationType = deferredIntentConfirmationType;
            this.eventName = Companion.formatEventName(mode, "payment_" + Companion.analyticsValue(paymentSelection) + "_" + this.result.getAnalyticsValue());
            Pair[] pairArray = new Pair[2];
            Duration duration2 = duration;
            pairArray[0] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_DURATION, (Object)(duration2 != null ? Float.valueOf(PaymentSheetEventKt.access$getAsSeconds-LRDsOJo(duration2.unbox-impl())) : null));
            pairArray[1] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency);
            this.additionalParams = MapsKt.plus((Map)MapsKt.plus((Map)MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), this.buildDeferredIntentConfirmationType()), (Map)PaymentSheetEventKt.access$paymentMethodInfo(paymentSelection)), this.errorMessage());
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        private final Map<String, String> buildDeferredIntentConfirmationType() {
            Map map2;
            Map map3;
            DeferredIntentConfirmationType deferredIntentConfirmationType = this.deferredIntentConfirmationType;
            if (deferredIntentConfirmationType != null) {
                DeferredIntentConfirmationType it = deferredIntentConfirmationType;
                boolean bl = false;
                map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_DEFERRED_INTENT_CONFIRMATION_TYPE, (Object)it.getValue()));
            } else {
                map3 = map2 = null;
            }
            if (map3 == null) {
                map2 = MapsKt.emptyMap();
            }
            return map2;
        }

        private final Map<String, String> errorMessage() {
            Map map2;
            Result result2 = this.result;
            if (result2 instanceof Result.Success) {
                map2 = MapsKt.emptyMap();
            } else if (result2 instanceof Result.Failure) {
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_ERROR_MESSAGE, (Object)((Result.Failure)this.result).getError().getAnalyticsValue()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return map2;
        }

        public /* synthetic */ Payment(EventReporter.Mode mode, Result result2, Duration duration, PaymentSelection paymentSelection, String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, DeferredIntentConfirmationType deferredIntentConfirmationType, DefaultConstructorMarker $constructor_marker) {
            this(mode, result2, duration, paymentSelection, currency, isDeferred, linkEnabled, googlePaySupported, deferredIntentConfirmationType);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0006\u0007R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;", "", "analyticsValue", "", "getAnalyticsValue", "()Ljava/lang/String;", "Failure", "Success", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result$Failure;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result$Success;", "paymentsheet_release"})
        public static interface Result {
            @NotNull
            public String getAnalyticsValue();

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public static final class DefaultImpls {
                @NotNull
                public static String getAnalyticsValue(@NotNull Result $this) {
                    String string2;
                    Result result2 = $this;
                    if (result2 instanceof Success) {
                        string2 = "success";
                    } else if (result2 instanceof Failure) {
                        string2 = "failure";
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    return string2;
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result$Failure;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;", "error", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;", "(Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;)V", "getError", "()Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
            @StabilityInferred(parameters=1)
            public static final class Failure
            implements Result {
                @NotNull
                private final PaymentSheetConfirmationError error;
                public static final int $stable;

                public Failure(@NotNull PaymentSheetConfirmationError error2) {
                    Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                    this.error = error2;
                }

                @NotNull
                public final PaymentSheetConfirmationError getError() {
                    return this.error;
                }

                @Override
                @NotNull
                public String getAnalyticsValue() {
                    return DefaultImpls.getAnalyticsValue(this);
                }

                @NotNull
                public final PaymentSheetConfirmationError component1() {
                    return this.error;
                }

                @NotNull
                public final Failure copy(@NotNull PaymentSheetConfirmationError error2) {
                    Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                    return new Failure(error2);
                }

                public static /* synthetic */ Failure copy$default(Failure failure, PaymentSheetConfirmationError paymentSheetConfirmationError, int n, Object object) {
                    if ((n & 1) != 0) {
                        paymentSheetConfirmationError = failure.error;
                    }
                    return failure.copy(paymentSheetConfirmationError);
                }

                @NotNull
                public String toString() {
                    return "Failure(error=" + this.error + ")";
                }

                public int hashCode() {
                    return this.error.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Failure)) {
                        return false;
                    }
                    Failure failure = (Failure)other;
                    return Intrinsics.areEqual((Object)this.error, (Object)failure.error);
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result$Success;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
            @StabilityInferred(parameters=1)
            public static final class Success
            implements Result {
                @NotNull
                public static final Success INSTANCE = new Success();
                public static final int $stable;

                private Success() {
                }

                @Override
                @NotNull
                public String getAnalyticsValue() {
                    return DefaultImpls.getAnalyticsValue(this);
                }

                @NotNull
                public String toString() {
                    return "Success";
                }

                public int hashCode() {
                    return 1616357393;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Success)) {
                        return false;
                    }
                    Success cfr_ignored_0 = (Success)other;
                    return true;
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$PaymentOptionFormInteraction;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "code", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Ljava/lang/String;ZZZ)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class PaymentOptionFormInteraction
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public PaymentOptionFormInteraction(@NotNull String code, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_form_interacted";
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_LPM, (Object)code));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001BE\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fR\"\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u000b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0016R\u0014\u0010\n\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$PressConfirmButton;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "currency", "", "duration", "Lkotlin/time/Duration;", "selectedLpm", "linkContext", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Ljava/lang/String;Lkotlin/time/Duration;Ljava/lang/String;Ljava/lang/String;ZZZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class PressConfirmButton
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        private PressConfirmButton(String currency, Duration duration, String selectedLpm, String linkContext, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_confirm_button_tapped";
            Pair[] pairArray = new Pair[4];
            Duration duration2 = duration;
            pairArray[0] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_DURATION, (Object)(duration2 != null ? Float.valueOf(PaymentSheetEventKt.access$getAsSeconds-LRDsOJo(duration2.unbox-impl())) : null));
            pairArray[1] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency);
            pairArray[2] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_LPM, (Object)selectedLpm);
            pairArray[3] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_LINK_CONTEXT, (Object)linkContext);
            this.additionalParams = MapUtilsKt.filterNotNullValues((Map)MapsKt.mapOf((Pair[])pairArray));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        public /* synthetic */ PressConfirmButton(String currency, Duration duration, String selectedLpm, String linkContext, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, DefaultConstructorMarker $constructor_marker) {
            this(currency, duration, selectedLpm, linkContext, isDeferred, linkEnabled, googlePaySupported);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tR\"\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SelectPaymentMethod;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "code", "", "currency", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Ljava/lang/String;Ljava/lang/String;ZZZ)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class SelectPaymentMethod
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public SelectPaymentMethod(@NotNull String code, @Nullable String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_carousel_payment_method_tapped";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency), TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_LPM, (Object)code)};
            this.additionalParams = MapsKt.mapOf((Pair[])pairArray);
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fR\"\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u000b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0016R\u0014\u0010\n\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SelectPaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "currency", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Lcom/stripe/android/paymentsheet/model/PaymentSelection;Ljava/lang/String;ZZZ)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class SelectPaymentOption
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public SelectPaymentOption(@NotNull EventReporter.Mode mode, @Nullable PaymentSelection paymentSelection, @Nullable String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = Companion.formatEventName(mode, "paymentoption_" + Companion.analyticsValue(paymentSelection) + "_select");
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowEditablePaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "(ZZZ)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowEditablePaymentOption
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowEditablePaymentOption(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_open_edit_screen";
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0014R\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowExistingPaymentOptions;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "currency", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Ljava/lang/String;ZZZ)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowExistingPaymentOptions
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowExistingPaymentOptions(@NotNull EventReporter.Mode mode, @Nullable String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = Companion.formatEventName(mode, "sheet_savedpm_show");
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0014R\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowNewPaymentOptionForm;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "currency", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Ljava/lang/String;ZZZ)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowNewPaymentOptionForm
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowNewPaymentOptionForm(@NotNull EventReporter.Mode mode, @Nullable String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = Companion.formatEventName(mode, "sheet_newpm_show");
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0015R\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowPaymentOptionBrands;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "source", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowPaymentOptionBrands$Source;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowPaymentOptionBrands$Source;Lcom/stripe/android/model/CardBrand;ZZZ)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "Source", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowPaymentOptionBrands
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowPaymentOptionBrands(@NotNull Source source, @NotNull CardBrand selectedBrand, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)selectedBrand, (String)"selectedBrand");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_open_cbc_dropdown";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PaymentSheetEvent.FIELD_CBC_EVENT_SOURCE, (Object)source.getValue()), TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_CARD_BRAND, (Object)selectedBrand.getCode())};
            this.additionalParams = MapsKt.mapOf((Pair[])pairArray);
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowPaymentOptionBrands$Source;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "Edit", "Add", "paymentsheet_release"})
        public static final class Source
        extends Enum<Source> {
            @NotNull
            private final String value;
            public static final /* enum */ Source Edit = new Source("edit");
            public static final /* enum */ Source Add = new Source("add");
            private static final /* synthetic */ Source[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Source(String value) {
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public static Source[] values() {
                return (Source[])$VALUES.clone();
            }

            public static Source valueOf(String value) {
                return Enum.valueOf(Source.class, value);
            }

            @NotNull
            public static EnumEntries<Source> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = sourceArray = new Source[]{Source.Edit, Source.Add};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowPaymentOptionForm;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "code", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Ljava/lang/String;ZZZ)V", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowPaymentOptionForm
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowPaymentOptionForm(@NotNull String code, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_form_shown";
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_LPM, (Object)code));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0015R\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$UpdatePaymentOptionFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "error", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Lcom/stripe/android/model/CardBrand;Ljava/lang/Throwable;ZZZ)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class UpdatePaymentOptionFailed
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public UpdatePaymentOptionFailed(@NotNull CardBrand selectedBrand, @NotNull Throwable error2, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)selectedBrand, (String)"selectedBrand");
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_update_card_failed";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_CARD_BRAND, (Object)selectedBrand.getCode()), TuplesKt.to((Object)PaymentSheetEvent.FIELD_ERROR_MESSAGE, (Object)error2.getMessage())};
            this.additionalParams = MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), (Map)ErrorReporter.Companion.getAdditionalParamsFromError(error2));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$UpdatePaymentOptionSucceeded;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "isDeferred", "", "linkEnabled", "googlePaySupported", "(Lcom/stripe/android/model/CardBrand;ZZZ)V", "additionalParams", "", "", "", "getAdditionalParams", "()Ljava/util/Map;", "eventName", "getEventName", "()Ljava/lang/String;", "getGooglePaySupported", "()Z", "getLinkEnabled", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class UpdatePaymentOptionSucceeded
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public UpdatePaymentOptionSucceeded(@NotNull CardBrand selectedBrand, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)selectedBrand, (String)"selectedBrand");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_update_card";
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_CARD_BRAND, (Object)selectedBrand.getCode()));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }
}

