/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.cvcrecollection;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.CvcRecollectionCallbackHandler;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.cvcrecollection.CvcRecollectionHandler;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.paymentdatacollection.cvcrecollection.CvcRecollectionData;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J&\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u0011\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J4\u0010\u0012\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/cvcrecollection/CvcRecollectionHandlerImpl;", "Lcom/stripe/android/paymentsheet/cvcrecollection/CvcRecollectionHandler;", "()V", "cvcRecollectionEnabled", "", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "initializationMode", "Lcom/stripe/android/paymentsheet/PaymentSheet$InitializationMode;", "deferredIntentRequiresCVCRecollection", "launch", "", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "Lkotlin/Function1;", "Lcom/stripe/android/paymentsheet/paymentdatacollection/cvcrecollection/CvcRecollectionData;", "paymentIntentRequiresCVCRecollection", "paymentSelectionIsSavedCard", "requiresCVCRecollection", "extraRequirements", "Lkotlin/Function0;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class CvcRecollectionHandlerImpl
implements CvcRecollectionHandler {
    public static final int $stable;

    @Override
    public void launch(@Nullable PaymentSelection paymentSelection, @NotNull Function1<? super CvcRecollectionData, Unit> launch) {
        Unit unit;
        Intrinsics.checkNotNullParameter(launch, (String)"launch");
        PaymentSelection.Saved saved = paymentSelection instanceof PaymentSelection.Saved ? (PaymentSelection.Saved)paymentSelection : null;
        PaymentMethod.Card card = saved != null && (saved = saved.getPaymentMethod()) != null ? ((PaymentMethod)saved).card : null;
        CvcRecollectionData cvcRecollectionData = CvcRecollectionData.Companion.fromPaymentSelection(card);
        if (cvcRecollectionData != null) {
            launch.invoke((Object)cvcRecollectionData);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("unable to create CvcRecollectionData");
        }
    }

    @Override
    public boolean cvcRecollectionEnabled(@Nullable StripeIntent stripeIntent, @Nullable PaymentSheet.InitializationMode initializationMode) {
        return this.deferredIntentRequiresCVCRecollection(initializationMode) || this.paymentIntentRequiresCVCRecollection(stripeIntent);
    }

    @Override
    public boolean requiresCVCRecollection(@Nullable StripeIntent stripeIntent, @Nullable PaymentSelection paymentSelection, @Nullable PaymentSheet.InitializationMode initializationMode, @NotNull Function0<Boolean> extraRequirements) {
        Intrinsics.checkNotNullParameter(extraRequirements, (String)"extraRequirements");
        return this.paymentSelectionIsSavedCard(paymentSelection) && this.cvcRecollectionEnabled(stripeIntent, initializationMode) && (Boolean)extraRequirements.invoke() != false;
    }

    private final boolean deferredIntentRequiresCVCRecollection(PaymentSheet.InitializationMode initializationMode) {
        return CvcRecollectionCallbackHandler.INSTANCE.isCvcRecollectionEnabledForDeferredIntent() && initializationMode instanceof PaymentSheet.InitializationMode.DeferredIntent;
    }

    private final boolean paymentIntentRequiresCVCRecollection(StripeIntent stripeIntent) {
        PaymentIntent paymentIntent = stripeIntent instanceof PaymentIntent ? (PaymentIntent)stripeIntent : null;
        return paymentIntent != null ? paymentIntent.getRequireCvcRecollection() : false;
    }

    private final boolean paymentSelectionIsSavedCard(PaymentSelection paymentSelection) {
        return paymentSelection instanceof PaymentSelection.Saved && ((PaymentSelection.Saved)paymentSelection).getPaymentMethod().type == PaymentMethod.Type.Card;
    }
}

