/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.forms;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.customersheet.CustomerSheet;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import com.stripe.android.paymentsheet.paymentdatacollection.FormArguments;
import com.stripe.android.ui.core.Amount;
import com.stripe.android.ui.core.cbc.CardBrandChoiceEligibility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/paymentsheet/forms/FormArgumentsFactory;", "", "()V", "create", "Lcom/stripe/android/paymentsheet/paymentdatacollection/FormArguments;", "paymentMethodCode", "", "Lcom/stripe/android/model/PaymentMethodCode;", "configuration", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration;", "merchantName", "cbcEligibility", "Lcom/stripe/android/ui/core/cbc/CardBrandChoiceEligibility;", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class FormArgumentsFactory {
    @NotNull
    public static final FormArgumentsFactory INSTANCE = new FormArgumentsFactory();
    public static final int $stable;

    private FormArgumentsFactory() {
    }

    @NotNull
    public final FormArguments create(@NotNull String paymentMethodCode, @NotNull PaymentMethodMetadata metadata2) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodCode, (String)"paymentMethodCode");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        String string2 = metadata2.getMerchantName();
        Amount amount = metadata2.amount();
        PaymentSheet.BillingDetails billingDetails = metadata2.getDefaultBillingDetails();
        AddressDetails addressDetails = metadata2.getShippingDetails();
        PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = metadata2.getBillingDetailsCollectionConfiguration();
        CardBrandChoiceEligibility cardBrandChoiceEligibility = metadata2.getCbcEligibility();
        return new FormArguments(paymentMethodCode, cardBrandChoiceEligibility, string2, amount, billingDetails, addressDetails, billingDetailsCollectionConfiguration);
    }

    @NotNull
    public final FormArguments create(@NotNull String paymentMethodCode, @NotNull CustomerSheet.Configuration configuration, @NotNull String merchantName, @NotNull CardBrandChoiceEligibility cbcEligibility) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodCode, (String)"paymentMethodCode");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        Intrinsics.checkNotNullParameter((Object)cbcEligibility, (String)"cbcEligibility");
        PaymentSheet.BillingDetails billingDetails = configuration.getDefaultBillingDetails();
        PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = configuration.getBillingDetailsCollectionConfiguration();
        return new FormArguments(paymentMethodCode, cbcEligibility, merchantName, null, billingDetails, null, billingDetailsCollectionConfiguration, 40, null);
    }
}

