/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.paymentdatacollection.ach;

import android.app.Application;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.core.utils.CreationExtrasKtxKt;
import com.stripe.android.financialconnections.model.BankAccount;
import com.stripe.android.financialconnections.model.FinancialConnectionsAccount;
import com.stripe.android.financialconnections.model.PaymentAccount;
import com.stripe.android.model.Address;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.PaymentMethodOptionsParams;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.payments.bankaccount.CollectBankAccountConfiguration;
import com.stripe.android.payments.bankaccount.CollectBankAccountForInstantDebitsLauncher;
import com.stripe.android.payments.bankaccount.CollectBankAccountLauncher;
import com.stripe.android.payments.bankaccount.navigation.CollectBankAccountForInstantDebitsResult;
import com.stripe.android.payments.bankaccount.navigation.CollectBankAccountResponseInternal;
import com.stripe.android.payments.bankaccount.navigation.CollectBankAccountResultInternal;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import com.stripe.android.paymentsheet.addresselement.AddressDetailsKt;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.paymentdatacollection.FormArguments;
import com.stripe.android.paymentsheet.paymentdatacollection.ach.TransformToBankIcon;
import com.stripe.android.paymentsheet.paymentdatacollection.ach.USBankAccountFormScreenState;
import com.stripe.android.paymentsheet.paymentdatacollection.ach.USBankAccountFormViewModel;
import com.stripe.android.paymentsheet.paymentdatacollection.ach.USBankAccountFormViewModelKt;
import com.stripe.android.paymentsheet.paymentdatacollection.ach.USBankAccountTextBuilder;
import com.stripe.android.paymentsheet.paymentdatacollection.ach.di.DaggerUSBankAccountFormComponent;
import com.stripe.android.paymentsheet.paymentdatacollection.ach.di.USBankAccountFormViewModelSubcomponent;
import com.stripe.android.ui.core.Amount;
import com.stripe.android.ui.core.R;
import com.stripe.android.ui.core.elements.SaveForFutureUseElement;
import com.stripe.android.uicore.elements.AddressElement;
import com.stripe.android.uicore.elements.EmailConfig;
import com.stripe.android.uicore.elements.IdentifierSpec;
import com.stripe.android.uicore.elements.NameConfig;
import com.stripe.android.uicore.elements.PhoneNumberController;
import com.stripe.android.uicore.elements.SameAsShippingController;
import com.stripe.android.uicore.elements.SameAsShippingElement;
import com.stripe.android.uicore.elements.TextFieldController;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u0089\u00012\u00020\u0001:\u0006\u0088\u0001\u0089\u0001\u008a\u0001B-\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010e\u001a\u00020fH\u0002J\b\u0010g\u001a\u00020fH\u0002J\u0012\u0010h\u001a\u00020i2\b\u0010j\u001a\u0004\u0018\u000106H\u0002J\b\u0010k\u001a\u00020iH\u0002J\u0010\u0010l\u001a\u00020i2\u0006\u0010j\u001a\u000206H\u0002J \u0010m\u001a\u00020\u00132\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u0002062\u0006\u0010q\u001a\u000206H\u0002J\b\u0010r\u001a\u00020\u0011H\u0002J\u0006\u0010s\u001a\u000206J\u0010\u0010t\u001a\u00020i2\u0006\u0010V\u001a\u00020\u000eH\u0007J\u0010\u0010u\u001a\u00020i2\u0006\u0010V\u001a\u00020vH\u0002J\u0010\u0010w\u001a\u00020i2\u0006\u0010V\u001a\u00020xH\u0002J\u0010\u0010y\u001a\u00020i2\u0006\u0010V\u001a\u00020zH\u0002J\u000e\u0010{\u001a\u00020i2\u0006\u0010|\u001a\u00020\u0011J\u001b\u0010}\u001a\u00020i2\u0006\u0010~\u001a\u00020\u007f2\t\u0010\u0080\u0001\u001a\u0004\u0018\u000106H\u0002J\u0007\u0010\u0081\u0001\u001a\u00020iJ\u0011\u0010\u0082\u0001\u001a\u00020i2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J\u0014\u0010\u0085\u0001\u001a\u00020i2\u000b\b\u0002\u0010\u0086\u0001\u001a\u0004\u0018\u00010fJ%\u0010\u0087\u0001\u001a\u00020i2\u0006\u0010n\u001a\u00020o2\b\u0010q\u001a\u0004\u0018\u0001062\b\u0010p\u001a\u0004\u0018\u000106H\u0002R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001d\u001a\u0004\u0018\u00010\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0019\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0018R\u0010\u00102\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000106X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000106X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u000106X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001060\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0018R\u0011\u0010=\u001a\u00020>\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R$\u0010B\u001a\u00020*2\u0006\u0010A\u001a\u00020*8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u0019\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010H0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\u0018R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010J\u001a\b\u0012\u0004\u0012\u0002060\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u0018R\u0011\u0010L\u001a\u00020>\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010@R\u0019\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001060\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u0018R\u0011\u0010P\u001a\u00020Q\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u0017\u0010T\u001a\b\u0012\u0004\u0012\u00020*0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u0018R\u0019\u0010V\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130&\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010(R\u0013\u0010X\u001a\u0004\u0018\u00010Y\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010[R\u0017\u0010\\\u001a\b\u0012\u0004\u0012\u00020*0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\u0018R\u0011\u0010^\u001a\u00020_\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010aR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010b\u001a\u00020*2\u0006\u0010A\u001a\u00020*8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bc\u0010D\"\u0004\bd\u0010F\u00a8\u0006\u008b\u0001"}, d2={"Lcom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountFormViewModel;", "Landroidx/lifecycle/ViewModel;", "args", "Lcom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountFormViewModel$Args;", "application", "Landroid/app/Application;", "lazyPaymentConfig", "Ljavax/inject/Provider;", "Lcom/stripe/android/PaymentConfiguration;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Lcom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountFormViewModel$Args;Landroid/app/Application;Ljavax/inject/Provider;Landroidx/lifecycle/SavedStateHandle;)V", "_collectBankAccountResult", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountResultInternal;", "_currentScreenState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountFormScreenState;", "_result", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$New$USBankAccount;", "address", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/model/Address;", "getAddress", "()Lkotlinx/coroutines/flow/StateFlow;", "addressElement", "Lcom/stripe/android/uicore/elements/AddressElement;", "getAddressElement", "()Lcom/stripe/android/uicore/elements/AddressElement;", "collectBankAccountLauncher", "Lcom/stripe/android/payments/bankaccount/CollectBankAccountLauncher;", "getCollectBankAccountLauncher$annotations", "()V", "getCollectBankAccountLauncher", "()Lcom/stripe/android/payments/bankaccount/CollectBankAccountLauncher;", "setCollectBankAccountLauncher", "(Lcom/stripe/android/payments/bankaccount/CollectBankAccountLauncher;)V", "collectBankAccountResult", "Lkotlinx/coroutines/flow/Flow;", "getCollectBankAccountResult", "()Lkotlinx/coroutines/flow/Flow;", "collectingAddress", "", "collectingEmail", "collectingName", "collectingPhone", "collectionConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "currentScreenState", "getCurrentScreenState", "defaultAddress", "defaultBillingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "defaultEmail", "", "defaultName", "defaultPhone", "defaultPhoneCountry", "defaultSaveForFutureUse", "email", "getEmail", "emailController", "Lcom/stripe/android/uicore/elements/TextFieldController;", "getEmailController", "()Lcom/stripe/android/uicore/elements/TextFieldController;", "value", "hasLaunched", "getHasLaunched", "()Z", "setHasLaunched", "(Z)V", "lastTextFieldIdentifier", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "getLastTextFieldIdentifier", "name", "getName", "nameController", "getNameController", "phone", "getPhone", "phoneController", "Lcom/stripe/android/uicore/elements/PhoneNumberController;", "getPhoneController", "()Lcom/stripe/android/uicore/elements/PhoneNumberController;", "requiredFields", "getRequiredFields", "result", "getResult", "sameAsShippingElement", "Lcom/stripe/android/uicore/elements/SameAsShippingElement;", "getSameAsShippingElement", "()Lcom/stripe/android/uicore/elements/SameAsShippingElement;", "saveForFutureUse", "getSaveForFutureUse", "saveForFutureUseElement", "Lcom/stripe/android/ui/core/elements/SaveForFutureUseElement;", "getSaveForFutureUseElement", "()Lcom/stripe/android/ui/core/elements/SaveForFutureUseElement;", "shouldReset", "getShouldReset", "setShouldReset", "buildMandateText", "Lcom/stripe/android/core/strings/ResolvableString;", "buildPrimaryButtonText", "collectBankAccount", "", "clientSecret", "collectBankAccountForDeferredIntent", "collectBankAccountForIntent", "createNewPaymentSelection", "resultIdentifier", "Lcom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountFormScreenState$ResultIdentifier;", "last4", "bankName", "determineInitialState", "formattedMerchantName", "handleCollectBankAccountResult", "handleCompletedBankAccountResult", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountResultInternal$Completed;", "handleCompletedInstantDebitsResult", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountForInstantDebitsResult$Completed;", "handleInstantDebitsResult", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountForInstantDebitsResult;", "handlePrimaryButtonClick", "screenState", "handleResultForACH", "usBankAccountData", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountResponseInternal$USBankAccountData;", "intentId", "onDestroy", "register", "activityResultRegistryOwner", "Landroidx/activity/result/ActivityResultRegistryOwner;", "reset", "error", "updatePaymentSelection", "Args", "Companion", "Factory", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nUSBankAccountFormViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 USBankAccountFormViewModel.kt\ncom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountFormViewModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,710:1\n230#2,5:711\n230#2,5:716\n230#2,5:721\n230#2,5:726\n230#2,5:731\n141#3:736\n130#3,5:737\n*S KotlinDebug\n*F\n+ 1 USBankAccountFormViewModel.kt\ncom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountFormViewModel\n*L\n322#1:711,5\n340#1:716,5\n352#1:721,5\n375#1:726,5\n416#1:731,5\n436#1:736\n436#1:737,5\n*E\n"})
public final class USBankAccountFormViewModel
extends ViewModel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Args args;
    @NotNull
    private final Application application;
    @NotNull
    private final Provider<PaymentConfiguration> lazyPaymentConfig;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @Nullable
    private final PaymentSheet.BillingDetails defaultBillingDetails;
    @NotNull
    private final PaymentSheet.BillingDetailsCollectionConfiguration collectionConfiguration;
    private final boolean collectingAddress;
    private final boolean collectingPhone;
    private final boolean collectingName;
    private final boolean collectingEmail;
    @Nullable
    private final String defaultName;
    @NotNull
    private final TextFieldController nameController;
    @NotNull
    private final StateFlow<String> name;
    @Nullable
    private final String defaultEmail;
    @NotNull
    private final TextFieldController emailController;
    @NotNull
    private final StateFlow<String> email;
    @Nullable
    private final String defaultPhoneCountry;
    @Nullable
    private final String defaultPhone;
    @NotNull
    private final PhoneNumberController phoneController;
    @NotNull
    private final StateFlow<String> phone;
    @Nullable
    private final Address defaultAddress;
    @Nullable
    private final SameAsShippingElement sameAsShippingElement;
    @NotNull
    private final AddressElement addressElement;
    @NotNull
    private final StateFlow<Address> address;
    @NotNull
    private final StateFlow<IdentifierSpec> lastTextFieldIdentifier;
    @NotNull
    private final MutableSharedFlow<PaymentSelection.New.USBankAccount> _result;
    @NotNull
    private final Flow<PaymentSelection.New.USBankAccount> result;
    @NotNull
    private final MutableSharedFlow<CollectBankAccountResultInternal> _collectBankAccountResult;
    @NotNull
    private final Flow<CollectBankAccountResultInternal> collectBankAccountResult;
    private final boolean defaultSaveForFutureUse;
    @NotNull
    private final SaveForFutureUseElement saveForFutureUseElement;
    @NotNull
    private final StateFlow<Boolean> saveForFutureUse;
    @NotNull
    private final MutableStateFlow<USBankAccountFormScreenState> _currentScreenState;
    @NotNull
    private final StateFlow<USBankAccountFormScreenState> currentScreenState;
    @NotNull
    private final StateFlow<Boolean> requiredFields;
    @Nullable
    private CollectBankAccountLauncher collectBankAccountLauncher;
    public static final int $stable = 8;
    @NotNull
    private static final String HAS_LAUNCHED_KEY = "has_launched";
    @NotNull
    private static final String SHOULD_RESET_KEY = "should_reset";

    /*
     * WARNING - void declaration
     */
    @Inject
    public USBankAccountFormViewModel(@NotNull Args args2, @NotNull Application application, @NotNull Provider<PaymentConfiguration> lazyPaymentConfig, @NotNull SavedStateHandle savedStateHandle) {
        boolean bl;
        SameAsShippingElement sameAsShippingElement;
        Boolean bl2;
        Object object;
        String string2;
        String string3;
        Object object2;
        String string4;
        String string5;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter(lazyPaymentConfig, (String)"lazyPaymentConfig");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.args = args2;
        this.application = application;
        this.lazyPaymentConfig = lazyPaymentConfig;
        this.savedStateHandle = savedStateHandle;
        this.defaultBillingDetails = this.args.getFormArgs().getBillingDetails();
        this.collectionConfiguration = this.args.getFormArgs().getBillingDetailsCollectionConfiguration();
        this.collectingAddress = this.args.getFormArgs().getBillingDetailsCollectionConfiguration().getAddress() == PaymentSheet.BillingDetailsCollectionConfiguration.AddressCollectionMode.Full;
        this.collectingPhone = this.args.getFormArgs().getBillingDetailsCollectionConfiguration().getPhone() == PaymentSheet.BillingDetailsCollectionConfiguration.CollectionMode.Always;
        this.collectingName = this.args.getFormArgs().getBillingDetailsCollectionConfiguration().getName() != PaymentSheet.BillingDetailsCollectionConfiguration.CollectionMode.Never;
        boolean bl3 = this.collectingEmail = this.args.getFormArgs().getBillingDetailsCollectionConfiguration().getEmail() != PaymentSheet.BillingDetailsCollectionConfiguration.CollectionMode.Never;
        if (this.args.getSavedPaymentMethod() != null) {
            string5 = this.args.getSavedPaymentMethod().getInput().getName();
        } else if (this.collectingName || this.collectionConfiguration.getAttachDefaultsToPaymentMethod()) {
            PaymentSheet.BillingDetails billingDetails = this.defaultBillingDetails;
            string5 = billingDetails != null ? billingDetails.getName() : null;
        } else {
            string5 = null;
        }
        this.defaultName = string5;
        this.nameController = (TextFieldController)NameConfig.Companion.createController(this.defaultName);
        this.name = StateFlowsKt.mapAsStateFlow((StateFlow)this.nameController.getFormFieldValue(), (Function1)name.1.INSTANCE);
        if (this.args.getSavedPaymentMethod() != null) {
            string4 = this.args.getSavedPaymentMethod().getInput().getEmail();
        } else if (this.collectingEmail || this.collectionConfiguration.getAttachDefaultsToPaymentMethod()) {
            PaymentSheet.BillingDetails billingDetails = this.defaultBillingDetails;
            string4 = billingDetails != null ? billingDetails.getEmail() : null;
        } else {
            string4 = this.defaultEmail = null;
        }
        if ((object2 = this.args.getSavedPaymentMethod()) == null || (object2 = ((PaymentSelection.New.USBankAccount)object2).getInput()) == null || (object2 = ((PaymentSelection.New.USBankAccount.Input)object2).getEmail()) == null) {
            object2 = this.defaultEmail;
        }
        this.emailController = (TextFieldController)EmailConfig.Companion.createController$default((EmailConfig.Companion)EmailConfig.Companion, (String)object2, (boolean)false, (int)2, null);
        this.email = StateFlowsKt.mapAsStateFlow((StateFlow)this.emailController.getFormFieldValue(), (Function1)email.1.INSTANCE);
        if (this.args.getSavedPaymentMethod() != null) {
            Address address2 = this.args.getSavedPaymentMethod().getInput().getAddress();
            string3 = address2 != null ? address2.getCountry() : null;
        } else {
            Object object3;
            string3 = this.collectingPhone || this.collectionConfiguration.getAttachDefaultsToPaymentMethod() ? ((object3 = this.defaultBillingDetails) != null && (object3 = ((PaymentSheet.BillingDetails)object3).getAddress()) != null ? ((PaymentSheet.Address)object3).getCountry() : null) : (this.defaultPhoneCountry = null);
        }
        if (this.args.getSavedPaymentMethod() != null) {
            string2 = this.args.getSavedPaymentMethod().getInput().getPhone();
        } else if (this.collectingPhone || this.collectionConfiguration.getAttachDefaultsToPaymentMethod()) {
            PaymentSheet.BillingDetails billingDetails = this.defaultBillingDetails;
            string2 = billingDetails != null ? billingDetails.getPhone() : null;
        } else {
            string2 = null;
        }
        this.defaultPhone = string2;
        Object object4 = PhoneNumberController.Companion;
        Object object5 = this.defaultPhoneCountry;
        String string6 = this.defaultPhone;
        if (string6 == null) {
            string6 = "";
        }
        String string7 = string6;
        this.phoneController = PhoneNumberController.Companion.createPhoneNumberController$default((PhoneNumberController.Companion)object4, (String)string7, (String)object5, null, (boolean)false, (boolean)false, (int)28, null);
        this.phone = StateFlowsKt.mapAsStateFlow((StateFlow)this.phoneController.getFormFieldValue(), (Function1)phone.1.INSTANCE);
        this.defaultAddress = this.args.getSavedPaymentMethod() != null ? this.args.getSavedPaymentMethod().getInput().getAddress() : (this.collectingAddress || this.collectionConfiguration.getAttachDefaultsToPaymentMethod() ? ((object = this.defaultBillingDetails) != null && (object = object.getAddress()) != null ? USBankAccountFormViewModelKt.asAddressModel((PaymentSheet.Address)object) : null) : null);
        USBankAccountFormViewModel uSBankAccountFormViewModel = this;
        object4 = this.args.getFormArgs().getShippingDetails();
        if (object4 != null && (object5 = AddressDetailsKt.toIdentifierMap((AddressDetails)object4, this.defaultBillingDetails)) != null && (string7 = (String)object5.get(IdentifierSpec.Companion.getSameAsShipping())) != null && (bl2 = StringsKt.toBooleanStrictOrNull((String)string7)) != null) {
            void it;
            boolean bl4 = bl2;
            USBankAccountFormViewModel uSBankAccountFormViewModel2 = uSBankAccountFormViewModel;
            boolean bl5 = false;
            sameAsShippingElement = new SameAsShippingElement(IdentifierSpec.Companion.getSameAsShipping(), new SameAsShippingController((boolean)it));
            uSBankAccountFormViewModel = uSBankAccountFormViewModel2;
        } else {
            sameAsShippingElement = null;
        }
        uSBankAccountFormViewModel.sameAsShippingElement = sameAsShippingElement;
        IdentifierSpec identifierSpec = IdentifierSpec.Companion.Generic("billing_details[address]");
        Object object6 = this.defaultAddress;
        if (object6 == null || (object6 = USBankAccountFormViewModelKt.asFormFieldValues(object6)) == null) {
            object6 = MapsKt.emptyMap();
        }
        AddressDetails addressDetails = this.args.getFormArgs().getShippingDetails();
        this.addressElement = new AddressElement(identifierSpec, (Map)object6, null, null, null, this.sameAsShippingElement, addressDetails != null ? AddressDetailsKt.toIdentifierMap(addressDetails, this.args.getFormArgs().getBillingDetails()) : null, null, false, 412, null);
        StateFlow stateFlow = this.address = this.defaultAddress == null ? (StateFlow)StateFlowKt.MutableStateFlow(null) : StateFlowsKt.mapAsStateFlow((StateFlow)this.addressElement.getFormFieldValueFlow(), (Function1)address.1.INSTANCE);
        this.lastTextFieldIdentifier = this.collectingAddress ? StateFlowsKt.mapAsStateFlow((StateFlow)this.addressElement.getTextFieldIdentifiers(), (Function1)lastTextFieldIdentifier.1.INSTANCE) : (this.collectingPhone ? StateFlowsKt.stateFlowOf((Object)IdentifierSpec.Companion.getPhone()) : (this.collectingEmail ? StateFlowsKt.stateFlowOf((Object)IdentifierSpec.Companion.getEmail()) : (this.collectingName ? StateFlowsKt.stateFlowOf((Object)IdentifierSpec.Companion.getName()) : StateFlowsKt.stateFlowOf(null))));
        this._result = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.result = (Flow)this._result;
        this._collectBankAccountResult = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.collectBankAccountResult = (Flow)this._collectBankAccountResult;
        Object object7 = this.args.getSavedPaymentMethod();
        this.defaultSaveForFutureUse = object7 != null && (object7 = ((PaymentSelection.New.USBankAccount)object7).getInput()) != null ? ((PaymentSelection.New.USBankAccount.Input)object7).getSaveForFutureUse() : false;
        this.saveForFutureUseElement = new SaveForFutureUseElement(this.defaultSaveForFutureUse, this.args.getFormArgs().getMerchantName());
        this.saveForFutureUse = this.saveForFutureUseElement.getController().getSaveForFutureUse();
        this._currentScreenState = StateFlowKt.MutableStateFlow((Object)this.determineInitialState());
        this.currentScreenState = (StateFlow)this._currentScreenState;
        this.requiredFields = StateFlowsKt.combineAsStateFlow((StateFlow)StateFlowsKt.mapAsStateFlow((StateFlow)this.nameController.getFormFieldValue(), (Function1)requiredFields.1.INSTANCE), (StateFlow)StateFlowsKt.mapAsStateFlow((StateFlow)this.emailController.getFormFieldValue(), (Function1)requiredFields.2.INSTANCE), (StateFlow)StateFlowsKt.mapAsStateFlow((StateFlow)this.phoneController.getFormFieldValue(), (Function1)requiredFields.3.INSTANCE), (StateFlow)StateFlowsKt.mapAsStateFlow((StateFlow)this.addressElement.getFormFieldValueFlow(), (Function1)requiredFields.4.INSTANCE), (Function4)((Function4)new Function4<Boolean, Boolean, Boolean, Boolean, Boolean>(this){
            final /* synthetic */ USBankAccountFormViewModel this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            @NotNull
            public final Boolean invoke(boolean validName, boolean validEmail, boolean validPhone, boolean validAddress) {
                boolean validBaseInfo = USBankAccountFormViewModel.access$getArgs$p(this.this$0).getInstantDebits() ? validEmail : validName && validEmail;
                boolean validAddressInfo = !(!validPhone && USBankAccountFormViewModel.access$getCollectionConfiguration$p(this.this$0).getPhone() == PaymentSheet.BillingDetailsCollectionConfiguration.CollectionMode.Always || !validAddress && USBankAccountFormViewModel.access$getCollectionConfiguration$p(this.this$0).getAddress() == PaymentSheet.BillingDetailsCollectionConfiguration.AddressCollectionMode.Full);
                return validBaseInfo && validAddressInfo;
            }
        }));
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ USBankAccountFormViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getAddressElement().getCountryElement().getController().getRawFieldValue().collect(new FlowCollector(){

                            @Nullable
                            public final Object emit(@Nullable String it, @NotNull Continuation<? super Unit> $completion) {
                                block0: {
                                    String string2 = it;
                                    if (string2 == null) break block0;
                                    String string3 = string2;
                                    USBankAccountFormViewModel uSBankAccountFormViewModel = this$0;
                                    String it2 = string3;
                                    boolean bl = false;
                                    uSBankAccountFormViewModel.getPhoneController().getCountryDropdownController().onRawValueChange(it2);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        PaymentSheet.BillingDetails billingDetails = this.args.getFormArgs().getBillingDetails();
        boolean hasDefaultName = (billingDetails != null ? billingDetails.getName() : null) != null && this.args.getFormArgs().getBillingDetailsCollectionConfiguration().getAttachDefaultsToPaymentMethod();
        PaymentSheet.BillingDetails billingDetails2 = this.args.getFormArgs().getBillingDetails();
        boolean hasDefaultEmail = (billingDetails2 != null ? billingDetails2.getEmail() : null) != null && this.args.getFormArgs().getBillingDetailsCollectionConfiguration().getAttachDefaultsToPaymentMethod();
        boolean bl6 = bl = !(!hasDefaultName && !this.collectingName || !hasDefaultEmail && !this.collectingEmail);
        if (_Assertions.ENABLED && !bl) {
            boolean bl7 = false;
            String string8 = "If name or email are not collected, they must be provided through defaults";
            throw new AssertionError((Object)string8);
        }
    }

    @NotNull
    public final TextFieldController getNameController() {
        return this.nameController;
    }

    @NotNull
    public final StateFlow<String> getName() {
        return this.name;
    }

    @NotNull
    public final TextFieldController getEmailController() {
        return this.emailController;
    }

    @NotNull
    public final StateFlow<String> getEmail() {
        return this.email;
    }

    @NotNull
    public final PhoneNumberController getPhoneController() {
        return this.phoneController;
    }

    @NotNull
    public final StateFlow<String> getPhone() {
        return this.phone;
    }

    @Nullable
    public final SameAsShippingElement getSameAsShippingElement() {
        return this.sameAsShippingElement;
    }

    @NotNull
    public final AddressElement getAddressElement() {
        return this.addressElement;
    }

    @NotNull
    public final StateFlow<Address> getAddress() {
        return this.address;
    }

    @NotNull
    public final StateFlow<IdentifierSpec> getLastTextFieldIdentifier() {
        return this.lastTextFieldIdentifier;
    }

    @NotNull
    public final Flow<PaymentSelection.New.USBankAccount> getResult() {
        return this.result;
    }

    @NotNull
    public final Flow<CollectBankAccountResultInternal> getCollectBankAccountResult() {
        return this.collectBankAccountResult;
    }

    @NotNull
    public final SaveForFutureUseElement getSaveForFutureUseElement() {
        return this.saveForFutureUseElement;
    }

    @NotNull
    public final StateFlow<Boolean> getSaveForFutureUse() {
        return this.saveForFutureUse;
    }

    @NotNull
    public final StateFlow<USBankAccountFormScreenState> getCurrentScreenState() {
        return this.currentScreenState;
    }

    @NotNull
    public final StateFlow<Boolean> getRequiredFields() {
        return this.requiredFields;
    }

    @Nullable
    public final CollectBankAccountLauncher getCollectBankAccountLauncher() {
        return this.collectBankAccountLauncher;
    }

    public final void setCollectBankAccountLauncher(@Nullable CollectBankAccountLauncher collectBankAccountLauncher) {
        this.collectBankAccountLauncher = collectBankAccountLauncher;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCollectBankAccountLauncher$annotations() {
    }

    private final boolean getHasLaunched() {
        return Intrinsics.areEqual((Object)this.savedStateHandle.get(HAS_LAUNCHED_KEY), (Object)true);
    }

    private final void setHasLaunched(boolean value) {
        this.savedStateHandle.set(HAS_LAUNCHED_KEY, (Object)value);
    }

    private final boolean getShouldReset() {
        return Intrinsics.areEqual((Object)this.savedStateHandle.get(SHOULD_RESET_KEY), (Object)true);
    }

    private final void setShouldReset(boolean value) {
        this.savedStateHandle.set(SHOULD_RESET_KEY, (Object)value);
    }

    public final void register(@NotNull ActivityResultRegistryOwner activityResultRegistryOwner) {
        Intrinsics.checkNotNullParameter((Object)activityResultRegistryOwner, (String)"activityResultRegistryOwner");
        this.collectBankAccountLauncher = this.args.getInstantDebits() ? CollectBankAccountForInstantDebitsLauncher.Companion.createForPaymentSheet(this.args.getHostedSurface(), activityResultRegistryOwner, (Function1)new Function1<CollectBankAccountForInstantDebitsResult, Unit>((Object)this){

            public final void invoke(@NotNull CollectBankAccountForInstantDebitsResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                USBankAccountFormViewModel.access$handleInstantDebitsResult((USBankAccountFormViewModel)((Object)this.receiver), p0);
            }
        }) : CollectBankAccountLauncher.Companion.createForPaymentSheet(this.args.getHostedSurface(), activityResultRegistryOwner, (Function1)new Function1<CollectBankAccountResultInternal, Unit>((Object)this){

            public final void invoke(@NotNull CollectBankAccountResultInternal p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((USBankAccountFormViewModel)((Object)this.receiver)).handleCollectBankAccountResult(p0);
            }
        });
    }

    @VisibleForTesting
    public final void handleCollectBankAccountResult(@NotNull CollectBankAccountResultInternal result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.setHasLaunched(false);
        this._collectBankAccountResult.tryEmit((Object)result2);
        CollectBankAccountResultInternal collectBankAccountResultInternal = result2;
        if (collectBankAccountResultInternal instanceof CollectBankAccountResultInternal.Completed) {
            this.handleCompletedBankAccountResult((CollectBankAccountResultInternal.Completed)result2);
        } else if (collectBankAccountResultInternal instanceof CollectBankAccountResultInternal.Failed) {
            this.reset(ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_paymentsheet_ach_something_went_wrong));
        } else if (collectBankAccountResultInternal instanceof CollectBankAccountResultInternal.Cancelled) {
            USBankAccountFormViewModel.reset$default(this, null, 1, null);
        }
    }

    private final void handleInstantDebitsResult(CollectBankAccountForInstantDebitsResult result2) {
        this.setHasLaunched(false);
        CollectBankAccountForInstantDebitsResult collectBankAccountForInstantDebitsResult = result2;
        if (collectBankAccountForInstantDebitsResult instanceof CollectBankAccountForInstantDebitsResult.Completed) {
            this.handleCompletedInstantDebitsResult((CollectBankAccountForInstantDebitsResult.Completed)result2);
        } else if (collectBankAccountForInstantDebitsResult instanceof CollectBankAccountForInstantDebitsResult.Failed) {
            this.reset(ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_paymentsheet_ach_something_went_wrong));
        } else if (collectBankAccountForInstantDebitsResult instanceof CollectBankAccountForInstantDebitsResult.Cancelled) {
            USBankAccountFormViewModel.reset$default(this, null, 1, null);
        }
    }

    private final void handleCompletedBankAccountResult(CollectBankAccountResultInternal.Completed result2) {
        StripeIntent stripeIntent = result2.getResponse().getIntent();
        String intentId = stripeIntent != null ? stripeIntent.getId() : null;
        CollectBankAccountResponseInternal.USBankAccountData usBankAccountData = result2.getResponse().getUsBankAccountData();
        if (usBankAccountData != null) {
            this.handleResultForACH(usBankAccountData, intentId);
        } else {
            this.reset(ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_paymentsheet_ach_something_went_wrong));
        }
    }

    private final void handleCompletedInstantDebitsResult(CollectBankAccountForInstantDebitsResult.Completed result2) {
        USBankAccountFormScreenState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<USBankAccountFormScreenState> $this$update$iv = this._currentScreenState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            USBankAccountFormScreenState it = (USBankAccountFormScreenState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (USBankAccountFormScreenState)new USBankAccountFormScreenState.MandateCollection(new USBankAccountFormScreenState.ResultIdentifier.PaymentMethod(result2.getPaymentMethodId()), result2.getBankName(), result2.getLast4(), result2.getIntent().getId(), this.buildPrimaryButtonText(), this.buildMandateText()))));
    }

    private final void handleResultForACH(CollectBankAccountResponseInternal.USBankAccountData usBankAccountData, String intentId) {
        PaymentAccount paymentAccount = usBankAccountData.getFinancialConnectionsSession().getPaymentAccount();
        if (paymentAccount instanceof BankAccount) {
            USBankAccountFormScreenState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<USBankAccountFormScreenState> $this$update$iv = this._currentScreenState;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                USBankAccountFormScreenState it = (USBankAccountFormScreenState)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (USBankAccountFormScreenState)new USBankAccountFormScreenState.VerifyWithMicrodeposits((BankAccount)paymentAccount, usBankAccountData.getFinancialConnectionsSession().getId(), intentId, this.buildPrimaryButtonText(), this.buildMandateText()))));
        } else if (paymentAccount instanceof FinancialConnectionsAccount) {
            USBankAccountFormScreenState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<USBankAccountFormScreenState> $this$update$iv = this._currentScreenState;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                USBankAccountFormScreenState it = (USBankAccountFormScreenState)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (USBankAccountFormScreenState)new USBankAccountFormScreenState.MandateCollection(new USBankAccountFormScreenState.ResultIdentifier.Session(usBankAccountData.getFinancialConnectionsSession().getId()), ((FinancialConnectionsAccount)paymentAccount).getInstitutionName(), ((FinancialConnectionsAccount)paymentAccount).getLast4(), intentId, this.buildPrimaryButtonText(), this.buildMandateText()))));
        } else if (paymentAccount == null) {
            this.reset(ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_paymentsheet_ach_something_went_wrong));
        }
    }

    public final void handlePrimaryButtonClick(@NotNull USBankAccountFormScreenState screenState) {
        block3: {
            USBankAccountFormScreenState uSBankAccountFormScreenState;
            block5: {
                block4: {
                    block2: {
                        USBankAccountFormScreenState nextValue$iv;
                        Object prevValue$iv;
                        Intrinsics.checkNotNullParameter((Object)screenState, (String)"screenState");
                        uSBankAccountFormScreenState = screenState;
                        if (!(uSBankAccountFormScreenState instanceof USBankAccountFormScreenState.BillingDetailsCollection)) break block2;
                        MutableStateFlow<USBankAccountFormScreenState> $this$update$iv = this._currentScreenState;
                        boolean $i$f$update = false;
                        do {
                            prevValue$iv = $this$update$iv.getValue();
                            USBankAccountFormScreenState it = (USBankAccountFormScreenState)prevValue$iv;
                            boolean bl = false;
                        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (USBankAccountFormScreenState)USBankAccountFormScreenState.BillingDetailsCollection.copy$default((USBankAccountFormScreenState.BillingDetailsCollection)screenState, null, null, true, 3, null))));
                        this.collectBankAccount(this.args.getClientSecret());
                        break block3;
                    }
                    if (!(uSBankAccountFormScreenState instanceof USBankAccountFormScreenState.MandateCollection)) break block4;
                    this.updatePaymentSelection(((USBankAccountFormScreenState.MandateCollection)screenState).getResultIdentifier(), ((USBankAccountFormScreenState.MandateCollection)screenState).getBankName(), ((USBankAccountFormScreenState.MandateCollection)screenState).getLast4());
                    break block3;
                }
                if (!(uSBankAccountFormScreenState instanceof USBankAccountFormScreenState.VerifyWithMicrodeposits)) break block5;
                this.updatePaymentSelection(new USBankAccountFormScreenState.ResultIdentifier.Session(((USBankAccountFormScreenState.VerifyWithMicrodeposits)screenState).getFinancialConnectionsSessionId()), ((USBankAccountFormScreenState.VerifyWithMicrodeposits)screenState).getPaymentAccount().getBankName(), ((USBankAccountFormScreenState.VerifyWithMicrodeposits)screenState).getPaymentAccount().getLast4());
                break block3;
            }
            if (!(uSBankAccountFormScreenState instanceof USBankAccountFormScreenState.SavedAccount)) break block3;
            String string2 = ((USBankAccountFormScreenState.SavedAccount)screenState).getFinancialConnectionsSessionId();
            if (string2 != null) {
                String linkAccountId = string2;
                boolean bl = false;
                this.updatePaymentSelection(new USBankAccountFormScreenState.ResultIdentifier.Session(linkAccountId), ((USBankAccountFormScreenState.SavedAccount)screenState).getBankName(), ((USBankAccountFormScreenState.SavedAccount)screenState).getLast4());
            }
        }
    }

    public final void reset(@Nullable ResolvableString error2) {
        USBankAccountFormScreenState nextValue$iv;
        Object prevValue$iv;
        this.setHasLaunched(false);
        this.setShouldReset(false);
        this.saveForFutureUseElement.getController().onValueChange(true);
        this._collectBankAccountResult.tryEmit(null);
        MutableStateFlow<USBankAccountFormScreenState> $this$update$iv = this._currentScreenState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            USBankAccountFormScreenState it = (USBankAccountFormScreenState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (USBankAccountFormScreenState)new USBankAccountFormScreenState.BillingDetailsCollection(error2, ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_continue_button_label), false))));
    }

    public static /* synthetic */ void reset$default(USBankAccountFormViewModel uSBankAccountFormViewModel, ResolvableString resolvableString, int n, Object object) {
        if ((n & 1) != 0) {
            resolvableString = null;
        }
        uSBankAccountFormViewModel.reset(resolvableString);
    }

    public final void onDestroy() {
        if (this.getShouldReset()) {
            USBankAccountFormViewModel.reset$default(this, null, 1, null);
        }
        this._result.tryEmit(null);
        this._collectBankAccountResult.tryEmit(null);
        CollectBankAccountLauncher collectBankAccountLauncher = this.collectBankAccountLauncher;
        if (collectBankAccountLauncher != null) {
            collectBankAccountLauncher.unregister();
        }
        this.collectBankAccountLauncher = null;
    }

    @NotNull
    public final String formattedMerchantName() {
        CharSequence charSequence;
        block2: {
            String $this$trimEnd$iv = this.args.getFormArgs().getMerchantName();
            boolean $i$f$trimEnd = false;
            CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
            boolean $i$f$trimEnd2 = false;
            int n = $this$trimEnd$iv$iv.length() + -1;
            if (0 <= n) {
                do {
                    int index$iv$iv = n--;
                    char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (it == '.') continue;
                    charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                    break block2;
                } while (0 <= n);
            }
            charSequence = "";
        }
        return ((Object)charSequence).toString();
    }

    private final USBankAccountFormScreenState determineInitialState() {
        return this.args.getSavedPaymentMethod() != null ? this.args.getSavedPaymentMethod().getScreenState() : (USBankAccountFormScreenState)new USBankAccountFormScreenState.BillingDetailsCollection(null, ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_continue_button_label), false, 1, null);
    }

    private final void collectBankAccount(String clientSecret) {
        if (this.getHasLaunched()) {
            return;
        }
        this.setHasLaunched(true);
        if (clientSecret != null) {
            this.collectBankAccountForIntent(clientSecret);
        } else {
            this.collectBankAccountForDeferredIntent();
        }
    }

    private final void collectBankAccountForIntent(String clientSecret) {
        block1: {
            CollectBankAccountConfiguration configuration;
            block0: {
                CollectBankAccountConfiguration collectBankAccountConfiguration = configuration = this.args.getInstantDebits() ? (CollectBankAccountConfiguration)new CollectBankAccountConfiguration.InstantDebits((String)this.email.getValue()) : (CollectBankAccountConfiguration)new CollectBankAccountConfiguration.USBankAccount((String)this.name.getValue(), (String)this.email.getValue());
                if (!this.args.isPaymentFlow()) break block0;
                CollectBankAccountLauncher collectBankAccountLauncher = this.collectBankAccountLauncher;
                if (collectBankAccountLauncher == null) break block1;
                collectBankAccountLauncher.presentWithPaymentIntent(((PaymentConfiguration)this.lazyPaymentConfig.get()).getPublishableKey(), ((PaymentConfiguration)this.lazyPaymentConfig.get()).getStripeAccountId(), clientSecret, configuration);
                break block1;
            }
            CollectBankAccountLauncher collectBankAccountLauncher = this.collectBankAccountLauncher;
            if (collectBankAccountLauncher == null) break block1;
            collectBankAccountLauncher.presentWithSetupIntent(((PaymentConfiguration)this.lazyPaymentConfig.get()).getPublishableKey(), ((PaymentConfiguration)this.lazyPaymentConfig.get()).getStripeAccountId(), clientSecret, configuration);
        }
    }

    private final void collectBankAccountForDeferredIntent() {
        block2: {
            String elementsSessionId;
            block1: {
                String string2 = this.args.getStripeIntentId();
                if (string2 == null) {
                    return;
                }
                elementsSessionId = string2;
                if (!this.args.isPaymentFlow()) break block1;
                CollectBankAccountLauncher collectBankAccountLauncher = this.collectBankAccountLauncher;
                if (collectBankAccountLauncher == null) break block2;
                Amount amount = this.args.getFormArgs().getAmount();
                Amount amount2 = this.args.getFormArgs().getAmount();
                collectBankAccountLauncher.presentWithDeferredPayment(((PaymentConfiguration)this.lazyPaymentConfig.get()).getPublishableKey(), ((PaymentConfiguration)this.lazyPaymentConfig.get()).getStripeAccountId(), (CollectBankAccountConfiguration)new CollectBankAccountConfiguration.USBankAccount((String)this.name.getValue(), (String)this.email.getValue()), elementsSessionId, null, this.args.getOnBehalfOf(), amount != null ? Integer.valueOf((int)amount.getValue()) : null, amount2 != null ? amount2.getCurrencyCode() : null);
                break block2;
            }
            CollectBankAccountLauncher collectBankAccountLauncher = this.collectBankAccountLauncher;
            if (collectBankAccountLauncher == null) break block2;
            collectBankAccountLauncher.presentWithDeferredSetup(((PaymentConfiguration)this.lazyPaymentConfig.get()).getPublishableKey(), ((PaymentConfiguration)this.lazyPaymentConfig.get()).getStripeAccountId(), (CollectBankAccountConfiguration)new CollectBankAccountConfiguration.USBankAccount((String)this.name.getValue(), (String)this.email.getValue()), elementsSessionId, null, this.args.getOnBehalfOf());
        }
    }

    private final void updatePaymentSelection(USBankAccountFormScreenState.ResultIdentifier resultIdentifier, String bankName, String last4) {
        if (bankName == null || last4 == null) {
            return;
        }
        PaymentSelection.New.USBankAccount paymentSelection = this.createNewPaymentSelection(resultIdentifier, last4, bankName);
        this._result.tryEmit((Object)paymentSelection);
        this.setShouldReset(true);
    }

    private final PaymentSelection.New.USBankAccount createNewPaymentSelection(USBankAccountFormScreenState.ResultIdentifier resultIdentifier, String last4, String bankName) {
        PaymentSelection.New.USBankAccount.InstantDebitsInfo instantDebitsInfo;
        Object[] objectArray;
        String string2;
        PaymentMethodCreateParams paymentMethodCreateParams;
        PaymentSelection.CustomerRequestedSave customerRequestedSave = USBankAccountFormViewModelKt.customerRequestedSave(this.args.getShowCheckbox(), (Boolean)this.saveForFutureUse.getValue());
        USBankAccountFormScreenState.ResultIdentifier resultIdentifier2 = resultIdentifier;
        if (resultIdentifier2 instanceof USBankAccountFormScreenState.ResultIdentifier.PaymentMethod) {
            paymentMethodCreateParams = PaymentMethodCreateParams.Companion.createInstantDebits(((USBankAccountFormScreenState.ResultIdentifier.PaymentMethod)resultIdentifier).getId(), true, SetsKt.setOf((Object)"PaymentSheet"));
        } else if (resultIdentifier2 instanceof USBankAccountFormScreenState.ResultIdentifier.Session) {
            String string3 = (String)this.name.getValue();
            string2 = (String)this.email.getValue();
            objectArray = (Object[])this.phone.getValue();
            Address address2 = (Address)this.address.getValue();
            paymentMethodCreateParams = PaymentMethodCreateParams.Companion.create$default((PaymentMethodCreateParams.Companion)PaymentMethodCreateParams.Companion, (PaymentMethodCreateParams.USBankAccount)new PaymentMethodCreateParams.USBankAccount(((USBankAccountFormScreenState.ResultIdentifier.Session)resultIdentifier).getId()), (PaymentMethod.BillingDetails)new PaymentMethod.BillingDetails(address2, string2, string3, (String)objectArray), null, null, (int)12, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        PaymentMethodCreateParams paymentMethodCreateParams2 = paymentMethodCreateParams;
        USBankAccountFormScreenState.ResultIdentifier.PaymentMethod paymentMethod = resultIdentifier instanceof USBankAccountFormScreenState.ResultIdentifier.PaymentMethod ? (USBankAccountFormScreenState.ResultIdentifier.PaymentMethod)resultIdentifier : null;
        if (paymentMethod != null) {
            USBankAccountFormScreenState.ResultIdentifier.PaymentMethod it = paymentMethod;
            boolean bl = false;
            instantDebitsInfo = new PaymentSelection.New.USBankAccount.InstantDebitsInfo(it.getId());
        } else {
            instantDebitsInfo = null;
        }
        PaymentSelection.New.USBankAccount.InstantDebitsInfo instantDebitsInfo2 = instantDebitsInfo;
        PaymentMethodOptionsParams.USBankAccount paymentMethodOptionsParams = resultIdentifier instanceof USBankAccountFormScreenState.ResultIdentifier.Session ? new PaymentMethodOptionsParams.USBankAccount(customerRequestedSave.getSetupFutureUsage()) : null;
        objectArray = new Object[]{last4};
        string2 = this.application.getString(R.string.stripe_paymentsheet_payment_method_item_card_number, objectArray);
        int n = TransformToBankIcon.Companion.invoke(bankName);
        USBankAccountFormScreenState uSBankAccountFormScreenState = (USBankAccountFormScreenState)this.currentScreenState.getValue();
        PaymentSelection.New.USBankAccount.Input input = new PaymentSelection.New.USBankAccount.Input((String)this.name.getValue(), (String)this.email.getValue(), (String)this.phone.getValue(), (Address)this.address.getValue(), (Boolean)this.saveForFutureUse.getValue());
        Intrinsics.checkNotNull((Object)string2);
        return new PaymentSelection.New.USBankAccount(string2, n, input, uSBankAccountFormScreenState, instantDebitsInfo2, paymentMethodCreateParams2, customerRequestedSave, (PaymentMethodOptionsParams)paymentMethodOptionsParams, null, 256, null);
    }

    private final ResolvableString buildPrimaryButtonText() {
        ResolvableString resolvableString;
        if (this.args.isCompleteFlow()) {
            if (this.args.isPaymentFlow()) {
                Amount amount = this.args.getFormArgs().getAmount();
                Intrinsics.checkNotNull((Object)amount);
                resolvableString = amount.buildPayButtonLabel();
            } else {
                resolvableString = ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_setup_button_label);
            }
        } else {
            resolvableString = ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_continue_button_label);
        }
        return resolvableString;
    }

    private final ResolvableString buildMandateText() {
        return USBankAccountTextBuilder.INSTANCE.getContinueMandateText(this.formattedMerchantName(), (Boolean)this.saveForFutureUse.getValue(), this.args.getInstantDebits(), !this.args.isPaymentFlow());
    }

    public static final /* synthetic */ void access$handleInstantDebitsResult(USBankAccountFormViewModel $this, CollectBankAccountForInstantDebitsResult result2) {
        $this.handleInstantDebitsResult(result2);
    }

    public static final /* synthetic */ Args access$getArgs$p(USBankAccountFormViewModel $this) {
        return $this.args;
    }

    public static final /* synthetic */ PaymentSheet.BillingDetailsCollectionConfiguration access$getCollectionConfiguration$p(USBankAccountFormViewModel $this) {
        return $this.collectionConfiguration;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0012J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u0081\u0001\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\nH\u00c6\u0001J\u0013\u0010-\u001a\u00020\u00032\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\nH\u00d6\u0001R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0019R\u0013\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014\u00a8\u00062"}, d2={"Lcom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountFormViewModel$Args;", "", "instantDebits", "", "formArgs", "Lcom/stripe/android/paymentsheet/paymentdatacollection/FormArguments;", "showCheckbox", "isCompleteFlow", "isPaymentFlow", "stripeIntentId", "", "clientSecret", "onBehalfOf", "savedPaymentMethod", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$New$USBankAccount;", "shippingDetails", "Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "hostedSurface", "(ZLcom/stripe/android/paymentsheet/paymentdatacollection/FormArguments;ZZZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/paymentsheet/model/PaymentSelection$New$USBankAccount;Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;Ljava/lang/String;)V", "getClientSecret", "()Ljava/lang/String;", "getFormArgs", "()Lcom/stripe/android/paymentsheet/paymentdatacollection/FormArguments;", "getHostedSurface", "getInstantDebits", "()Z", "getOnBehalfOf", "getSavedPaymentMethod", "()Lcom/stripe/android/paymentsheet/model/PaymentSelection$New$USBankAccount;", "getShippingDetails", "()Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "getShowCheckbox", "getStripeIntentId", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Args {
        private final boolean instantDebits;
        @NotNull
        private final FormArguments formArgs;
        private final boolean showCheckbox;
        private final boolean isCompleteFlow;
        private final boolean isPaymentFlow;
        @Nullable
        private final String stripeIntentId;
        @Nullable
        private final String clientSecret;
        @Nullable
        private final String onBehalfOf;
        @Nullable
        private final PaymentSelection.New.USBankAccount savedPaymentMethod;
        @Nullable
        private final AddressDetails shippingDetails;
        @NotNull
        private final String hostedSurface;
        public static final int $stable = 8;

        public Args(boolean instantDebits, @NotNull FormArguments formArgs, boolean showCheckbox, boolean isCompleteFlow, boolean isPaymentFlow, @Nullable String stripeIntentId, @Nullable String clientSecret, @Nullable String onBehalfOf, @Nullable PaymentSelection.New.USBankAccount savedPaymentMethod, @Nullable AddressDetails shippingDetails, @NotNull String hostedSurface) {
            Intrinsics.checkNotNullParameter((Object)formArgs, (String)"formArgs");
            Intrinsics.checkNotNullParameter((Object)hostedSurface, (String)"hostedSurface");
            this.instantDebits = instantDebits;
            this.formArgs = formArgs;
            this.showCheckbox = showCheckbox;
            this.isCompleteFlow = isCompleteFlow;
            this.isPaymentFlow = isPaymentFlow;
            this.stripeIntentId = stripeIntentId;
            this.clientSecret = clientSecret;
            this.onBehalfOf = onBehalfOf;
            this.savedPaymentMethod = savedPaymentMethod;
            this.shippingDetails = shippingDetails;
            this.hostedSurface = hostedSurface;
        }

        public final boolean getInstantDebits() {
            return this.instantDebits;
        }

        @NotNull
        public final FormArguments getFormArgs() {
            return this.formArgs;
        }

        public final boolean getShowCheckbox() {
            return this.showCheckbox;
        }

        public final boolean isCompleteFlow() {
            return this.isCompleteFlow;
        }

        public final boolean isPaymentFlow() {
            return this.isPaymentFlow;
        }

        @Nullable
        public final String getStripeIntentId() {
            return this.stripeIntentId;
        }

        @Nullable
        public final String getClientSecret() {
            return this.clientSecret;
        }

        @Nullable
        public final String getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Nullable
        public final PaymentSelection.New.USBankAccount getSavedPaymentMethod() {
            return this.savedPaymentMethod;
        }

        @Nullable
        public final AddressDetails getShippingDetails() {
            return this.shippingDetails;
        }

        @NotNull
        public final String getHostedSurface() {
            return this.hostedSurface;
        }

        public final boolean component1() {
            return this.instantDebits;
        }

        @NotNull
        public final FormArguments component2() {
            return this.formArgs;
        }

        public final boolean component3() {
            return this.showCheckbox;
        }

        public final boolean component4() {
            return this.isCompleteFlow;
        }

        public final boolean component5() {
            return this.isPaymentFlow;
        }

        @Nullable
        public final String component6() {
            return this.stripeIntentId;
        }

        @Nullable
        public final String component7() {
            return this.clientSecret;
        }

        @Nullable
        public final String component8() {
            return this.onBehalfOf;
        }

        @Nullable
        public final PaymentSelection.New.USBankAccount component9() {
            return this.savedPaymentMethod;
        }

        @Nullable
        public final AddressDetails component10() {
            return this.shippingDetails;
        }

        @NotNull
        public final String component11() {
            return this.hostedSurface;
        }

        @NotNull
        public final Args copy(boolean instantDebits, @NotNull FormArguments formArgs, boolean showCheckbox, boolean isCompleteFlow, boolean isPaymentFlow, @Nullable String stripeIntentId, @Nullable String clientSecret, @Nullable String onBehalfOf, @Nullable PaymentSelection.New.USBankAccount savedPaymentMethod, @Nullable AddressDetails shippingDetails, @NotNull String hostedSurface) {
            Intrinsics.checkNotNullParameter((Object)formArgs, (String)"formArgs");
            Intrinsics.checkNotNullParameter((Object)hostedSurface, (String)"hostedSurface");
            return new Args(instantDebits, formArgs, showCheckbox, isCompleteFlow, isPaymentFlow, stripeIntentId, clientSecret, onBehalfOf, savedPaymentMethod, shippingDetails, hostedSurface);
        }

        public static /* synthetic */ Args copy$default(Args args2, boolean bl, FormArguments formArguments, boolean bl2, boolean bl3, boolean bl4, String string2, String string3, String string4, PaymentSelection.New.USBankAccount uSBankAccount, AddressDetails addressDetails, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                bl = args2.instantDebits;
            }
            if ((n & 2) != 0) {
                formArguments = args2.formArgs;
            }
            if ((n & 4) != 0) {
                bl2 = args2.showCheckbox;
            }
            if ((n & 8) != 0) {
                bl3 = args2.isCompleteFlow;
            }
            if ((n & 0x10) != 0) {
                bl4 = args2.isPaymentFlow;
            }
            if ((n & 0x20) != 0) {
                string2 = args2.stripeIntentId;
            }
            if ((n & 0x40) != 0) {
                string3 = args2.clientSecret;
            }
            if ((n & 0x80) != 0) {
                string4 = args2.onBehalfOf;
            }
            if ((n & 0x100) != 0) {
                uSBankAccount = args2.savedPaymentMethod;
            }
            if ((n & 0x200) != 0) {
                addressDetails = args2.shippingDetails;
            }
            if ((n & 0x400) != 0) {
                string5 = args2.hostedSurface;
            }
            return args2.copy(bl, formArguments, bl2, bl3, bl4, string2, string3, string4, uSBankAccount, addressDetails, string5);
        }

        @NotNull
        public String toString() {
            return "Args(instantDebits=" + this.instantDebits + ", formArgs=" + this.formArgs + ", showCheckbox=" + this.showCheckbox + ", isCompleteFlow=" + this.isCompleteFlow + ", isPaymentFlow=" + this.isPaymentFlow + ", stripeIntentId=" + this.stripeIntentId + ", clientSecret=" + this.clientSecret + ", onBehalfOf=" + this.onBehalfOf + ", savedPaymentMethod=" + this.savedPaymentMethod + ", shippingDetails=" + this.shippingDetails + ", hostedSurface=" + this.hostedSurface + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.instantDebits);
            result2 = result2 * 31 + this.formArgs.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.showCheckbox);
            result2 = result2 * 31 + Boolean.hashCode(this.isCompleteFlow);
            result2 = result2 * 31 + Boolean.hashCode(this.isPaymentFlow);
            result2 = result2 * 31 + (this.stripeIntentId == null ? 0 : this.stripeIntentId.hashCode());
            result2 = result2 * 31 + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
            result2 = result2 * 31 + (this.onBehalfOf == null ? 0 : this.onBehalfOf.hashCode());
            result2 = result2 * 31 + (this.savedPaymentMethod == null ? 0 : this.savedPaymentMethod.hashCode());
            result2 = result2 * 31 + (this.shippingDetails == null ? 0 : this.shippingDetails.hashCode());
            result2 = result2 * 31 + this.hostedSurface.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args2 = (Args)other;
            if (this.instantDebits != args2.instantDebits) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.formArgs, (Object)args2.formArgs)) {
                return false;
            }
            if (this.showCheckbox != args2.showCheckbox) {
                return false;
            }
            if (this.isCompleteFlow != args2.isCompleteFlow) {
                return false;
            }
            if (this.isPaymentFlow != args2.isPaymentFlow) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stripeIntentId, (Object)args2.stripeIntentId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clientSecret, (Object)args2.clientSecret)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.onBehalfOf, (Object)args2.onBehalfOf)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.savedPaymentMethod, (Object)args2.savedPaymentMethod)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shippingDetails, (Object)args2.shippingDetails)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hostedSurface, (Object)args2.hostedSurface);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountFormViewModel$Companion;", "", "()V", "HAS_LAUNCHED_KEY", "", "SHOULD_RESET_KEY", "paymentsheet_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J-\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountFormViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "argsSupplier", "Lkotlin/Function0;", "Lcom/stripe/android/paymentsheet/paymentdatacollection/ach/USBankAccountFormViewModel$Args;", "(Lkotlin/jvm/functions/Function0;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "extras", "Landroidx/lifecycle/viewmodel/CreationExtras;", "(Ljava/lang/Class;Landroidx/lifecycle/viewmodel/CreationExtras;)Landroidx/lifecycle/ViewModel;", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final Function0<Args> argsSupplier;
        public static final int $stable;

        public Factory(@NotNull Function0<Args> argsSupplier) {
            Intrinsics.checkNotNullParameter(argsSupplier, (String)"argsSupplier");
            this.argsSupplier = argsSupplier;
        }

        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass, @NotNull CreationExtras extras) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            USBankAccountFormViewModel uSBankAccountFormViewModel = ((USBankAccountFormViewModelSubcomponent.Builder)DaggerUSBankAccountFormComponent.builder().application(CreationExtrasKtxKt.requireApplication((CreationExtras)extras)).build().getSubComponentBuilderProvider().get()).configuration((Args)this.argsSupplier.invoke()).savedStateHandle(SavedStateHandleSupport.createSavedStateHandle((CreationExtras)extras)).build().getViewModel();
            Intrinsics.checkNotNull((Object)((Object)uSBankAccountFormViewModel), (String)"null cannot be cast to non-null type T of com.stripe.android.paymentsheet.paymentdatacollection.ach.USBankAccountFormViewModel.Factory.create");
            return (T)((Object)uSBankAccountFormViewModel);
        }
    }
}

