/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.state;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.ElementsSession;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.PaymentSheet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0081\b\u0018\u0000 $2\u00020\u0001:\u0002$%B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J7\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Lcom/stripe/android/paymentsheet/state/CustomerState;", "Landroid/os/Parcelable;", "id", "", "ephemeralKeySecret", "paymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "permissions", "Lcom/stripe/android/paymentsheet/state/CustomerState$Permissions;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/stripe/android/paymentsheet/state/CustomerState$Permissions;)V", "getEphemeralKeySecret", "()Ljava/lang/String;", "getId", "getPaymentMethods", "()Ljava/util/List;", "getPermissions", "()Lcom/stripe/android/paymentsheet/state/CustomerState$Permissions;", "component1", "component2", "component3", "component4", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "Permissions", "paymentsheet_release"})
@Parcelize
@StabilityInferred(parameters=0)
public final class CustomerState
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String ephemeralKeySecret;
    @NotNull
    private final List<PaymentMethod> paymentMethods;
    @NotNull
    private final Permissions permissions;
    public static final int $stable = 8;
    @NotNull
    public static final Parcelable.Creator<CustomerState> CREATOR;

    public CustomerState(@NotNull String id, @NotNull String ephemeralKeySecret, @NotNull List<PaymentMethod> paymentMethods2, @NotNull Permissions permissions) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)ephemeralKeySecret, (String)"ephemeralKeySecret");
        Intrinsics.checkNotNullParameter(paymentMethods2, (String)"paymentMethods");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        this.id = id;
        this.ephemeralKeySecret = ephemeralKeySecret;
        this.paymentMethods = paymentMethods2;
        this.permissions = permissions;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getEphemeralKeySecret() {
        return this.ephemeralKeySecret;
    }

    @NotNull
    public final List<PaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    @NotNull
    public final Permissions getPermissions() {
        return this.permissions;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.ephemeralKeySecret;
    }

    @NotNull
    public final List<PaymentMethod> component3() {
        return this.paymentMethods;
    }

    @NotNull
    public final Permissions component4() {
        return this.permissions;
    }

    @NotNull
    public final CustomerState copy(@NotNull String id, @NotNull String ephemeralKeySecret, @NotNull List<PaymentMethod> paymentMethods2, @NotNull Permissions permissions) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)ephemeralKeySecret, (String)"ephemeralKeySecret");
        Intrinsics.checkNotNullParameter(paymentMethods2, (String)"paymentMethods");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        return new CustomerState(id, ephemeralKeySecret, paymentMethods2, permissions);
    }

    public static /* synthetic */ CustomerState copy$default(CustomerState customerState, String string2, String string3, List list, Permissions permissions, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = customerState.id;
        }
        if ((n & 2) != 0) {
            string3 = customerState.ephemeralKeySecret;
        }
        if ((n & 4) != 0) {
            list = customerState.paymentMethods;
        }
        if ((n & 8) != 0) {
            permissions = customerState.permissions;
        }
        return customerState.copy(string2, string3, list, permissions);
    }

    @NotNull
    public String toString() {
        return "CustomerState(id=" + this.id + ", ephemeralKeySecret=" + this.ephemeralKeySecret + ", paymentMethods=" + this.paymentMethods + ", permissions=" + this.permissions + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + this.ephemeralKeySecret.hashCode();
        result2 = result2 * 31 + ((Object)this.paymentMethods).hashCode();
        result2 = result2 * 31 + this.permissions.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CustomerState)) {
            return false;
        }
        CustomerState customerState = (CustomerState)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)customerState.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ephemeralKeySecret, (Object)customerState.ephemeralKeySecret)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paymentMethods, customerState.paymentMethods)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.permissions, (Object)customerState.permissions);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.id);
        out.writeString(this.ephemeralKeySecret);
        List<PaymentMethod> list = this.paymentMethods;
        out.writeInt(list.size());
        Iterator<PaymentMethod> iterator = list.iterator();
        while (iterator.hasNext()) {
            out.writeParcelable((Parcelable)iterator.next(), flags);
        }
        this.permissions.writeToParcel(out, flags);
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<CustomerState> {
            @NotNull
            public final CustomerState[] newArray(int size) {
                return new CustomerState[size];
            }

            @NotNull
            public final CustomerState createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                ArrayList<Parcelable> arrayList = new ArrayList<Parcelable>(n);
                String string2 = parcel.readString();
                String string3 = parcel.readString();
                for (int i = 0; i != n; ++i) {
                    arrayList.add(parcel.readParcelable(CustomerState.class.getClassLoader()));
                }
                Permissions permissions = (Permissions)Permissions.CREATOR.createFromParcel(parcel);
                List list = arrayList;
                String string4 = string2;
                String string5 = string3;
                return new CustomerState(string5, string4, list, permissions);
            }
        }
        CREATOR = new Creator();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u00a2\u0006\u0002\b\nJ+\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0000\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/paymentsheet/state/CustomerState$Companion;", "", "()V", "createForCustomerSession", "Lcom/stripe/android/paymentsheet/state/CustomerState;", "customer", "Lcom/stripe/android/model/ElementsSession$Customer;", "supportedSavedPaymentMethodTypes", "", "Lcom/stripe/android/model/PaymentMethod$Type;", "createForCustomerSession$paymentsheet_release", "createForLegacyEphemeralKey", "customerId", "", "accessType", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerAccessType$LegacyCustomerEphemeralKey;", "paymentMethods", "Lcom/stripe/android/model/PaymentMethod;", "createForLegacyEphemeralKey$paymentsheet_release", "paymentsheet_release"})
    @SourceDebugExtension(value={"SMAP\nCustomerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomerState.kt\ncom/stripe/android/paymentsheet/state/CustomerState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n766#2:91\n857#2,2:92\n*S KotlinDebug\n*F\n+ 1 CustomerState.kt\ncom/stripe/android/paymentsheet/state/CustomerState$Companion\n*L\n45#1:91\n45#1:92,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CustomerState createForCustomerSession$paymentsheet_release(@NotNull ElementsSession.Customer customer2, @NotNull List<? extends PaymentMethod.Type> supportedSavedPaymentMethodTypes) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)customer2, (String)"customer");
            Intrinsics.checkNotNullParameter(supportedSavedPaymentMethodTypes, (String)"supportedSavedPaymentMethodTypes");
            Object paymentSheetComponent = customer2.getSession().getComponents().getPaymentSheet();
            if (paymentSheetComponent instanceof ElementsSession.Customer.Components.PaymentSheet.Enabled) {
                bl = ((ElementsSession.Customer.Components.PaymentSheet.Enabled)paymentSheetComponent).isPaymentMethodRemoveEnabled();
            } else if (paymentSheetComponent instanceof ElementsSession.Customer.Components.PaymentSheet.Disabled) {
                bl = false;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            boolean canRemovePaymentMethods = bl;
            paymentSheetComponent = customer2.getPaymentMethods();
            String string2 = customer2.getSession().getApiKey();
            String string3 = customer2.getSession().getCustomerId();
            boolean $i$f$filter = false;
            void var6_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PaymentMethod it = (PaymentMethod)element$iv$iv;
                boolean bl2 = false;
                if (!CollectionsKt.contains((Iterable)supportedSavedPaymentMethodTypes, (Object)it.type)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            Permissions permissions = new Permissions(canRemovePaymentMethods, true);
            List list2 = list;
            String string4 = string2;
            String string5 = string3;
            return new CustomerState(string5, string4, list2, permissions);
        }

        @NotNull
        public final CustomerState createForLegacyEphemeralKey$paymentsheet_release(@NotNull String customerId, @NotNull PaymentSheet.CustomerAccessType.LegacyCustomerEphemeralKey accessType, @NotNull List<PaymentMethod> paymentMethods2) {
            Intrinsics.checkNotNullParameter((Object)customerId, (String)"customerId");
            Intrinsics.checkNotNullParameter((Object)accessType, (String)"accessType");
            Intrinsics.checkNotNullParameter(paymentMethods2, (String)"paymentMethods");
            return new CustomerState(customerId, accessType.getEphemeralKeySecret(), paymentMethods2, new Permissions(true, false));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0019\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/paymentsheet/state/CustomerState$Permissions;", "Landroid/os/Parcelable;", "canRemovePaymentMethods", "", "canRemoveDuplicates", "(ZZ)V", "getCanRemoveDuplicates", "()Z", "getCanRemovePaymentMethods", "component1", "component2", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @Parcelize
    @StabilityInferred(parameters=1)
    public static final class Permissions
    implements Parcelable {
        private final boolean canRemovePaymentMethods;
        private final boolean canRemoveDuplicates;
        public static final int $stable;
        @NotNull
        public static final Parcelable.Creator<Permissions> CREATOR;

        public Permissions(boolean canRemovePaymentMethods, boolean canRemoveDuplicates) {
            this.canRemovePaymentMethods = canRemovePaymentMethods;
            this.canRemoveDuplicates = canRemoveDuplicates;
        }

        public final boolean getCanRemovePaymentMethods() {
            return this.canRemovePaymentMethods;
        }

        public final boolean getCanRemoveDuplicates() {
            return this.canRemoveDuplicates;
        }

        public final boolean component1() {
            return this.canRemovePaymentMethods;
        }

        public final boolean component2() {
            return this.canRemoveDuplicates;
        }

        @NotNull
        public final Permissions copy(boolean canRemovePaymentMethods, boolean canRemoveDuplicates) {
            return new Permissions(canRemovePaymentMethods, canRemoveDuplicates);
        }

        public static /* synthetic */ Permissions copy$default(Permissions permissions, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = permissions.canRemovePaymentMethods;
            }
            if ((n & 2) != 0) {
                bl2 = permissions.canRemoveDuplicates;
            }
            return permissions.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Permissions(canRemovePaymentMethods=" + this.canRemovePaymentMethods + ", canRemoveDuplicates=" + this.canRemoveDuplicates + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.canRemovePaymentMethods);
            result2 = result2 * 31 + Boolean.hashCode(this.canRemoveDuplicates);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Permissions)) {
                return false;
            }
            Permissions permissions = (Permissions)other;
            if (this.canRemovePaymentMethods != permissions.canRemovePaymentMethods) {
                return false;
            }
            return this.canRemoveDuplicates == permissions.canRemoveDuplicates;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(this.canRemovePaymentMethods ? 1 : 0);
            out.writeInt(this.canRemoveDuplicates ? 1 : 0);
        }

        static {
            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Permissions> {
                @NotNull
                public final Permissions[] newArray(int size) {
                    return new Permissions[size];
                }

                @NotNull
                public final Permissions createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Permissions(parcel.readInt() != 0, parcel.readInt() != 0);
                }
            }
            CREATOR = new Creator();
        }
    }
}

