/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.platform.ComposeView;
import androidx.compose.ui.platform.ViewCompositionStrategy;
import androidx.compose.ui.unit.Dp;
import com.google.android.material.progressindicator.CircularProgressIndicator;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.databinding.StripePrimaryButtonBinding;
import com.stripe.android.paymentsheet.ui.PrimaryButtonAnimator;
import com.stripe.android.paymentsheet.ui.PrimaryButtonKt;
import com.stripe.android.uicore.PrimaryButtonStyle;
import com.stripe.android.uicore.StripeThemeDefaults;
import com.stripe.android.uicore.StripeThemeKt;
import com.stripe.android.uicore.strings.ResolvableStringComposeUtilsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002NOB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u00102\u001a\u0004\u0018\u0001032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0016\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020507H\u0002J\b\u00108\u001a\u000205H\u0002J\b\u00109\u001a\u000205H\u0002J\u0018\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u0014J\u0012\u0010>\u001a\u0002052\b\u0010=\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010?\u001a\u0002052\b\b\u0001\u0010@\u001a\u00020\u0007J\u0010\u0010A\u001a\u0002052\b\b\u0001\u0010B\u001a\u00020\u0007J\u0010\u0010C\u001a\u0002052\u0006\u0010D\u001a\u00020%H\u0016J\u0010\u0010E\u001a\u0002052\b\b\u0001\u0010B\u001a\u00020\u0007J\u0012\u0010F\u001a\u0002052\b\u0010G\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010H\u001a\u0002052\b\b\u0001\u0010@\u001a\u00020\u0007J\b\u0010I\u001a\u000205H\u0002J\u0010\u0010J\u001a\u0002052\b\u0010+\u001a\u0004\u0018\u00010,J\u0010\u0010K\u001a\u0002052\b\u0010L\u001a\u0004\u0018\u00010MR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R&\u0010\u0013\u001a\u0004\u0018\u00010\u00148\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR&\u0010\u001b\u001a\u0004\u0018\u00010\u001c8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001d\u0010\u0016\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020%X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0010\u0010*\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\u00020.8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b/\u0010\u0016\u001a\u0004\b0\u00101\u00a8\u0006P"}, d2={"Lcom/stripe/android/paymentsheet/ui/PrimaryButton;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animator", "Lcom/stripe/android/paymentsheet/ui/PrimaryButtonAnimator;", "borderStrokeColor", "borderStrokeWidth", "", "confirmedIcon", "Landroid/widget/ImageView;", "cornerRadius", "defaultLabelColor", "Ljava/lang/Integer;", "defaultTintList", "Landroid/content/res/ColorStateList;", "getDefaultTintList$paymentsheet_release$annotations", "()V", "getDefaultTintList$paymentsheet_release", "()Landroid/content/res/ColorStateList;", "setDefaultTintList$paymentsheet_release", "(Landroid/content/res/ColorStateList;)V", "externalLabel", "Lcom/stripe/android/core/strings/ResolvableString;", "getExternalLabel$paymentsheet_release$annotations", "getExternalLabel$paymentsheet_release", "()Lcom/stripe/android/core/strings/ResolvableString;", "setExternalLabel$paymentsheet_release", "(Lcom/stripe/android/core/strings/ResolvableString;)V", "finishedBackgroundColor", "finishedOnBackgroundColor", "lockVisible", "", "getLockVisible$paymentsheet_release", "()Z", "setLockVisible$paymentsheet_release", "(Z)V", "originalLabel", "state", "Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State;", "viewBinding", "Lcom/stripe/android/paymentsheet/databinding/StripePrimaryButtonBinding;", "getViewBinding$paymentsheet_release$annotations", "getViewBinding$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/databinding/StripePrimaryButtonBinding;", "getTextAttributeValue", "", "onFinishProcessing", "", "onAnimationEnd", "Lkotlin/Function0;", "onReadyState", "onStartProcessing", "setAppearanceConfiguration", "primaryButtonStyle", "Lcom/stripe/android/uicore/PrimaryButtonStyle;", "tintList", "setBackgroundTintList", "setConfirmedIconDrawable", "drawable", "setDefaultLabelColor", "color", "setEnabled", "enabled", "setIndicatorColor", "setLabel", "text", "setLockIconDrawable", "updateAlpha", "updateState", "updateUiState", "uiState", "Lcom/stripe/android/paymentsheet/ui/PrimaryButton$UIState;", "State", "UIState", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPrimaryButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimaryButton.kt\ncom/stripe/android/paymentsheet/ui/PrimaryButton\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n+ 4 Context.kt\nandroidx/core/content/ContextKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n174#2:299\n174#2:300\n174#2:301\n174#2:302\n177#3,2:303\n262#3,2:314\n262#3,2:316\n262#3,2:318\n262#3,2:320\n262#3,2:322\n262#3,2:324\n52#4,9:305\n1855#5,2:326\n*S KotlinDebug\n*F\n+ 1 PrimaryButton.kt\ncom/stripe/android/paymentsheet/ui/PrimaryButton\n*L\n71#1:299\n74#1:300\n102#1:301\n103#1:302\n138#1:303,2\n179#1:314,2\n180#1:316,2\n184#1:318,2\n185#1:320,2\n211#1:322,2\n221#1:324,2\n147#1:305,9\n248#1:326,2\n*E\n"})
public final class PrimaryButton
extends FrameLayout {
    @Nullable
    private ColorStateList defaultTintList;
    @Nullable
    private State state;
    @NotNull
    private final PrimaryButtonAnimator animator;
    @Nullable
    private ResolvableString originalLabel;
    @Nullable
    private Integer defaultLabelColor;
    @Nullable
    private ResolvableString externalLabel;
    @NotNull
    private final StripePrimaryButtonBinding viewBinding;
    private boolean lockVisible;
    @NotNull
    private final ImageView confirmedIcon;
    private float cornerRadius;
    private float borderStrokeWidth;
    private int borderStrokeColor;
    private int finishedBackgroundColor;
    private int finishedOnBackgroundColor;
    public static final int $stable = 8;

    @JvmOverloads
    public PrimaryButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.animator = new PrimaryButtonAnimator(context);
        StripePrimaryButtonBinding stripePrimaryButtonBinding = StripePrimaryButtonBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)stripePrimaryButtonBinding, (String)"inflate(...)");
        this.viewBinding = stripePrimaryButtonBinding;
        this.lockVisible = true;
        ImageView imageView = this.viewBinding.confirmedIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"confirmedIcon");
        this.confirmedIcon = imageView;
        float $this$dp$iv = StripeThemeDefaults.INSTANCE.getPrimaryButtonStyle().getShape().getCornerRadius();
        boolean $i$f$getDp = false;
        this.cornerRadius = StripeThemeKt.convertDpToPx-3ABfNKs((Context)context, (float)Dp.constructor-impl((float)$this$dp$iv));
        $this$dp$iv = StripeThemeDefaults.INSTANCE.getPrimaryButtonStyle().getShape().getBorderStrokeWidth();
        $i$f$getDp = false;
        this.borderStrokeWidth = StripeThemeKt.convertDpToPx-3ABfNKs((Context)context, (float)Dp.constructor-impl((float)$this$dp$iv));
        this.borderStrokeColor = StripeThemeKt.getBorderStrokeColor((PrimaryButtonStyle)StripeThemeDefaults.INSTANCE.getPrimaryButtonStyle(), (Context)context);
        this.finishedBackgroundColor = StripeThemeKt.getSuccessBackgroundColor((PrimaryButtonStyle)StripeThemeDefaults.INSTANCE.getPrimaryButtonStyle(), (Context)context);
        this.finishedOnBackgroundColor = StripeThemeKt.getOnSuccessBackgroundColor((PrimaryButtonStyle)StripeThemeDefaults.INSTANCE.getPrimaryButtonStyle(), (Context)context);
        this.viewBinding.label.setViewCompositionStrategy((ViewCompositionStrategy)ViewCompositionStrategy.DisposeOnViewTreeLifecycleDestroyed.INSTANCE);
        CharSequence charSequence = this.getTextAttributeValue(attrs);
        if (charSequence != null) {
            CharSequence it = charSequence;
            boolean bl = false;
            this.setLabel(ResolvableStringUtilsKt.getResolvableString((String)((Object)it).toString()));
        }
        this.setClickable(true);
        this.setEnabled(false);
    }

    public /* synthetic */ PrimaryButton(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final ColorStateList getDefaultTintList$paymentsheet_release() {
        return this.defaultTintList;
    }

    public final void setDefaultTintList$paymentsheet_release(@Nullable ColorStateList colorStateList) {
        this.defaultTintList = colorStateList;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDefaultTintList$paymentsheet_release$annotations() {
    }

    @Nullable
    public final ResolvableString getExternalLabel$paymentsheet_release() {
        return this.externalLabel;
    }

    public final void setExternalLabel$paymentsheet_release(@Nullable ResolvableString resolvableString) {
        this.externalLabel = resolvableString;
    }

    @VisibleForTesting
    public static /* synthetic */ void getExternalLabel$paymentsheet_release$annotations() {
    }

    @NotNull
    public final StripePrimaryButtonBinding getViewBinding$paymentsheet_release() {
        return this.viewBinding;
    }

    @VisibleForTesting
    public static /* synthetic */ void getViewBinding$paymentsheet_release$annotations() {
    }

    public final boolean getLockVisible$paymentsheet_release() {
        return this.lockVisible;
    }

    public final void setLockVisible$paymentsheet_release(boolean bl) {
        this.lockVisible = bl;
    }

    public final void setAppearanceConfiguration(@NotNull PrimaryButtonStyle primaryButtonStyle, @Nullable ColorStateList tintList) {
        Intrinsics.checkNotNullParameter((Object)primaryButtonStyle, (String)"primaryButtonStyle");
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        float $this$dp$iv = primaryButtonStyle.getShape().getCornerRadius();
        boolean $i$f$getDp = false;
        this.cornerRadius = StripeThemeKt.convertDpToPx-3ABfNKs((Context)context, (float)Dp.constructor-impl((float)$this$dp$iv));
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        $this$dp$iv = primaryButtonStyle.getShape().getBorderStrokeWidth();
        $i$f$getDp = false;
        this.borderStrokeWidth = StripeThemeKt.convertDpToPx-3ABfNKs((Context)context2, (float)Dp.constructor-impl((float)$this$dp$iv));
        Context context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getContext(...)");
        this.borderStrokeColor = StripeThemeKt.getBorderStrokeColor((PrimaryButtonStyle)primaryButtonStyle, (Context)context3);
        ImageView imageView = this.viewBinding.lockIcon;
        Context context4 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"getContext(...)");
        imageView.setImageTintList(ColorStateList.valueOf((int)StripeThemeKt.getOnBackgroundColor((PrimaryButtonStyle)primaryButtonStyle, (Context)context4)));
        this.defaultTintList = tintList;
        this.setBackgroundTintList(tintList);
        Context context5 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context5, (String)"getContext(...)");
        this.finishedBackgroundColor = StripeThemeKt.getSuccessBackgroundColor((PrimaryButtonStyle)primaryButtonStyle, (Context)context5);
        Context context6 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context6, (String)"getContext(...)");
        this.finishedOnBackgroundColor = StripeThemeKt.getOnSuccessBackgroundColor((PrimaryButtonStyle)primaryButtonStyle, (Context)context6);
    }

    public final void setDefaultLabelColor(@ColorInt int color2) {
        this.defaultLabelColor = color2;
    }

    public final void setLockIconDrawable(@DrawableRes int drawable2) {
        this.viewBinding.lockIcon.setImageResource(drawable2);
    }

    public final void setIndicatorColor(@ColorInt int color2) {
        int[] nArray = new int[]{color2};
        this.viewBinding.confirmingIcon.setIndicatorColor(nArray);
    }

    public final void setConfirmedIconDrawable(@DrawableRes int drawable2) {
        this.viewBinding.confirmedIcon.setImageResource(drawable2);
    }

    /*
     * WARNING - void declaration
     */
    public void setBackgroundTintList(@Nullable ColorStateList tintList) {
        void size$iv;
        void $this$setPadding$iv;
        GradientDrawable shape = new GradientDrawable();
        shape.setShape(0);
        shape.setCornerRadius(this.cornerRadius);
        shape.setColor(tintList);
        shape.setStroke((int)this.borderStrokeWidth, this.borderStrokeColor);
        this.setBackground((Drawable)shape);
        View view = (View)this;
        int n = this.getResources().getDimensionPixelSize(R.dimen.stripe_paymentsheet_primary_button_padding);
        boolean $i$f$setPadding = false;
        $this$setPadding$iv.setPadding((int)size$iv, (int)size$iv, (int)size$iv, (int)size$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final CharSequence getTextAttributeValue(AttributeSet attrs) {
        void attrs$iv;
        void $this$withStyledAttributes_u24default$iv;
        TypedArray typedArray;
        CharSequence text = null;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Context context2 = context;
        int[] nArray = CollectionsKt.toIntArray((Collection)CollectionsKt.listOf((Object)16843087));
        int defStyleAttr$iv = 0;
        int defStyleRes$iv = 0;
        boolean $i$f$withStyledAttributes = false;
        TypedArray $this$getTextAttributeValue_u24lambda_u241 = typedArray = $this$withStyledAttributes_u24default$iv.obtainStyledAttributes(attrs, (int[])attrs$iv, defStyleAttr$iv, defStyleRes$iv);
        boolean bl = false;
        text = $this$getTextAttributeValue_u24lambda_u241.getText(0);
        typedArray.recycle();
        return text;
    }

    private final void setLabel(ResolvableString text) {
        block1: {
            this.externalLabel = text;
            ResolvableString resolvableString = text;
            if (resolvableString == null) break block1;
            ResolvableString it = resolvableString;
            boolean bl = false;
            if (!(this.state instanceof State.StartProcessing)) {
                this.originalLabel = text;
            }
            this.viewBinding.label.setContent((Function2)ComposableLambdaKt.composableLambdaInstance((int)-47128405, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(text, this){
                final /* synthetic */ ResolvableString $text;
                final /* synthetic */ PrimaryButton this$0;
                {
                    this.$text = $text;
                    this.this$0 = $receiver;
                    super(2);
                }

                @Composable
                @ComposableTarget(applier="androidx.compose.ui.UiComposable")
                public final void invoke(@Nullable Composer $composer, int $changed) {
                    if (($changed & 0xB) != 2 || !$composer.getSkipping()) {
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventStart((int)-47128405, (int)$changed, (int)-1, (String)"com.stripe.android.paymentsheet.ui.PrimaryButton.setLabel.<anonymous>.<anonymous> (PrimaryButton.kt:162)");
                        }
                        PrimaryButtonKt.access$LabelUI(ResolvableStringComposeUtilsKt.resolve((ResolvableString)this.$text, (Composer)$composer, (int)8), PrimaryButton.access$getDefaultLabelColor$p(this.this$0), $composer, 0);
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventEnd();
                        }
                    } else {
                        $composer.skipToGroupEnd();
                    }
                }
            }));
        }
    }

    private final void onReadyState() {
        View $this$isVisible$iv;
        ResolvableString it;
        this.setClickable(true);
        ResolvableString resolvableString = this.originalLabel;
        if (resolvableString != null) {
            it = resolvableString;
            boolean bl = false;
            this.setLabel(it);
        }
        ColorStateList colorStateList = this.defaultTintList;
        if (colorStateList != null) {
            it = colorStateList;
            boolean bl = false;
            this.setBackgroundTintList((ColorStateList)it);
        }
        ImageView imageView = this.viewBinding.lockIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"lockIcon");
        View view = (View)imageView;
        boolean value$iv = this.lockVisible;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        CircularProgressIndicator circularProgressIndicator = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)circularProgressIndicator, (String)"confirmingIcon");
        $this$isVisible$iv = (View)circularProgressIndicator;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
    }

    private final void onStartProcessing() {
        View $this$isVisible$iv;
        ImageView imageView = this.viewBinding.lockIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"lockIcon");
        View view = (View)imageView;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        CircularProgressIndicator circularProgressIndicator = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)circularProgressIndicator, (String)"confirmingIcon");
        $this$isVisible$iv = (View)circularProgressIndicator;
        value$iv = true;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        this.setClickable(false);
        this.setLabel(ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_paymentsheet_primary_button_processing));
    }

    private final void onFinishProcessing(Function0<Unit> onAnimationEnd) {
        this.setClickable(false);
        this.setBackgroundTintList(ColorStateList.valueOf((int)this.finishedBackgroundColor));
        this.confirmedIcon.setImageTintList(ColorStateList.valueOf((int)this.finishedOnBackgroundColor));
        ComposeView composeView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)composeView, (String)"label");
        this.animator.fadeOut$paymentsheet_release((View)composeView);
        CircularProgressIndicator circularProgressIndicator = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)circularProgressIndicator, (String)"confirmingIcon");
        this.animator.fadeOut$paymentsheet_release((View)circularProgressIndicator);
        this.animator.fadeIn$paymentsheet_release((View)this.confirmedIcon, this.getWidth(), (Function0<Unit>)((Function0)new Function0<Unit>(onAnimationEnd){
            final /* synthetic */ Function0<Unit> $onAnimationEnd;
            {
                this.$onAnimationEnd = $onAnimationEnd;
                super(0);
            }

            public final void invoke() {
                this.$onAnimationEnd.invoke();
            }
        }));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateAlpha();
    }

    public final void updateUiState(@Nullable UIState uiState) {
        View $this$isVisible$iv;
        View view = (View)this;
        boolean value$iv = uiState != null;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        if (uiState != null) {
            if (!(this.state instanceof State.StartProcessing) && !(this.state instanceof State.FinishProcessing)) {
                this.setLabel(uiState.getLabel());
            }
            this.setEnabled(uiState.getEnabled());
            this.lockVisible = uiState.getLockVisible();
            ImageView imageView = this.viewBinding.lockIcon;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"lockIcon");
            $this$isVisible$iv = (View)imageView;
            value$iv = this.lockVisible;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
            this.setOnClickListener(arg_0 -> PrimaryButton.updateUiState$lambda$5(uiState, arg_0));
        }
    }

    public final void updateState(@Nullable State state2) {
        this.state = state2;
        this.updateAlpha();
        State state3 = state2;
        if (state3 instanceof State.Ready) {
            this.onReadyState();
        } else if (Intrinsics.areEqual((Object)state3, (Object)State.StartProcessing.INSTANCE)) {
            this.onStartProcessing();
        } else if (state3 instanceof State.FinishProcessing) {
            this.onFinishProcessing(((State.FinishProcessing)state2).getOnComplete());
        } else if (state3 == null) {
            // empty if block
        }
    }

    private final void updateAlpha() {
        Object[] objectArray = new View[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.viewBinding.label, (String)"label");
        Intrinsics.checkNotNullExpressionValue((Object)this.viewBinding.lockIcon, (String)"lockIcon");
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            View view = (View)element$iv;
            boolean bl = false;
            view.setAlpha((this.state == null || this.state instanceof State.Ready) && !this.isEnabled() ? 0.5f : 1.0f);
        }
    }

    @JvmOverloads
    public PrimaryButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PrimaryButton(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void updateUiState$lambda$5(UIState $uiState, View it) {
        $uiState.getOnClick().invoke();
    }

    public static final /* synthetic */ Integer access$getDefaultLabelColor$p(PrimaryButton $this) {
        return $this.defaultLabelColor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u0006\u0007\bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0005\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State;", "", "isProcessing", "", "(Z)V", "()Z", "FinishProcessing", "Ready", "StartProcessing", "Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State$FinishProcessing;", "Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State$Ready;", "Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State$StartProcessing;", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static abstract class State {
        private final boolean isProcessing;
        public static final int $stable;

        private State(boolean isProcessing) {
            this.isProcessing = isProcessing;
        }

        public final boolean isProcessing() {
            return this.isProcessing;
        }

        public /* synthetic */ State(boolean isProcessing, DefaultConstructorMarker $constructor_marker) {
            this(isProcessing);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State$FinishProcessing;", "Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State;", "onComplete", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "getOnComplete", "()Lkotlin/jvm/functions/Function0;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
        @StabilityInferred(parameters=1)
        public static final class FinishProcessing
        extends State {
            @NotNull
            private final Function0<Unit> onComplete;
            public static final int $stable;

            public FinishProcessing(@NotNull Function0<Unit> onComplete) {
                Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
                super(true, null);
                this.onComplete = onComplete;
            }

            @NotNull
            public final Function0<Unit> getOnComplete() {
                return this.onComplete;
            }

            @NotNull
            public final Function0<Unit> component1() {
                return this.onComplete;
            }

            @NotNull
            public final FinishProcessing copy(@NotNull Function0<Unit> onComplete) {
                Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
                return new FinishProcessing(onComplete);
            }

            public static /* synthetic */ FinishProcessing copy$default(FinishProcessing finishProcessing, Function0 function0, int n, Object object) {
                if ((n & 1) != 0) {
                    function0 = finishProcessing.onComplete;
                }
                return finishProcessing.copy(function0);
            }

            @NotNull
            public String toString() {
                return "FinishProcessing(onComplete=" + this.onComplete + ")";
            }

            public int hashCode() {
                return this.onComplete.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FinishProcessing)) {
                    return false;
                }
                FinishProcessing finishProcessing = (FinishProcessing)other;
                return Intrinsics.areEqual(this.onComplete, finishProcessing.onComplete);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State$Ready;", "Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
        @StabilityInferred(parameters=1)
        public static final class Ready
        extends State {
            @NotNull
            public static final Ready INSTANCE = new Ready();
            public static final int $stable;

            private Ready() {
                super(false, null);
            }

            @NotNull
            public String toString() {
                return "Ready";
            }

            public int hashCode() {
                return -745924076;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Ready)) {
                    return false;
                }
                Ready cfr_ignored_0 = (Ready)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State$StartProcessing;", "Lcom/stripe/android/paymentsheet/ui/PrimaryButton$State;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
        @StabilityInferred(parameters=1)
        public static final class StartProcessing
        extends State {
            @NotNull
            public static final StartProcessing INSTANCE = new StartProcessing();
            public static final int $stable;

            private StartProcessing() {
                super(true, null);
            }

            @NotNull
            public String toString() {
                return "StartProcessing";
            }

            public int hashCode() {
                return -198876090;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StartProcessing)) {
                    return false;
                }
                StartProcessing cfr_ignored_0 = (StartProcessing)other;
                return true;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J7\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/paymentsheet/ui/PrimaryButton$UIState;", "", "label", "Lcom/stripe/android/core/strings/ResolvableString;", "onClick", "Lkotlin/Function0;", "", "enabled", "", "lockVisible", "(Lcom/stripe/android/core/strings/ResolvableString;Lkotlin/jvm/functions/Function0;ZZ)V", "getEnabled", "()Z", "getLabel", "()Lcom/stripe/android/core/strings/ResolvableString;", "getLockVisible", "getOnClick", "()Lkotlin/jvm/functions/Function0;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class UIState {
        @NotNull
        private final ResolvableString label;
        @NotNull
        private final Function0<Unit> onClick;
        private final boolean enabled;
        private final boolean lockVisible;
        public static final int $stable = 8;

        public UIState(@NotNull ResolvableString label, @NotNull Function0<Unit> onClick, boolean enabled, boolean lockVisible) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
            this.label = label;
            this.onClick = onClick;
            this.enabled = enabled;
            this.lockVisible = lockVisible;
        }

        @NotNull
        public final ResolvableString getLabel() {
            return this.label;
        }

        @NotNull
        public final Function0<Unit> getOnClick() {
            return this.onClick;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final boolean getLockVisible() {
            return this.lockVisible;
        }

        @NotNull
        public final ResolvableString component1() {
            return this.label;
        }

        @NotNull
        public final Function0<Unit> component2() {
            return this.onClick;
        }

        public final boolean component3() {
            return this.enabled;
        }

        public final boolean component4() {
            return this.lockVisible;
        }

        @NotNull
        public final UIState copy(@NotNull ResolvableString label, @NotNull Function0<Unit> onClick, boolean enabled, boolean lockVisible) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
            return new UIState(label, onClick, enabled, lockVisible);
        }

        public static /* synthetic */ UIState copy$default(UIState uIState, ResolvableString resolvableString, Function0 function0, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                resolvableString = uIState.label;
            }
            if ((n & 2) != 0) {
                function0 = uIState.onClick;
            }
            if ((n & 4) != 0) {
                bl = uIState.enabled;
            }
            if ((n & 8) != 0) {
                bl2 = uIState.lockVisible;
            }
            return uIState.copy(resolvableString, function0, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "UIState(label=" + this.label + ", onClick=" + this.onClick + ", enabled=" + this.enabled + ", lockVisible=" + this.lockVisible + ")";
        }

        public int hashCode() {
            int result2 = this.label.hashCode();
            result2 = result2 * 31 + this.onClick.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.enabled);
            result2 = result2 * 31 + Boolean.hashCode(this.lockVisible);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UIState)) {
                return false;
            }
            UIState uIState = (UIState)other;
            if (!Intrinsics.areEqual((Object)this.label, (Object)uIState.label)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onClick, uIState.onClick)) {
                return false;
            }
            if (this.enabled != uIState.enabled) {
                return false;
            }
            return this.lockVisible == uIState.lockVisible;
        }
    }
}

