/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.common.model.CommonConfigurationKt;
import com.stripe.android.common.validation.CustomerSessionClientSecretValidator;
import com.stripe.android.model.CardBrand;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u009f\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0010\u0016\u001a\u00020\u000f\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u000209H\u0002J\u0010\u0010;\u001a\u0002092\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u0002092\u0006\u0010<\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u0002092\u0006\u0010<\u001a\u00020AH\u0002J\t\u0010B\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010C\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010D\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010E\u001a\u00020\tH\u00c6\u0003J\u000b\u0010F\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010G\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\t\u0010H\u001a\u00020\u000fH\u00c6\u0003J\t\u0010I\u001a\u00020\u000fH\u00c6\u0003J\t\u0010J\u001a\u00020\u0012H\u00c6\u0003J\u000f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u00c6\u0003J\t\u0010L\u001a\u00020\u000fH\u00c6\u0003J\u000f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u00c6\u0003J\u000f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u00c6\u0003J\t\u0010O\u001a\u00020\u001aH\u00c6\u0003J\u000f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014H\u00c6\u0003J\u00bf\u0001\u0010Q\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014H\u00c6\u0001J\u0006\u0010R\u001a\u00020SJ\u0013\u0010T\u001a\u00020\u000f2\b\u0010U\u001a\u0004\u0018\u00010VH\u00d6\u0003J\t\u0010W\u001a\u00020SH\u00d6\u0001J\t\u0010X\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010Y\u001a\u0002092\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020SR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010,R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0016\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010,R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00101R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00101R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00101\u00a8\u0006]"}, d2={"Lcom/stripe/android/common/model/CommonConfiguration;", "Landroid/os/Parcelable;", "merchantDisplayName", "", "customer", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerConfiguration;", "googlePay", "Lcom/stripe/android/paymentsheet/PaymentSheet$GooglePayConfiguration;", "link", "Lcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration;", "defaultBillingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "shippingDetails", "Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "allowsDelayedPaymentMethods", "", "allowsPaymentMethodsRequiringShippingAddress", "billingDetailsCollectionConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "preferredNetworks", "", "Lcom/stripe/android/model/CardBrand;", "allowsRemovalOfLastSavedPaymentMethod", "paymentMethodOrder", "externalPaymentMethods", "cardBrandAcceptance", "Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;", "customPaymentMethods", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomPaymentMethod;", "<init>", "(Ljava/lang/String;Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerConfiguration;Lcom/stripe/android/paymentsheet/PaymentSheet$GooglePayConfiguration;Lcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;ZZLcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;Ljava/util/List;ZLjava/util/List;Ljava/util/List;Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;Ljava/util/List;)V", "getMerchantDisplayName", "()Ljava/lang/String;", "getCustomer", "()Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerConfiguration;", "getGooglePay", "()Lcom/stripe/android/paymentsheet/PaymentSheet$GooglePayConfiguration;", "getLink", "()Lcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration;", "getDefaultBillingDetails", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "getShippingDetails", "()Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "getAllowsDelayedPaymentMethods", "()Z", "getAllowsPaymentMethodsRequiringShippingAddress", "getBillingDetailsCollectionConfiguration", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "getPreferredNetworks", "()Ljava/util/List;", "getAllowsRemovalOfLastSavedPaymentMethod", "getPaymentMethodOrder", "getExternalPaymentMethods", "getCardBrandAcceptance", "()Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;", "getCustomPaymentMethods", "validate", "", "customerAndMerchantValidate", "customerAccessTypeValidate", "customerAccessType", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerAccessType;", "customerSessionValidate", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerAccessType$CustomerSession;", "legacyCustomerEphemeralKeyValidate", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerAccessType$LegacyCustomerEphemeralKey;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "dest", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
@Parcelize
@StabilityInferred(parameters=0)
public final class CommonConfiguration
implements Parcelable {
    @NotNull
    private final String merchantDisplayName;
    @Nullable
    private final PaymentSheet.CustomerConfiguration customer;
    @Nullable
    private final PaymentSheet.GooglePayConfiguration googlePay;
    @NotNull
    private final PaymentSheet.LinkConfiguration link;
    @Nullable
    private final PaymentSheet.BillingDetails defaultBillingDetails;
    @Nullable
    private final AddressDetails shippingDetails;
    private final boolean allowsDelayedPaymentMethods;
    private final boolean allowsPaymentMethodsRequiringShippingAddress;
    @NotNull
    private final PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration;
    @NotNull
    private final List<CardBrand> preferredNetworks;
    private final boolean allowsRemovalOfLastSavedPaymentMethod;
    @NotNull
    private final List<String> paymentMethodOrder;
    @NotNull
    private final List<String> externalPaymentMethods;
    @NotNull
    private final PaymentSheet.CardBrandAcceptance cardBrandAcceptance;
    @NotNull
    private final List<PaymentSheet.CustomPaymentMethod> customPaymentMethods;
    @NotNull
    public static final Parcelable.Creator<CommonConfiguration> CREATOR;
    public static final int $stable;

    public CommonConfiguration(@NotNull String merchantDisplayName, @Nullable PaymentSheet.CustomerConfiguration customer2, @Nullable PaymentSheet.GooglePayConfiguration googlePay, @NotNull PaymentSheet.LinkConfiguration link, @Nullable PaymentSheet.BillingDetails defaultBillingDetails, @Nullable AddressDetails shippingDetails, boolean allowsDelayedPaymentMethods, boolean allowsPaymentMethodsRequiringShippingAddress, @NotNull PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, @NotNull List<? extends CardBrand> preferredNetworks, boolean allowsRemovalOfLastSavedPaymentMethod, @NotNull List<String> paymentMethodOrder, @NotNull List<String> externalPaymentMethods, @NotNull PaymentSheet.CardBrandAcceptance cardBrandAcceptance, @NotNull List<PaymentSheet.CustomPaymentMethod> customPaymentMethods) {
        Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)billingDetailsCollectionConfiguration, (String)"billingDetailsCollectionConfiguration");
        Intrinsics.checkNotNullParameter(preferredNetworks, (String)"preferredNetworks");
        Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
        Intrinsics.checkNotNullParameter(externalPaymentMethods, (String)"externalPaymentMethods");
        Intrinsics.checkNotNullParameter((Object)cardBrandAcceptance, (String)"cardBrandAcceptance");
        Intrinsics.checkNotNullParameter(customPaymentMethods, (String)"customPaymentMethods");
        this.merchantDisplayName = merchantDisplayName;
        this.customer = customer2;
        this.googlePay = googlePay;
        this.link = link;
        this.defaultBillingDetails = defaultBillingDetails;
        this.shippingDetails = shippingDetails;
        this.allowsDelayedPaymentMethods = allowsDelayedPaymentMethods;
        this.allowsPaymentMethodsRequiringShippingAddress = allowsPaymentMethodsRequiringShippingAddress;
        this.billingDetailsCollectionConfiguration = billingDetailsCollectionConfiguration;
        this.preferredNetworks = preferredNetworks;
        this.allowsRemovalOfLastSavedPaymentMethod = allowsRemovalOfLastSavedPaymentMethod;
        this.paymentMethodOrder = paymentMethodOrder;
        this.externalPaymentMethods = externalPaymentMethods;
        this.cardBrandAcceptance = cardBrandAcceptance;
        this.customPaymentMethods = customPaymentMethods;
    }

    @NotNull
    public final String getMerchantDisplayName() {
        return this.merchantDisplayName;
    }

    @Nullable
    public final PaymentSheet.CustomerConfiguration getCustomer() {
        return this.customer;
    }

    @Nullable
    public final PaymentSheet.GooglePayConfiguration getGooglePay() {
        return this.googlePay;
    }

    @NotNull
    public final PaymentSheet.LinkConfiguration getLink() {
        return this.link;
    }

    @Nullable
    public final PaymentSheet.BillingDetails getDefaultBillingDetails() {
        return this.defaultBillingDetails;
    }

    @Nullable
    public final AddressDetails getShippingDetails() {
        return this.shippingDetails;
    }

    public final boolean getAllowsDelayedPaymentMethods() {
        return this.allowsDelayedPaymentMethods;
    }

    public final boolean getAllowsPaymentMethodsRequiringShippingAddress() {
        return this.allowsPaymentMethodsRequiringShippingAddress;
    }

    @NotNull
    public final PaymentSheet.BillingDetailsCollectionConfiguration getBillingDetailsCollectionConfiguration() {
        return this.billingDetailsCollectionConfiguration;
    }

    @NotNull
    public final List<CardBrand> getPreferredNetworks() {
        return this.preferredNetworks;
    }

    public final boolean getAllowsRemovalOfLastSavedPaymentMethod() {
        return this.allowsRemovalOfLastSavedPaymentMethod;
    }

    @NotNull
    public final List<String> getPaymentMethodOrder() {
        return this.paymentMethodOrder;
    }

    @NotNull
    public final List<String> getExternalPaymentMethods() {
        return this.externalPaymentMethods;
    }

    @NotNull
    public final PaymentSheet.CardBrandAcceptance getCardBrandAcceptance() {
        return this.cardBrandAcceptance;
    }

    @NotNull
    public final List<PaymentSheet.CustomPaymentMethod> getCustomPaymentMethods() {
        return this.customPaymentMethods;
    }

    public final void validate() {
        block0: {
            this.customerAndMerchantValidate();
            Object object = this.customer;
            if (object == null || (object = object.getAccessType$paymentsheet_release()) == null) break block0;
            Object customerAccessType = object;
            boolean bl = false;
            this.customerAccessTypeValidate((PaymentSheet.CustomerAccessType)customerAccessType);
        }
    }

    private final void customerAndMerchantValidate() {
        if (StringsKt.isBlank((CharSequence)this.merchantDisplayName)) {
            throw new IllegalArgumentException("When a Configuration is passed to PaymentSheet, the Merchant display name cannot be an empty string.");
        }
        Object object = this.customer;
        boolean bl = object != null && (object = ((PaymentSheet.CustomerConfiguration)object).getId()) != null ? StringsKt.isBlank((CharSequence)((CharSequence)object)) : false;
        if (bl) {
            throw new IllegalArgumentException("When a CustomerConfiguration is passed to PaymentSheet, the Customer ID cannot be an empty string.");
        }
    }

    private final void customerAccessTypeValidate(PaymentSheet.CustomerAccessType customerAccessType) {
        PaymentSheet.CustomerAccessType customerAccessType2 = customerAccessType;
        if (customerAccessType2 instanceof PaymentSheet.CustomerAccessType.LegacyCustomerEphemeralKey) {
            this.legacyCustomerEphemeralKeyValidate((PaymentSheet.CustomerAccessType.LegacyCustomerEphemeralKey)customerAccessType);
        } else if (customerAccessType2 instanceof PaymentSheet.CustomerAccessType.CustomerSession) {
            this.customerSessionValidate((PaymentSheet.CustomerAccessType.CustomerSession)customerAccessType);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void customerSessionValidate(PaymentSheet.CustomerAccessType.CustomerSession customerAccessType) {
        CustomerSessionClientSecretValidator.Result result2 = CustomerSessionClientSecretValidator.INSTANCE.validate(customerAccessType.getCustomerSessionClientSecret());
        CustomerSessionClientSecretValidator.Result result3 = result2;
        if (result3 instanceof CustomerSessionClientSecretValidator.Result.Error.Empty) {
            throw new IllegalArgumentException("When a CustomerConfiguration is passed to PaymentSheet, the customerSessionClientSecret cannot be an empty string.");
        }
        if (result3 instanceof CustomerSessionClientSecretValidator.Result.Error.LegacyEphemeralKey) {
            throw new IllegalArgumentException("Argument looks like an Ephemeral Key secret, but expecting a CustomerSession client secret. See CustomerSession API: https://docs.stripe.com/api/customer_sessions/create");
        }
        if (result3 instanceof CustomerSessionClientSecretValidator.Result.Error.UnknownKey) {
            throw new IllegalArgumentException("Argument does not look like a CustomerSession client secret. See CustomerSession API: https://docs.stripe.com/api/customer_sessions/create");
        }
        if (!(result3 instanceof CustomerSessionClientSecretValidator.Result.Valid)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void legacyCustomerEphemeralKeyValidate(PaymentSheet.CustomerAccessType.LegacyCustomerEphemeralKey customerAccessType) {
        PaymentSheet.CustomerConfiguration customerConfiguration = this.customer;
        if (!Intrinsics.areEqual((Object)customerAccessType.getEphemeralKeySecret(), (Object)(customerConfiguration != null ? customerConfiguration.getEphemeralKeySecret() : null))) {
            throw new IllegalArgumentException("Conflicting ephemeralKeySecrets between CustomerConfiguration and CustomerConfiguration.customerAccessType");
        }
        if (StringsKt.isBlank((CharSequence)customerAccessType.getEphemeralKeySecret()) || StringsKt.isBlank((CharSequence)this.customer.getEphemeralKeySecret())) {
            throw new IllegalArgumentException("When a CustomerConfiguration is passed to PaymentSheet, the ephemeralKeySecret cannot be an empty string.");
        }
        if (!CommonConfigurationKt.access$isEKClientSecretValid(customerAccessType.getEphemeralKeySecret()) || !CommonConfigurationKt.access$isEKClientSecretValid(this.customer.getEphemeralKeySecret())) {
            throw new IllegalArgumentException("`ephemeralKeySecret` format does not match expected client secret formatting");
        }
    }

    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.merchantDisplayName);
        Object object = this.customer;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((PaymentSheet.CustomerConfiguration)object).writeToParcel(dest, flags);
        }
        object = this.googlePay;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((PaymentSheet.GooglePayConfiguration)object).writeToParcel(dest, flags);
        }
        this.link.writeToParcel(dest, flags);
        object = this.defaultBillingDetails;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((PaymentSheet.BillingDetails)object).writeToParcel(dest, flags);
        }
        object = this.shippingDetails;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((AddressDetails)object).writeToParcel(dest, flags);
        }
        dest.writeInt(this.allowsDelayedPaymentMethods ? 1 : 0);
        dest.writeInt(this.allowsPaymentMethodsRequiringShippingAddress ? 1 : 0);
        this.billingDetailsCollectionConfiguration.writeToParcel(dest, flags);
        object = this.preferredNetworks;
        dest.writeInt(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            dest.writeString(((CardBrand)iterator.next()).name());
        }
        dest.writeInt(this.allowsRemovalOfLastSavedPaymentMethod ? 1 : 0);
        dest.writeStringList(this.paymentMethodOrder);
        dest.writeStringList(this.externalPaymentMethods);
        dest.writeParcelable((Parcelable)this.cardBrandAcceptance, flags);
        object = this.customPaymentMethods;
        dest.writeInt(object.size());
        iterator = object.iterator();
        while (iterator.hasNext()) {
            ((PaymentSheet.CustomPaymentMethod)iterator.next()).writeToParcel(dest, flags);
        }
    }

    public final int describeContents() {
        return 0;
    }

    @NotNull
    public final String component1() {
        return this.merchantDisplayName;
    }

    @Nullable
    public final PaymentSheet.CustomerConfiguration component2() {
        return this.customer;
    }

    @Nullable
    public final PaymentSheet.GooglePayConfiguration component3() {
        return this.googlePay;
    }

    @NotNull
    public final PaymentSheet.LinkConfiguration component4() {
        return this.link;
    }

    @Nullable
    public final PaymentSheet.BillingDetails component5() {
        return this.defaultBillingDetails;
    }

    @Nullable
    public final AddressDetails component6() {
        return this.shippingDetails;
    }

    public final boolean component7() {
        return this.allowsDelayedPaymentMethods;
    }

    public final boolean component8() {
        return this.allowsPaymentMethodsRequiringShippingAddress;
    }

    @NotNull
    public final PaymentSheet.BillingDetailsCollectionConfiguration component9() {
        return this.billingDetailsCollectionConfiguration;
    }

    @NotNull
    public final List<CardBrand> component10() {
        return this.preferredNetworks;
    }

    public final boolean component11() {
        return this.allowsRemovalOfLastSavedPaymentMethod;
    }

    @NotNull
    public final List<String> component12() {
        return this.paymentMethodOrder;
    }

    @NotNull
    public final List<String> component13() {
        return this.externalPaymentMethods;
    }

    @NotNull
    public final PaymentSheet.CardBrandAcceptance component14() {
        return this.cardBrandAcceptance;
    }

    @NotNull
    public final List<PaymentSheet.CustomPaymentMethod> component15() {
        return this.customPaymentMethods;
    }

    @NotNull
    public final CommonConfiguration copy(@NotNull String merchantDisplayName, @Nullable PaymentSheet.CustomerConfiguration customer2, @Nullable PaymentSheet.GooglePayConfiguration googlePay, @NotNull PaymentSheet.LinkConfiguration link, @Nullable PaymentSheet.BillingDetails defaultBillingDetails, @Nullable AddressDetails shippingDetails, boolean allowsDelayedPaymentMethods, boolean allowsPaymentMethodsRequiringShippingAddress, @NotNull PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, @NotNull List<? extends CardBrand> preferredNetworks, boolean allowsRemovalOfLastSavedPaymentMethod, @NotNull List<String> paymentMethodOrder, @NotNull List<String> externalPaymentMethods, @NotNull PaymentSheet.CardBrandAcceptance cardBrandAcceptance, @NotNull List<PaymentSheet.CustomPaymentMethod> customPaymentMethods) {
        Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)billingDetailsCollectionConfiguration, (String)"billingDetailsCollectionConfiguration");
        Intrinsics.checkNotNullParameter(preferredNetworks, (String)"preferredNetworks");
        Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
        Intrinsics.checkNotNullParameter(externalPaymentMethods, (String)"externalPaymentMethods");
        Intrinsics.checkNotNullParameter((Object)cardBrandAcceptance, (String)"cardBrandAcceptance");
        Intrinsics.checkNotNullParameter(customPaymentMethods, (String)"customPaymentMethods");
        return new CommonConfiguration(merchantDisplayName, customer2, googlePay, link, defaultBillingDetails, shippingDetails, allowsDelayedPaymentMethods, allowsPaymentMethodsRequiringShippingAddress, billingDetailsCollectionConfiguration, preferredNetworks, allowsRemovalOfLastSavedPaymentMethod, paymentMethodOrder, externalPaymentMethods, cardBrandAcceptance, customPaymentMethods);
    }

    public static /* synthetic */ CommonConfiguration copy$default(CommonConfiguration commonConfiguration, String string2, PaymentSheet.CustomerConfiguration customerConfiguration, PaymentSheet.GooglePayConfiguration googlePayConfiguration, PaymentSheet.LinkConfiguration linkConfiguration, PaymentSheet.BillingDetails billingDetails, AddressDetails addressDetails, boolean bl, boolean bl2, PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, List list, boolean bl3, List list2, List list3, PaymentSheet.CardBrandAcceptance cardBrandAcceptance, List list4, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = commonConfiguration.merchantDisplayName;
        }
        if ((n & 2) != 0) {
            customerConfiguration = commonConfiguration.customer;
        }
        if ((n & 4) != 0) {
            googlePayConfiguration = commonConfiguration.googlePay;
        }
        if ((n & 8) != 0) {
            linkConfiguration = commonConfiguration.link;
        }
        if ((n & 0x10) != 0) {
            billingDetails = commonConfiguration.defaultBillingDetails;
        }
        if ((n & 0x20) != 0) {
            addressDetails = commonConfiguration.shippingDetails;
        }
        if ((n & 0x40) != 0) {
            bl = commonConfiguration.allowsDelayedPaymentMethods;
        }
        if ((n & 0x80) != 0) {
            bl2 = commonConfiguration.allowsPaymentMethodsRequiringShippingAddress;
        }
        if ((n & 0x100) != 0) {
            billingDetailsCollectionConfiguration = commonConfiguration.billingDetailsCollectionConfiguration;
        }
        if ((n & 0x200) != 0) {
            list = commonConfiguration.preferredNetworks;
        }
        if ((n & 0x400) != 0) {
            bl3 = commonConfiguration.allowsRemovalOfLastSavedPaymentMethod;
        }
        if ((n & 0x800) != 0) {
            list2 = commonConfiguration.paymentMethodOrder;
        }
        if ((n & 0x1000) != 0) {
            list3 = commonConfiguration.externalPaymentMethods;
        }
        if ((n & 0x2000) != 0) {
            cardBrandAcceptance = commonConfiguration.cardBrandAcceptance;
        }
        if ((n & 0x4000) != 0) {
            list4 = commonConfiguration.customPaymentMethods;
        }
        return commonConfiguration.copy(string2, customerConfiguration, googlePayConfiguration, linkConfiguration, billingDetails, addressDetails, bl, bl2, billingDetailsCollectionConfiguration, list, bl3, list2, list3, cardBrandAcceptance, list4);
    }

    @NotNull
    public String toString() {
        return "CommonConfiguration(merchantDisplayName=" + this.merchantDisplayName + ", customer=" + this.customer + ", googlePay=" + this.googlePay + ", link=" + this.link + ", defaultBillingDetails=" + this.defaultBillingDetails + ", shippingDetails=" + this.shippingDetails + ", allowsDelayedPaymentMethods=" + this.allowsDelayedPaymentMethods + ", allowsPaymentMethodsRequiringShippingAddress=" + this.allowsPaymentMethodsRequiringShippingAddress + ", billingDetailsCollectionConfiguration=" + this.billingDetailsCollectionConfiguration + ", preferredNetworks=" + this.preferredNetworks + ", allowsRemovalOfLastSavedPaymentMethod=" + this.allowsRemovalOfLastSavedPaymentMethod + ", paymentMethodOrder=" + this.paymentMethodOrder + ", externalPaymentMethods=" + this.externalPaymentMethods + ", cardBrandAcceptance=" + this.cardBrandAcceptance + ", customPaymentMethods=" + this.customPaymentMethods + ")";
    }

    public int hashCode() {
        int result2 = this.merchantDisplayName.hashCode();
        result2 = result2 * 31 + (this.customer == null ? 0 : this.customer.hashCode());
        result2 = result2 * 31 + (this.googlePay == null ? 0 : this.googlePay.hashCode());
        result2 = result2 * 31 + this.link.hashCode();
        result2 = result2 * 31 + (this.defaultBillingDetails == null ? 0 : this.defaultBillingDetails.hashCode());
        result2 = result2 * 31 + (this.shippingDetails == null ? 0 : this.shippingDetails.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.allowsDelayedPaymentMethods);
        result2 = result2 * 31 + Boolean.hashCode(this.allowsPaymentMethodsRequiringShippingAddress);
        result2 = result2 * 31 + this.billingDetailsCollectionConfiguration.hashCode();
        result2 = result2 * 31 + ((Object)this.preferredNetworks).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.allowsRemovalOfLastSavedPaymentMethod);
        result2 = result2 * 31 + ((Object)this.paymentMethodOrder).hashCode();
        result2 = result2 * 31 + ((Object)this.externalPaymentMethods).hashCode();
        result2 = result2 * 31 + this.cardBrandAcceptance.hashCode();
        result2 = result2 * 31 + ((Object)this.customPaymentMethods).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommonConfiguration)) {
            return false;
        }
        CommonConfiguration commonConfiguration = (CommonConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.merchantDisplayName, (Object)commonConfiguration.merchantDisplayName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.customer, (Object)commonConfiguration.customer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.googlePay, (Object)commonConfiguration.googlePay)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.link, (Object)commonConfiguration.link)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultBillingDetails, (Object)commonConfiguration.defaultBillingDetails)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shippingDetails, (Object)commonConfiguration.shippingDetails)) {
            return false;
        }
        if (this.allowsDelayedPaymentMethods != commonConfiguration.allowsDelayedPaymentMethods) {
            return false;
        }
        if (this.allowsPaymentMethodsRequiringShippingAddress != commonConfiguration.allowsPaymentMethodsRequiringShippingAddress) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.billingDetailsCollectionConfiguration, (Object)commonConfiguration.billingDetailsCollectionConfiguration)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.preferredNetworks, commonConfiguration.preferredNetworks)) {
            return false;
        }
        if (this.allowsRemovalOfLastSavedPaymentMethod != commonConfiguration.allowsRemovalOfLastSavedPaymentMethod) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paymentMethodOrder, commonConfiguration.paymentMethodOrder)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.externalPaymentMethods, commonConfiguration.externalPaymentMethods)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cardBrandAcceptance, (Object)commonConfiguration.cardBrandAcceptance)) {
            return false;
        }
        return Intrinsics.areEqual(this.customPaymentMethods, commonConfiguration.customPaymentMethods);
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<CommonConfiguration> {
            public final CommonConfiguration[] newArray(int size) {
                return new CommonConfiguration[size];
            }

            public final CommonConfiguration createFromParcel(Parcel parcel) {
                int n;
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n2 = parcel.readInt();
                ArrayList<Object> arrayList = new ArrayList<Object>(n2);
                PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = (PaymentSheet.BillingDetailsCollectionConfiguration)PaymentSheet.BillingDetailsCollectionConfiguration.CREATOR.createFromParcel(parcel);
                boolean bl = parcel.readInt() != 0;
                boolean bl2 = parcel.readInt() != 0;
                AddressDetails addressDetails = (AddressDetails)(parcel.readInt() == 0 ? null : AddressDetails.CREATOR.createFromParcel(parcel));
                PaymentSheet.BillingDetails billingDetails = (PaymentSheet.BillingDetails)(parcel.readInt() == 0 ? null : PaymentSheet.BillingDetails.CREATOR.createFromParcel(parcel));
                PaymentSheet.LinkConfiguration linkConfiguration = (PaymentSheet.LinkConfiguration)PaymentSheet.LinkConfiguration.CREATOR.createFromParcel(parcel);
                PaymentSheet.GooglePayConfiguration googlePayConfiguration = (PaymentSheet.GooglePayConfiguration)(parcel.readInt() == 0 ? null : PaymentSheet.GooglePayConfiguration.CREATOR.createFromParcel(parcel));
                PaymentSheet.CustomerConfiguration customerConfiguration = (PaymentSheet.CustomerConfiguration)(parcel.readInt() == 0 ? null : PaymentSheet.CustomerConfiguration.CREATOR.createFromParcel(parcel));
                String string2 = parcel.readString();
                for (n = 0; n != n2; ++n) {
                    arrayList.add(CardBrand.valueOf((String)parcel.readString()));
                }
                List list = arrayList;
                n2 = parcel.readInt();
                arrayList = new ArrayList(n2);
                PaymentSheet.CardBrandAcceptance cardBrandAcceptance = (PaymentSheet.CardBrandAcceptance)parcel.readParcelable(CommonConfiguration.class.getClassLoader());
                List list2 = parcel.createStringArrayList();
                List list3 = parcel.createStringArrayList();
                boolean bl3 = parcel.readInt() != 0;
                List list4 = list;
                for (n = 0; n != n2; ++n) {
                    arrayList.add(PaymentSheet.CustomPaymentMethod.CREATOR.createFromParcel(parcel));
                }
                List list5 = arrayList;
                PaymentSheet.CardBrandAcceptance cardBrandAcceptance2 = cardBrandAcceptance;
                List list6 = list2;
                List list7 = list3;
                boolean bl4 = bl3;
                List list8 = list4;
                PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration2 = billingDetailsCollectionConfiguration;
                boolean bl5 = bl;
                boolean bl6 = bl2;
                AddressDetails addressDetails2 = addressDetails;
                PaymentSheet.BillingDetails billingDetails2 = billingDetails;
                PaymentSheet.LinkConfiguration linkConfiguration2 = linkConfiguration;
                PaymentSheet.GooglePayConfiguration googlePayConfiguration2 = googlePayConfiguration;
                PaymentSheet.CustomerConfiguration customerConfiguration2 = customerConfiguration;
                String string3 = string2;
                return new CommonConfiguration(string3, customerConfiguration2, googlePayConfiguration2, linkConfiguration2, billingDetails2, addressDetails2, bl6, bl5, billingDetailsCollectionConfiguration2, list8, bl4, list7, list6, cardBrandAcceptance2, list5);
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }
}

