/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.common.model;

import com.stripe.android.common.model.CommonConfiguration;
import com.stripe.android.common.model.VolatileCommonConfiguration;
import com.stripe.android.model.CardBrand;
import com.stripe.android.paymentelement.EmbeddedPaymentElement;
import com.stripe.android.paymentelement.ExperimentalEmbeddedPaymentElementApi;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0003H\u0001\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u001a\u0014\u0010\b\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0001H\u0002\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"asCommonConfiguration", "Lcom/stripe/android/common/model/CommonConfiguration;", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Configuration;", "isEKClientSecretValid", "", "", "EK_CLIENT_SECRET_VALID_REGEX_PATTERN", "containsVolatileDifferences", "other", "toVolatileConfiguration", "Lcom/stripe/android/common/model/VolatileCommonConfiguration;", "paymentsheet_release"})
public final class CommonConfigurationKt {
    @NotNull
    private static final String EK_CLIENT_SECRET_VALID_REGEX_PATTERN = "^ek_[^_](.)+$";

    @NotNull
    public static final CommonConfiguration asCommonConfiguration(@NotNull PaymentSheet.Configuration $this$asCommonConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$asCommonConfiguration, (String)"<this>");
        String string2 = $this$asCommonConfiguration.getMerchantDisplayName();
        PaymentSheet.CustomerConfiguration customerConfiguration = $this$asCommonConfiguration.getCustomer();
        PaymentSheet.GooglePayConfiguration googlePayConfiguration = $this$asCommonConfiguration.getGooglePay();
        PaymentSheet.BillingDetails billingDetails = $this$asCommonConfiguration.getDefaultBillingDetails();
        AddressDetails addressDetails = $this$asCommonConfiguration.getShippingDetails();
        boolean bl = $this$asCommonConfiguration.getAllowsDelayedPaymentMethods();
        boolean bl2 = $this$asCommonConfiguration.getAllowsPaymentMethodsRequiringShippingAddress();
        PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = $this$asCommonConfiguration.getBillingDetailsCollectionConfiguration();
        List<CardBrand> list = $this$asCommonConfiguration.getPreferredNetworks();
        boolean bl3 = $this$asCommonConfiguration.getAllowsRemovalOfLastSavedPaymentMethod$paymentsheet_release();
        List<String> list2 = $this$asCommonConfiguration.getPaymentMethodOrder$paymentsheet_release();
        List<String> list3 = $this$asCommonConfiguration.getExternalPaymentMethods$paymentsheet_release();
        PaymentSheet.CardBrandAcceptance cardBrandAcceptance = $this$asCommonConfiguration.getCardBrandAcceptance$paymentsheet_release();
        List<PaymentSheet.CustomPaymentMethod> list4 = $this$asCommonConfiguration.getCustomPaymentMethods$paymentsheet_release();
        PaymentSheet.LinkConfiguration linkConfiguration = $this$asCommonConfiguration.getLink$paymentsheet_release();
        return new CommonConfiguration(string2, customerConfiguration, googlePayConfiguration, linkConfiguration, billingDetails, addressDetails, bl, bl2, billingDetailsCollectionConfiguration, list, bl3, list2, list3, cardBrandAcceptance, list4);
    }

    @ExperimentalEmbeddedPaymentElementApi
    @NotNull
    public static final CommonConfiguration asCommonConfiguration(@NotNull EmbeddedPaymentElement.Configuration $this$asCommonConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$asCommonConfiguration, (String)"<this>");
        String string2 = $this$asCommonConfiguration.getMerchantDisplayName$paymentsheet_release();
        PaymentSheet.CustomerConfiguration customerConfiguration = $this$asCommonConfiguration.getCustomer$paymentsheet_release();
        PaymentSheet.GooglePayConfiguration googlePayConfiguration = $this$asCommonConfiguration.getGooglePay$paymentsheet_release();
        PaymentSheet.BillingDetails billingDetails = $this$asCommonConfiguration.getDefaultBillingDetails$paymentsheet_release();
        AddressDetails addressDetails = $this$asCommonConfiguration.getShippingDetails$paymentsheet_release();
        boolean bl = $this$asCommonConfiguration.getAllowsDelayedPaymentMethods$paymentsheet_release();
        boolean bl2 = $this$asCommonConfiguration.getAllowsPaymentMethodsRequiringShippingAddress$paymentsheet_release();
        PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = $this$asCommonConfiguration.getBillingDetailsCollectionConfiguration$paymentsheet_release();
        List<CardBrand> list = $this$asCommonConfiguration.getPreferredNetworks$paymentsheet_release();
        boolean bl3 = $this$asCommonConfiguration.getAllowsRemovalOfLastSavedPaymentMethod$paymentsheet_release();
        List<String> list2 = $this$asCommonConfiguration.getPaymentMethodOrder$paymentsheet_release();
        List<String> list3 = $this$asCommonConfiguration.getExternalPaymentMethods$paymentsheet_release();
        PaymentSheet.CardBrandAcceptance cardBrandAcceptance = $this$asCommonConfiguration.getCardBrandAcceptance$paymentsheet_release();
        List<PaymentSheet.CustomPaymentMethod> list4 = $this$asCommonConfiguration.getCustomPaymentMethods$paymentsheet_release();
        PaymentSheet.LinkConfiguration linkConfiguration = $this$asCommonConfiguration.getLink$paymentsheet_release();
        return new CommonConfiguration(string2, customerConfiguration, googlePayConfiguration, linkConfiguration, billingDetails, addressDetails, bl, bl2, billingDetailsCollectionConfiguration, list, bl3, list2, list3, cardBrandAcceptance, list4);
    }

    private static final boolean isEKClientSecretValid(String $this$isEKClientSecretValid) {
        return new Regex(EK_CLIENT_SECRET_VALID_REGEX_PATTERN).matches((CharSequence)$this$isEKClientSecretValid);
    }

    public static final boolean containsVolatileDifferences(@NotNull CommonConfiguration $this$containsVolatileDifferences, @NotNull CommonConfiguration other) {
        Intrinsics.checkNotNullParameter((Object)$this$containsVolatileDifferences, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return !Intrinsics.areEqual((Object)CommonConfigurationKt.toVolatileConfiguration($this$containsVolatileDifferences), (Object)CommonConfigurationKt.toVolatileConfiguration(other));
    }

    private static final VolatileCommonConfiguration toVolatileConfiguration(CommonConfiguration $this$toVolatileConfiguration) {
        return new VolatileCommonConfiguration($this$toVolatileConfiguration.getDefaultBillingDetails(), $this$toVolatileConfiguration.getBillingDetailsCollectionConfiguration(), $this$toVolatileConfiguration.getCardBrandAcceptance());
    }

    public static final /* synthetic */ boolean access$isEKClientSecretValid(String $receiver) {
        return CommonConfigurationKt.isEKClientSecretValid($receiver);
    }
}

