/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.customersheet.injection;

import android.app.Application;
import android.content.Context;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.core.Logger;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor_Factory;
import com.stripe.android.customersheet.CustomerSheet;
import com.stripe.android.customersheet.CustomerSheetIntegration;
import com.stripe.android.customersheet.CustomerSheetViewModel;
import com.stripe.android.customersheet.CustomerSheetViewModel_Factory;
import com.stripe.android.customersheet.DefaultCustomerSheetLoader;
import com.stripe.android.customersheet.DefaultCustomerSheetLoader_Factory;
import com.stripe.android.customersheet.analytics.DefaultCustomerSheetEventReporter;
import com.stripe.android.customersheet.analytics.DefaultCustomerSheetEventReporter_Factory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelComponent;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_ContextFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_IoContextFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_IsLiveModeFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_PaymentConfigurationFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_ProvideAllowsManualConfirmationFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_ProvideLoggerFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_ProvideProductUsageTokensFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_ProvidePublishableKeyFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_ProvideStripeAccountIdFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_ProvidesEnableLoggingFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_ProvidesErrorReporter$paymentsheet_releaseFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_ProvidesIsFinancialConnectionsAvailableFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_ProvidesPaymentElementCallbackIdentifierFactory;
import com.stripe.android.customersheet.injection.CustomerSheetViewModelModule_Companion_SavedPaymentSelectionFactory;
import com.stripe.android.googlepaylauncher.GooglePayEnvironment;
import com.stripe.android.googlepaylauncher.GooglePayRepository;
import com.stripe.android.googlepaylauncher.injection.GooglePayLauncherModule;
import com.stripe.android.googlepaylauncher.injection.GooglePayLauncherModule_ProvideGooglePayRepositoryFactoryFactory;
import com.stripe.android.lpmfoundations.luxe.LpmRepository;
import com.stripe.android.lpmfoundations.luxe.LpmRepository_Factory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory_Factory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeApiRepository_Factory;
import com.stripe.android.paymentelement.confirmation.ConfirmationDefinition;
import com.stripe.android.paymentelement.confirmation.ConfirmationRegistry;
import com.stripe.android.paymentelement.confirmation.DefaultConfirmationHandler;
import com.stripe.android.paymentelement.confirmation.DefaultConfirmationHandler_Factory_Factory;
import com.stripe.android.paymentelement.confirmation.injection.ConfirmationHandlerModule_Companion_ProvidesConfirmationRegistryFactory;
import com.stripe.android.paymentelement.confirmation.intent.DefaultIntentConfirmationInterceptor;
import com.stripe.android.paymentelement.confirmation.intent.DefaultIntentConfirmationInterceptor_Factory;
import com.stripe.android.paymentelement.confirmation.intent.IntentConfirmationModule_Companion_ProvidesCreateIntentCallbackFactory;
import com.stripe.android.paymentelement.confirmation.intent.IntentConfirmationModule_Companion_ProvidesIntentConfirmationDefinitionFactory;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.payments.financialconnections.IsFinancialConnectionsSdkAvailable;
import com.stripe.android.payments.paymentlauncher.StripePaymentLauncherAssistedFactory;
import com.stripe.android.payments.paymentlauncher.StripePaymentLauncherAssistedFactory_Impl;
import com.stripe.android.payments.paymentlauncher.StripePaymentLauncher_Factory;
import com.stripe.android.paymentsheet.CreateIntentCallback;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.SetFactory;
import java.util.Set;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;

@DaggerGenerated
public final class DaggerCustomerSheetViewModelComponent {
    private DaggerCustomerSheetViewModelComponent() {
    }

    public static CustomerSheetViewModelComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements CustomerSheetViewModelComponent.Builder {
        private Application application;
        private CustomerSheet.Configuration configuration;
        private Integer statusBarColor;
        private CustomerSheetIntegration.Type integrationType;
        private SavedStateHandle savedStateHandle;

        private Builder() {
        }

        @Override
        public Builder application(Application application) {
            this.application = (Application)Preconditions.checkNotNull((Object)application);
            return this;
        }

        @Override
        public Builder configuration(CustomerSheet.Configuration configuration) {
            this.configuration = (CustomerSheet.Configuration)Preconditions.checkNotNull((Object)configuration);
            return this;
        }

        @Override
        public Builder statusBarColor(Integer statusBarColor) {
            this.statusBarColor = statusBarColor;
            return this;
        }

        @Override
        public Builder integrationType(CustomerSheetIntegration.Type integrationType) {
            this.integrationType = (CustomerSheetIntegration.Type)((Object)Preconditions.checkNotNull((Object)((Object)integrationType)));
            return this;
        }

        @Override
        public Builder savedStateHandle(SavedStateHandle savedStateHandle) {
            this.savedStateHandle = (SavedStateHandle)Preconditions.checkNotNull((Object)savedStateHandle);
            return this;
        }

        @Override
        public CustomerSheetViewModelComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.application, Application.class);
            Preconditions.checkBuilderRequirement((Object)this.configuration, CustomerSheet.Configuration.class);
            Preconditions.checkBuilderRequirement((Object)((Object)this.integrationType), CustomerSheetIntegration.Type.class);
            Preconditions.checkBuilderRequirement((Object)this.savedStateHandle, SavedStateHandle.class);
            return new CustomerSheetViewModelComponentImpl(new GooglePayLauncherModule(), this.application, this.configuration, this.statusBarColor, this.integrationType, this.savedStateHandle);
        }
    }

    private static final class CustomerSheetViewModelComponentImpl
    implements CustomerSheetViewModelComponent {
        private final CustomerSheetViewModelComponentImpl customerSheetViewModelComponentImpl = this;
        private Provider<Application> applicationProvider;
        private Provider<PaymentConfiguration> paymentConfigurationProvider;
        private Provider<CustomerSheet.Configuration> configurationProvider;
        private Provider<CustomerSheetIntegration.Type> integrationTypeProvider;
        private Provider<Logger> provideLoggerProvider;
        private Provider<Context> contextProvider;
        private Provider<Function0<String>> providePublishableKeyProvider;
        private Provider<PaymentAnalyticsRequestFactory> paymentAnalyticsRequestFactoryProvider;
        private Provider<DefaultAnalyticsRequestExecutor> defaultAnalyticsRequestExecutorProvider;
        private Provider<StripeApiRepository> stripeApiRepositoryProvider;
        private Provider<DefaultCustomerSheetEventReporter> defaultCustomerSheetEventReporterProvider;
        private Provider<Function0<Boolean>> isLiveModeProvider;
        private Provider<ErrorReporter> providesErrorReporter$paymentsheet_releaseProvider;
        private Provider<CreateIntentCallback> providesCreateIntentCallbackProvider;
        private Provider<Function0<String>> provideStripeAccountIdProvider;
        private Provider<DefaultIntentConfirmationInterceptor> defaultIntentConfirmationInterceptorProvider;
        private StripePaymentLauncher_Factory stripePaymentLauncherProvider;
        private Provider<StripePaymentLauncherAssistedFactory> stripePaymentLauncherAssistedFactoryProvider;
        private Provider<Integer> statusBarColorProvider;
        private Provider<ConfirmationDefinition<?, ?, ?, ?>> providesIntentConfirmationDefinitionProvider;
        private Provider<Set<ConfirmationDefinition<?, ?, ?, ?>>> setOfConfirmationDefinitionOfAndAndAndProvider;
        private Provider<ConfirmationRegistry> providesConfirmationRegistryProvider;
        private Provider<SavedStateHandle> savedStateHandleProvider;
        private Provider<DefaultConfirmationHandler.Factory> factoryProvider;
        private Provider<Function1<GooglePayEnvironment, GooglePayRepository>> provideGooglePayRepositoryFactoryProvider;
        private Provider<DefaultCustomerSheetLoader> defaultCustomerSheetLoaderProvider;
        private Provider<CustomerSheetViewModel> customerSheetViewModelProvider;

        private CustomerSheetViewModelComponentImpl(GooglePayLauncherModule googlePayLauncherModuleParam, Application applicationParam, CustomerSheet.Configuration configurationParam, Integer statusBarColorParam, CustomerSheetIntegration.Type integrationTypeParam, SavedStateHandle savedStateHandleParam) {
            this.initialize(googlePayLauncherModuleParam, applicationParam, configurationParam, statusBarColorParam, integrationTypeParam, savedStateHandleParam);
            this.initialize2(googlePayLauncherModuleParam, applicationParam, configurationParam, statusBarColorParam, integrationTypeParam, savedStateHandleParam);
        }

        private void initialize(GooglePayLauncherModule googlePayLauncherModuleParam, Application applicationParam, CustomerSheet.Configuration configurationParam, Integer statusBarColorParam, CustomerSheetIntegration.Type integrationTypeParam, SavedStateHandle savedStateHandleParam) {
            this.applicationProvider = InstanceFactory.create((Object)applicationParam);
            this.paymentConfigurationProvider = CustomerSheetViewModelModule_Companion_PaymentConfigurationFactory.create(this.applicationProvider);
            this.configurationProvider = InstanceFactory.create((Object)configurationParam);
            this.integrationTypeProvider = InstanceFactory.create((Object)((Object)integrationTypeParam));
            this.provideLoggerProvider = CustomerSheetViewModelModule_Companion_ProvideLoggerFactory.create((Provider<Boolean>)CustomerSheetViewModelModule_Companion_ProvidesEnableLoggingFactory.create());
            this.contextProvider = CustomerSheetViewModelModule_Companion_ContextFactory.create(this.applicationProvider);
            this.providePublishableKeyProvider = CustomerSheetViewModelModule_Companion_ProvidePublishableKeyFactory.create(this.paymentConfigurationProvider);
            this.paymentAnalyticsRequestFactoryProvider = PaymentAnalyticsRequestFactory_Factory.create(this.contextProvider, this.providePublishableKeyProvider, (Provider)CustomerSheetViewModelModule_Companion_ProvideProductUsageTokensFactory.create());
            this.defaultAnalyticsRequestExecutorProvider = DefaultAnalyticsRequestExecutor_Factory.create(this.provideLoggerProvider, (Provider)CustomerSheetViewModelModule_Companion_IoContextFactory.create());
            this.stripeApiRepositoryProvider = StripeApiRepository_Factory.create(this.contextProvider, this.providePublishableKeyProvider, (Provider)CustomerSheetViewModelModule_Companion_IoContextFactory.create(), (Provider)CustomerSheetViewModelModule_Companion_ProvideProductUsageTokensFactory.create(), this.paymentAnalyticsRequestFactoryProvider, this.defaultAnalyticsRequestExecutorProvider, this.provideLoggerProvider);
            this.defaultCustomerSheetEventReporterProvider = DefaultCustomerSheetEventReporter_Factory.create(this.defaultAnalyticsRequestExecutorProvider, this.paymentAnalyticsRequestFactoryProvider, (Provider<CoroutineContext>)CustomerSheetViewModelModule_Companion_IoContextFactory.create());
            this.isLiveModeProvider = CustomerSheetViewModelModule_Companion_IsLiveModeFactory.create(this.paymentConfigurationProvider);
            this.providesErrorReporter$paymentsheet_releaseProvider = CustomerSheetViewModelModule_Companion_ProvidesErrorReporter$paymentsheet_releaseFactory.create(this.paymentAnalyticsRequestFactoryProvider, this.defaultAnalyticsRequestExecutorProvider);
            this.providesCreateIntentCallbackProvider = IntentConfirmationModule_Companion_ProvidesCreateIntentCallbackFactory.create((Provider<String>)CustomerSheetViewModelModule_Companion_ProvidesPaymentElementCallbackIdentifierFactory.create());
            this.provideStripeAccountIdProvider = CustomerSheetViewModelModule_Companion_ProvideStripeAccountIdFactory.create(this.paymentConfigurationProvider);
            this.defaultIntentConfirmationInterceptorProvider = DefaultIntentConfirmationInterceptor_Factory.create(this.stripeApiRepositoryProvider, this.providesErrorReporter$paymentsheet_releaseProvider, this.providesCreateIntentCallbackProvider, (Provider<Boolean>)CustomerSheetViewModelModule_Companion_ProvideAllowsManualConfirmationFactory.create(), this.providePublishableKeyProvider, this.provideStripeAccountIdProvider);
            this.stripePaymentLauncherProvider = StripePaymentLauncher_Factory.create((Provider)CustomerSheetViewModelModule_Companion_ProvidesEnableLoggingFactory.create(), (Provider)CustomerSheetViewModelModule_Companion_ProvideProductUsageTokensFactory.create());
            this.stripePaymentLauncherAssistedFactoryProvider = StripePaymentLauncherAssistedFactory_Impl.createFactoryProvider((StripePaymentLauncher_Factory)this.stripePaymentLauncherProvider);
            this.statusBarColorProvider = InstanceFactory.createNullable((Object)statusBarColorParam);
            this.providesIntentConfirmationDefinitionProvider = IntentConfirmationModule_Companion_ProvidesIntentConfirmationDefinitionFactory.create(this.defaultIntentConfirmationInterceptorProvider, this.stripePaymentLauncherAssistedFactoryProvider, this.statusBarColorProvider, this.paymentConfigurationProvider);
            this.setOfConfirmationDefinitionOfAndAndAndProvider = SetFactory.builder((int)1, (int)0).addProvider(this.providesIntentConfirmationDefinitionProvider).build();
            this.providesConfirmationRegistryProvider = ConfirmationHandlerModule_Companion_ProvidesConfirmationRegistryFactory.create(this.setOfConfirmationDefinitionOfAndAndAndProvider);
            this.savedStateHandleProvider = InstanceFactory.create((Object)savedStateHandleParam);
            this.factoryProvider = DefaultConfirmationHandler_Factory_Factory.create(this.providesConfirmationRegistryProvider, this.savedStateHandleProvider, this.providesErrorReporter$paymentsheet_releaseProvider, (Provider<CoroutineContext>)CustomerSheetViewModelModule_Companion_IoContextFactory.create());
            this.provideGooglePayRepositoryFactoryProvider = GooglePayLauncherModule_ProvideGooglePayRepositoryFactoryFactory.create((GooglePayLauncherModule)googlePayLauncherModuleParam, this.contextProvider, this.provideLoggerProvider, this.providesErrorReporter$paymentsheet_releaseProvider);
        }

        private void initialize2(GooglePayLauncherModule googlePayLauncherModuleParam, Application applicationParam, CustomerSheet.Configuration configurationParam, Integer statusBarColorParam, CustomerSheetIntegration.Type integrationTypeParam, SavedStateHandle savedStateHandleParam) {
            this.defaultCustomerSheetLoaderProvider = DefaultCustomerSheetLoader_Factory.create(this.isLiveModeProvider, this.provideGooglePayRepositoryFactoryProvider, (Provider<IsFinancialConnectionsSdkAvailable>)CustomerSheetViewModelModule_Companion_ProvidesIsFinancialConnectionsAvailableFactory.create(), (Provider<LpmRepository>)LpmRepository_Factory.create(), this.providesErrorReporter$paymentsheet_releaseProvider, (Provider<CoroutineContext>)CustomerSheetViewModelModule_Companion_IoContextFactory.create());
            this.customerSheetViewModelProvider = DoubleCheck.provider((Provider)CustomerSheetViewModel_Factory.create(this.applicationProvider, (Provider<PaymentSelection>)CustomerSheetViewModelModule_Companion_SavedPaymentSelectionFactory.create(), this.paymentConfigurationProvider, this.configurationProvider, this.integrationTypeProvider, this.provideLoggerProvider, this.stripeApiRepositoryProvider, this.defaultCustomerSheetEventReporterProvider, (Provider<CoroutineContext>)CustomerSheetViewModelModule_Companion_IoContextFactory.create(), this.isLiveModeProvider, (Provider<Set<String>>)CustomerSheetViewModelModule_Companion_ProvideProductUsageTokensFactory.create(), this.factoryProvider, this.defaultCustomerSheetLoaderProvider, this.providesErrorReporter$paymentsheet_releaseProvider));
        }

        @Override
        public CustomerSheetViewModel getViewModel() {
            return (CustomerSheetViewModel)((Object)this.customerSheetViewModelProvider.get());
        }
    }
}

