/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.customersheet.util;

import com.stripe.android.model.ElementsSession;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\"\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u00a8\u0006\r"}, d2={"filterToSupportedPaymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "isSyncDefaultPaymentMethodFeatureEnabled", "", "getDefaultPaymentMethodsEnabledForCustomerSheet", "elementsSession", "Lcom/stripe/android/model/ElementsSession;", "getDefaultPaymentMethodAsPaymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "paymentMethods", "defaultPaymentMethodId", "", "paymentsheet_release"})
@SourceDebugExtension(value={"SMAP\nSyncDefaultPaymentMethodUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncDefaultPaymentMethodUtils.kt\ncom/stripe/android/customersheet/util/SyncDefaultPaymentMethodUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n774#2:39\n865#2,2:40\n1#3:42\n*S KotlinDebug\n*F\n+ 1 SyncDefaultPaymentMethodUtils.kt\ncom/stripe/android/customersheet/util/SyncDefaultPaymentMethodUtilsKt\n*L\n15#1:39\n15#1:40,2\n*E\n"})
public final class SyncDefaultPaymentMethodUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PaymentMethod> filterToSupportedPaymentMethods(@NotNull List<PaymentMethod> $this$filterToSupportedPaymentMethods, boolean isSyncDefaultPaymentMethodFeatureEnabled) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterToSupportedPaymentMethods, (String)"<this>");
        Object[] objectArray = new PaymentMethod.Type[]{PaymentMethod.Type.Card, PaymentMethod.Type.USBankAccount};
        List paymentMethodTypesSupportedWithSyncDefaultFeature = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$filter$iv = $this$filterToSupportedPaymentMethods;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PaymentMethod paymentMethod = (PaymentMethod)element$iv$iv;
            boolean bl = false;
            if (!(!isSyncDefaultPaymentMethodFeatureEnabled || CollectionsKt.contains((Iterable)paymentMethodTypesSupportedWithSyncDefaultFeature, (Object)paymentMethod.type))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean getDefaultPaymentMethodsEnabledForCustomerSheet(@NotNull ElementsSession elementsSession) {
        boolean bl;
        ElementsSession.Customer.Components.CustomerSheet customerSheetComponent;
        Intrinsics.checkNotNullParameter((Object)elementsSession, (String)"elementsSession");
        ElementsSession.Customer customer2 = elementsSession.getCustomer();
        ElementsSession.Customer.Components.CustomerSheet customerSheet = customer2 != null && (customer2 = customer2.getSession()) != null && (customer2 = customer2.getComponents()) != null ? customer2.getCustomerSheet() : (customerSheetComponent = null);
        if (customerSheetComponent instanceof ElementsSession.Customer.Components.CustomerSheet.Enabled) {
            bl = ((ElementsSession.Customer.Components.CustomerSheet.Enabled)customerSheetComponent).isPaymentMethodSyncDefaultEnabled();
        } else if (Intrinsics.areEqual((Object)customerSheetComponent, (Object)ElementsSession.Customer.Components.CustomerSheet.Disabled.INSTANCE) || customerSheetComponent == null) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Nullable
    public static final PaymentSelection getDefaultPaymentMethodAsPaymentSelection(@NotNull List<PaymentMethod> paymentMethods, @Nullable String defaultPaymentMethodId) {
        PaymentSelection.Saved saved;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(paymentMethods, (String)"paymentMethods");
            Iterable iterable = paymentMethods;
            for (Object t : iterable) {
                PaymentMethod paymentMethod = (PaymentMethod)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)paymentMethod.id, (Object)defaultPaymentMethodId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        PaymentMethod paymentMethod = v0;
        if (paymentMethod != null) {
            PaymentMethod it = paymentMethod;
            boolean bl = false;
            saved = new PaymentSelection.Saved(it, null, null, 6, null);
        } else {
            saved = null;
        }
        return saved;
    }
}

