/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link;

import android.app.Application;
import android.content.Context;
import androidx.activity.result.ActivityResultCaller;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.lifecycle.viewmodel.InitializerViewModelFactoryBuilder;
import androidx.navigation.NavBackStackEntry;
import com.stripe.android.link.LinkAccountUpdate;
import com.stripe.android.link.LinkAction;
import com.stripe.android.link.LinkActivity;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.LinkActivityViewModel;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.link.LinkScreen;
import com.stripe.android.link.NativeLinkArgs;
import com.stripe.android.link.NoArgsException;
import com.stripe.android.link.ScreenState;
import com.stripe.android.link.account.LinkAccountHolder;
import com.stripe.android.link.account.LinkAccountManager;
import com.stripe.android.link.account.LinkAccountUtilKt;
import com.stripe.android.link.attestation.LinkAttestationCheck;
import com.stripe.android.link.injection.DaggerNativeLinkComponent;
import com.stripe.android.link.injection.NativeLinkComponent;
import com.stripe.android.link.model.AccountStatus;
import com.stripe.android.link.model.LinkAccount;
import com.stripe.android.link.ui.LinkAppBarState;
import com.stripe.android.model.ConsumerSession;
import com.stripe.android.paymentelement.confirmation.ConfirmationHandler;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.uicore.navigation.NavBackStackEntryUpdate;
import com.stripe.android.uicore.navigation.NavigationIntent;
import com.stripe.android.uicore.navigation.NavigationManager;
import com.stripe.android.uicore.navigation.PopUpToBehavior;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 a2\u00020\u00012\u00020\u0002:\u0001aBY\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000e\u0010B\u001a\u00020:2\u0006\u0010C\u001a\u00020DJ\u0006\u0010E\u001a\u00020:J\u0006\u0010F\u001a\u00020:J\b\u0010G\u001a\u00020:H\u0002J\u000e\u0010H\u001a\u00020:2\u0006\u0010I\u001a\u00020JJ\u0006\u0010K\u001a\u00020:J\u0006\u0010L\u001a\u00020:J\u0016\u0010M\u001a\u00020:2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QJ \u0010R\u001a\u00020:2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\u00142\b\b\u0002\u0010V\u001a\u00020\u0014J\u0006\u0010W\u001a\u00020:J\u0006\u0010X\u001a\u00020:J\u0006\u0010Y\u001a\u00020:J\u0010\u0010Z\u001a\u00020:2\u0006\u0010[\u001a\u00020QH\u0016J\u000e\u0010\\\u001a\u00020:H\u0082@\u00a2\u0006\u0002\u0010]J\u000e\u0010^\u001a\u00020_H\u0082@\u00a2\u0006\u0002\u0010]J\u000e\u0010`\u001a\u00020:H\u0082@\u00a2\u0006\u0002\u0010]R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020%0'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u0002000$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00101\u001a\b\u0012\u0004\u0012\u0002000'\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010)R\u0013\u00103\u001a\u0004\u0018\u0001048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R(\u00107\u001a\u0010\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020:\u0018\u000108X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R(\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020:\u0018\u000108X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010<\"\u0004\bA\u0010>\u00a8\u0006b"}, d2={"Lcom/stripe/android/link/LinkActivityViewModel;", "Landroidx/lifecycle/ViewModel;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "activityRetainedComponent", "Lcom/stripe/android/link/injection/NativeLinkComponent;", "confirmationHandlerFactory", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Factory;", "linkAccountManager", "Lcom/stripe/android/link/account/LinkAccountManager;", "linkAccountHolder", "Lcom/stripe/android/link/account/LinkAccountHolder;", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "linkConfiguration", "Lcom/stripe/android/link/LinkConfiguration;", "linkAttestationCheck", "Lcom/stripe/android/link/attestation/LinkAttestationCheck;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "startWithVerificationDialog", "", "navigationManager", "Lcom/stripe/android/uicore/navigation/NavigationManager;", "<init>", "(Lcom/stripe/android/link/injection/NativeLinkComponent;Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Factory;Lcom/stripe/android/link/account/LinkAccountManager;Lcom/stripe/android/link/account/LinkAccountHolder;Lcom/stripe/android/paymentsheet/analytics/EventReporter;Lcom/stripe/android/link/LinkConfiguration;Lcom/stripe/android/link/attestation/LinkAttestationCheck;Landroidx/lifecycle/SavedStateHandle;ZLcom/stripe/android/uicore/navigation/NavigationManager;)V", "getActivityRetainedComponent", "()Lcom/stripe/android/link/injection/NativeLinkComponent;", "getEventReporter", "()Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "getSavedStateHandle", "()Landroidx/lifecycle/SavedStateHandle;", "confirmationHandler", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler;", "getConfirmationHandler", "()Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler;", "_linkAppBarState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/link/ui/LinkAppBarState;", "linkAppBarState", "Lkotlinx/coroutines/flow/StateFlow;", "getLinkAppBarState", "()Lkotlinx/coroutines/flow/StateFlow;", "navigationFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "Lcom/stripe/android/uicore/navigation/NavigationIntent;", "getNavigationFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "_linkScreenState", "Lcom/stripe/android/link/ScreenState;", "linkScreenState", "getLinkScreenState", "linkAccount", "Lcom/stripe/android/link/model/LinkAccount;", "getLinkAccount", "()Lcom/stripe/android/link/model/LinkAccount;", "dismissWithResult", "Lkotlin/Function1;", "Lcom/stripe/android/link/LinkActivityResult;", "", "getDismissWithResult", "()Lkotlin/jvm/functions/Function1;", "setDismissWithResult", "(Lkotlin/jvm/functions/Function1;)V", "launchWebFlow", "getLaunchWebFlow", "setLaunchWebFlow", "handleViewAction", "action", "Lcom/stripe/android/link/LinkAction;", "onVerificationSucceeded", "onDismissVerificationClicked", "handleLogoutClicked", "onNavEntryChanged", "entry", "Lcom/stripe/android/uicore/navigation/NavBackStackEntryUpdate;", "moveToWeb", "handleBackPressed", "registerActivityForConfirmation", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "navigate", "screen", "Lcom/stripe/android/link/LinkScreen;", "clearStack", "launchSingleTop", "goBack", "changeEmail", "unregisterActivity", "onCreate", "owner", "updateScreenState", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildFullScreenState", "Lcom/stripe/android/link/ScreenState$FullScreen;", "handleAccountError", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLinkActivityViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkActivityViewModel.kt\ncom/stripe/android/link/LinkActivityViewModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,274:1\n230#2,5:275\n*S KotlinDebug\n*F\n+ 1 LinkActivityViewModel.kt\ncom/stripe/android/link/LinkActivityViewModel\n*L\n110#1:275,5\n*E\n"})
public final class LinkActivityViewModel
extends ViewModel
implements DefaultLifecycleObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NativeLinkComponent activityRetainedComponent;
    @NotNull
    private final LinkAccountManager linkAccountManager;
    @NotNull
    private final LinkAccountHolder linkAccountHolder;
    @NotNull
    private final EventReporter eventReporter;
    @NotNull
    private final LinkConfiguration linkConfiguration;
    @NotNull
    private final LinkAttestationCheck linkAttestationCheck;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    private final boolean startWithVerificationDialog;
    @NotNull
    private final NavigationManager navigationManager;
    @NotNull
    private final ConfirmationHandler confirmationHandler;
    @NotNull
    private final MutableStateFlow<LinkAppBarState> _linkAppBarState;
    @NotNull
    private final StateFlow<LinkAppBarState> linkAppBarState;
    @NotNull
    private final SharedFlow<NavigationIntent> navigationFlow;
    @NotNull
    private final MutableStateFlow<ScreenState> _linkScreenState;
    @NotNull
    private final StateFlow<ScreenState> linkScreenState;
    @Nullable
    private Function1<? super LinkActivityResult, Unit> dismissWithResult;
    @Nullable
    private Function1<? super LinkConfiguration, Unit> launchWebFlow;
    public static final int $stable = 8;

    @Inject
    public LinkActivityViewModel(@NotNull NativeLinkComponent activityRetainedComponent, @NotNull ConfirmationHandler.Factory confirmationHandlerFactory, @NotNull LinkAccountManager linkAccountManager, @NotNull LinkAccountHolder linkAccountHolder, @NotNull EventReporter eventReporter, @NotNull LinkConfiguration linkConfiguration, @NotNull LinkAttestationCheck linkAttestationCheck, @NotNull SavedStateHandle savedStateHandle, boolean startWithVerificationDialog, @NotNull NavigationManager navigationManager) {
        Intrinsics.checkNotNullParameter((Object)activityRetainedComponent, (String)"activityRetainedComponent");
        Intrinsics.checkNotNullParameter((Object)confirmationHandlerFactory, (String)"confirmationHandlerFactory");
        Intrinsics.checkNotNullParameter((Object)linkAccountManager, (String)"linkAccountManager");
        Intrinsics.checkNotNullParameter((Object)linkAccountHolder, (String)"linkAccountHolder");
        Intrinsics.checkNotNullParameter((Object)eventReporter, (String)"eventReporter");
        Intrinsics.checkNotNullParameter((Object)linkConfiguration, (String)"linkConfiguration");
        Intrinsics.checkNotNullParameter((Object)linkAttestationCheck, (String)"linkAttestationCheck");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)navigationManager, (String)"navigationManager");
        this.activityRetainedComponent = activityRetainedComponent;
        this.linkAccountManager = linkAccountManager;
        this.linkAccountHolder = linkAccountHolder;
        this.eventReporter = eventReporter;
        this.linkConfiguration = linkConfiguration;
        this.linkAttestationCheck = linkAttestationCheck;
        this.savedStateHandle = savedStateHandle;
        this.startWithVerificationDialog = startWithVerificationDialog;
        this.navigationManager = navigationManager;
        this.confirmationHandler = confirmationHandlerFactory.create(ViewModelKt.getViewModelScope((ViewModel)this));
        this._linkAppBarState = StateFlowKt.MutableStateFlow((Object)LinkAppBarState.Companion.initial());
        this.linkAppBarState = FlowKt.asStateFlow(this._linkAppBarState);
        this.navigationFlow = this.navigationManager.getNavigationFlow();
        this._linkScreenState = StateFlowKt.MutableStateFlow((Object)ScreenState.Loading.INSTANCE);
        this.linkScreenState = (StateFlow)this._linkScreenState;
    }

    @NotNull
    public final NativeLinkComponent getActivityRetainedComponent() {
        return this.activityRetainedComponent;
    }

    @NotNull
    public final EventReporter getEventReporter() {
        return this.eventReporter;
    }

    @NotNull
    public final SavedStateHandle getSavedStateHandle() {
        return this.savedStateHandle;
    }

    @NotNull
    public final ConfirmationHandler getConfirmationHandler() {
        return this.confirmationHandler;
    }

    @NotNull
    public final StateFlow<LinkAppBarState> getLinkAppBarState() {
        return this.linkAppBarState;
    }

    @NotNull
    public final SharedFlow<NavigationIntent> getNavigationFlow() {
        return this.navigationFlow;
    }

    @NotNull
    public final StateFlow<ScreenState> getLinkScreenState() {
        return this.linkScreenState;
    }

    @Nullable
    public final LinkAccount getLinkAccount() {
        return (LinkAccount)this.linkAccountManager.getLinkAccount().getValue();
    }

    @Nullable
    public final Function1<LinkActivityResult, Unit> getDismissWithResult() {
        return this.dismissWithResult;
    }

    public final void setDismissWithResult(@Nullable Function1<? super LinkActivityResult, Unit> function1) {
        this.dismissWithResult = function1;
    }

    @Nullable
    public final Function1<LinkConfiguration, Unit> getLaunchWebFlow() {
        return this.launchWebFlow;
    }

    public final void setLaunchWebFlow(@Nullable Function1<? super LinkConfiguration, Unit> function1) {
        this.launchWebFlow = function1;
    }

    public final void handleViewAction(@NotNull LinkAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        LinkAction linkAction = action2;
        if (Intrinsics.areEqual((Object)linkAction, (Object)LinkAction.BackPressed.INSTANCE)) {
            this.handleBackPressed();
        } else if (Intrinsics.areEqual((Object)linkAction, (Object)LinkAction.LogoutClicked.INSTANCE)) {
            this.handleLogoutClicked();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void onVerificationSucceeded() {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ LinkActivityViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = LinkActivityViewModel.access$get_linkScreenState$p(this.this$0);
                        this.L$0 = var2_3;
                        this.label = 1;
                        v0 = LinkActivityViewModel.access$buildFullScreenState(this.this$0, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        var2_3 = (MutableStateFlow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        var2_3.setValue(v0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void onDismissVerificationClicked() {
        block0: {
            Function1<? super LinkActivityResult, Unit> function1 = this.dismissWithResult;
            if (function1 == null) break block0;
            function1.invoke((Object)new LinkActivityResult.Canceled(null, LinkAccountUtilKt.getLinkAccountUpdate(this.linkAccountManager), 1, null));
        }
    }

    private final void handleLogoutClicked() {
        block0: {
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ LinkActivityViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = LinkActivityViewModel.access$getLinkAccountManager$p(this.this$0).logOut-IoAF18A((Continuation<? super Result<ConsumerSession>>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = ((Result)$result).unbox-impl();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            Function1<? super LinkActivityResult, Unit> function1 = this.dismissWithResult;
            if (function1 == null) break block0;
            function1.invoke((Object)new LinkActivityResult.Canceled(LinkActivityResult.Canceled.Reason.LoggedOut, new LinkAccountUpdate.Value(null)));
        }
    }

    public final void onNavEntryChanged(@NotNull NavBackStackEntryUpdate entry) {
        boolean bl;
        String string2;
        LinkAppBarState.Companion companion;
        LinkAppBarState nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Object object = entry.getCurrentBackStackEntry();
        if (object == null || (object = object.getDestination()) == null || (object = object.getRoute()) == null) {
            return;
        }
        Object route = object;
        NavBackStackEntry navBackStackEntry = entry.getPreviousBackStackEntry();
        String previousEntry = navBackStackEntry != null && (navBackStackEntry = navBackStackEntry.getDestination()) != null ? navBackStackEntry.getRoute() : null;
        MutableStateFlow<LinkAppBarState> $this$update$iv = this._linkAppBarState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            LinkAppBarState it = (LinkAppBarState)prevValue$iv;
            boolean bl2 = false;
            companion = LinkAppBarState.Companion;
            LinkAccount linkAccount = (LinkAccount)this.linkAccountManager.getLinkAccount().getValue();
            string2 = linkAccount != null ? linkAccount.getEmail() : null;
            LinkAccount linkAccount2 = this.getLinkAccount();
            bl = linkAccount2 != null ? linkAccount2.getCompletedSignup() : false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = companion.create((String)route, string2, previousEntry, bl))));
    }

    public final void moveToWeb() {
        block0: {
            Function1<? super LinkConfiguration, Unit> function1 = this.launchWebFlow;
            if (function1 == null) break block0;
            Function1<? super LinkConfiguration, Unit> launcher = function1;
            boolean bl = false;
            LinkActivityViewModel.navigate$default(this, LinkScreen.Loading.INSTANCE, true, false, 4, null);
            launcher.invoke((Object)this.linkConfiguration);
        }
    }

    public final void handleBackPressed() {
        block0: {
            Function1<? super LinkActivityResult, Unit> function1 = this.dismissWithResult;
            if (function1 == null) break block0;
            function1.invoke((Object)new LinkActivityResult.Canceled(null, LinkAccountUtilKt.getLinkAccountUpdate(this.linkAccountManager), 1, null));
        }
    }

    public final void registerActivityForConfirmation(@NotNull ActivityResultCaller activityResultCaller, @NotNull LifecycleOwner lifecycleOwner) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        this.confirmationHandler.register(activityResultCaller, lifecycleOwner);
    }

    public final void navigate(@NotNull LinkScreen screen, boolean clearStack, boolean launchSingleTop) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        NavigationManager navigationManager = this.navigationManager;
        String string2 = screen.getRoute();
        PopUpToBehavior.Start start2 = clearStack ? PopUpToBehavior.Start.INSTANCE : null;
        navigationManager.tryNavigateTo(string2, (PopUpToBehavior)start2, launchSingleTop);
    }

    public static /* synthetic */ void navigate$default(LinkActivityViewModel linkActivityViewModel, LinkScreen linkScreen, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        linkActivityViewModel.navigate(linkScreen, bl, bl2);
    }

    public final void goBack() {
        this.navigationManager.tryNavigateBack();
    }

    public final void changeEmail() {
        this.savedStateHandle.set("use_link_configuration_customer_info", (Object)false);
        LinkActivityViewModel.navigate$default(this, LinkScreen.SignUp.INSTANCE, true, false, 4, null);
    }

    public final void unregisterActivity() {
        this.dismissWithResult = null;
        this.launchWebFlow = null;
    }

    public void onCreate(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onCreate(owner);
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LinkActivityViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block14: {
                    block15: {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                if (!LinkActivityViewModel.access$getStartWithVerificationDialog$p(this.this$0)) break;
                                this.label = 1;
                                v0 = LinkActivityViewModel.access$updateScreenState(this.this$0, (Continuation)this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl14
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl14:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        this.label = 2;
                        v1 = LinkActivityViewModel.access$getLinkAttestationCheck$p(this.this$0).invoke((Continuation<? super LinkAttestationCheck.Result>)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl23
                        {
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl23:
                                // 2 sources

                                if ((var3_4 = (attestationCheckResult = (LinkAttestationCheck.Result)v1)) instanceof LinkAttestationCheck.Result.AttestationFailed) {
                                    v2 = this.this$0.getLaunchWebFlow();
                                    if (v2 != null) {
                                        v2.invoke((Object)LinkActivityViewModel.access$getLinkConfiguration$p(this.this$0));
                                    }
                                } else {
                                    if (!Intrinsics.areEqual((Object)var3_4, (Object)LinkAttestationCheck.Result.Successful.INSTANCE)) break;
                                    this.label = 3;
                                    v3 = LinkActivityViewModel.access$updateScreenState(this.this$0, (Continuation)this);
                                    if (v3 == var4_2) {
                                        return var4_2;
                                    }
                                }
                                break block14;
                            }
                            case 3: {
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
                                break block14;
                            }
                        }
                        if (!(var3_4 instanceof LinkAttestationCheck.Result.Error) && !(var3_4 instanceof LinkAttestationCheck.Result.AccountError)) break block15;
                        this.label = 4;
                        v4 = LinkActivityViewModel.access$handleAccountError(this.this$0, (Continuation)this);
                        if (v4 == var4_2) {
                            return var4_2;
                        }
                        break block14;
                        {
                            case 4: {
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
                                break block14;
                            }
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private final Object updateScreenState(Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateScreenState.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ LinkActivityViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LinkActivityViewModel.access$updateScreenState(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = FlowKt.first(this.linkAccountManager.getAccountStatus(), (Continuation)$continuation);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (LinkActivityViewModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                accountStatus = (AccountStatus)v0;
                linkAccount = (LinkAccount)this.linkAccountManager.getLinkAccount().getValue();
                var4_7 = accountStatus;
                switch (WhenMappings.$EnumSwitchMapping$0[var4_7.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        $continuation.L$0 = var5_8 = this._linkScreenState;
                        $continuation.label = 2;
                        v1 = this.buildFullScreenState((Continuation<? super ScreenState.FullScreen>)$continuation);
                        if (v1 == var8_4) {
                            return var8_4;
                        }
                        ** GOTO lbl37
                    }
                    case 2: {
                        var5_8 = (MutableStateFlow<ScreenState>)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl37:
                        // 2 sources

                        var5_8.setValue(v1);
                        return Unit.INSTANCE;
                    }
                    case 4: 
                    case 5: {
                        if (linkAccount != null && this.startWithVerificationDialog) {
                            this._linkScreenState.setValue((Object)new ScreenState.VerificationDialog(linkAccount));
                            return Unit.INSTANCE;
                        }
                        $continuation.L$0 = var5_9 = this._linkScreenState;
                        $continuation.label = 3;
                        v2 = this.buildFullScreenState((Continuation<? super ScreenState.FullScreen>)$continuation);
                        if (v2 == var8_4) {
                            return var8_4;
                        }
                        ** GOTO lbl55
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            case 3: {
                var5_9 = (MutableStateFlow<ScreenState>)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl55:
                // 2 sources

                var5_9.setValue(v2);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object buildFullScreenState(Continuation<? super ScreenState.FullScreen> $completion) {
        if (!($completion instanceof buildFullScreenState.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ LinkActivityViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LinkActivityViewModel.access$buildFullScreenState(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = FlowKt.first(this.linkAccountManager.getAccountStatus(), (Continuation)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (LinkActivityViewModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                accountStatus = (AccountStatus)v0;
                $continuation.L$0 = this;
                $continuation.L$1 = accountStatus;
                $continuation.label = 2;
                v1 = DelayKt.delay((long)250L, (Continuation)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl35
            }
            case 2: {
                accountStatus = (AccountStatus)$continuation.L$1;
                this = (LinkActivityViewModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                var3_6 = accountStatus;
                switch (WhenMappings.$EnumSwitchMapping$0[var3_6.ordinal()]) {
                    case 1: {
                        v2 = this.getLinkAccount();
                        v3 = v2 != null ? v2.getCompletedSignup() : false;
                        if (v3) {
                            v4 = LinkScreen.PaymentMethod.INSTANCE;
                            break;
                        }
                        v4 = LinkScreen.Wallet.INSTANCE;
                        break;
                    }
                    case 4: 
                    case 5: {
                        v4 = LinkScreen.Verification.INSTANCE;
                        break;
                    }
                    case 2: 
                    case 3: {
                        v4 = LinkScreen.SignUp.INSTANCE;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return new ScreenState.FullScreen(v4);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleAccountError(Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleAccountError.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ LinkActivityViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LinkActivityViewModel.access$handleAccountError(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.linkAccountManager.logOut-IoAF18A((Continuation<? super Result<ConsumerSession>>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (LinkActivityViewModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = ((Result)$result).unbox-impl();
lbl22:
                // 2 sources

                this.linkAccountHolder.set(null);
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = this.updateScreenState((Continuation<? super Unit>)$continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl32
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ MutableStateFlow access$get_linkScreenState$p(LinkActivityViewModel $this) {
        return $this._linkScreenState;
    }

    public static final /* synthetic */ Object access$buildFullScreenState(LinkActivityViewModel $this, Continuation $completion) {
        return $this.buildFullScreenState((Continuation<? super ScreenState.FullScreen>)$completion);
    }

    public static final /* synthetic */ LinkAccountManager access$getLinkAccountManager$p(LinkActivityViewModel $this) {
        return $this.linkAccountManager;
    }

    public static final /* synthetic */ boolean access$getStartWithVerificationDialog$p(LinkActivityViewModel $this) {
        return $this.startWithVerificationDialog;
    }

    public static final /* synthetic */ Object access$updateScreenState(LinkActivityViewModel $this, Continuation $completion) {
        return $this.updateScreenState((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ LinkAttestationCheck access$getLinkAttestationCheck$p(LinkActivityViewModel $this) {
        return $this.linkAttestationCheck;
    }

    public static final /* synthetic */ LinkConfiguration access$getLinkConfiguration$p(LinkActivityViewModel $this) {
        return $this.linkConfiguration;
    }

    public static final /* synthetic */ Object access$handleAccountError(LinkActivityViewModel $this, Continuation $completion) {
        return $this.handleAccountError((Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/link/LinkActivityViewModel$Companion;", "", "<init>", "()V", "factory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "paymentsheet_release"})
    @SourceDebugExtension(value={"SMAP\nLinkActivityViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkActivityViewModel.kt\ncom/stripe/android/link/LinkActivityViewModel$Companion\n+ 2 InitializerViewModelFactory.kt\nandroidx/lifecycle/viewmodel/InitializerViewModelFactoryKt\n*L\n1#1,274:1\n35#2:275\n77#2,2:276\n*S KotlinDebug\n*F\n+ 1 LinkActivityViewModel.kt\ncom/stripe/android/link/LinkActivityViewModel$Companion\n*L\n243#1:275\n244#1:276,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ViewModelProvider.Factory factory(@Nullable SavedStateHandle savedStateHandle) {
            void $this$initializer$iv;
            InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder;
            boolean $i$f$viewModelFactory = false;
            InitializerViewModelFactoryBuilder $this$factory_u24lambda_u243 = initializerViewModelFactoryBuilder = new InitializerViewModelFactoryBuilder();
            boolean bl = false;
            InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder2 = $this$factory_u24lambda_u243;
            Function1 initializer$iv = arg_0 -> Companion.factory$lambda$3$lambda$2(savedStateHandle, arg_0);
            boolean $i$f$initializer = false;
            $this$initializer$iv.addInitializer(Reflection.getOrCreateKotlinClass(LinkActivityViewModel.class), initializer$iv);
            return initializerViewModelFactoryBuilder.build();
        }

        public static /* synthetic */ ViewModelProvider.Factory factory$default(Companion companion, SavedStateHandle savedStateHandle, int n, Object object) {
            if ((n & 1) != 0) {
                savedStateHandle = null;
            }
            return companion.factory(savedStateHandle);
        }

        private static final String factory$lambda$3$lambda$2$lambda$0(NativeLinkArgs $args) {
            return $args.getPublishableKey();
        }

        private static final String factory$lambda$3$lambda$2$lambda$1(NativeLinkArgs $args) {
            return $args.getStripeAccountId();
        }

        private static final LinkActivityViewModel factory$lambda$3$lambda$2(SavedStateHandle $savedStateHandle, CreationExtras $this$initializer) {
            Intrinsics.checkNotNullParameter((Object)$this$initializer, (String)"$this$initializer");
            SavedStateHandle savedStateHandle = $savedStateHandle;
            if (savedStateHandle == null) {
                savedStateHandle = SavedStateHandleSupport.createSavedStateHandle((CreationExtras)$this$initializer);
            }
            SavedStateHandle handle = savedStateHandle;
            Object object = $this$initializer.get(ViewModelProvider.AndroidViewModelFactory.APPLICATION_KEY);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.Application");
            Application app = (Application)object;
            NativeLinkArgs nativeLinkArgs = LinkActivity.Companion.getArgs$paymentsheet_release(handle);
            if (nativeLinkArgs == null) {
                throw new NoArgsException();
            }
            NativeLinkArgs args = nativeLinkArgs;
            return DaggerNativeLinkComponent.builder().configuration(args.getConfiguration()).publishableKeyProvider((Function0<String>)((Function0)() -> Companion.factory$lambda$3$lambda$2$lambda$0(args))).stripeAccountIdProvider((Function0<String>)((Function0)() -> Companion.factory$lambda$3$lambda$2$lambda$1(args))).paymentElementCallbackIdentifier(args.getPaymentElementCallbackIdentifier()).savedStateHandle(handle).context((Context)app).application(app).startWithVerificationDialog(args.getStartWithVerificationDialog()).linkAccount(args.getLinkAccount()).build().getViewModel();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AccountStatus.values().length];
            try {
                nArray[AccountStatus.Verified.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccountStatus.SignedOut.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccountStatus.Error.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccountStatus.NeedsVerification.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccountStatus.VerificationStarted.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

