/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.compose.runtime.internal.StabilityInferred;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0014J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0014J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/link/LinkForegroundActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "<init>", "()V", "hasLaunchedPopup", "", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onSaveInstanceState", "outState", "onNewIntent", "intent", "Landroid/content/Intent;", "onResume", "handleRedirectIfAvailable", "launchPopup", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLinkForegroundActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkForegroundActivity.kt\ncom/stripe/android/link/LinkForegroundActivity\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,97:1\n29#2:98\n*S KotlinDebug\n*F\n+ 1 LinkForegroundActivity.kt\ncom/stripe/android/link/LinkForegroundActivity\n*L\n80#1:98\n*E\n"})
public final class LinkForegroundActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasLaunchedPopup;
    public static final int $stable = 8;
    @NotNull
    public static final String ACTION_REDIRECT = "LinkForegroundActivity.redirect";
    @NotNull
    public static final String EXTRA_POPUP_URL = "LinkPopupUrl";
    @NotNull
    public static final String EXTRA_FAILURE = "LinkFailure";
    public static final int RESULT_COMPLETE = 49871;
    public static final int RESULT_FAILURE = 91367;
    @NotNull
    private static final String SAVED_STATE_HAS_LAUNCHED_POPUP = "LinkHasLaunchedPopup";

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = savedInstanceState;
        this.hasLaunchedPopup = bundle != null ? bundle.getBoolean(SAVED_STATE_HAS_LAUNCHED_POPUP) : false;
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        this.handleRedirectIfAvailable(intent);
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        outState.putBoolean(SAVED_STATE_HAS_LAUNCHED_POPUP, this.hasLaunchedPopup);
    }

    public void onNewIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        super.onNewIntent(intent);
        this.handleRedirectIfAvailable(intent);
    }

    protected void onResume() {
        super.onResume();
        if (!this.isFinishing()) {
            if (this.hasLaunchedPopup) {
                this.setResult(0);
                this.finish();
            } else {
                this.launchPopup();
            }
        }
    }

    private final void handleRedirectIfAvailable(Intent intent) {
        if (Intrinsics.areEqual((Object)intent.getAction(), (Object)ACTION_REDIRECT)) {
            this.setResult(49871, intent);
            this.finish();
        }
    }

    private final void launchPopup() {
        Uri popupUri;
        Uri uri;
        this.hasLaunchedPopup = true;
        Object object = this.getIntent().getExtras();
        if (object != null && (object = object.getString(EXTRA_POPUP_URL)) != null) {
            Object $this$toUri$iv = object;
            boolean $i$f$toUri = false;
            uri = Uri.parse((String)$this$toUri$iv);
        } else {
            uri = popupUri = null;
        }
        if (popupUri == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        try {
            new CustomTabsIntent.Builder().setShareState(2).build().launchUrl((Context)this, popupUri);
        }
        catch (ActivityNotFoundException e) {
            this.setResult(91367, new Intent().putExtra(EXTRA_FAILURE, (Serializable)((Object)e)));
            this.finish();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/link/LinkForegroundActivity$Companion;", "", "<init>", "()V", "ACTION_REDIRECT", "", "EXTRA_POPUP_URL", "EXTRA_FAILURE", "RESULT_COMPLETE", "", "RESULT_FAILURE", "SAVED_STATE_HAS_LAUNCHED_POPUP", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "popupUrl", "redirectIntent", "uri", "Landroid/net/Uri;", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Intent createIntent(@NotNull Context context, @NotNull String popupUrl) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)popupUrl, (String)"popupUrl");
            Intent intent = new Intent(context, LinkForegroundActivity.class).putExtra(LinkForegroundActivity.EXTRA_POPUP_URL, popupUrl);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"putExtra(...)");
            return intent;
        }

        @NotNull
        public final Intent redirectIntent(@NotNull Context context, @Nullable Uri uri) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, LinkForegroundActivity.class);
            intent.setAction(LinkForegroundActivity.ACTION_REDIRECT);
            intent.setData(uri);
            intent.addFlags(0x24000000);
            return intent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

