/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link;

import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.link.LinkActivityContract;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.link.account.LinkStore;
import com.stripe.android.link.analytics.LinkAnalyticsHelper;
import com.stripe.android.link.injection.LinkAnalyticsComponent;
import com.stripe.android.link.model.LinkAccount;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B!\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u0014J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u0014J$\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00152\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J\u0006\u0010\u001b\u001a\u00020\u0010J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/stripe/android/link/LinkPaymentLauncher;", "", "linkAnalyticsComponentBuilder", "Lcom/stripe/android/link/injection/LinkAnalyticsComponent$Builder;", "linkActivityContract", "Lcom/stripe/android/link/LinkActivityContract;", "linkStore", "Lcom/stripe/android/link/account/LinkStore;", "<init>", "(Lcom/stripe/android/link/injection/LinkAnalyticsComponent$Builder;Lcom/stripe/android/link/LinkActivityContract;Lcom/stripe/android/link/account/LinkStore;)V", "analyticsHelper", "Lcom/stripe/android/link/analytics/LinkAnalyticsHelper;", "linkActivityResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/link/LinkActivityContract$Args;", "register", "", "activityResultRegistry", "Landroidx/activity/result/ActivityResultRegistry;", "callback", "Lkotlin/Function1;", "Lcom/stripe/android/link/LinkActivityResult;", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "handleActivityResult", "linkActivityResult", "nextStep", "unregister", "present", "configuration", "Lcom/stripe/android/link/LinkConfiguration;", "linkAccount", "Lcom/stripe/android/link/model/LinkAccount;", "useLinkExpress", "", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class LinkPaymentLauncher {
    @NotNull
    private final LinkActivityContract linkActivityContract;
    @NotNull
    private final LinkStore linkStore;
    @NotNull
    private final LinkAnalyticsHelper analyticsHelper;
    @Nullable
    private ActivityResultLauncher<LinkActivityContract.Args> linkActivityResultLauncher;
    public static final int $stable = 8;

    @Inject
    public LinkPaymentLauncher(@NotNull LinkAnalyticsComponent.Builder linkAnalyticsComponentBuilder, @NotNull LinkActivityContract linkActivityContract, @NotNull LinkStore linkStore) {
        Intrinsics.checkNotNullParameter((Object)linkAnalyticsComponentBuilder, (String)"linkAnalyticsComponentBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)linkActivityContract), (String)"linkActivityContract");
        Intrinsics.checkNotNullParameter((Object)linkStore, (String)"linkStore");
        this.linkActivityContract = linkActivityContract;
        this.linkStore = linkStore;
        this.analyticsHelper = linkAnalyticsComponentBuilder.build().getLinkAnalyticsHelper();
    }

    public final void register(@NotNull ActivityResultRegistry activityResultRegistry, @NotNull Function1<? super LinkActivityResult, Unit> callback2) {
        Intrinsics.checkNotNullParameter((Object)activityResultRegistry, (String)"activityResultRegistry");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.linkActivityResultLauncher = activityResultRegistry.register("LinkPaymentLauncher", (ActivityResultContract)this.linkActivityContract, arg_0 -> LinkPaymentLauncher.register$lambda$0(this, callback2, arg_0));
    }

    public final void register(@NotNull ActivityResultCaller activityResultCaller, @NotNull Function1<? super LinkActivityResult, Unit> callback2) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.linkActivityResultLauncher = activityResultCaller.registerForActivityResult((ActivityResultContract)this.linkActivityContract, arg_0 -> LinkPaymentLauncher.register$lambda$1(this, callback2, arg_0));
    }

    private final void handleActivityResult(LinkActivityResult linkActivityResult, Function1<? super LinkActivityResult, Unit> nextStep) {
        this.analyticsHelper.onLinkResult(linkActivityResult);
        LinkActivityResult linkActivityResult2 = linkActivityResult;
        if (linkActivityResult2 instanceof LinkActivityResult.PaymentMethodObtained || linkActivityResult2 instanceof LinkActivityResult.Completed) {
            this.linkStore.markLinkAsUsed();
        } else if (!(linkActivityResult2 instanceof LinkActivityResult.Canceled) && !(linkActivityResult2 instanceof LinkActivityResult.Failed)) {
            throw new NoWhenBranchMatchedException();
        }
        nextStep.invoke((Object)linkActivityResult);
    }

    public final void unregister() {
        ActivityResultLauncher<LinkActivityContract.Args> activityResultLauncher2 = this.linkActivityResultLauncher;
        if (activityResultLauncher2 != null) {
            activityResultLauncher2.unregister();
        }
        this.linkActivityResultLauncher = null;
    }

    public final void present(@NotNull LinkConfiguration configuration, @Nullable LinkAccount linkAccount, boolean useLinkExpress) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        LinkActivityContract.Args args = new LinkActivityContract.Args(configuration, useLinkExpress, linkAccount);
        ActivityResultLauncher<LinkActivityContract.Args> activityResultLauncher2 = this.linkActivityResultLauncher;
        if (activityResultLauncher2 != null) {
            activityResultLauncher2.launch((Object)args);
        }
        this.analyticsHelper.onLinkLaunched();
    }

    private static final void register$lambda$0(LinkPaymentLauncher this$0, Function1 $callback, LinkActivityResult linkActivityResult) {
        Intrinsics.checkNotNullParameter((Object)linkActivityResult, (String)"linkActivityResult");
        this$0.handleActivityResult(linkActivityResult, (Function1<? super LinkActivityResult, Unit>)$callback);
    }

    private static final void register$lambda$1(LinkPaymentLauncher this$0, Function1 $callback, LinkActivityResult linkActivityResult) {
        Intrinsics.checkNotNullParameter((Object)linkActivityResult, (String)"linkActivityResult");
        this$0.handleActivityResult(linkActivityResult, (Function1<? super LinkActivityResult, Unit>)$callback);
    }
}

