/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Base64;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.os.BundleCompat;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.link.FailedToParseLinkResultUriException;
import com.stripe.android.link.LinkAccountUpdate;
import com.stripe.android.link.LinkActivityContract;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.LinkForegroundActivity;
import com.stripe.android.link.serialization.PopupPayload;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.parsers.PaymentMethodJsonParser;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import java.nio.charset.Charset;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0019\b\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u001a\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0013\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/link/WebLinkActivityContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/link/LinkActivityContract$Args;", "Lcom/stripe/android/link/LinkActivityResult;", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "errorReporter", "Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "<init>", "(Lcom/stripe/android/networking/StripeRepository;Lcom/stripe/android/payments/core/analytics/ErrorReporter;)V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "handleCompleteResult", "parsePaymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class WebLinkActivityContract
extends ActivityResultContract<LinkActivityContract.Args, LinkActivityResult> {
    @NotNull
    private final StripeRepository stripeRepository;
    @NotNull
    private final ErrorReporter errorReporter;
    public static final int $stable = 8;

    @Inject
    public WebLinkActivityContract(@NotNull StripeRepository stripeRepository, @NotNull ErrorReporter errorReporter) {
        Intrinsics.checkNotNullParameter((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        this.stripeRepository = stripeRepository;
        this.errorReporter = errorReporter;
    }

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull LinkActivityContract.Args input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PaymentConfiguration paymentConfiguration = PaymentConfiguration.Companion.getInstance(context);
        PopupPayload payload = PopupPayload.Companion.create(input.getConfiguration$paymentsheet_release(), context, paymentConfiguration.getPublishableKey(), paymentConfiguration.getStripeAccountId(), StripeRepository.DefaultImpls.buildPaymentUserAgent$default((StripeRepository)this.stripeRepository, null, (int)1, null));
        return LinkForegroundActivity.Companion.createIntent(context, payload.toUrl());
    }

    @NotNull
    public LinkActivityResult parseResult(int resultCode, @Nullable Intent intent) {
        LinkActivityResult linkActivityResult;
        switch (resultCode) {
            case 91367: {
                Exception exception;
                Exception exception2;
                Intent intent2 = intent;
                if (intent2 != null && (intent2 = intent2.getExtras()) != null) {
                    Intent it = intent2;
                    boolean bl = false;
                    exception2 = (Exception)BundleCompat.getSerializable((Bundle)it, (String)"LinkFailure", Exception.class);
                } else {
                    exception2 = exception = null;
                }
                if (exception != null) {
                    linkActivityResult = new LinkActivityResult.Failed(exception, LinkAccountUpdate.None.INSTANCE);
                    break;
                }
                linkActivityResult = new LinkActivityResult.Canceled(null, LinkAccountUpdate.None.INSTANCE, 1, null);
                break;
            }
            case 49871: {
                linkActivityResult = this.handleCompleteResult(intent);
                break;
            }
            case 0: {
                linkActivityResult = new LinkActivityResult.Canceled(null, LinkAccountUpdate.None.INSTANCE, 1, null);
                break;
            }
            default: {
                linkActivityResult = new LinkActivityResult.Canceled(null, LinkAccountUpdate.None.INSTANCE, 1, null);
            }
        }
        return linkActivityResult;
    }

    /*
     * Unable to fully structure code
     */
    private final LinkActivityResult handleCompleteResult(Intent intent) {
        block6: {
            block5: {
                v0 = intent;
                if (v0 == null || (v0 = v0.getData()) == null) {
                    return new LinkActivityResult.Canceled(null, LinkAccountUpdate.None.INSTANCE, 1, null);
                }
                redirectUri = v0;
                var3_3 = redirectUri.getQueryParameter("link_status");
                if (var3_3 == null) break block5;
                switch (var3_3.hashCode()) {
                    case -1097329270: {
                        if (var3_3.equals("logout")) break;
                        ** break;
                    }
                    case -599445191: {
                        if (!var3_3.equals("complete")) ** break;
                        var5_4 = redirectUri.getQueryParameter("pm");
                        v1 = paymentMethod = var5_4 != null ? this.parsePaymentMethod(var5_4) : null;
                        v2 = paymentMethod == null ? (LinkActivityResult)new LinkActivityResult.Canceled(null, LinkAccountUpdate.None.INSTANCE, 1, null) : (LinkActivityResult)new LinkActivityResult.PaymentMethodObtained(paymentMethod);
                        break block6;
                    }
                }
                v2 = new LinkActivityResult.Canceled(LinkActivityResult.Canceled.Reason.LoggedOut, LinkAccountUpdate.None.INSTANCE);
                break block6;
            }
            v2 = new LinkActivityResult.Canceled(null, LinkAccountUpdate.None.INSTANCE, 1, null);
        }
        return v2;
    }

    private final PaymentMethod parsePaymentMethod(String $this$parsePaymentMethod) {
        Object object;
        Object $this$parsePaymentMethod_u24lambda_u241;
        Object object2 = $this$parsePaymentMethod;
        try {
            $this$parsePaymentMethod_u24lambda_u241 = object2;
            boolean bl = false;
            byte[] byArray = Base64.decode((String)$this$parsePaymentMethod_u24lambda_u241, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            byte[] byArray2 = byArray;
            Charset charset = Charsets.UTF_8;
            String decodedPaymentMethod = new String(byArray2, charset);
            $this$parsePaymentMethod_u24lambda_u241 = Result.constructor-impl((Object)new PaymentMethodJsonParser().parse(new JSONObject(decodedPaymentMethod)));
        }
        catch (Throwable bl) {
            $this$parsePaymentMethod_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$parsePaymentMethod_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            ErrorReporter.DefaultImpls.report$default((ErrorReporter)this.errorReporter, (ErrorReporter.ErrorEvent)((ErrorReporter.ErrorEvent)ErrorReporter.UnexpectedErrorEvent.LINK_WEB_FAILED_TO_PARSE_RESULT_URI), (StripeException)new FailedToParseLinkResultUriException(e), null, (int)4, null);
            object = null;
        }
        return (PaymentMethod)object;
    }
}

