/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.attestation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.core.injection.IOContext;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.link.account.LinkAccountManager;
import com.stripe.android.link.account.LinkAuth;
import com.stripe.android.link.account.LinkAuthResult;
import com.stripe.android.link.attestation.LinkAttestationCheck;
import com.stripe.android.link.gate.LinkGate;
import com.stripe.android.link.model.LinkAccount;
import com.stripe.android.model.EmailSource;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.attestation.IntegrityRequestManager;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001BC\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/link/attestation/DefaultLinkAttestationCheck;", "Lcom/stripe/android/link/attestation/LinkAttestationCheck;", "linkGate", "Lcom/stripe/android/link/gate/LinkGate;", "linkAuth", "Lcom/stripe/android/link/account/LinkAuth;", "integrityRequestManager", "Lcom/stripe/attestation/IntegrityRequestManager;", "linkAccountManager", "Lcom/stripe/android/link/account/LinkAccountManager;", "linkConfiguration", "Lcom/stripe/android/link/LinkConfiguration;", "errorReporter", "Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lcom/stripe/android/link/gate/LinkGate;Lcom/stripe/android/link/account/LinkAuth;Lcom/stripe/attestation/IntegrityRequestManager;Lcom/stripe/android/link/account/LinkAccountManager;Lcom/stripe/android/link/LinkConfiguration;Lcom/stripe/android/payments/core/analytics/ErrorReporter;Lkotlin/coroutines/CoroutineContext;)V", "invoke", "Lcom/stripe/android/link/attestation/LinkAttestationCheck$Result;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleLookupResult", "lookupResult", "Lcom/stripe/android/link/account/LinkAuthResult;", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class DefaultLinkAttestationCheck
implements LinkAttestationCheck {
    @NotNull
    private final LinkGate linkGate;
    @NotNull
    private final LinkAuth linkAuth;
    @NotNull
    private final IntegrityRequestManager integrityRequestManager;
    @NotNull
    private final LinkAccountManager linkAccountManager;
    @NotNull
    private final LinkConfiguration linkConfiguration;
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final CoroutineContext workContext;
    public static final int $stable = 8;

    @Inject
    public DefaultLinkAttestationCheck(@NotNull LinkGate linkGate, @NotNull LinkAuth linkAuth, @NotNull IntegrityRequestManager integrityRequestManager, @NotNull LinkAccountManager linkAccountManager, @NotNull LinkConfiguration linkConfiguration, @NotNull ErrorReporter errorReporter, @IOContext @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)linkGate, (String)"linkGate");
        Intrinsics.checkNotNullParameter((Object)linkAuth, (String)"linkAuth");
        Intrinsics.checkNotNullParameter((Object)integrityRequestManager, (String)"integrityRequestManager");
        Intrinsics.checkNotNullParameter((Object)linkAccountManager, (String)"linkAccountManager");
        Intrinsics.checkNotNullParameter((Object)linkConfiguration, (String)"linkConfiguration");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this.linkGate = linkGate;
        this.linkAuth = linkAuth;
        this.integrityRequestManager = integrityRequestManager;
        this.linkAccountManager = linkAccountManager;
        this.linkConfiguration = linkConfiguration;
        this.errorReporter = errorReporter;
        this.workContext = workContext;
    }

    @Override
    @Nullable
    public Object invoke(@NotNull Continuation<? super LinkAttestationCheck.Result> $completion) {
        if (!this.linkGate.getUseAttestationEndpoints()) {
            return LinkAttestationCheck.Result.Successful.INSTANCE;
        }
        return BuildersKt.withContext((CoroutineContext)this.workContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LinkAttestationCheck.Result>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ DefaultLinkAttestationCheck this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block8: {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DefaultLinkAttestationCheck.access$getIntegrityRequestManager$p(this.this$0).prepare-IoAF18A((Continuation)this);
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = ((Result)$result).unbox-impl();
lbl13:
                            // 2 sources

                            var3_4 = result = v0;
                            var4_5 = this.this$0;
                            var5_6 = this.this$0;
                            v1 = Result.exceptionOrNull-impl((Object)var3_4);
                            if (v1 != null) break;
                            (Unit)var3_4;
                            $i$a$-fold-DefaultLinkAttestationCheck$invoke$2$1 = false;
                            v2 = (LinkAccount)DefaultLinkAttestationCheck.access$getLinkAccountManager$p(var4_5).getLinkAccount().getValue();
                            if (v2 == null || (v2 = v2.getEmail()) == null) {
                                v2 = DefaultLinkAttestationCheck.access$getLinkConfiguration$p(var4_5).getCustomerInfo().getEmail();
                            }
                            if ((email = v2) != null) ** GOTO lbl27
                            v3 = LinkAttestationCheck.Result.Successful.INSTANCE;
                            break block8;
lbl27:
                            // 1 sources

                            this.L$0 = var4_5;
                            this.label = 2;
                            v4 = DefaultLinkAttestationCheck.access$getLinkAuth$p(var4_5).lookUp((String)email, EmailSource.CUSTOMER_OBJECT, false, (Continuation<? super LinkAuthResult>)this);
                            if (v4 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl38
                        }
                        case 2: {
                            $i$a$-fold-DefaultLinkAttestationCheck$invoke$2$1 = false;
                            var4_5 = (DefaultLinkAttestationCheck)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl38:
                            // 2 sources

                            lookupResult = (LinkAuthResult)v4;
                            v3 = DefaultLinkAttestationCheck.access$handleLookupResult(var4_5, lookupResult);
                            break block8;
                        }
                    }
                    error = v1;
                    $i$a$-fold-DefaultLinkAttestationCheck$invoke$2$2 = false;
                    ErrorReporter.DefaultImpls.report$default((ErrorReporter)DefaultLinkAttestationCheck.access$getErrorReporter$p(var5_6), (ErrorReporter.ErrorEvent)((ErrorReporter.ErrorEvent)ErrorReporter.ExpectedErrorEvent.LINK_NATIVE_FAILED_TO_PREPARE_INTEGRITY_MANAGER), (StripeException)StripeException.Companion.create(error), null, (int)4, null);
                    v3 = new LinkAttestationCheck.Result.AttestationFailed(error);
                }
                return v3;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LinkAttestationCheck.Result> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final LinkAttestationCheck.Result handleLookupResult(LinkAuthResult lookupResult) {
        LinkAttestationCheck.Result result2;
        LinkAuthResult linkAuthResult = lookupResult;
        if (linkAuthResult instanceof LinkAuthResult.AttestationFailed) {
            result2 = new LinkAttestationCheck.Result.AttestationFailed(((LinkAuthResult.AttestationFailed)lookupResult).getError());
        } else if (linkAuthResult instanceof LinkAuthResult.Error) {
            result2 = new LinkAttestationCheck.Result.Error(((LinkAuthResult.Error)lookupResult).getError());
        } else if (linkAuthResult instanceof LinkAuthResult.AccountError) {
            result2 = new LinkAttestationCheck.Result.AccountError(((LinkAuthResult.AccountError)lookupResult).getError());
        } else if (Intrinsics.areEqual((Object)linkAuthResult, (Object)LinkAuthResult.NoLinkAccountFound.INSTANCE) || linkAuthResult instanceof LinkAuthResult.Success) {
            result2 = LinkAttestationCheck.Result.Successful.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    public static final /* synthetic */ IntegrityRequestManager access$getIntegrityRequestManager$p(DefaultLinkAttestationCheck $this) {
        return $this.integrityRequestManager;
    }

    public static final /* synthetic */ LinkAccountManager access$getLinkAccountManager$p(DefaultLinkAttestationCheck $this) {
        return $this.linkAccountManager;
    }

    public static final /* synthetic */ LinkConfiguration access$getLinkConfiguration$p(DefaultLinkAttestationCheck $this) {
        return $this.linkConfiguration;
    }

    public static final /* synthetic */ LinkAuth access$getLinkAuth$p(DefaultLinkAttestationCheck $this) {
        return $this.linkAuth;
    }

    public static final /* synthetic */ LinkAttestationCheck.Result access$handleLookupResult(DefaultLinkAttestationCheck $this, LinkAuthResult lookupResult) {
        return $this.handleLookupResult(lookupResult);
    }

    public static final /* synthetic */ ErrorReporter access$getErrorReporter$p(DefaultLinkAttestationCheck $this) {
        return $this.errorReporter;
    }
}

