/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.confirmation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.Logger;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.link.LinkPaymentDetails;
import com.stripe.android.link.confirmation.DefaultLinkConfirmationHandler;
import com.stripe.android.link.confirmation.LinkConfirmationHandler;
import com.stripe.android.link.confirmation.Result;
import com.stripe.android.link.model.LinkAccount;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConsumerPaymentDetails;
import com.stripe.android.model.LinkMode;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.PaymentMethodOptionsParams;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.wallets.Wallet;
import com.stripe.android.paymentelement.confirmation.ConfirmationHandler;
import com.stripe.android.paymentelement.confirmation.PaymentMethodConfirmationOption;
import com.stripe.android.paymentelement.confirmation.link.LinkPassthroughConfirmationOption;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import com.stripe.android.paymentsheet.state.PaymentElementLoader;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001:\u0001$B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\n\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0082@\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\"\u0010\u001c\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\"\u0010\u001d\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001a\u0010\u001e\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\"\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010#\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/stripe/android/link/confirmation/DefaultLinkConfirmationHandler;", "Lcom/stripe/android/link/confirmation/LinkConfirmationHandler;", "configuration", "Lcom/stripe/android/link/LinkConfiguration;", "logger", "Lcom/stripe/android/core/Logger;", "confirmationHandler", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler;", "<init>", "(Lcom/stripe/android/link/LinkConfiguration;Lcom/stripe/android/core/Logger;Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler;)V", "confirm", "Lcom/stripe/android/link/confirmation/Result;", "paymentDetails", "Lcom/stripe/android/model/ConsumerPaymentDetails$PaymentDetails;", "linkAccount", "Lcom/stripe/android/link/model/LinkAccount;", "cvc", "", "(Lcom/stripe/android/model/ConsumerPaymentDetails$PaymentDetails;Lcom/stripe/android/link/model/LinkAccount;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/stripe/android/link/LinkPaymentDetails;", "(Lcom/stripe/android/link/LinkPaymentDetails;Lcom/stripe/android/link/model/LinkAccount;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createArgs", "Lkotlin/Function0;", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Args;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "transformResult", "result", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Result;", "confirmationArgs", "newConfirmationArgs", "savedConfirmationArgs", "createPaymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "selectedPaymentDetails", "computeExpectedPaymentMethodType", "computeBankAccountExpectedPaymentMethodType", "Factory", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDefaultLinkConfirmationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultLinkConfirmationHandler.kt\ncom/stripe/android/link/confirmation/DefaultLinkConfirmationHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
public final class DefaultLinkConfirmationHandler
implements LinkConfirmationHandler {
    @NotNull
    private final LinkConfiguration configuration;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConfirmationHandler confirmationHandler;
    public static final int $stable = 8;

    @Inject
    public DefaultLinkConfirmationHandler(@NotNull LinkConfiguration configuration, @NotNull Logger logger, @NotNull ConfirmationHandler confirmationHandler) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)confirmationHandler, (String)"confirmationHandler");
        this.configuration = configuration;
        this.logger = logger;
        this.confirmationHandler = confirmationHandler;
    }

    @Override
    @Nullable
    public Object confirm(@NotNull ConsumerPaymentDetails.PaymentDetails paymentDetails, @NotNull LinkAccount linkAccount, @Nullable String cvc, @NotNull Continuation<? super Result> $completion) {
        return this.confirm((Function0<ConfirmationHandler.Args>)((Function0)() -> DefaultLinkConfirmationHandler.confirm$lambda$0(this, paymentDetails, linkAccount, cvc)), $completion);
    }

    @Override
    @Nullable
    public Object confirm(@NotNull LinkPaymentDetails paymentDetails, @NotNull LinkAccount linkAccount, @Nullable String cvc, @NotNull Continuation<? super Result> $completion) {
        return this.confirm((Function0<ConfirmationHandler.Args>)((Function0)() -> DefaultLinkConfirmationHandler.confirm$lambda$1(this, paymentDetails, linkAccount, cvc)), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object confirm(Function0<ConfirmationHandler.Args> var1_1, Continuation<? super Result> $completion) {
        if (!($completion instanceof confirm.5)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultLinkConfirmationHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultLinkConfirmationHandler.access$confirm(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = this;
                $this$confirm_u24lambda_u242 = var3_6;
                $i$a$-runCatching-DefaultLinkConfirmationHandler$confirm$6 = false;
                args = (ConfirmationHandler.Args)createArgs.invoke();
                $continuation.L$0 = this;
                $continuation.L$1 = $this$confirm_u24lambda_u242;
                $continuation.label = 1;
                v0 = $this$confirm_u24lambda_u242.confirmationHandler.start(args, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var10_5) goto lbl25
lbl24:
                // 1 sources

                return var10_5;
lbl25:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                $i$a$-runCatching-DefaultLinkConfirmationHandler$confirm$6 = false;
                $this$confirm_u24lambda_u242 = (DefaultLinkConfirmationHandler)$continuation.L$1;
                this = (DefaultLinkConfirmationHandler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = $this$confirm_u24lambda_u242;
                $continuation.label = 2;
                v1 = $this$confirm_u24lambda_u242.confirmationHandler.awaitResult((Continuation<? super ConfirmationHandler.Result>)$continuation);
                ** if (v1 != var10_5) goto lbl40
lbl39:
                // 1 sources

                return var10_5;
lbl40:
                // 1 sources

                ** GOTO lbl49
            }
            case 2: {
                $i$a$-runCatching-DefaultLinkConfirmationHandler$confirm$6 = false;
                $this$confirm_u24lambda_u242 = (DefaultLinkConfirmationHandler)$continuation.L$1;
                this = (DefaultLinkConfirmationHandler)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl49:
                    // 2 sources

                    result = (ConfirmationHandler.Result)v1;
                    $this$confirm_u24lambda_u242 = kotlin.Result.constructor-impl((Object)super.transformResult(result));
                }
                catch (Throwable $i$a$-runCatching-DefaultLinkConfirmationHandler$confirm$6) {
                    $this$confirm_u24lambda_u242 = kotlin.Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-DefaultLinkConfirmationHandler$confirm$6));
                }
                var3_6 = $this$confirm_u24lambda_u242;
                v2 = kotlin.Result.exceptionOrNull-impl((Object)var3_6);
                if (v2 == null) {
                    v3 = var3_6;
                } else {
                    error = v2;
                    $i$a$-getOrElse-DefaultLinkConfirmationHandler$confirm$7 = false;
                    this.logger.error("DefaultLinkConfirmationHandler: Failed to confirm payment", error);
                    v3 = new Result.Failed(ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_something_went_wrong));
                }
                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Result transformResult(ConfirmationHandler.Result result2) {
        Result result3;
        ConfirmationHandler.Result result4 = result2;
        if (result4 instanceof ConfirmationHandler.Result.Canceled) {
            result3 = Result.Canceled.INSTANCE;
        } else if (result4 instanceof ConfirmationHandler.Result.Failed) {
            this.logger.error("DefaultLinkConfirmationHandler: Failed to confirm payment", ((ConfirmationHandler.Result.Failed)result2).getCause());
            result3 = new Result.Failed(((ConfirmationHandler.Result.Failed)result2).getMessage());
        } else if (result4 instanceof ConfirmationHandler.Result.Succeeded) {
            result3 = Result.Succeeded.INSTANCE;
        } else if (result4 == null) {
            Logger.DefaultImpls.error$default((Logger)this.logger, (String)"DefaultLinkConfirmationHandler: Payment confirmation returned null", null, (int)2, null);
            result3 = new Result.Failed(ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_something_went_wrong));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result3;
    }

    private final ConfirmationHandler.Args confirmationArgs(LinkPaymentDetails paymentDetails, LinkAccount linkAccount, String cvc) {
        ConfirmationHandler.Args args;
        LinkPaymentDetails linkPaymentDetails = paymentDetails;
        if (linkPaymentDetails instanceof LinkPaymentDetails.New) {
            args = this.newConfirmationArgs(((LinkPaymentDetails.New)paymentDetails).getPaymentDetails(), linkAccount, cvc);
        } else if (linkPaymentDetails instanceof LinkPaymentDetails.Saved) {
            args = this.savedConfirmationArgs(paymentDetails, cvc);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return args;
    }

    private final ConfirmationHandler.Args newConfirmationArgs(ConsumerPaymentDetails.PaymentDetails paymentDetails, LinkAccount linkAccount, String cvc) {
        ConfirmationHandler.Option option;
        if (this.configuration.getPassthroughModeEnabled()) {
            option = new LinkPassthroughConfirmationOption(paymentDetails.getId(), this.computeExpectedPaymentMethodType(paymentDetails));
        } else {
            PaymentMethodCreateParams paymentMethodCreateParams = this.createPaymentMethodCreateParams(paymentDetails, linkAccount, cvc);
            option = new PaymentMethodConfirmationOption.New(paymentMethodCreateParams, null, null, false);
        }
        ConfirmationHandler.Option confirmationOption2 = option;
        return new ConfirmationHandler.Args(this.configuration.getStripeIntent(), confirmationOption2, new PaymentSheet.Appearance(), this.configuration.getInitializationMode(), this.configuration.getShippingDetails());
    }

    private final ConfirmationHandler.Args savedConfirmationArgs(LinkPaymentDetails paymentDetails, String cvc) {
        String string2;
        StripeIntent stripeIntent = this.configuration.getStripeIntent();
        PaymentMethod paymentMethod = new PaymentMethod.Builder().setId(paymentDetails.getPaymentDetails().getId()).setCode(paymentDetails.getPaymentMethodCreateParams().getTypeCode()).setCard(new PaymentMethod.Card(null, null, null, null, null, null, null, paymentDetails.getPaymentDetails().getLast4(), null, (Wallet)new Wallet.LinkWallet(paymentDetails.getPaymentDetails().getLast4()), null, null, 3455, null)).setType(PaymentMethod.Type.Card).build();
        ConfirmPaymentIntentParams.SetupFutureUsage setupFutureUsage = ConfirmPaymentIntentParams.SetupFutureUsage.OffSession;
        String string3 = cvc;
        if (string3 != null) {
            String string4;
            String string5 = string4 = string3;
            PaymentMethod paymentMethod2 = paymentMethod;
            StripeIntent stripeIntent2 = stripeIntent;
            boolean bl = false;
            boolean bl2 = !this.configuration.getPassthroughModeEnabled();
            stripeIntent = stripeIntent2;
            paymentMethod = paymentMethod2;
            string2 = bl2 ? string4 : null;
        } else {
            string2 = null;
        }
        String string6 = string2;
        PaymentMethodOptionsParams paymentMethodOptionsParams = (PaymentMethodOptionsParams)new PaymentMethodOptionsParams.Card(string6, null, setupFutureUsage, 2, null);
        PaymentMethod paymentMethod3 = paymentMethod;
        AddressDetails addressDetails = this.configuration.getShippingDetails();
        PaymentElementLoader.InitializationMode initializationMode = this.configuration.getInitializationMode();
        PaymentSheet.Appearance appearance = new PaymentSheet.Appearance();
        ConfirmationHandler.Option option = new PaymentMethodConfirmationOption.Saved(paymentMethod3, paymentMethodOptionsParams);
        StripeIntent stripeIntent3 = stripeIntent;
        return new ConfirmationHandler.Args(stripeIntent3, option, appearance, initializationMode, addressDetails);
    }

    private final PaymentMethodCreateParams createPaymentMethodCreateParams(ConsumerPaymentDetails.PaymentDetails selectedPaymentDetails, LinkAccount linkAccount, String cvc) {
        Map map2;
        PaymentMethodCreateParams.Companion companion = PaymentMethodCreateParams.Companion;
        String string2 = selectedPaymentDetails.getId();
        String string3 = linkAccount.getClientSecret();
        String string4 = cvc;
        if (string4 != null) {
            String string5 = string4;
            String string6 = string3;
            String string7 = string2;
            PaymentMethodCreateParams.Companion companion2 = companion;
            boolean bl = false;
            Map map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"card", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"cvc", (Object)cvc))));
            companion = companion2;
            string2 = string7;
            string3 = string6;
            map2 = map3;
        } else {
            map2 = null;
        }
        return companion.createLink(string2, string3, map2);
    }

    private final String computeExpectedPaymentMethodType(ConsumerPaymentDetails.PaymentDetails paymentDetails) {
        String string2;
        ConsumerPaymentDetails.PaymentDetails paymentDetails2 = paymentDetails;
        if (paymentDetails2 instanceof ConsumerPaymentDetails.BankAccount) {
            string2 = this.computeBankAccountExpectedPaymentMethodType();
        } else if (paymentDetails2 instanceof ConsumerPaymentDetails.Card) {
            string2 = "card";
        } else if (paymentDetails2 instanceof ConsumerPaymentDetails.Passthrough) {
            string2 = "card";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private final String computeBankAccountExpectedPaymentMethodType() {
        boolean canAcceptACH = this.configuration.getStripeIntent().getPaymentMethodTypes().contains(PaymentMethod.Type.USBankAccount.code);
        boolean isLinkCardBrand = this.configuration.getLinkMode() == LinkMode.LinkCardBrand;
        return isLinkCardBrand && !canAcceptACH ? "card" : "bank_account";
    }

    private static final ConfirmationHandler.Args confirm$lambda$0(DefaultLinkConfirmationHandler this$0, ConsumerPaymentDetails.PaymentDetails $paymentDetails, LinkAccount $linkAccount, String $cvc) {
        return this$0.newConfirmationArgs($paymentDetails, $linkAccount, $cvc);
    }

    private static final ConfirmationHandler.Args confirm$lambda$1(DefaultLinkConfirmationHandler this$0, LinkPaymentDetails $paymentDetails, LinkAccount $linkAccount, String $cvc) {
        return this$0.confirmationArgs($paymentDetails, $linkAccount, $cvc);
    }

    public static final /* synthetic */ Object access$confirm(DefaultLinkConfirmationHandler $this, Function0 createArgs, Continuation $completion) {
        return $this.confirm((Function0<ConfirmationHandler.Args>)createArgs, (Continuation<? super Result>)$completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/link/confirmation/DefaultLinkConfirmationHandler$Factory;", "Lcom/stripe/android/link/confirmation/LinkConfirmationHandler$Factory;", "configuration", "Lcom/stripe/android/link/LinkConfiguration;", "logger", "Lcom/stripe/android/core/Logger;", "<init>", "(Lcom/stripe/android/link/LinkConfiguration;Lcom/stripe/android/core/Logger;)V", "create", "Lcom/stripe/android/link/confirmation/LinkConfirmationHandler;", "confirmationHandler", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    implements LinkConfirmationHandler.Factory {
        @NotNull
        private final LinkConfiguration configuration;
        @NotNull
        private final Logger logger;
        public static final int $stable = 8;

        @Inject
        public Factory(@NotNull LinkConfiguration configuration, @NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.configuration = configuration;
            this.logger = logger;
        }

        @Override
        @NotNull
        public LinkConfirmationHandler create(@NotNull ConfirmationHandler confirmationHandler) {
            Intrinsics.checkNotNullParameter((Object)confirmationHandler, (String)"confirmationHandler");
            Logger logger = this.logger;
            LinkConfiguration linkConfiguration = this.configuration;
            return new DefaultLinkConfirmationHandler(linkConfiguration, logger, confirmationHandler);
        }
    }
}

